/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.util;

import com.hotent.base.attachment.Attachment;
import com.hotent.base.attachment.AttachmentService;
import com.hotent.base.attachment.AttachmentServiceFactory;
import com.hotent.base.context.BaseContext;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.file.model.UploadProperties;
import com.hotent.file.service.FlowUploadPropertiesService;
import com.hotent.file.service.SysPropertyService;
import java.io.File;
import java.io.InputStream;
import java.util.Calendar;
import javax.servlet.ServletContext;

public class AppFileUtil {
    private static ServletContext servletContext;

    public static String getAttachPath() {
        SysPropertyService sysPropertyService = (SysPropertyService)AppUtil.getBean(SysPropertyService.class);
        return sysPropertyService.getByAlias("file.upload", "D:\\x7\\file");
    }

    public static String getSaveType(String propertiesId) {
        FlowUploadPropertiesService flowUploadPropertiesService;
        UploadProperties uploadProperties;
        if (StringUtil.isNotEmpty((String)propertiesId) && BeanUtils.isNotEmpty((Object)(uploadProperties = (flowUploadPropertiesService = (FlowUploadPropertiesService)AppUtil.getBean(FlowUploadPropertiesService.class)).getUploadProperties(propertiesId))) && BeanUtils.isNotEmpty((Object)uploadProperties.getUploadType())) {
            return uploadProperties.getUploadType();
        }
        SysPropertyService sysPropertyService = (SysPropertyService)AppUtil.getBean(SysPropertyService.class);
        return sysPropertyService.getByAlias("file.saveType", "database");
    }

    public static String createFilePath(String tempPath, String fileName) {
        BaseContext baseContext = (BaseContext)AppUtil.getBean(BaseContext.class);
        String tenantId = baseContext.getCurrentTenantId();
        Calendar cal = Calendar.getInstance();
        Integer year = cal.get(1);
        Integer month = cal.get(2) + 1;
        File one = new File(File.separator + year + File.separator + tenantId + File.separator + month + File.separator + tempPath + File.separator);
        if (!one.exists()) {
            one.mkdirs();
        }
        return one.getPath() + File.separator + fileName;
    }

    public static String getFilePath(String tempPath, String fileName) {
        BaseContext baseContext = (BaseContext)AppUtil.getBean(BaseContext.class);
        String tenantId = baseContext.getCurrentTenantId();
        Calendar cal = Calendar.getInstance();
        Integer year = cal.get(1);
        Integer month = cal.get(2) + 1;
        File one = new File(File.separator + year + File.separator + tenantId + File.separator + month + File.separator + tempPath + File.separator);
        return one.getPath() + File.separator + fileName;
    }

    public static String getBasePath() {
        String attachPath = AppFileUtil.getAttachPath();
        if (StringUtil.isEmpty((String)attachPath)) {
            attachPath = AppFileUtil.getRealPath("/attachFiles/temp");
        }
        attachPath = StringUtil.trimSufffix((String)attachPath, (String)"\\");
        attachPath = StringUtil.trimSufffix((String)attachPath, (String)"/");
        return attachPath;
    }

    public static String createPath(String tempPath, String fileName) {
        File one = new File(tempPath);
        if (!one.exists()) {
            one.mkdirs();
        }
        return one.getPath() + File.separator + fileName;
    }

    public static void init(ServletContext _servletContext) {
        servletContext = _servletContext;
    }

    public static String getRealPath(String path) {
        return servletContext.getRealPath(path);
    }

    public static String getForderPath(String tempPath) {
        BaseContext baseContext = (BaseContext)AppUtil.getBean(BaseContext.class);
        String tenantId = baseContext.getCurrentTenantId();
        Calendar cal = Calendar.getInstance();
        Integer year = cal.get(1);
        Integer month = cal.get(2) + 1;
        File one = new File(File.separator + year + File.separator + tenantId + File.separator + month + File.separator + tempPath + File.separator);
        return one.getPath();
    }

    public static String getAliOssFolderPath(String tempPath) {
        BaseContext baseContext = (BaseContext)AppUtil.getBean(BaseContext.class);
        String tenantId = baseContext.getCurrentTenantId();
        Calendar cal = Calendar.getInstance();
        Integer year = cal.get(1);
        Integer month = cal.get(2) + 1;
        return year + "/" + tenantId + "/" + month + "/" + tempPath + "/";
    }

    public static AttachmentService getAttachmentService(String saveType) throws Exception {
        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
        return attachmentHandlerFactory.getCurrentServices(saveType);
    }

    public static AttachmentService getAttachmentService(Attachment attachment) throws Exception {
        return AppFileUtil.getAttachmentService(attachment.getStoreType());
    }

    public static void copy(Attachment source, Attachment target) throws Exception {
        AttachmentService sourceAttachmentService = AppFileUtil.getAttachmentService(source.getStoreType());
        AttachmentService targetAttachmentService = AppFileUtil.getAttachmentService(AppFileUtil.getSaveType(""));
        try (InputStream inputStream = sourceAttachmentService.getFileInputStream(source);){
            targetAttachmentService.upload(target, inputStream, "");
        }
    }

    public static void uploadByDefault(Attachment attachment, InputStream inputStream) throws Exception {
        AttachmentService targetAttachmentService = AppFileUtil.getAttachmentService(AppFileUtil.getSaveType(""));
        targetAttachmentService.upload(attachment, inputStream, "");
    }

    public static String getUploadPath(String fileName) {
        BaseContext baseContext = (BaseContext)AppUtil.getBean(BaseContext.class);
        String account = baseContext.getCurrentUserAccout();
        String saveType = AppFileUtil.getSaveType("");
        String filePath = AppFileUtil.createFilePath(account, fileName);
        if ("aliyunOss".equals(saveType)) {
            filePath = AppFileUtil.getAliOssFolderPath(account) + fileName;
        }
        return filePath;
    }
}

