/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.attachmentService;

import cn.hutool.core.io.IoUtil;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.hotent.base.attachment.Attachment;
import com.hotent.base.attachment.AttachmentService;
import com.hotent.base.attachment.MultipartFileParam;
import com.hotent.base.attachment.UploadShardResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.file.model.AwsConfig;
import com.hotent.file.util.AppFileUtil;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AwsAttachmentServiceImpl
implements AttachmentService {
    @Value(value="${aws.bucketName:null}")
    private String bucketName;
    @Resource
    AwsConfig awsConfig;

    public String getStoreType() {
        return "aws";
    }

    public void remove(Attachment attachment, String propertiesId) throws Exception {
    }

    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType(attachment.getContentType());
        objectMetadata.setContentLength(BeanUtils.isNotEmpty((Object)attachment.getByteCount()) ? attachment.getByteCount() : 0L);
        String keyStr = attachment.getFilePath();
        this.awsConfig.getAmazonS3().putObject(new PutObjectRequest(this.bucketName, keyStr, inputStream, objectMetadata));
    }

    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, attachment.getFilePath());
        S3Object s3Object = this.awsConfig.getAmazonS3().getObject(getObjectRequest);
        S3ObjectInputStream objectContent = s3Object.getObjectContent();
        IoUtil.copy((InputStream)objectContent, (OutputStream)outStream);
        IoUtil.close((Closeable)objectContent);
        IoUtil.close((Closeable)outStream);
        IoUtil.close((Closeable)s3Object);
    }

    public boolean chekckFile(Attachment attachment, String propertiesId) throws Exception {
        return false;
    }

    public byte[] getFileBytes(Attachment sysFile) throws Exception {
        return new byte[0];
    }

    public UploadShardResult uploadByShard(MultipartFileParam multipartFileParam, Attachment attachment, String propertiesId) throws Exception {
        return null;
    }

    public Map<String, Object> generatePolicy(Attachment attachment, String propertiesId) {
        return null;
    }

    public String getUrl(Attachment attachment, String propertiesId) throws UnsupportedEncodingException {
        return null;
    }

    public InputStream getFileInputStream(Attachment attachment) throws FileNotFoundException {
        return null;
    }

    public String getFilePath(String account, String fileName) {
        return AppFileUtil.getFilePath(account, fileName);
    }

    public String getCompressImage(Attachment attachment, int width, int quality) throws Exception {
        return null;
    }

    public String getFileRealPath(Attachment attachment, String propertiesId) {
        return null;
    }
}

