/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.attachmentService;

import cn.hutool.core.io.FileUtil;
import com.hotent.base.attachment.Attachment;
import com.hotent.base.attachment.AttachmentService;
import com.hotent.base.attachment.MultipartFileParam;
import com.hotent.base.attachment.UploadShardResult;
import com.hotent.base.exception.BaseException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.file.model.FtpEntity;
import com.hotent.file.model.UploadProperties;
import com.hotent.file.service.FlowUploadPropertiesService;
import com.hotent.file.util.AppFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Resource;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.springframework.stereotype.Service;

@Service
public class FtpAttachmentServiceImpl
implements AttachmentService {
    @Resource
    FlowUploadPropertiesService flowUploadPropertiesService;

    private void connect(FtpEntity ftpEntity, FTPClient ftp) {
        try {
            int reply;
            ftp.connect(ftpEntity.getUrl(), ftpEntity.getPort().intValue());
            FTPClientConfig conf = new FTPClientConfig("WINDOWS");
            conf.setServerLanguageCode("zh");
            boolean loginResult = ftp.login(ftpEntity.getUsername(), ftpEntity.getPassword());
            if (loginResult) {
                if (FTPReply.isPositiveCompletion((int)ftp.sendCommand("OPTS UTF8", "ON"))) {
                    ftpEntity.setLOCAL_CHARSET("UTF-8");
                }
                ftp.setControlEncoding(ftpEntity.getLOCAL_CHARSET());
                ftp.enterLocalPassiveMode();
                ftp.setFileType(2);
            }
            if (!FTPReply.isPositiveCompletion((int)(reply = ftp.getReplyCode()))) {
                ftp.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        FtpEntity ftpEntity = (FtpEntity)AppUtil.getBean(FtpEntity.class);
        FTPClient ftp = new FTPClient();
        ftpEntity = this.initUploadProperties(propertiesId, attachment, ftpEntity, true);
        String path = attachment.getFilePath();
        String fileName = attachment.getEntryptName() != false ? attachment.getId() : FileUtil.getName((String)attachment.getFilePath());
        path = this.replaceFileSeparator(path);
        path = new String(path.getBytes(ftpEntity.getLOCAL_CHARSET()), ftpEntity.getSERVER_CHARSET());
        this.validConnection(ftpEntity, ftp);
        this.CreateDirecroty(path, ftp);
        ftp.setFileType(2);
        boolean result = ftp.storeFile(fileName, inputStream);
        if (!result) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
        }
        inputStream.close();
    }

    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        if (!this.downloadFile(attachment, outStream, propertiesId).booleanValue()) {
            throw new BaseException("\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        outStream.close();
    }

    private Boolean downloadFile(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        String fileName = attachment.getEntryptName() != false ? attachment.getId() : FileUtil.getName((String)attachment.getFilePath());
        FTPClient ftp = this.getFtpClientByAttachment(attachment, propertiesId);
        FTPFile[] fs = ftp.listFiles();
        boolean tag = false;
        for (FTPFile ff : fs) {
            String n = ff.getName();
            if (!n.equals(fileName)) continue;
            tag = true;
            ftp.retrieveFile(fileName, outStream);
            break;
        }
        return tag;
    }

    private FTPClient getFtpClientByAttachment(Attachment attachment, String propertiesId) throws Exception {
        FtpEntity ftpEntity = (FtpEntity)AppUtil.getBean(FtpEntity.class);
        FTPClient ftp = new FTPClient();
        ftpEntity = this.initUploadProperties(propertiesId, attachment, ftpEntity, false);
        this.validConnection(ftpEntity, ftp);
        String path = attachment.getFilePath();
        path = this.replaceFileSeparator(path);
        path = this.getFtpPath(path);
        path = new String(path.getBytes(ftpEntity.getLOCAL_CHARSET()), ftpEntity.getSERVER_CHARSET());
        boolean changeResult = ftp.changeWorkingDirectory(path);
        if (!changeResult) {
            throw new RuntimeException("\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728");
        }
        return ftp;
    }

    public boolean chekckFile(Attachment attachment, String propertiesId) throws Exception {
        FtpEntity ftpEntity = (FtpEntity)AppUtil.getBean(FtpEntity.class);
        FTPClient ftp = new FTPClient();
        ftpEntity = this.initUploadProperties(propertiesId, attachment, ftpEntity, false);
        boolean ref = true;
        this.validConnection(ftpEntity, ftp);
        String path = attachment.getFilePath();
        path = this.replaceFileSeparator(path);
        String fileName = attachment.getEntryptName() != false ? attachment.getId() : FileUtil.getName((String)attachment.getFilePath());
        path = this.getFtpPath(path);
        path = new String(path.getBytes(ftpEntity.getLOCAL_CHARSET()), ftpEntity.getSERVER_CHARSET());
        boolean changeResult = ftp.changeWorkingDirectory(path);
        if (!changeResult) {
            ref = false;
        }
        FTPFile[] fs = ftp.listFiles();
        boolean tag = false;
        for (FTPFile ff : fs) {
            String n = ff.getName();
            if (!n.equals(fileName)) continue;
            tag = true;
            break;
        }
        if (!tag) {
            ref = false;
        }
        return ref;
    }

    public void remove(Attachment attachment, String propertiesId) throws Exception {
        FtpEntity ftpEntity = (FtpEntity)AppUtil.getBean(FtpEntity.class);
        FTPClient ftp = new FTPClient();
        ftpEntity = this.initUploadProperties(propertiesId, attachment, ftpEntity, false);
        this.validConnection(ftpEntity, ftp);
        String path = attachment.getFilePath();
        path = path.replace("/", "\\");
        path = path.replace("\\\\", "\\");
        path = this.replaceFileSeparator(path);
        String fileName = attachment.getEntryptName() != false ? attachment.getId() : FileUtil.getName((String)attachment.getFilePath());
        ftp.deleteFile(path + ftpEntity.getSeparator() + fileName);
    }

    private void validConnection(FtpEntity ftpEntity, FTPClient ftp) {
        try {
            if (!(ftp.isConnected() && ftp.isRemoteVerificationEnabled() && ftp.sendNoOp())) {
                this.connect(ftpEntity, ftp);
            }
            ftp.changeWorkingDirectory(File.separator);
        }
        catch (Exception e) {
            this.connect(ftpEntity, ftp);
        }
    }

    private boolean CreateDirecroty(String remote, FTPClient ftp) throws IOException {
        boolean success;
        block5: {
            success = true;
            remote = this.getFtpPath(remote);
            String separator = "/";
            String directory = remote + separator;
            if (directory.equalsIgnoreCase(separator) || this.changeWorkingDirectory(new String(directory), ftp)) break block5;
            int start = 0;
            int end = 0;
            start = directory.startsWith(separator) ? 1 : 0;
            end = directory.indexOf(separator, start);
            String path = "";
            String paths = "";
            do {
                String subDirectory = new String(remote.substring(start, end).getBytes("GBK"), "iso-8859-1");
                if (!this.existFile(path = path + separator + subDirectory, ftp)) {
                    if (this.makeDirectory(subDirectory, ftp)) {
                        this.changeWorkingDirectory(subDirectory, ftp);
                    } else {
                        System.out.println("\u521b\u5efa\u76ee\u5f55[" + subDirectory + "]\u5931\u8d25");
                        this.changeWorkingDirectory(subDirectory, ftp);
                    }
                } else {
                    this.changeWorkingDirectory(subDirectory, ftp);
                }
                paths = paths + separator + subDirectory;
            } while ((end = directory.indexOf(separator, start = end + 1)) > start);
        }
        return success;
    }

    private boolean changeWorkingDirectory(String directory, FTPClient ftp) {
        boolean flag = true;
        try {
            flag = ftp.changeWorkingDirectory(directory);
            if (flag) {
                System.out.println("\u8fdb\u5165\u6587\u4ef6\u5939" + directory + " \u6210\u529f\uff01");
            } else {
                System.out.println("\u8fdb\u5165\u6587\u4ef6\u5939" + directory + " \u5931\u8d25\uff01\u5f00\u59cb\u521b\u5efa\u6587\u4ef6\u5939");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return flag;
    }

    private boolean existFile(String path, FTPClient ftp) throws IOException {
        boolean flag = false;
        FTPFile[] ftpFileArr = ftp.listFiles(path);
        if (ftpFileArr.length > 0) {
            flag = true;
        }
        return flag;
    }

    private boolean makeDirectory(String dir, FTPClient ftp) {
        boolean flag = true;
        try {
            flag = ftp.makeDirectory(dir);
            if (flag) {
                System.out.println("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u6210\u529f\uff01");
            } else {
                System.out.println("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    private String replaceFileSeparator(String path) {
        String ftpFormatPath = this.regReplace(path, File.separator);
        if (path.equals(ftpFormatPath = ftpFormatPath.replaceAll("/\\w+\\.?(\\w+)?(\\s+)?$", ""))) {
            ftpFormatPath = this.getFtpPath(ftpFormatPath);
            ftpFormatPath = ftpFormatPath.replace(FileUtil.getName((String)ftpFormatPath), "");
            ftpFormatPath = ftpFormatPath.replaceAll("/", "\\\\");
        }
        return ftpFormatPath;
    }

    private String regReplace(String str, String replaceChar) {
        StringBuffer resultString = new StringBuffer();
        try {
            Pattern regex = Pattern.compile("[\\|/]");
            Matcher regexMatcher = regex.matcher(str);
            while (regexMatcher.find()) {
                regexMatcher.appendReplacement(resultString, replaceChar);
            }
            regexMatcher.appendTail(resultString);
        }
        catch (PatternSyntaxException ex) {
            ex.printStackTrace();
        }
        return resultString.toString();
    }

    public String getStoreType() {
        return "ftp";
    }

    private FtpEntity initUploadProperties(String propertiesId, Attachment defaultFile, FtpEntity ftpEntity, boolean isUpload) {
        String sysPath;
        UploadProperties uploadProperties;
        if (StringUtil.isNotEmpty((String)propertiesId) && BeanUtils.isNotEmpty((Object)(uploadProperties = this.flowUploadPropertiesService.getUploadProperties(propertiesId)))) {
            String location = uploadProperties.getLocation();
            if (isUpload && StringUtil.isNotEmpty((String)location)) {
                location = location.replace("/", "\\");
                defaultFile.setFilePath(location + defaultFile.getFilePath());
            }
            FtpEntity ftpEntity2 = new FtpEntity();
            ftpEntity2.setUrl(uploadProperties.getFtpUrl());
            ftpEntity2.setPort(uploadProperties.getFtpPort());
            ftpEntity2.setUsername(uploadProperties.getFtpUserName());
            ftpEntity2.setPassword(uploadProperties.getFtpPassword());
            defaultFile.setEntryptName(Boolean.valueOf(uploadProperties.getEncryptName() != 0));
            return ftpEntity2;
        }
        if (isUpload && StringUtil.isNotEmpty((String)(sysPath = AppFileUtil.getAttachPath()))) {
            sysPath = sysPath.replace("/", "\\");
            defaultFile.setFilePath(sysPath + defaultFile.getFilePath());
        }
        return ftpEntity;
    }

    public byte[] getFileBytes(Attachment attachment) throws Exception {
        String propertiesId = BeanUtils.isNotEmpty((Object)attachment) ? attachment.getProp6() : "";
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            this.downloadFile(attachment, outStream, propertiesId);
            byte[] byArray = outStream.toByteArray();
            return byArray;
        }
    }

    private String getFtpPath(String path) {
        if (StringUtil.isNotEmpty((String)path)) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }

    public UploadShardResult uploadByShard(MultipartFileParam multipartFileParam, Attachment attachment, String propertiesId) throws Exception {
        return null;
    }

    public Map<String, Object> generatePolicy(Attachment attachment, String propertiesId) {
        return null;
    }

    public String getUrl(Attachment attachment, String propertiesId) throws UnsupportedEncodingException {
        return null;
    }

    public InputStream getFileInputStream(Attachment attachment) throws Exception {
        String fileName = attachment.getEntryptName() != false ? attachment.getId() : FileUtil.getName((String)attachment.getFilePath());
        FTPClient ftp = this.getFtpClientByAttachment(attachment, "");
        FTPFile[] fs = ftp.listFiles();
        InputStream inputStream = null;
        for (FTPFile ff : fs) {
            String n = ff.getName();
            if (!n.equals(fileName)) continue;
            inputStream = ftp.retrieveFileStream(fileName);
            break;
        }
        return inputStream;
    }

    public String getFilePath(String account, String fileName) {
        return AppFileUtil.getFilePath(account, fileName);
    }

    public String getCompressImage(Attachment attachment, int width, int quality) throws Exception {
        return null;
    }

    public String getFileRealPath(Attachment attachment, String propertiesId) {
        return null;
    }
}

