/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.util;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ResponseHeaderOverrides;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.cache.annotation.SecondaryCache;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.file.model.AliyunOssSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;

@Service
public class AliOssUtil {
    public static final long EXPIRE_TIME = 1800000L;
    public static final long MAX_EXPIRE_TIME = Long.MAX_VALUE;

    public static String getFileSignedUrl(String objectName, String fileName) {
        AliOssUtil aliOssUtil = (AliOssUtil)AppUtil.getBean(AliOssUtil.class);
        return aliOssUtil.createSignedUrl(objectName, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Cacheable(value={"eip:file:signed:url"}, key="#objectName", firstCache=@FirstCache(expireTime=1500, timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=1500, preloadTime=300, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public String createSignedUrl(String objectName, String fileName) {
        AliyunOssSettings ossSettings = (AliyunOssSettings)AppUtil.getBean(AliyunOssSettings.class);
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        try {
            Date expiration = new Date(System.currentTimeMillis() + 1800000L);
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(ossSettings.getBucketName(), objectName);
            request.setExpiration(expiration);
            if (StringUtil.isNotEmpty((String)fileName)) {
                ResponseHeaderOverrides headers = new ResponseHeaderOverrides();
                headers.setContentDisposition(String.format("attachment;filename=%s", fileName));
                request.setResponseHeaders(headers);
            }
            URL url = ossClient.generatePresignedUrl(request);
            String string = url.toString();
            return string;
        }
        finally {
            ossClient.shutdown();
        }
    }

    @CacheEvict(value={"eip:file:signed:url"}, key="#objectName")
    public void removeSignedUrlCache(String objectName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressOssImage(String objectName, OutputStream outputStream, int width, int quality) throws IOException {
        AliyunOssSettings ossSettings = (AliyunOssSettings)AppUtil.getBean(AliyunOssSettings.class);
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        InputStream inputStream = null;
        try {
            String style = "image/resize,m_mfit,w_" + width + ",q_" + quality;
            GetObjectRequest request = new GetObjectRequest(ossSettings.getBucketName(), objectName);
            request.setProcess(style);
            inputStream = ossClient.getObject(request).getObjectContent();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getForeverUrl(String objectName) {
        AliyunOssSettings ossSettings = (AliyunOssSettings)AppUtil.getBean(AliyunOssSettings.class);
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        try {
            Date expiration = new Date(Long.MAX_VALUE);
            URL url = ossClient.generatePresignedUrl(ossSettings.getBucketName(), objectName, expiration);
            String string = url.toString();
            return string;
        }
        finally {
            ossClient.shutdown();
        }
    }
}

