/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hotent.file.model.FileType;
import com.hotent.file.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class ZipReader {
    static Pattern pattern = Pattern.compile("^\\d+");
    @Autowired
    FileUtils fileUtils;
    @Value(value="${file.file.dir}")
    String fileDir;
    ExecutorService executors = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    public static Comparator<FileNode> sortComparator = new Comparator<FileNode>(){
        Collator cmp = Collator.getInstance(Locale.US);

        @Override
        public int compare(FileNode o1, FileNode o2) {
            BigDecimal num2;
            BigDecimal num1 = ZipReader.isStartNumber(o1);
            if (null != num1 && null != (num2 = ZipReader.isStartNumber(o2))) {
                return num1.subtract(num2).intValue();
            }
            CollationKey c1 = this.cmp.getCollationKey(o1.getOriginName());
            CollationKey c2 = this.cmp.getCollationKey(o2.getOriginName());
            return this.cmp.compare(c1.getSourceString(), c2.getSourceString());
        }
    };

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readZipFile(String filePath, String fileKey) {
        this.fileDir = filePath.substring(0, filePath.lastIndexOf(File.separator) + 1);
        String archiveSeparator = "/";
        HashMap appender = Maps.newHashMap();
        ArrayList<String> imgUrls = new ArrayList<String>();
        String archiveFileName = this.fileUtils.getFileNameFromPath(filePath);
        try (ZipFile zipFile = new ZipFile(filePath, this.fileUtils.getFileEncodeUTFGBK(filePath));){
            Enumeration<ZipArchiveEntry> entries = zipFile.getEntries();
            entries = this.sortZipEntries(entries);
            ArrayList entriesToBeExtracted = Lists.newArrayList();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = entries.nextElement();
                String fullName = entry.getName();
                int level = fullName.split(archiveSeparator).length;
                String originName = ZipReader.getLastFileName(fullName, archiveSeparator);
                String childName = level + "_" + originName;
                boolean directory = entry.isDirectory();
                if (!directory) {
                    childName = archiveFileName + "_" + originName;
                    entriesToBeExtracted.add(Collections.singletonMap(childName, entry));
                }
                String parentName = ZipReader.getLast2FileName(fullName, archiveSeparator, archiveFileName);
                parentName = level - 1 + "_" + parentName;
                FileType type = this.fileUtils.typeFromUrl(childName);
                if (type.equals((Object)FileType.picture)) {
                    imgUrls.add(childName);
                }
                FileNode node = new FileNode(originName, childName, parentName, new ArrayList<FileNode>(), directory, fileKey);
                this.addNodes(appender, parentName, node);
                appender.put(childName, node);
            }
            this.executors.submit(new ZipExtractorWorker(entriesToBeExtracted, zipFile, filePath));
            String string = new ObjectMapper().writeValueAsString(appender.get(""));
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Enumeration<ZipArchiveEntry> sortZipEntries(Enumeration<ZipArchiveEntry> entries) {
        ArrayList sortedEntries = Lists.newArrayList();
        while (entries.hasMoreElements()) {
            sortedEntries.add(entries.nextElement());
        }
        Collections.sort(sortedEntries, Comparator.comparingInt(o -> o.getName().length()));
        return Collections.enumeration(sortedEntries);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String unRar(String filePath, String fileKey) {
        HashMap appender = Maps.newHashMap();
        ArrayList imgUrls = Lists.newArrayList();
        String baseUrl = (String)RequestContextHolder.currentRequestAttributes().getAttribute("baseUrl", 0);
        try (Archive archive = new Archive(new File(filePath));){
            List<FileHeader> headers = archive.getFileHeaders();
            headers = this.sortedHeaders(headers);
            String archiveFileName = this.fileUtils.getFileNameFromPath(filePath);
            ArrayList headersToBeExtracted = Lists.newArrayList();
            for (FileHeader header : headers) {
                String originName;
                String fullName = header.isUnicode() ? header.getFileNameW() : header.getFileNameString();
                String childName = originName = ZipReader.getLastFileName(fullName, "\\");
                boolean directory = header.isDirectory();
                if (!directory) {
                    childName = archiveFileName + "_" + originName;
                    headersToBeExtracted.add(Collections.singletonMap(childName, header));
                }
                String parentName = ZipReader.getLast2FileName(fullName, "\\", archiveFileName);
                FileType type = this.fileUtils.typeFromUrl(childName);
                if (type.equals((Object)FileType.picture)) {
                    imgUrls.add(baseUrl + childName);
                }
                FileNode node = new FileNode(originName, childName, parentName, new ArrayList<FileNode>(), directory, fileKey);
                this.addNodes(appender, parentName, node);
                appender.put(childName, node);
            }
            this.executors.submit(new RarExtractorWorker(headersToBeExtracted, archive, filePath));
            String string = new ObjectMapper().writeValueAsString(appender.get(""));
            return string;
        }
        catch (RarException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addNodes(Map<String, FileNode> appender, String parentName, FileNode node) {
        if (appender.containsKey(parentName)) {
            appender.get(parentName).getChildList().add(node);
            Collections.sort(appender.get(parentName).getChildList(), sortComparator);
        } else {
            FileNode nodeRoot = new FileNode(parentName, parentName, "", new ArrayList<FileNode>(), true);
            nodeRoot.getChildList().add(node);
            appender.put("", nodeRoot);
            appender.put(parentName, nodeRoot);
        }
    }

    private List<FileHeader> sortedHeaders(List<FileHeader> headers) {
        ArrayList<FileHeader> sortedHeaders = new ArrayList<FileHeader>();
        TreeMap mapHeaders = new TreeMap();
        headers.forEach(header -> mapHeaders.put(header.getFileNameW().length(), header));
        for (Map.Entry entry : mapHeaders.entrySet()) {
            for (FileHeader header2 : headers) {
                if (((Integer)entry.getKey()).intValue() != header2.getFileNameW().length()) continue;
                sortedHeaders.add(header2);
            }
        }
        return sortedHeaders;
    }

    private static String getLast2FileName(String fullName, String seperator, String rootName) {
        int endIndex;
        String leftPath;
        if (fullName.endsWith(seperator)) {
            fullName = fullName.substring(0, fullName.length() - 1);
        }
        if (null != (leftPath = fullName.substring(0, (endIndex = fullName.lastIndexOf(seperator)) == -1 ? 0 : endIndex)) && leftPath.length() > 1) {
            return ZipReader.getLastFileName(leftPath, seperator);
        }
        return rootName;
    }

    private static String getLastFileName(String fullName, String seperator) {
        if (fullName.endsWith(seperator)) {
            fullName = fullName.substring(0, fullName.length() - 1);
        }
        String newName = fullName;
        if (null != fullName && fullName.contains(seperator)) {
            newName = fullName.substring(fullName.lastIndexOf(seperator) + 1);
        }
        return newName;
    }

    private static BigDecimal isStartNumber(FileNode src) {
        Matcher matcher = pattern.matcher(src.getOriginName());
        if (matcher.find()) {
            return new BigDecimal(matcher.group());
        }
        return null;
    }

    class RarExtractorWorker
    implements Runnable {
        private List<Map<String, FileHeader>> headersToBeExtracted;
        private Archive archive;
        private String filePath;

        public RarExtractorWorker(List<Map<String, FileHeader>> headersToBeExtracted, Archive archive, String filePath) {
            this.headersToBeExtracted = headersToBeExtracted;
            this.archive = archive;
            this.filePath = filePath;
        }

        @Override
        public void run() {
            System.out.println("\u89e3\u6790\u538b\u7f29\u6587\u4ef6\u5f00\u59cb\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a");
            for (Map<String, FileHeader> entryMap : this.headersToBeExtracted) {
                String childName = entryMap.keySet().iterator().next();
                this.extractRarFile(childName, entryMap.values().iterator().next(), this.archive);
            }
            try {
                this.archive.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (new File(this.filePath).exists()) {
                new File(this.filePath).delete();
            }
            System.out.println("\u89e3\u6790\u538b\u7f29\u6587\u4ef6\u7ed3\u675f\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a");
        }

        private void extractRarFile(String childName, FileHeader header, Archive archive) {
            String outPath = ZipReader.this.fileDir + childName;
            try (FileOutputStream ot = new FileOutputStream(outPath);){
                archive.extractFile(header, (OutputStream)ot);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RarException e) {
                e.printStackTrace();
            }
        }
    }

    class ZipExtractorWorker
    implements Runnable {
        private List<Map<String, ZipArchiveEntry>> entriesToBeExtracted;
        private ZipFile zipFile;
        private String filePath;

        public ZipExtractorWorker(List<Map<String, ZipArchiveEntry>> entriesToBeExtracted, ZipFile zipFile, String filePath) {
            this.entriesToBeExtracted = entriesToBeExtracted;
            this.zipFile = zipFile;
            this.filePath = filePath;
        }

        @Override
        public void run() {
            System.out.println("\u89e3\u6790\u538b\u7f29\u6587\u4ef6\u5f00\u59cb\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a");
            for (Map<String, ZipArchiveEntry> entryMap : this.entriesToBeExtracted) {
                String childName = entryMap.keySet().iterator().next();
                ZipArchiveEntry entry = entryMap.values().iterator().next();
                try {
                    this.extractZipFile(childName, this.zipFile.getInputStream(entry));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (new File(this.filePath).exists()) {
                new File(this.filePath).delete();
            }
            System.out.println("\u89e3\u6790\u538b\u7f29\u6587\u4ef6\u7ed3\u675f\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a");
        }

        private void extractZipFile(String childName, InputStream zipFile) {
            String outPath = ZipReader.this.fileDir + childName;
            try (FileOutputStream ot = new FileOutputStream(outPath);){
                int len;
                byte[] inByte = new byte[1024];
                while (-1 != (len = zipFile.read(inByte))) {
                    ((OutputStream)ot).write(inByte, 0, len);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class FileNode {
        private String originName;
        private String fileName;
        private String parentFileName;
        private boolean directory;
        private String fileKey;
        private List<FileNode> childList;

        public FileNode() {
        }

        public FileNode(String originName, String fileName, String parentFileName, List<FileNode> childList, boolean directory) {
            this.originName = originName;
            this.fileName = fileName;
            this.parentFileName = parentFileName;
            this.childList = childList;
            this.directory = directory;
        }

        public FileNode(String originName, String fileName, String parentFileName, List<FileNode> childList, boolean directory, String fileKey) {
            this.originName = originName;
            this.fileName = fileName;
            this.parentFileName = parentFileName;
            this.childList = childList;
            this.directory = directory;
            this.fileKey = fileKey;
        }

        public String getFileKey() {
            return this.fileKey;
        }

        public void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getParentFileName() {
            return this.parentFileName;
        }

        public void setParentFileName(String parentFileName) {
            this.parentFileName = parentFileName;
        }

        public List<FileNode> getChildList() {
            return this.childList;
        }

        public void setChildList(List<FileNode> childList) {
            this.childList = childList;
        }

        public String toString() {
            try {
                return new ObjectMapper().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return "";
            }
        }

        public String getOriginName() {
            return this.originName;
        }

        public void setOriginName(String originName) {
            this.originName = originName;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public void setDirectory(boolean directory) {
            this.directory = directory;
        }
    }
}

