/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.attachmentService;

import cn.hutool.core.io.IoUtil;
import cn.hutool.json.JSONUtil;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.StorageClass;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import com.hotent.base.attachment.Attachment;
import com.hotent.base.attachment.AttachmentService;
import com.hotent.base.attachment.MultipartFileParam;
import com.hotent.base.attachment.UploadShardResult;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.cache.annotation.SecondaryCache;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.file.model.AliyunOssObject;
import com.hotent.file.model.AliyunOssSettings;
import com.hotent.file.model.FileInfo;
import com.hotent.file.model.UploadProperties;
import com.hotent.file.service.FlowUploadPropertiesService;
import com.hotent.file.util.AliOssUtil;
import com.hotent.file.util.AppFileUtil;
import io.jsonwebtoken.lang.Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class AliyunOssAttachmentServiceImpl
implements AttachmentService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String aliyunOssTempDir = File.separator + "aliyunOssTempDir";
    @Resource
    FlowUploadPropertiesService flowUploadPropertiesService;
    @Resource
    AliyunOssAttachmentServiceImpl aliyunOssAttachmentService;

    private AliyunOssObject initOssObject(Attachment attachment, String propertiesId) {
        AliyunOssObject aliyunOssObject = new AliyunOssObject();
        AliyunOssSettings ossSettings = (AliyunOssSettings)AppUtil.getBean(AliyunOssSettings.class);
        aliyunOssObject.setAliyunOssSettings(ossSettings);
        this.setObjectKeyAndFilePath(attachment, aliyunOssObject);
        if (StringUtil.isNotEmpty((String)propertiesId)) {
            UploadProperties uploadProperties = this.flowUploadPropertiesService.getUploadProperties(propertiesId, ossSettings);
            attachment.setEntryptName(Boolean.valueOf(uploadProperties.getEncryptName() != 0));
            this.setObjectKeyAndFilePath(attachment, aliyunOssObject);
        }
        return aliyunOssObject;
    }

    private void setObjectKeyAndFilePath(Attachment attachment, AliyunOssObject ossObject) {
        String filePath = this.getFileRealPath(attachment, null);
        ossObject.setObjectKey(filePath);
        attachment.setFilePath(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Attachment attachment, String propertiesId) throws Exception {
        AliyunOssObject ossObject = this.initOssObject(attachment, propertiesId);
        AliyunOssSettings ossSettings = ossObject.getAliyunOssSettings();
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        try {
            if (!ossClient.doesBucketExist(ossSettings.getBucketName())) {
                ossClient.createBucket(ossSettings.getBucketName());
            }
            ossClient.deleteObject(ossSettings.getBucketName(), ossObject.getObjectKey());
        }
        finally {
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        AliyunOssObject ossObject = this.initOssObject(attachment, propertiesId);
        AliyunOssSettings ossSettings = ossObject.getAliyunOssSettings();
        String objectKey = this.getFileRealPath(attachment, propertiesId);
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        try {
            if (!ossClient.doesBucketExist(ossSettings.getBucketName())) {
                ossClient.createBucket(ossSettings.getBucketName());
            }
            if (BeanUtils.isEmpty((Object)inputStream)) {
                ossClient.putObject(ossSettings.getBucketName(), objectKey, (InputStream)new ByteArrayInputStream(attachment.getBytes()));
            } else {
                ossClient.putObject(ossSettings.getBucketName(), objectKey, inputStream);
            }
        }
        finally {
            inputStream.close();
            ossClient.shutdown();
            this.removeTemp(attachment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        AliyunOssObject aliyunOssObject = this.initOssObject(attachment, propertiesId);
        AliyunOssSettings ossSettings = aliyunOssObject.getAliyunOssSettings();
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        try (OSSObject ossObject = ossClient.getObject(ossSettings.getBucketName(), aliyunOssObject.getObjectKey());){
            if (!ossClient.doesBucketExist(ossSettings.getBucketName())) {
                ossClient.createBucket(ossSettings.getBucketName());
            }
            IoUtil.copy((InputStream)ossObject.getObjectContent(), (OutputStream)outStream);
        }
        finally {
            outStream.close();
            ossClient.shutdown();
        }
    }

    public String getStoreType() {
        return "aliyunOss";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chekckFile(Attachment attachment, String propertiesId) throws Exception {
        AliyunOssObject aliyunOssObject = this.initOssObject(attachment, propertiesId);
        AliyunOssSettings ossSettings = aliyunOssObject.getAliyunOssSettings();
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        try {
            boolean found;
            if (!ossClient.doesBucketExist(ossSettings.getBucketName())) {
                ossClient.createBucket(ossSettings.getBucketName());
            }
            boolean bl = found = ossClient.doesObjectExist(ossSettings.getBucketName(), aliyunOssObject.getObjectKey());
            return bl;
        }
        finally {
            ossClient.shutdown();
        }
    }

    public String getLocalTempFilePath(Attachment attachment) {
        String localFilePath = attachment.getFilePath();
        localFilePath = localFilePath.replace("/", File.separator);
        if (!attachment.getFilePath().startsWith(File.separator)) {
            localFilePath = File.separator + localFilePath;
        }
        localFilePath = this.aliyunOssTempDir + localFilePath;
        return localFilePath;
    }

    /*
     * Exception decompiling
     */
    public byte[] getFileBytes(Attachment attachment) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public UploadShardResult uploadByShard(MultipartFileParam multipartFileParam, Attachment attachment, String propertiesId) throws Exception {
        multipartFileParam.setUniqueKey(multipartFileParam.getIdentifier() + "_" + multipartFileParam.getUniqueIdCard());
        String uploadId = this.aliyunOssAttachmentService.getUploadIdFromCache(multipartFileParam.getUniqueKey());
        String fileId = this.aliyunOssAttachmentService.getIdentifierIdFromCache(multipartFileParam.getUniqueKey());
        OSS ossClient = null;
        try {
            UploadShardResult uploadShardResult;
            if (StringUtil.isEmpty((String)fileId)) {
                fileId = UniqueIdUtil.getSuid();
                this.aliyunOssAttachmentService.putIdentifierIdCache(multipartFileParam.getUniqueKey(), fileId);
            }
            attachment.setId(fileId);
            AliyunOssObject aliyunOssObject = this.initOssObject(attachment, propertiesId);
            AliyunOssSettings ossSettings = aliyunOssObject.getAliyunOssSettings();
            ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
            if (!ossClient.doesBucketExist(ossSettings.getBucketName())) {
                ossClient.createBucket(ossSettings.getBucketName());
            }
            if (StringUtil.isEmpty((String)uploadId)) {
                uploadId = this.initUploadId(multipartFileParam, attachment, aliyunOssObject, ossClient);
            }
            multipartFileParam.setAliyunOssUploadId(uploadId);
            UploadShardResult uploadShardResult2 = uploadShardResult = this.partUpload(multipartFileParam, attachment, aliyunOssObject, ossClient);
            return uploadShardResult2;
        }
        catch (Exception e) {
            this.aliyunOssAttachmentService.delUploadIdCache(multipartFileParam.getUniqueKey());
            this.aliyunOssAttachmentService.delPartTagListCache(multipartFileParam.getUniqueKey());
            this.aliyunOssAttachmentService.delIdentifierIdCache(multipartFileParam.getUniqueKey());
            throw e;
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public String initUploadId(MultipartFileParam multipartFileParam, Attachment attachment, AliyunOssObject aliyunOssObject, OSS ossClient) {
        AliyunOssSettings ossSettings = aliyunOssObject.getAliyunOssSettings();
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setHeader("x-oss-storage-class", (Object)StorageClass.Standard.toString());
        metadata.setCacheControl("no-cache");
        metadata.setObjectAcl(CannedAccessControlList.Private);
        metadata.setContentDisposition("attachment;filename=" + attachment.getFileName());
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(ossSettings.getBucketName(), aliyunOssObject.getObjectKey());
        InitiateMultipartUploadResult upResult = ossClient.initiateMultipartUpload(request);
        String uploadId = upResult.getUploadId();
        this.aliyunOssAttachmentService.putUploadIdCache(multipartFileParam.getUniqueKey(), uploadId);
        this.aliyunOssAttachmentService.putPartETagListCache(multipartFileParam.getUniqueKey(), new ArrayList<PartETag>());
        return uploadId;
    }

    public UploadShardResult partUpload(MultipartFileParam multipartFileParam, Attachment attachment, AliyunOssObject aliyunOssObject, OSS ossClient) throws Exception {
        AliyunOssSettings ossSettings = aliyunOssObject.getAliyunOssSettings();
        String uploadId = multipartFileParam.getAliyunOssUploadId();
        StopWatch st = new StopWatch();
        st.start();
        UploadPartRequest uploadPartRequest = new UploadPartRequest();
        uploadPartRequest.setUploadId(uploadId);
        uploadPartRequest.setPartNumber(multipartFileParam.getChunkNumber());
        uploadPartRequest.setPartSize(multipartFileParam.getCurrentChunkSize());
        uploadPartRequest.setBucketName(ossSettings.getBucketName());
        uploadPartRequest.setKey(aliyunOssObject.getObjectKey());
        UploadPartResult uploadPartResult = null;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(multipartFileParam.getFile().getBytes());){
            uploadPartRequest.setInputStream((InputStream)inputStream);
            uploadPartResult = ossClient.uploadPart(uploadPartRequest);
        }
        catch (OSSException e) {
            e.printStackTrace();
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
        }
        catch (ClientException e) {
            e.printStackTrace();
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25,\u5ba2\u6237\u7aef\u9519\u8bef:" + e.getMessage());
        }
        st.stop();
        this.logger.info("{}\u6587\u4ef6\u7b2c {} \u7247\u4e0a\u4f20\u6210\u529f,\u4e0a\u4f20\u7ed3\u679c:{},\u8017\u65f6:{}", new Object[]{uploadId, uploadPartRequest.getPartNumber(), JSONUtil.toJsonStr((Object)uploadPartResult), st.getTotalTimeMillis()});
        List<PartETag> partETagList = this.aliyunOssAttachmentService.getPartTagListFromCache(multipartFileParam.getUniqueKey());
        Assert.notNull(partETagList, (String)"\u83b7\u53d6\u7f13\u5b58\u5206\u7247\u5386\u53f2\u5931\u8d25\uff01");
        partETagList.add(uploadPartResult.getPartETag());
        this.aliyunOssAttachmentService.putPartETagListCache(multipartFileParam.getUniqueKey(), partETagList);
        if (multipartFileParam.getChunkNumber() == multipartFileParam.getTotalChunks()) {
            this.mergeMultipart(partETagList, uploadId, aliyunOssObject, ossClient);
            this.aliyunOssAttachmentService.delUploadIdCache(multipartFileParam.getUniqueKey());
            this.aliyunOssAttachmentService.delPartTagListCache(multipartFileParam.getUniqueKey());
            this.aliyunOssAttachmentService.delIdentifierIdCache(multipartFileParam.getUniqueKey());
            return new UploadShardResult(true);
        }
        return new UploadShardResult(false);
    }

    private CompleteMultipartUploadResult mergeMultipart(List<PartETag> partTagList, String uploadId, AliyunOssObject aliyunOssObject, OSS ossClient) throws Exception {
        AliyunOssSettings ossSettings = aliyunOssObject.getAliyunOssSettings();
        try {
            StopWatch st = new StopWatch();
            st.start();
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(ossSettings.getBucketName(), aliyunOssObject.getObjectKey(), uploadId, partTagList);
            this.logger.info("{}\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210,\u5f00\u59cb\u5408\u5e76,partList:{}", (Object)uploadId, (Object)JSONUtil.toJsonStr(partTagList));
            CompleteMultipartUploadResult completeMultipartUploadResult = ossClient.completeMultipartUpload(completeMultipartUploadRequest);
            st.stop();
            this.logger.info("{}\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210,\u4e0a\u4f20\u7ed3\u679c:{},\u8017\u65f6:{}", new Object[]{uploadId, JSONUtil.toJsonStr((Object)completeMultipartUploadResult), st.getTotalTimeMillis()});
            return completeMultipartUploadResult;
        }
        catch (OSSException e) {
            this.logger.error("\u5408\u5e76\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u5408\u5e76\u5931\u8d25:" + e.getMessage());
        }
        catch (ClientException e) {
            this.logger.error("\u5408\u5e76\u5931\u8d25,\u5ba2\u6237\u7aef\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u5408\u5e76\u5931\u8d25,\u5ba2\u6237\u7aef\u5f02\u5e38:" + e.getMessage());
        }
    }

    @Cacheable(value={"eip:upload:aliyun:id"}, key="#key", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.DAYS), secondaryCache=@SecondaryCache(expireTime=1, timeUnit=TimeUnit.DAYS))
    public String getUploadIdFromCache(String key) {
        return null;
    }

    @CachePut(value={"eip:upload:aliyun:id"}, key="#key", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.DAYS), secondaryCache=@SecondaryCache(expireTime=1, timeUnit=TimeUnit.DAYS))
    public String putUploadIdCache(String key, String uploadId) {
        return uploadId;
    }

    @CacheEvict(value={"eip:upload:aliyun:id"}, key="#key")
    public void delUploadIdCache(String key) {
    }

    @Cacheable(value={"eip:upload:aliyun:partList"}, key="#key", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.DAYS), secondaryCache=@SecondaryCache(expireTime=1, timeUnit=TimeUnit.DAYS))
    public List<PartETag> getPartTagListFromCache(String key) {
        return null;
    }

    @CachePut(value={"eip:upload:aliyun:partList"}, key="#key", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.DAYS), secondaryCache=@SecondaryCache(expireTime=1, timeUnit=TimeUnit.DAYS))
    public List<PartETag> putPartETagListCache(String key, List<PartETag> partETagList) {
        return partETagList;
    }

    @CacheEvict(value={"eip:upload:aliyun:partList"}, key="#key")
    public void delPartTagListCache(String key) {
    }

    @Cacheable(value={"eip:upload:aliyun:fileId"}, key="#key", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.DAYS), secondaryCache=@SecondaryCache(expireTime=1, timeUnit=TimeUnit.DAYS))
    public String getIdentifierIdFromCache(String key) {
        return null;
    }

    @CachePut(value={"eip:upload:aliyun:fileId"}, key="#key", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.DAYS), secondaryCache=@SecondaryCache(expireTime=1, timeUnit=TimeUnit.DAYS))
    public String putIdentifierIdCache(String key, String id) {
        return id;
    }

    @CacheEvict(value={"eip:upload:aliyun:fileId"}, key="#key")
    public void delIdentifierIdCache(String key) {
    }

    public Map<String, Object> generatePolicy(Attachment attachment, String propertiesId) throws Exception {
        AliyunOssObject aliyunOssObject = this.initOssObject(attachment, propertiesId);
        AliyunOssSettings ossSettings = aliyunOssObject.getAliyunOssSettings();
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        String host = "https://" + ossSettings.getBucketName() + "." + ossSettings.getEndpoint();
        String dir = attachment.getProp1();
        LinkedHashMap<String, Object> respMap = null;
        try {
            if (!ossClient.doesBucketExist(ossSettings.getBucketName())) {
                ossClient.createBucket(ossSettings.getBucketName());
            }
            long expireTime = 86400L;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 1L, 1048576000L);
            policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
            String postPolicy = ossClient.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = ossClient.calculatePostSignature(postPolicy);
            respMap = new LinkedHashMap<String, Object>();
            respMap.put("accessid", ossSettings.getAccessKeyId());
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("dir", dir);
            respMap.put("host", host);
            respMap.put("expire", String.valueOf(expireEndTime / 1000L));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ossClient.shutdown();
        }
        return respMap;
    }

    public String getUrl(Attachment attachment, String propertiesId) throws Exception {
        Map<String, Object> map = this.generatePolicy(attachment, "");
        String host = BeanUtils.isEmpty((Object)map.get("host")) ? "" : map.get("host").toString();
        String dir = BeanUtils.isEmpty((Object)map.get("dir")) ? "" : map.get("dir").toString();
        String accessid = BeanUtils.isEmpty((Object)map.get("accessid")) ? "" : map.get("accessid").toString();
        String signature = BeanUtils.isEmpty((Object)map.get("signature")) ? "" : map.get("signature").toString();
        String Expires = BeanUtils.isEmpty((Object)map.get("Expires")) ? "" : map.get("Expires").toString();
        String s = "OSSAccessKeyId=" + accessid + "&Signature=" + signature + "&Expires=" + Expires;
        return host + "/" + dir + "?" + URLEncoder.encode(s, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getFileInputStream(Attachment attachment) throws FileNotFoundException {
        String localFilePath = this.getLocalTempFilePath(attachment);
        FileUtil.createFolderFile((String)localFilePath);
        File file = new File(localFilePath);
        if (!file.exists()) {
            AliyunOssSettings ossSettings = (AliyunOssSettings)AppUtil.getBean(AliyunOssSettings.class);
            OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
            try {
                if (!ossClient.doesBucketExist(ossSettings.getBucketName())) {
                    ossClient.createBucket(ossSettings.getBucketName());
                }
                ossClient.getObject(new GetObjectRequest(ossSettings.getBucketName(), attachment.getFilePath()), file);
            }
            finally {
                ossClient.shutdown();
            }
        }
        return new FileInputStream(file);
    }

    public String getFilePath(String account, String fileName) {
        if (StringUtil.isEmpty((String)account)) {
            account = "_unknow";
        }
        return AppFileUtil.getAliOssFolderPath(account) + fileName;
    }

    public String getCompressImage(Attachment attachment, int width, int quality) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        AliOssUtil.compressOssImage(attachment.getFilePath(), outputStream, 28, 90);
        String thumbnailName = attachment.getId() + ".thumbnail.jpg";
        FileInfo thumbnailFile = new FileInfo();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());){
            String filePath = AppFileUtil.getUploadPath(thumbnailName);
            thumbnailFile.setFilePath(filePath);
            thumbnailFile.setEntryptName(true);
            this.upload(thumbnailFile, inputStream, null);
            String string = AliOssUtil.getForeverUrl(thumbnailFile.getFilePath());
            return string;
        }
    }

    public String getFileRealPath(Attachment attachment, String propertiesId) {
        String fileParentPath = "";
        String filePath = attachment.getFilePath();
        if (StringUtil.isNotEmpty((String)filePath)) {
            fileParentPath = Paths.get(filePath, new String[0]).getParent().toString();
            if ((fileParentPath = fileParentPath.replaceAll("\\\\", "/")).startsWith("/")) {
                fileParentPath = fileParentPath.substring(1);
            }
        }
        if (attachment.getUsePath() != null && attachment.getUsePath().booleanValue()) {
            return attachment.getFilePath().replaceAll("\\\\", "/");
        }
        if (StringUtil.isEmpty((String)attachment.getId())) {
            return filePath.replaceAll("\\\\", "/");
        }
        filePath = attachment.getEntryptName() != false ? fileParentPath + "/" + attachment.getId() + "." + attachment.getExtensionName() : fileParentPath + "/" + attachment.getId() + "_" + attachment.getFileName() + "." + attachment.getExtensionName();
        return filePath;
    }

    public void removeTemp(Attachment attachment) {
        String localFilePath = this.getLocalTempFilePath(attachment);
        FileUtil.createFolderFile((String)localFilePath);
        File file = new File(localFilePath);
        if (file.exists()) {
            file.delete();
        }
    }
}

