/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.attachmentService;

import cn.hutool.core.lang.Assert;
import com.hotent.base.attachment.Attachment;
import com.hotent.base.attachment.AttachmentService;
import com.hotent.base.attachment.MultipartFileParam;
import com.hotent.base.attachment.UploadShardResult;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.cache.annotation.SecondaryCache;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.ImageUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.file.model.UploadProperties;
import com.hotent.file.service.FlowUploadPropertiesService;
import com.hotent.file.util.AppFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FolderAttachmentServiceImpl
implements AttachmentService {
    @Resource
    FlowUploadPropertiesService flowUploadPropertiesService;
    @Resource
    FolderAttachmentServiceImpl folderAttachmentService;

    public void remove(Attachment attachment, String propertiesId) throws Exception {
        if (attachment == null) {
            return;
        }
        String fullPath = this.getFileRealPath(attachment, propertiesId);
        FileUtil.deleteFile((String)fullPath);
    }

    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        String filePath = this.getFileRealPath(attachment, propertiesId);
        FileUtil.createFolderFile((String)filePath);
        if (BeanUtils.isNotEmpty((Object)inputStream)) {
            FileUtil.writeFile((String)filePath, (InputStream)inputStream);
        } else {
            FileUtil.writeByte((String)filePath, (byte[])attachment.getBytes());
        }
    }

    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        String fullPath = this.getFileRealPath(attachment, propertiesId);
        File file = new File(fullPath);
        if (file.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(fullPath);
                byte[] b = new byte[1024];
                int i = 0;
                while ((i = inputStream.read(b)) > 0) {
                    outStream.write(b, 0, i);
                }
                outStream.flush();
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                }
            }
        } else {
            if (outStream != null) {
                CommonResult commonResult = new CommonResult(false, "\u8be5\u9644\u4ef6\u4e0d\u5b58\u5728");
                outStream.write(JsonUtil.toJsonString((Object)commonResult).getBytes());
                outStream.flush();
                outStream.close();
            }
            throw new BaseException("\u8be5\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public String getStoreType() {
        return "folder";
    }

    public boolean chekckFile(Attachment attachment, String propertiesId) {
        String fullPath = this.getFileRealPath(attachment, propertiesId);
        File file = new File(fullPath);
        return file.exists();
    }

    private String getAttachPath(String propertiesId, Attachment attachment) {
        UploadProperties uploadProperties = this.flowUploadPropertiesService.getUploadProperties(propertiesId);
        String attachPath = "";
        if (BeanUtils.isNotEmpty((Object)uploadProperties)) {
            attachPath = uploadProperties.getLocation();
            attachment.setEntryptName(Boolean.valueOf(uploadProperties.getEncryptName() != 0));
        } else {
            attachPath = AppFileUtil.getAttachPath();
        }
        return attachPath;
    }

    public byte[] getFileBytes(Attachment sysFile) throws Exception {
        String fullPath;
        File file;
        String propertiesId = BeanUtils.isNotEmpty((Object)sysFile) ? sysFile.getProp6() : "";
        String location = this.getByUploadProperties(propertiesId);
        if (StringUtil.isEmpty((String)location)) {
            location = AppFileUtil.getAttachPath();
        }
        if ((file = new File(fullPath = sysFile.getFilePath().startsWith(location) ? sysFile.getFilePath() : StringUtil.trimSufffix((String)location, (String)File.separator) + File.separator + sysFile.getFilePath().replace("/", File.separator))).exists()) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(fullPath);
                byte[] b = new byte[1024];
                int i = 0;
                while ((i = inputStream.read(b)) > 0) {
                    outStream.write(b, 0, i);
                }
                outStream.flush();
                byte[] byArray = outStream.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                }
            }
        }
        throw new FileNotFoundException("\u8be5\u9644\u4ef6\u4e0d\u5b58\u5728");
    }

    private String getByUploadProperties(String propertiesId) {
        String location;
        UploadProperties uploadProperties;
        if (StringUtil.isNotEmpty((String)propertiesId) && BeanUtils.isNotEmpty((Object)(uploadProperties = this.flowUploadPropertiesService.getUploadProperties(propertiesId))) && StringUtil.isNotEmpty((String)(location = uploadProperties.getLocation()))) {
            return location.replace("/", File.separator);
        }
        return "";
    }

    public UploadShardResult uploadByShard(MultipartFileParam multipartFileParam, Attachment attachment, String propertiesId) throws Exception {
        String fileId;
        multipartFileParam.setUniqueKey(multipartFileParam.getIdentifier() + "_" + multipartFileParam.getUniqueIdCard());
        UploadShardResult uploadShardResult = new UploadShardResult();
        uploadShardResult.setComplete(false);
        String filePath = attachment.getFilePath();
        String attachPath = this.getAttachPath(propertiesId, attachment);
        String fileName = multipartFileParam.getFile().getOriginalFilename();
        String extensionName = "";
        if (fileName.indexOf(".") != -1) {
            extensionName = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        if (StringUtil.isEmpty((String)(fileId = this.folderAttachmentService.getIdentifierIdFromCache(multipartFileParam.getUniqueKey())))) {
            fileId = UniqueIdUtil.getSuid();
            this.folderAttachmentService.putIdentifierIdCache(multipartFileParam.getUniqueKey(), fileId);
        }
        attachment.setId(fileId);
        String fullFilePath = attachPath + File.separator + filePath;
        String tempFilePath = fullFilePath.substring(0, fullFilePath.lastIndexOf(File.separator));
        String tempFileName = fileId + "." + extensionName + ".tmp";
        FileUtil.createFolderFile((String)fullFilePath);
        File tempFile = new File(tempFilePath, tempFileName);
        try (RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");
             FileChannel fileChannel = raf.getChannel();){
            long position = (long)(multipartFileParam.getChunkNumber() - 1) * multipartFileParam.getChunkSize();
            byte[] fileData = multipartFileParam.getFile().getBytes();
            fileChannel.position(position);
            fileChannel.write(ByteBuffer.wrap(fileData));
            fileChannel.force(true);
        }
        boolean isComplete = this.checkUploadStatus(multipartFileParam, attachment, tempFilePath);
        if (!isComplete) {
            return uploadShardResult;
        }
        this.folderAttachmentService.delIdentifierIdCache(multipartFileParam.getUniqueKey());
        try (FileInputStream fileInputStream = new FileInputStream(tempFile.getPath());){
            String md5 = DigestUtils.md5Hex((InputStream)fileInputStream);
            if (StringUtils.isNotBlank((String)md5) && !md5.equals(multipartFileParam.getIdentifier())) {
                throw new IllegalArgumentException("MD5\u6821\u9a8c\u5931\u8d25");
            }
        }
        attachment.setFilePath(filePath.substring(0, filePath.lastIndexOf(File.separator)) + File.separator + attachment.getId() + "." + extensionName);
        this.renameFile(tempFile, attachment.getId() + "." + extensionName);
        uploadShardResult.setComplete(true);
        return uploadShardResult;
    }

    public Map<String, Object> generatePolicy(Attachment attachment, String propertiesId) {
        return null;
    }

    public String getUrl(Attachment attachment, String propertiesId) throws UnsupportedEncodingException {
        return null;
    }

    public InputStream getFileInputStream(Attachment attachment) throws FileNotFoundException {
        String filePath = attachment.getFilePath();
        String fullPath = StringUtil.trimSufffix((String)AppFileUtil.getAttachPath(), (String)File.separator) + File.separator + filePath.replace("/", File.separator);
        File file = new File(fullPath);
        if (file.exists()) {
            return new FileInputStream(fullPath);
        }
        throw new RuntimeException("\u8be5\u9644\u4ef6\u4e0d\u5b58\u5728");
    }

    public String getFilePath(String account, String fileName) {
        return AppFileUtil.getFilePath(account, fileName);
    }

    public String getCompressImage(Attachment attachment, int width, int quality) throws Exception {
        try (InputStream inputStream = this.getFileInputStream(attachment);){
            String string = ImageUtil.getCompressBase64((InputStream)inputStream, (String)attachment.getExtensionName(), (int)width, (int)quality);
            return string;
        }
    }

    public String getFileRealPath(Attachment attachment, String propertiesId) {
        String filePath = attachment.getFilePath();
        String attachPath = this.getAttachPath(propertiesId, attachment);
        if ((attachment.getUsePath() == null || !attachment.getUsePath().booleanValue()) && !attachment.getEntryptName().booleanValue() && StringUtil.isNotEmpty((String)attachment.getId()) && StringUtil.isNotEmpty((String)attachment.getFileName())) {
            filePath = filePath.replace(attachment.getId(), attachment.getFileName());
        }
        filePath = attachPath + File.separator + filePath;
        return filePath.replace("/", File.separator);
    }

    public void renameFile(File toBeRenamed, String toFileNewName) {
        Assert.isTrue((toBeRenamed.exists() && !toBeRenamed.isDirectory() ? 1 : 0) != 0, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String p = toBeRenamed.getParent();
        File newFile = new File(p + File.separatorChar + toFileNewName);
        toBeRenamed.renameTo(newFile);
    }

    public boolean checkUploadStatus(MultipartFileParam param, Attachment attachment, String filePath) throws IOException {
        File confFile = new File(filePath, attachment.getId() + ".conf");
        try (RandomAccessFile confAccessFile = new RandomAccessFile(confFile, "rw");){
            confAccessFile.setLength(param.getTotalChunks());
            confAccessFile.seek(param.getChunkNumber() - 1);
            confAccessFile.write(127);
            byte[] completeStatusList = FileUtils.readFileToByteArray((File)confFile);
            for (int i = 0; i < completeStatusList.length; ++i) {
                if (completeStatusList[i] == 127) continue;
                boolean bl = false;
                return bl;
            }
        }
        confFile.delete();
        return true;
    }

    @Cacheable(value={"eip:upload:aliyun:fileId"}, key="#key", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.DAYS), secondaryCache=@SecondaryCache(expireTime=1, timeUnit=TimeUnit.DAYS))
    public String getIdentifierIdFromCache(String key) {
        return null;
    }

    @CachePut(value={"eip:upload:aliyun:fileId"}, key="#key", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.DAYS), secondaryCache=@SecondaryCache(expireTime=1, timeUnit=TimeUnit.DAYS))
    public String putIdentifierIdCache(String key, String id) {
        return id;
    }

    @CacheEvict(value={"eip:upload:aliyun:fileId"}, key="#key")
    public void delIdentifierIdCache(String key) {
    }
}

