/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.model;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.hotent.base.util.StringUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AwsConfig {
    @Value(value="${aws.accessKey:null}")
    private String accessKey;
    @Value(value="${aws.secretKey:null}")
    private String secretKey;
    @Value(value="${aws.region:null}")
    private String region;
    @Value(value="${aws.uploadDir:null}")
    private String uploadDir;
    @Value(value="${aws.hostName:null}")
    private String hostName;

    @Bean
    public AmazonS3 getAmazonS3() {
        System.setProperty("com.amazonaws.sdk.disableCertChecking", "true");
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        ClientConfiguration baseOpts = new ClientConfiguration();
        baseOpts.setSignerOverride("S3SignerType");
        baseOpts.setProtocol(Protocol.HTTPS);
        if (StringUtil.isEmpty((String)this.hostName)) {
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).withRegion(this.region)).withPathStyleAccessEnabled(Boolean.valueOf(true))).withClientConfiguration(baseOpts)).build();
        }
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.hostName, this.region))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withClientConfiguration(baseOpts)).build();
    }

    public String getUploadDir() {
        return this.uploadDir;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
    }
}

