/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.context.BaseContext;
import com.hotent.base.controller.BaseController;
import com.hotent.base.feign.BpmModelFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.file.model.DefaultFile;
import com.hotent.file.model.UploadResult;
import com.hotent.file.model.WangEditorUploadResult;
import com.hotent.file.persistence.manager.FileManager;
import com.hotent.file.print.model.WordPrintParam;
import com.hotent.uc.api.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/system/file/v1"})
@Api(tags={"\u9644\u4ef6\u7ba1\u7406"})
@ApiGroup(group={"group_portal"})
public class FileController
extends BaseController<FileManager, DefaultFile> {
    private Logger logger = LoggerFactory.getLogger(FileController.class);
    @Resource
    FileManager fileManager;
    @Resource
    IUserService userService;
    @Resource
    BaseContext baseContext;
    @Resource
    BpmModelFeignService bpmModelFeignService;
    String formates = "";

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u9644\u4ef6\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<DefaultFile> list(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) {
        return this.fileManager.listData(queryFilter);
    }

    @RequestMapping(value={"fileGet"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u9644\u4ef6\u5bf9\u8c61", httpMethod="GET", notes="\u83b7\u5f97\u9644\u4ef6\u5bf9\u8c61")
    public DefaultFile edit(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) {
        DefaultFile file = null;
        if (StringUtil.isNotEmpty((String)id)) {
            file = (DefaultFile)this.fileManager.get((Serializable)((Object)id));
        }
        return file;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u9644\u4ef6", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664\u9644\u4ef6")
    public CommonResult remove(@ApiParam(name="ids", value="\u9644\u4ef6ID!\u591a\u4e2aID\u7528,\u5206\u5272") @RequestBody String ids) throws Exception {
        String[] aryIds = null;
        if (StringUtil.isNotEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.fileManager.delSysFileByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u9644\u4ef6\u6210\u529f", null);
    }

    @RequestMapping(value={"fileUpload"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public UploadResult fileUpload(@ApiParam(name="params", value="\u683c\u5f0f\u9650\u5b9a") @RequestParam Map<String, Object> params, @ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> files, @ApiParam(name="flowKey", value="\u6d41\u7a0bkey") @RequestParam Optional<String> flowKey) throws Exception {
        DefaultFile file = new DefaultFile();
        if (params.containsKey("file")) {
            file = (DefaultFile)((Object)JsonUtil.toBean((String)params.getOrDefault("file", "{}").toString(), DefaultFile.class));
        }
        String account = this.baseContext.getCurrentUserAccout();
        return this.fileManager.uploadFile(file, files, this.formates, this.userService.getUserByAccount(account), flowKey.orElse(""));
    }

    @RequestMapping(value={"/compress/upload"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c(\u538b\u7f29\u56fe\u7247)", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public UploadResult fileUploadCompress(@ApiParam(name="compress", value="\u662f\u5426\u538b\u7f29\u56fe\u7247") @RequestParam(required=false) Boolean compress, @ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> files) throws Exception {
        boolean isCompress = compress == null ? false : compress;
        return this.fileManager.uploadFile(new DefaultFile(), files, isCompress);
    }

    @RequestMapping(value={"editor/fileUpload"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bcc\u6587\u672c\u4e2d\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c", httpMethod="POST", notes="\u5bcc\u6587\u672c\u4e2d\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public WangEditorUploadResult editorFileUpload(HttpServletRequest request) throws Exception {
        String contentType = request.getContentType();
        if (contentType == null || !contentType.toLowerCase().startsWith("multipart/")) {
            return new WangEditorUploadResult(Integer.valueOf(2));
        }
        Map fileMap = ((MultipartHttpServletRequest)request).getFileMap();
        String account = this.baseContext.getCurrentUserAccout();
        HashMap<DefaultFile, MultipartFile> files = new HashMap<DefaultFile, MultipartFile>();
        fileMap.entrySet().forEach(file -> files.put(new DefaultFile(), (MultipartFile)file.getValue()));
        WangEditorUploadResult wangEditorUploadResult = this.fileManager.uploadFile(files, this.userService.getUserByAccount(account));
        return wangEditorUploadResult;
    }

    @RequestMapping(value={"upload"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public UploadResult upload(MultipartHttpServletRequest request, @ApiParam(name="flowKey", value="\u6d41\u7a0bkey") @RequestParam Optional<String> flowKey, @ApiParam(name="defId", value="\u6d41\u7a0bdefId") @RequestParam Optional<String> defId, @ApiParam(name="fileId", value="\u6587\u4ef6id") @RequestParam(required=false) String fileId) throws Exception {
        CommonResult flowKeyByDefId;
        String defIdStr;
        if (!flowKey.isPresent() && defId.isPresent() && StringUtil.isNotEmpty((String)(defIdStr = defId.get())) && (flowKeyByDefId = this.bpmModelFeignService.getFlowKeyByDefId(defIdStr)).getState().booleanValue()) {
            String flowKeyStr = (String)flowKeyByDefId.getValue();
            flowKey = Optional.of(flowKeyStr);
        }
        return this.fileManager.upload(request, flowKey, fileId);
    }

    @RequestMapping(value={"thumbnailUpload"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f29\u7565\u56fe\u4e0a\u4f20\u64cd\u4f5c", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public UploadResult thumbnailUpload(MultipartHttpServletRequest request, @ApiParam(name="fileId", value="\u6587\u4ef6id") @RequestParam(required=false) String fileId) throws Exception {
        return this.fileManager.thumbnailUpload(request, fileId);
    }

    @RequestMapping(value={"downloadFile"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u4e0b\u8f7d", httpMethod="GET", notes="\u9644\u4ef6\u4e0b\u8f7d")
    public void downloadFile(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="fileId", value="\u9644\u4ef6ID") @RequestParam String fileId) throws Exception {
        this.fileManager.downloadFile(request, response, fileId);
    }

    @RequestMapping(value={"getLogoFile"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u79df\u6237logo\u6587\u4ef6", httpMethod="GET", notes="\u6839\u636e\u79df\u6237id\u83b7\u53d6\u79df\u6237logo\u6587\u4ef6")
    public void getLogoFile(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="tenantId", value="\u79df\u6237id") @RequestParam String tenantId, @ApiParam(name="logoType", value="logo\u7c7b\u578b\uff1amanage(\u7ba1\u7406\u7aef)\u3001front(\u5e94\u7528\u7aef)\u3001ico(\u767b\u5f55\u9875)") @RequestParam String logoType) throws Exception {
        this.fileManager.getLogoFile(request, response, tenantId, logoType);
    }

    @RequestMapping(value={"getFileType"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u9644\u4ef6id\u53d6\u5f97\u9644\u4ef6\u7c7b\u578b\u3002", httpMethod="POST", notes="\u6839\u636e\u9644\u4ef6id\u53d6\u5f97\u9644\u4ef6\u7c7b\u578b\u3002")
    public String getFileType(@ApiParam(name="fileId", value="\u9644\u4ef6id") @RequestBody String fileId) throws IOException {
        DefaultFile DefaultFile2 = null;
        String type = "doc";
        if (StringUtil.isNotEmpty((String)fileId)) {
            DefaultFile2 = (DefaultFile)this.fileManager.get((Serializable)((Object)fileId));
            type = DefaultFile2.getExtensionName().toLowerCase();
        }
        return type;
    }

    @RequestMapping(value={"setXbTypeId"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u9644\u4ef6\u5206\u7c7b\u3002", httpMethod="POST", notes="\u4fee\u6539\u9644\u4ef6\u5206\u7c7b\u3002")
    public CommonResult setXbTypeId(@ApiParam(name="fileId", value="\u9644\u4ef6id") @RequestBody List<String> fileId, @ApiParam(name="xbTypeId", value="\u5206\u7c7bID") @RequestParam String xbTypeId, @ApiParam(name="type", value="\u5206\u7c7b\u540d\u79f0") @RequestParam String type) throws Exception {
        this.fileManager.setXbTypeId(fileId, xbTypeId, type);
        return new CommonResult(true, "\u8bbe\u7f6e\u9644\u4ef6\u5206\u7c7b\u6210\u529f", null);
    }

    @RequestMapping(value={"updateFileExtraProp"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u9644\u4ef6\u7684\u5c5e\u6027\u6210\u529f", httpMethod="POST", notes="\u66f4\u65b0\u9644\u4ef6\u7684\u5c5e\u6027\u6210\u529f\uff08\u5305\u542b\u6269\u5c55\u5c5e\u6027\u3001\u6d41\u7a0b\u5b9e\u4f8bID\u3001\u8282\u70b9\u540d\u79f0\u3001\u6d41\u7a0b\u6807\u9898\u3001\u9644\u4ef6\u6765\u6e90\u3001\u6240\u5c5e\u5206\u7c7b\uff09")
    public CommonResult updateFileExtraProp(@ApiParam(name="files", value="\u9644\u4ef6\u5217\u8868") @RequestBody List<DefaultFile> files) throws Exception {
        this.fileManager.updateFileExtraProp(files);
        return new CommonResult(true, "\u66f4\u65b0\u9644\u4ef6\u7684\u5c5e\u6027\u6210\u529f", null);
    }

    @RequestMapping(value={"preview"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u9884\u89c8", httpMethod="GET", notes="\u9644\u4ef6\u9884\u89c8")
    public void preview(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="fileId", value="\u9644\u4ef6ID") @RequestParam String fileId) throws Exception {
        this.fileManager.preview(request, response, fileId);
    }

    @RequestMapping(value={"wordPrint"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="word\u6a21\u677f\u6253\u5370", httpMethod="POST", notes="word\u6a21\u677f\u6253\u5370")
    public String wordPrint(@ApiParam(name="objectNode", value="Json\u5bf9\u8c61") @RequestBody WordPrintParam param) throws Exception {
        return this.fileManager.wordPrint(param);
    }

    @RequestMapping(value={"getFileBytesById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u4e0b\u8f7d", httpMethod="GET", notes="\u9644\u4ef6\u4e0b\u8f7d")
    public byte[] getFileBytesById(@ApiParam(name="fileId", value="\u9644\u4ef6ID") @RequestParam String fileId) throws Exception {
        return this.fileManager.getFileBytesById(fileId);
    }

    @RequestMapping(value={"/importSignature"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u7b7e\u7ae0", httpMethod="POST", notes="\u6279\u91cf\u5bfc\u5165\u7b7e\u7ae0")
    public CommonResult<String> importSignature(@ApiParam(name="file", value="\u5bfc\u5165\u7684\u538b\u7f29\u6587\u4ef6\uff08.zip\u6216.rar\uff09", required=true) @RequestBody MultipartFile file, @ApiParam(name="repeatConver", value="\u5f53\u7528\u6237\u5df2\u5b58\u5728\u7b7e\u7ae0\u65f6\u662f\u5426\u8986\u76d6", required=false) @RequestParam Optional<Boolean> repeatConver) throws Exception {
        return this.fileManager.importSignature(file, repeatConver.orElse(true));
    }

    @RequestMapping(value={"getImage"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u533f\u540d\u83b7\u53d6\u56fe\u7247", httpMethod="GET", notes="\u533f\u540d\u83b7\u53d6\u56fe\u7247")
    public void getImage(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="fileId", value="\u9644\u4ef6ID") @RequestParam String fileId) throws Exception {
        this.fileManager.downloadFile(request, response, fileId);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6587\u4ef6")
    @RequestMapping(value={"/saveFile"})
    public CommonResult saveFile(@RequestBody DefaultFile defaultFile) throws Exception {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)defaultFile.getId()), (String)"\u6587\u4ef6id\u4e3a\u7a7a");
        DefaultFile defaultFileDb = (DefaultFile)((FileManager)this.baseService).get((Serializable)((Object)defaultFile.getId()));
        BeanUtils.copyNotNullProperties((Object)((Object)defaultFileDb), (Object)((Object)defaultFile));
        ((FileManager)this.baseService).saveOrUpdate((Object)defaultFileDb);
        return CommonResult.ok();
    }
}

