/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.extend;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.TableTools;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.file.util.DecimalFormatUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyTableRenderPolicy
implements RenderPolicy {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REGEX_PARAGRAPH = "\\{.*?\\}|[^\\{]+";

    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        XWPFRun run = runTemplate.getRun();
        run.setText("", 0);
        try {
            if (!TableTools.isInsideTable((XWPFRun)run)) {
                throw new IllegalStateException("The template tag " + runTemplate.getSource() + " must be inside a table");
            }
            XWPFTableCell cell = (XWPFTableCell)((XWPFParagraph)run.getParent()).getBody();
            XWPFTable table = cell.getTableRow().getTable();
            this.render(table, data);
        }
        catch (Exception e) {
            throw new RenderException("dynamic table error:" + e.getMessage(), e);
        }
    }

    public void render(XWPFTable table, Object data) {
        if (null == data) {
            return;
        }
        List subTable = new ArrayList<Map>();
        if (data instanceof List) {
            subTable = (List)data;
        } else {
            subTable.add((Map)data);
        }
        table.removeRow(0);
        ArrayList<CTRow> ctRows = new ArrayList<CTRow>();
        int size = table.getRows().size();
        for (int i = 0; i < size; ++i) {
            XWPFTableRow sourceRow = table.getRow(i);
            CTRow ctrow = (CTRow)sourceRow.getCtRow().copy();
            ctRows.add(ctrow);
        }
        List<Integer> indexColumnMerge = this.getIndexMerge(table, subTable.size() > 0 ? (Map)subTable.get(0) : null);
        for (int i = 1; i < subTable.size(); ++i) {
            Map data1 = (Map)subTable.get(i);
            for (int j = 0; j < size; ++j) {
                XWPFTableRow addRow = new XWPFTableRow((CTRow)((CTRow)ctRows.get(j)).copy(), table);
                int columnIndex = 0;
                for (XWPFTableCell cell : addRow.getTableCells()) {
                    if (indexColumnMerge.contains(columnIndex)) {
                        cell.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.TOP);
                    }
                    ++columnIndex;
                }
                this.fillRowData(addRow, data1);
                table.addRow(addRow);
            }
        }
        this.fillTableData(table, (Map)subTable.get(0));
    }

    private void fillTableData(XWPFTable table, Map data) {
        if (BeanUtils.isEmpty((Object)table.getRows())) {
            return;
        }
        for (XWPFTableRow row : table.getRows()) {
            this.fillRowData(row, data);
        }
    }

    private List<Integer> getIndexMerge(XWPFTable table, Map dataFirst) {
        ArrayList<Integer> indexColumnMerge = new ArrayList<Integer>();
        if (dataFirst == null) {
            return indexColumnMerge;
        }
        for (int i = 0; i < table.getRows().size(); ++i) {
            XWPFTableRow row = table.getRow(i);
            for (int j = 0; j < row.getTableCells().size(); ++j) {
                XWPFTableCell cell = (XWPFTableCell)row.getTableCells().get(j);
                for (XWPFParagraph paragraph : cell.getParagraphs()) {
                    for (XWPFRun run : paragraph.getRuns()) {
                        String valueStr;
                        String text = run.text();
                        String key = text.replace("{", "").replace("}", "");
                        if (StringUtil.isNotEmpty((String)key)) {
                            key = key.substring(key.indexOf(".") + 1, key.length());
                        }
                        if (!dataFirst.containsKey(key) || dataFirst.get(key) == null || !(valueStr = dataFirst.get(key).toString()).startsWith("{{@") || !valueStr.endsWith("}}") || cell.getCTTc().getTcPr() == null || cell.getCTTc().getTcPr().getVMerge() == null || indexColumnMerge.contains(j)) continue;
                        indexColumnMerge.add(j);
                    }
                }
            }
        }
        return indexColumnMerge;
    }

    private void fillRowData(XWPFTableRow row, Map data) {
        List cells = row.getTableCells();
        if (BeanUtils.isEmpty((Object)cells)) {
            return;
        }
        for (XWPFTableCell cell : cells) {
            String cellText = cell.getText();
            if (!this.isSubFieldExp(cellText)) continue;
            ArrayList<String> paragraphList = new ArrayList<String>();
            Pattern pattern = Pattern.compile(REGEX_PARAGRAPH);
            Matcher matcher = pattern.matcher(cellText);
            while (matcher.find()) {
                String group = matcher.group();
                if (group.isEmpty()) continue;
                paragraphList.add(group);
            }
            for (String runs : paragraphList) {
                boolean isDigitSubFieldExp;
                String digitFlag = "";
                int index = runs.indexOf("#d");
                if (index != -1) {
                    digitFlag = runs.substring(index);
                }
                boolean bl = isDigitSubFieldExp = StringUtil.isNotEmpty((String)digitFlag) && StringUtil.isNotEmpty((String)runs) && runs.contains("{") && runs.contains(".");
                if (!isDigitSubFieldExp && !this.isSubFieldExp(runs)) {
                    if (!StringUtil.isNotEmpty((String)digitFlag) || !runs.startsWith("#d") && !runs.equals("}")) continue;
                    cellText = cellText.replace(runs, "");
                    continue;
                }
                if (isDigitSubFieldExp) {
                    runs = runs + digitFlag;
                }
                String key = runs.replace("{", "").replace("}", "");
                StringBuilder formatDigit = new StringBuilder("");
                if (key.contains("#d")) {
                    key = DecimalFormatUtil.handleDigitKey(key, formatDigit);
                }
                if (StringUtil.isNotEmpty((String)key)) {
                    key = key.substring(key.indexOf(".") + 1);
                }
                if (data.containsKey(key) && data.get(key) != null) {
                    String valueStr = data.get(key).toString();
                    if (valueStr.startsWith("{{@") && valueStr.endsWith("}}")) {
                        double width = cell.getWidthDecimal();
                        ThreadMsgUtil.addMapMsg((String)valueStr, (String)(width + ""));
                    }
                    if (StringUtil.isNotEmpty((String)valueStr) && StringUtil.isNotEmpty((String)formatDigit.toString())) {
                        try {
                            double number = Double.parseDouble(valueStr);
                            DecimalFormat decimalFormat = new DecimalFormat(formatDigit.toString());
                            valueStr = decimalFormat.format(number);
                        }
                        catch (Exception ignore) {
                            this.logger.error("\u6570\u5b57\u683c\u5f0f\u5316\u5f02\u5e38", (Throwable)ignore);
                        }
                    }
                    cellText = cellText.replace(runs, valueStr);
                    continue;
                }
                cellText = cellText.replace(runs, "");
            }
            this.setCellText(cell, cellText);
        }
    }

    private void setCellText(XWPFTableCell cell, String text) {
        XWPFParagraph paragraph;
        List paragraphs = cell.getParagraphs();
        if (paragraphs.isEmpty()) {
            paragraph = cell.addParagraph();
        } else {
            paragraph = (XWPFParagraph)paragraphs.get(0);
            for (int i = paragraph.getRuns().size() - 1; i >= 0; --i) {
                paragraph.removeRun(i);
            }
        }
        XWPFRun run = paragraph.createRun();
        run.setText(text);
    }

    private boolean isSubFieldExp(String str) {
        return StringUtil.isNotEmpty((String)str) && str.indexOf("{") > -1 && str.indexOf("}") > -1 && str.indexOf(".") > -1;
    }
}

