/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.extend;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.hotent.base.util.StringUtil;
import java.text.DecimalFormat;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecimalFormatRenderPolicy
implements RenderPolicy {
    private static Logger logger = LoggerFactory.getLogger(DecimalFormatRenderPolicy.class);
    private String formatDigit;

    public DecimalFormatRenderPolicy(String formatDigit) {
        this.formatDigit = formatDigit;
    }

    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        if (data == null || StringUtil.isEmpty((String)this.formatDigit)) {
            return;
        }
        String formattedNumber = data.toString();
        try {
            DecimalFormat decimalFormat = new DecimalFormat(this.formatDigit);
            formattedNumber = decimalFormat.format(data);
        }
        catch (Exception ignore) {
            logger.error("\u6570\u5b57\u683c\u5f0f\u5316\u5f02\u5e38", (Throwable)ignore);
        }
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        XWPFRun run = runTemplate.getRun();
        run.setText(formattedNumber, 0);
    }
}

