/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.util;

import cn.afterturn.easypoi.entity.ImageEntity;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.ReUtil;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.BpmModelFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.file.model.DefaultFile;
import com.hotent.file.persistence.manager.FileManager;
import com.hotent.file.util.AppFileUtil;
import com.hotent.sys.persistence.manager.SysSignetManager;
import com.hotent.sys.persistence.model.SysSignet;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.VerticalAlign;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.XmlCursor;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class HtmlUtil {
    private static final Logger logger = LoggerFactory.getLogger(HtmlUtil.class);
    private static List<String> HTML_TAG = Arrays.asList("div", "a", "p", "img", "table", "ul", "font", "lable", "strong", "b", "span", "h1", "h2", "h3", "h4", "title");
    private static List<String> PICTURE_TAG = Arrays.asList("emf", "wmf", "pict", "jpeg", "png", "dib", "gif", "tiff", "eps", "bmp", "wpg");
    private static String SIGNET_PREFIX = "signet_";

    public static InputStream getResourceInputStream(String filePath) {
        InputStream in = AppFileUtil.class.getResourceAsStream(filePath);
        if (in != null) {
            return in;
        }
        return null;
    }

    public static AbstractRenderPolicy createHtmlRenderPolicy() {
        return new AbstractRenderPolicy(){

            protected void afterRender(RenderContext context) {
                1.clearPlaceholder((RenderContext)context, (boolean)true);
            }

            public void doRender(RenderContext context) throws Exception {
                XWPFRun run = context.getRun();
                Object data = context.getData();
                XWPFTemplate template = context.getTemplate();
                if (data == null || StringUtils.isBlank((CharSequence)data.toString())) {
                    return;
                }
                NiceXWPFDocument doc = template.getXWPFDocument();
                String html = data.toString();
                html = html.replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&nbsp;", " ").replaceAll("\\n", "").replaceAll("<br>", "\n");
                Document htmlDoc = Jsoup.parse((String)html);
                Elements nodes = htmlDoc.body().children();
                XWPFParagraph xwpfParagraph = doc.insertNewParagraph(run.getParagraph().getCTP().newCursor());
                if (BeanUtils.isEmpty((Object)xwpfParagraph)) {
                    xwpfParagraph = doc.insertNewParagraph((XmlCursor)run);
                }
                ListIterator itr = nodes.listIterator();
                while (itr.hasNext()) {
                    Element e = (Element)itr.next();
                    xwpfParagraph = HtmlUtil.parseHtmlToWord(e, doc, xwpfParagraph, true);
                }
            }
        };
    }

    private static XWPFParagraph parseHtmlToWord(Element ele, NiceXWPFDocument doc, XWPFParagraph xwpfParagraph, boolean isParent) throws Exception {
        XWPFRun run;
        boolean enabledBreak;
        if ("img".equals(ele.tagName())) {
            HtmlUtil.parseImgToWord(ele.attr("src"), xwpfParagraph);
            return xwpfParagraph;
        }
        if ("table".equals(ele.tagName())) {
            xwpfParagraph = doc.insertNewParagraph(HtmlUtil.getPrevXWPFParagraph(doc, xwpfParagraph).getCTP().newCursor());
            HtmlUtil.parseTableToWord(doc, ele, xwpfParagraph.createRun());
            return xwpfParagraph;
        }
        if ("sup".equalsIgnoreCase(ele.tagName())) {
            XWPFRun run2 = xwpfParagraph.createRun();
            run2.setText(ele.text());
            run2.setBold(true);
            run2.setFontSize(12);
            run2.setFontFamily("Times New Roman", XWPFRun.FontCharRange.ascii);
            run2.setFontFamily("\u5b8b\u4f53", XWPFRun.FontCharRange.eastAsia);
            run2.setSubscript(VerticalAlign.SUPERSCRIPT);
            TextRenderPolicy.Helper.renderTextRun((XWPFRun)run2, (Object)new TextRenderData(ele.text()));
            return xwpfParagraph;
        }
        String text = ele.ownText();
        boolean continueItr = true;
        if ("span".equalsIgnoreCase(ele.tagName())) {
            text = ele.ownText();
            continueItr = false;
        }
        if (enabledBreak = ReUtil.isMatch((String)"(p|h[12345]|li|img)", (CharSequence)ele.tagName())) {
            run = xwpfParagraph.createRun();
            run.addBreak();
        }
        if (StringUtils.isNotBlank((CharSequence)text)) {
            run = xwpfParagraph.createRun();
            TextRenderPolicy.Helper.renderTextRun((XWPFRun)run, (Object)new TextRenderData(text));
        }
        if (continueItr && ele.children().size() > 0) {
            ListIterator itr = ele.children().listIterator();
            while (itr.hasNext()) {
                Element me = (Element)itr.next();
                xwpfParagraph = HtmlUtil.parseHtmlToWord(me, doc, xwpfParagraph, false);
            }
        }
        return xwpfParagraph;
    }

    private static XWPFParagraph getPrevXWPFParagraph(NiceXWPFDocument doc, XWPFParagraph xwpfParagraph) {
        List xwpfParagraphs = doc.getXWPFDocument().getParagraphs();
        for (int i = 0; i < xwpfParagraphs.size(); ++i) {
            if (!((XWPFParagraph)xwpfParagraphs.get(i)).equals(xwpfParagraph)) continue;
            return (XWPFParagraph)xwpfParagraphs.get(i + 1);
        }
        return xwpfParagraph;
    }

    private static void parseImgToWord(String imgUrl, XWPFParagraph xwpfParagraph) throws Exception {
        if (imgUrl.contains("system/file/v1/downloadFile?fileId=")) {
            String regEx = "(\\?|&+)(.+?)=([^&]*)";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(imgUrl);
            String fileId = "";
            while (m.find()) {
                String paramName = m.group(2);
                if (!"fileId".equals(paramName)) continue;
                fileId = m.group(3);
                break;
            }
            if (StringUtil.isNotEmpty((String)fileId)) {
                FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
                DefaultFile file = (DefaultFile)fileManager.get((Serializable)((Object)fileId));
                if (BeanUtils.isNotEmpty((Object)((Object)file))) {
                    String format = file.getExtensionName();
                    if (!PICTURE_TAG.contains(format)) {
                        format = "png";
                    }
                    format = "." + format;
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    fileManager.downloadFile(fileId, outStream);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outStream.toByteArray());
                    BufferedImage image = ImageIO.read(inputStream);
                    int width = image.getWidth();
                    int height = image.getHeight();
                    if (width > 600) {
                        int rate = width / 600 + 1;
                        width = width / rate - 20;
                        height /= rate;
                    }
                    PictureRenderData pictureRenderData = new PictureRenderData(width, height, format, image);
                    XWPFRun run = xwpfParagraph.createRun();
                    PictureRenderPolicy.Helper.renderPicture((XWPFRun)run, (PictureRenderData)pictureRenderData);
                }
                return;
            }
        } else {
            return;
        }
    }

    private static String getImgRealPath(String imgUrl) {
        if (imgUrl.startsWith("data:;base64,")) {
            imgUrl = imgUrl.replace("data:;base64,", "");
            byte[] bytes = Base64.getDecoder().decode(imgUrl);
            String path = "D:\\temp\\" + UUID.randomUUID().toString() + ".png";
            HtmlUtil.copyByte2File(bytes, new File(path));
            return path;
        }
        return "D:\\img\\timg.jpg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyByte2File(byte[] bytes, File file) {
        FileOutputStream out = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[1024];
            out = new FileOutputStream(file);
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void parseTableToWord(NiceXWPFDocument doc, Element ele, XWPFRun run) throws Exception {
        Document tableDoc = Jsoup.parse((String)HtmlUtil.simplifyTable(ele.outerHtml()));
        Elements trList = tableDoc.getElementsByTag("tr");
        Elements tdList = trList.get(0).getElementsByTag("td");
    }

    private static String simplifyTable(String tableContent) {
        if (StringUtils.isEmpty((CharSequence)tableContent)) {
            return null;
        }
        Document tableDoc = Jsoup.parse((String)tableContent);
        Elements trElements = tableDoc.getElementsByTag("tr");
        if (trElements != null) {
            Iterator eleIterator = trElements.iterator();
            Integer rowNum = 0;
            while (eleIterator.hasNext()) {
                Integer n = rowNum;
                Integer n2 = rowNum = Integer.valueOf(rowNum + 1);
                Element trElement = (Element)eleIterator.next();
                trElement.removeAttr("class");
                Elements tdElements = trElement.getElementsByTag("td");
                List<Element> tdEleList = HtmlUtil.covertElements2List(tdElements);
                for (int i = 0; i < tdEleList.size(); ++i) {
                    Element curTdElement = tdEleList.get(i);
                    curTdElement.removeAttr("class");
                    Element ele = curTdElement.clone();
                    String colspanValStr = curTdElement.attr("colspan");
                    if (StringUtils.isEmpty((CharSequence)colspanValStr)) continue;
                    ele.removeAttr("colspan");
                    Integer colspanVal = Integer.parseInt(colspanValStr);
                    for (int k = 0; k < colspanVal - 1; ++k) {
                        curTdElement.after(ele.outerHtml());
                    }
                }
            }
            List<Element> trEleList = HtmlUtil.covertElements2List(trElements);
            Element firstTrEle = trElements.first();
            Elements tdElements = firstTrEle.getElementsByTag("td");
            Integer tdCount = tdElements.size();
            for (int i = 0; i < tdElements.size(); ++i) {
                for (Element trElement : trEleList) {
                    List<Element> tdElementList = HtmlUtil.covertElements2List(trElement.getElementsByTag("td"));
                    try {
                        tdElementList.get(i);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    Node curTdNode = (Node)tdElementList.get(i);
                    Node cNode = curTdNode.clone();
                    String rowspanValStr = curTdNode.attr("rowspan");
                    if (StringUtils.isEmpty((CharSequence)rowspanValStr)) continue;
                    cNode.removeAttr("rowspan");
                    Element nextTrElement = trElement.nextElementSibling();
                    Integer rowspanVal = Integer.parseInt(rowspanValStr);
                    for (int j = 0; j < rowspanVal - 1; ++j) {
                        Node tempNode = cNode.clone();
                        ArrayList<Node> nodeList = new ArrayList<Node>();
                        nodeList.add(tempNode);
                        if (j > 0) {
                            nextTrElement = nextTrElement.nextElementSibling();
                        }
                        Integer indexNum = i + 1;
                        if (i == 0) {
                            indexNum = 0;
                        }
                        if (indexNum.equals(tdCount)) {
                            nextTrElement.appendChild(tempNode);
                            continue;
                        }
                        nextTrElement.insertChildren(indexNum.intValue(), nodeList);
                    }
                }
            }
        }
        Element tableEle = tableDoc.getElementsByTag("table").first();
        String tableHtml = tableEle.outerHtml();
        return tableHtml;
    }

    private static List<Element> covertElements2List(Elements curElements) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        for (Element curlement : curElements) {
            elementList.add(curlement);
        }
        return elementList;
    }

    public static boolean isHtml(String text) {
        if (StringUtil.isEmpty((String)text)) {
            return false;
        }
        Document document = Jsoup.parseBodyFragment((String)text, (String)"UTF-8");
        try {
            if (ObjectUtils.isEmpty((Object)document)) {
                return false;
            }
            Elements elements = document.getAllElements();
            for (Element e : elements) {
                String attrName = e.tag().getName();
                if (!HTML_TAG.contains(attrName.toLowerCase())) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getRichtextToDocx(String content) {
        PrintStream printStream = null;
        String basePath = (FileUtil.getIoTmpdir() + "/attachFiles/tempZip/printTrans/").replace("/", File.separator);
        String fileName = TimeUtil.getCurrentTimeMillis() + String.valueOf(new Random().nextInt(900) + 100);
        try {
            StringBuffer html = new StringBuffer();
            html.append("<html>").append("<head><style type=\"text/css\"> table { width: 70%; } td, th {\n    border: 0.5px solid #ccc; \n width: 50px;\n} </style>").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />").append("</head>").append("<body>");
            html.append(content.replaceAll("&nbsp;", "\u00a0"));
            html.append("</body></html>");
            File folder = new File(basePath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            printStream = new PrintStream((OutputStream)new FileOutputStream(basePath + fileName + ".html"), false, "utf-8");
            printStream.println(html.toString());
            WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
            NumberingDefinitionsPart ndp = new NumberingDefinitionsPart();
            wordMLPackage.getMainDocumentPart().addTargetPart((Part)ndp);
            ndp.unmarshalDefaultNumbering();
            XHTMLImporterImpl xHTMLImporter = new XHTMLImporterImpl(wordMLPackage);
            xHTMLImporter.setHyperlinkStyle("Hyperlink");
            wordMLPackage.getMainDocumentPart().getContent().addAll(xHTMLImporter.convert(new File(basePath + fileName + ".html"), null));
            File output = new File(basePath + fileName + ".docx");
            wordMLPackage.save(output);
            File file = output;
            return file;
        }
        catch (Exception e) {
            File file = null;
            return file;
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
            FileUtil.deleteFile((String)(basePath + fileName + ".html"));
        }
    }

    public static void printPicture(String skey, String key, String val, Map boMap, Map<String, Object> twiceMap, String templateType, boolean isDocx, String subIndex) {
        block41: {
            try {
                JsonNode varNode = JsonUtil.toJsonNode((String)val.toString());
                if (!varNode.isArray() || varNode.size() <= 0) break block41;
                FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
                ArrayNode arrayNode = (ArrayNode)varNode;
                if (BeanUtils.isNotEmpty((Object)arrayNode.get(0).get("response")) || BeanUtils.isNotEmpty((Object)arrayNode.get(0).get("signature"))) {
                    if (isDocx) {
                        boolean isSignature = false;
                        StringBuilder signatureTemp = new StringBuilder();
                        for (int i = 0; i < arrayNode.size(); ++i) {
                            JsonNode inode = arrayNode.get(i);
                            String itemKey = subIndex + key + "_" + i;
                            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                            String fileFormat = ".jpg";
                            if (BeanUtils.isNotEmpty((Object)arrayNode.get(0).get("signature"))) {
                                fileManager.downloadFile(inode.get("signature").asText(), outStream);
                                isSignature = true;
                            } else if (BeanUtils.isNotEmpty((Object)arrayNode.get(0).get("response"))) {
                                String fileNameTemp;
                                JsonNode response = inode.get("response");
                                if (response.has("fileName") && StringUtil.isNotEmpty((String)(fileNameTemp = response.get("fileName").asText())) && fileNameTemp.lastIndexOf(".") != -1) {
                                    fileFormat = fileNameTemp.substring(fileNameTemp.lastIndexOf("."));
                                    fileFormat = fileFormat.toLowerCase();
                                }
                                try {
                                    byte[] bytes = fileManager.getFileBytesById(response.get("fileId").asText());
                                    if (BeanUtils.isEmpty((Object)bytes)) {
                                        throw new FileNotFoundException("\u9644\u4ef6\u4e0d\u5b58\u5728");
                                    }
                                    IoUtil.write((OutputStream)outStream, (boolean)true, (byte[])bytes);
                                }
                                catch (FileNotFoundException e) {
                                    fileFormat = ".png";
                                    URL resource = ResourceUtil.getResource((String)"defaultImage.png");
                                    try (InputStream inputStream = resource.openStream();){
                                        IoUtil.copy((InputStream)inputStream, (OutputStream)outStream);
                                    }
                                }
                                isSignature = false;
                            }
                            BufferedImage sourceImg = ImageIO.read(new ByteArrayInputStream(outStream.toByteArray()));
                            if (isSignature) {
                                twiceMap.put(itemKey, new PictureRenderData(120, 35, ".png", sourceImg));
                            } else {
                                int width = sourceImg.getWidth();
                                int height = sourceImg.getHeight();
                                if (width > 520) {
                                    double mul = new BigDecimal((float)width / 520.0f).setScale(2, 4).doubleValue();
                                    width = (int)((double)width / mul);
                                    height = (int)((double)height / mul);
                                }
                                if (".jpg".equals(fileFormat)) {
                                    int widthTemp = sourceImg.getWidth();
                                    int heightTemp = sourceImg.getHeight();
                                    BufferedImage newImg = new BufferedImage(widthTemp, heightTemp, 1);
                                    int[] rgb = sourceImg.getRGB(0, 0, widthTemp, heightTemp, null, 0, widthTemp);
                                    newImg.setRGB(0, 0, widthTemp, heightTemp, rgb, 0, widthTemp);
                                    sourceImg = newImg;
                                }
                                twiceMap.put(itemKey, new PictureRenderData(width, height, fileFormat, sourceImg));
                            }
                            signatureTemp.append("{{@");
                            signatureTemp.append(itemKey);
                            signatureTemp.append("}}");
                        }
                        boMap.put(key, signatureTemp.toString());
                        boMap.put(skey, signatureTemp.toString());
                        break block41;
                    }
                    ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
                    int widht_sum = 0;
                    int height_max = 0;
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        JsonNode inode = arrayNode.get(i);
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        fileManager.downloadFile(inode.get("signature").asText(), outStream);
                        BufferedImage sourceImg = ImageIO.read(new ByteArrayInputStream(outStream.toByteArray()));
                        widht_sum += sourceImg.getWidth();
                        if (height_max < sourceImg.getHeight()) {
                            height_max = sourceImg.getHeight();
                        }
                        images.add(sourceImg);
                    }
                    BufferedImage tagImage = new BufferedImage(widht_sum, height_max, 1);
                    Graphics2D g = tagImage.createGraphics();
                    int width = 0;
                    for (int i = 0; i < images.size(); ++i) {
                        BufferedImage image = (BufferedImage)images.get(i);
                        g.drawImage(image, width, 0, image.getWidth(), height_max, null);
                        width += image.getWidth();
                    }
                    g.dispose();
                    ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)tagImage, "png", byteArrayOut);
                    ImageEntity imageEntity = new ImageEntity(byteArrayOut.toByteArray(), 120 * images.size(), 35);
                    boMap.put(key, imageEntity);
                    boMap.put(skey, imageEntity);
                    break block41;
                }
                if (BeanUtils.isNotEmpty((Object)arrayNode.get(0).get("url")) || BeanUtils.isNotEmpty((Object)arrayNode.get(0).get("fileName"))) {
                    if (isDocx) {
                        StringBuilder pictureTemp = new StringBuilder();
                        for (int i = 0; i < arrayNode.size(); ++i) {
                            double mul;
                            int height;
                            int width;
                            BufferedImage sourceImg;
                            ByteArrayOutputStream outStream;
                            String itemKey;
                            String[] urlItem;
                            JsonNode inode = arrayNode.get(i);
                            if (!BeanUtils.isNotEmpty((Object)inode.get("url"))) continue;
                            String url = inode.get("url").asText();
                            if (url.indexOf("getFileById_") != -1) {
                                urlItem = url.split("getFileById_");
                                itemKey = key + "_" + i;
                                outStream = new ByteArrayOutputStream();
                                fileManager.downloadFile(urlItem[1], outStream);
                                sourceImg = ImageIO.read(new ByteArrayInputStream(outStream.toByteArray()));
                                width = sourceImg.getWidth();
                                height = sourceImg.getHeight();
                                if (width > 520) {
                                    mul = new BigDecimal((float)width / 520.0f).setScale(2, 4).doubleValue();
                                    width = (int)((double)width / mul);
                                    height = (int)((double)height / mul);
                                }
                                twiceMap.put(itemKey, new PictureRenderData(width, height, ".png", sourceImg));
                                pictureTemp.append("\n{{@");
                                pictureTemp.append(itemKey);
                                pictureTemp.append("}}");
                            }
                            if (!url.contains("fileId=")) continue;
                            urlItem = url.split("fileId=");
                            itemKey = key + "_" + i;
                            outStream = new ByteArrayOutputStream();
                            fileManager.downloadFile(urlItem[1], outStream);
                            sourceImg = ImageIO.read(new ByteArrayInputStream(outStream.toByteArray()));
                            width = sourceImg.getWidth();
                            height = sourceImg.getHeight();
                            if (width > 220) {
                                mul = new BigDecimal((float)width / 220.0f).setScale(2, 4).doubleValue();
                                width = (int)((double)width / mul);
                                height = (int)((double)height / mul);
                            }
                            twiceMap.put(itemKey, new PictureRenderData(width, height, ".png", sourceImg));
                            pictureTemp.append("\n{{@");
                            pictureTemp.append(itemKey);
                            pictureTemp.append("}}");
                        }
                        boMap.put(key, pictureTemp.toString());
                        boMap.put(skey, pictureTemp.toString());
                    } else {
                        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
                        int widht_max = 0;
                        int height_sum = 0;
                        for (int i = 0; i < arrayNode.size(); ++i) {
                            String url;
                            JsonNode inode = arrayNode.get(i);
                            if (!BeanUtils.isNotEmpty((Object)inode.get("url")) || (url = inode.get("url").asText()).indexOf("getFileById_") == -1) continue;
                            String[] urlItem = url.split("getFileById_");
                            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                            fileManager.downloadFile(urlItem[1], outStream);
                            BufferedImage sourceImg = ImageIO.read(new ByteArrayInputStream(outStream.toByteArray()));
                            images.add(sourceImg);
                            if (sourceImg.getWidth() > widht_max) {
                                widht_max += sourceImg.getWidth();
                            }
                            height_sum += sourceImg.getHeight() + 10;
                        }
                        BufferedImage tagImage = new BufferedImage(widht_max, height_sum, 1);
                        Graphics2D g = tagImage.createGraphics();
                        g.fillRect(0, 0, widht_max, height_sum);
                        int height = 0;
                        for (int i = 0; i < images.size(); ++i) {
                            BufferedImage image = (BufferedImage)images.get(i);
                            g.drawImage(image, 0, height + 10, image.getWidth(), image.getHeight(), null);
                            height += image.getHeight();
                        }
                        g.dispose();
                        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)tagImage, "png", byteArrayOut);
                        ImageEntity imageEntity = new ImageEntity(byteArrayOut.toByteArray(), tagImage.getWidth(), tagImage.getHeight());
                        boMap.put(key, imageEntity);
                        boMap.put(skey, imageEntity);
                    }
                }
            }
            catch (Exception ignore) {
                logger.error("word\u5957\u6253\u65f6\u5904\u7406\u56fe\u7247\u63a7\u4ef6\u548c\u7b7e\u7ae0\u63a7\u4ef6\u5957\u6253\u5f02\u5e38", (Throwable)ignore);
            }
        }
    }

    public static void printSignetData(String defId, List<MetaTemplate> elementlist, Map boMap) throws Exception {
        if (BeanUtils.isNotEmpty(elementlist)) {
            try {
                ArrayList<String> signetFields = new ArrayList<String>();
                String prefix = "{{#" + SIGNET_PREFIX;
                for (MetaTemplate metaTemplate : elementlist) {
                    String templateAlias = metaTemplate.toString();
                    if (templateAlias.startsWith(prefix)) {
                        templateAlias = templateAlias.replaceAll("\\{", "");
                        templateAlias = templateAlias.replaceAll("\\}", "");
                        templateAlias = templateAlias.replaceAll("\\#", "");
                        templateAlias = templateAlias.replaceAll(SIGNET_PREFIX, "");
                        signetFields.add(templateAlias);
                    }
                    if (!templateAlias.startsWith("{{+")) continue;
                    templateAlias = templateAlias.replaceAll("\\{", "");
                    templateAlias = templateAlias.replaceAll("\\}", "");
                    if (boMap.get(templateAlias = templateAlias.replaceAll("\\+", "")) != null && !StringUtil.isEmpty((String)boMap.get(templateAlias).toString())) continue;
                    boMap.put(templateAlias, null);
                }
                if (BeanUtils.isNotEmpty(signetFields)) {
                    boolean isAllowed = true;
                    if (StringUtil.isNotEmpty((String)defId)) {
                        BpmModelFeignService service = (BpmModelFeignService)AppUtil.getBean(BpmModelFeignService.class);
                        CommonResult result = service.getAllowSignet(defId);
                        boolean bl = isAllowed = result.getState() != false && (Boolean)result.getValue() != false;
                    }
                    if (isAllowed) {
                        SysSignetManager sysSignetManager = (SysSignetManager)AppUtil.getBean(SysSignetManager.class);
                        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(0), PageBean.WITHOUT_PAGE));
                        filter.addFilter("alias_", signetFields, QueryOP.IN);
                        PageList pageList = sysSignetManager.query(filter);
                        if (BeanUtils.isNotEmpty((Object)pageList) && pageList.getRows().size() > 0) {
                            FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
                            List rows = pageList.getRows();
                            for (SysSignet sysSignet : rows) {
                                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                                fileManager.downloadFile(sysSignet.getFileId(), outStream);
                                BufferedImage sourceImg = ImageIO.read(new ByteArrayInputStream(outStream.toByteArray()));
                                int width = sourceImg.getWidth();
                                int height = sourceImg.getHeight();
                                if (width > 150) {
                                    double mul = new BigDecimal((float)width / 150.0f).setScale(2, 4).doubleValue();
                                    width = (int)((double)width / mul);
                                    height = (int)((double)height / mul);
                                }
                                boMap.put(SIGNET_PREFIX + sysSignet.getAlias(), new PictureRenderData(width, height, ".png", sourceImg));
                            }
                        } else {
                            for (String signetStr : signetFields) {
                                boMap.put(SIGNET_PREFIX + signetStr, null);
                            }
                        }
                    } else {
                        for (String signetStr : signetFields) {
                            boMap.put(SIGNET_PREFIX + signetStr, null);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new BaseException("\u5370\u7ae0\u6253\u5370\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }
}

