/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.StringUtil;
import com.hotent.file.model.Catalog;
import com.hotent.file.persistence.manager.CatalogManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/file/catalog/v1"})
@Api(tags={"\u9644\u4ef6\u76ee\u5f55\u7ba1\u7406"})
@ApiGroup(group={"group_portal"})
public class CatalogController
extends BaseController<CatalogManager, Catalog> {
    @Resource
    CatalogManager catalogManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u76ee\u5f55\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u76ee\u5f55\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<Catalog> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.catalogManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u76ee\u5f55\u8be6\u60c5", httpMethod="GET", notes="\u9644\u4ef6\u76ee\u5f55\u8be6\u60c5")
    public Catalog getJson(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        Catalog catalog = new Catalog();
        if (!StringUtil.isEmpty((String)id)) {
            catalog = (Catalog)this.catalogManager.get((Serializable)((Object)id));
        }
        return catalog;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u9644\u4ef6\u76ee\u5f55\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u76ee\u5f55\u4fe1\u606f")
    public CommonResult save(@ApiParam(name="catalog", value="\u9644\u4ef6\u76ee\u5f55\u5bf9\u8c61") @RequestBody Catalog catalog) throws Exception {
        CommonResult res = this.catalogManager.saveCatalog(catalog);
        return res;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u76ee\u5f55\u5206\u7c7b", httpMethod="DELETE", notes="\u5220\u9664\u76ee\u5f55\u5206\u7c7b")
    public CommonResult remove(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        CommonResult res = this.catalogManager.removeCatalogById(id);
        return res;
    }

    @RequestMapping(value={"getTree"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f97\u5230\u6811\u5f62\u9644\u4ef6\u5206\u7c7b\u76ee\u5f55\u6811", httpMethod="GET", notes="\u5f97\u5230\u6811\u5f62\u9644\u4ef6\u5206\u7c7b\u76ee\u5f55\u6811")
    public List<Catalog> getTree() throws Exception {
        List<Catalog> res = this.catalogManager.getTree();
        return res;
    }
}

