/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.service.impl;

import com.hotent.base.exception.BaseException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.file.model.AliyunOssSettings;
import com.hotent.file.model.FlowUploadProperties;
import com.hotent.file.model.UploadProperties;
import com.hotent.file.persistence.manager.FlowUploadPropertiesManager;
import com.hotent.file.service.FlowUploadPropertiesService;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class FlowUploadPropertiesServiceImpl
implements FlowUploadPropertiesService {
    public UploadProperties getUploadProperties(String propertiesId, AliyunOssSettings ossSettings) {
        if (StringUtil.isEmpty((String)propertiesId)) {
            return null;
        }
        UploadProperties uploadProperties = new UploadProperties();
        FlowUploadPropertiesManager uploadPropertiesManager = (FlowUploadPropertiesManager)AppUtil.getBean(FlowUploadPropertiesManager.class);
        FlowUploadProperties flowUploadProperties = (FlowUploadProperties)uploadPropertiesManager.get((Serializable)((Object)propertiesId));
        if (BeanUtils.isEmpty((Object)((Object)flowUploadProperties))) {
            flowUploadProperties = uploadPropertiesManager.getByFlowKey(propertiesId);
        }
        if (BeanUtils.isNotEmpty((Object)((Object)flowUploadProperties)) && BeanUtils.isNotEmpty((Object)ossSettings)) {
            ossSettings.setEndpoint(flowUploadProperties.getAliyunOssEndpoint());
            ossSettings.setAccessKeyId(flowUploadProperties.getAliyunOssAccessKeyId());
            ossSettings.setAccessKeySecret(flowUploadProperties.getAliyunOssAccessKeySecret());
            ossSettings.setBucketName(flowUploadProperties.getLocation());
        }
        if (BeanUtils.isNotEmpty((Object)uploadProperties)) {
            try {
                BeanUtils.copyNotNullProperties((Object)uploadProperties, (Object)((Object)flowUploadProperties));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new BaseException("flowUploadProperties\u8f6c\u6362\u62a5\u9519", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new BaseException("flowUploadProperties\u8f6c\u6362\u62a5\u9519", (Throwable)e);
            }
        }
        return uploadProperties;
    }

    public UploadProperties getUploadProperties(String propertiesId) {
        return this.getUploadProperties(propertiesId, null);
    }
}

