/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.ueditor;

import com.hotent.base.exception.BaseException;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.file.model.DefaultFile;
import com.hotent.file.persistence.manager.FileManager;
import com.hotent.file.util.AppFileUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.ueditor.define.BaseState;
import com.hotent.ueditor.define.State;
import com.hotent.ueditor.upload.StorageService;
import java.io.File;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@Primary
public class StorageServiceFileImpl
implements StorageService {
    @Resource
    FileManager fileManager;
    private String baseDomain;

    public State saveBinaryFile(byte[] data, String path) {
        return null;
    }

    private void buildBaseDomain() {
        if (StringUtil.isNotEmpty((String)this.baseDomain)) {
            return;
        }
        PatternSyntaxException error = null;
        HttpServletRequest request = HttpUtil.getRequest();
        String requestURL = request.getRequestURL().toString();
        try {
            Pattern regex = Pattern.compile("^(.*?)/ueditor/upload$");
            Matcher regexMatcher = regex.matcher(requestURL);
            if (regexMatcher.find()) {
                this.baseDomain = regexMatcher.group(1);
            }
        }
        catch (PatternSyntaxException ex) {
            error = ex;
        }
        if (error != null || StringUtil.isEmpty((String)this.baseDomain)) {
            throw new BaseException("\u83b7\u53d6ueditor\u7684\u4e0a\u4f20\u5730\u5740\u65f6\u51fa\u9519");
        }
    }

    public State saveFileByInputStream(InputStream is, String fileName) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)fileName), (String)"\u4e0a\u4f20\u56fe\u7247\u65f6path\u4e0d\u80fd\u4e3a\u7a7a");
        this.buildBaseDomain();
        DefaultFile file = new DefaultFile();
        file.setId(UniqueIdUtil.getSuid());
        IUser currentUser = ContextUtil.getCurrentUser();
        if (currentUser != null) {
            file.setCreateBy(currentUser.getUserId());
            file.setCreatorName(currentUser.getFullname());
        } else {
            file.setCreatorName(DefaultFile.FILE_UPLOAD_UNKNOWN);
        }
        file.setFileName(fileName.lastIndexOf(46) == -1 ? fileName : fileName.substring(0, fileName.lastIndexOf(46)));
        String sysPath = AppFileUtil.getAttachPath();
        String filePath = AppFileUtil.createFilePath((String)("ueditor" + File.separator + file.getId()), (String)fileName);
        filePath = filePath.replace(sysPath + File.separator, "");
        file.setFilePath(filePath);
        file.setCreateTime(LocalDateTime.now());
        String extName = FileUtil.getFileExt((String)fileName);
        file.setExtensionName(extName);
        String saveType = AppFileUtil.getSaveType((String)"");
        file.setStoreType(saveType);
        try {
            this.fileManager.uploadFile(file, is);
            BaseState state = new BaseState(true);
            state.putInfo("title", fileName);
            state.putInfo("url", String.format("%s/system/file/v1/downloadFile?fileId=%s", this.baseDomain, file.getId()));
            return state;
        }
        catch (Exception e) {
            BaseState state = new BaseState(false, 4);
            state.putInfo("code", e.getClass().getCanonicalName());
            state.putInfo("message", e.getMessage());
            return state;
        }
    }
}

