/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.util;

import com.hotent.base.util.StringUtil;
import com.hotent.file.service.impl.BASE64DecodedMultipartFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ImageCompressorUtil {
    private static final Logger logger = LoggerFactory.getLogger(ImageCompressorUtil.class);
    private static List<String> SUFFIX_LIST_IMAGE = Arrays.asList("png", "jpg", "jpeg");
    private static long DES_FILE_SIZE = 800L;

    public static int getImageLengthOfSide(MultipartFile params) {
        int lengthSize = 0;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String suffixName = ImageCompressorUtil.getSuffixNameInfo(params);
        try {
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(suffixName);
            ImageReader reader = readers.next();
            ImageInputStream iis = ImageIO.createImageInputStream(params.getInputStream());
            reader.setInput(iis, true);
            result.put("width", reader.getWidth(0));
            result.put("height", reader.getHeight(0));
            lengthSize = reader.getWidth(0) > reader.getHeight(0) ? reader.getWidth(0) : reader.getHeight(0);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u56fe\u7247\u6700\u957f\u8fb9\u957f\u5ea6\u5f02\u5e38", (Throwable)e);
        }
        return lengthSize;
    }

    private static String getSuffixNameInfo(MultipartFile params) {
        String result = "";
        if (StringUtil.isEmpty((String)params.getOriginalFilename())) {
            return result;
        }
        String suffixName = params.getOriginalFilename().substring(params.getOriginalFilename().lastIndexOf("."));
        suffixName = suffixName.toLowerCase();
        for (String suffix : SUFFIX_LIST_IMAGE) {
            if (suffixName.indexOf(suffix) <= 0) continue;
            result = suffix;
            break;
        }
        return result;
    }

    private static Boolean checkImageSuffix(MultipartFile params) {
        boolean result = false;
        if (StringUtil.isEmpty((String)params.getOriginalFilename())) {
            return result;
        }
        String suffixName = params.getOriginalFilename().substring(params.getOriginalFilename().lastIndexOf("."));
        suffixName = suffixName.toLowerCase();
        for (String suffix : SUFFIX_LIST_IMAGE) {
            if (suffixName.indexOf(suffix) <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    private static byte[] compressPicForScale(byte[] imageBytes, long desFileSize) {
        if (imageBytes == null || imageBytes.length <= 0 || (long)imageBytes.length < desFileSize * 1024L) {
            return imageBytes;
        }
        long srcSize = imageBytes.length;
        double accuracy = ImageCompressorUtil.getAccuracy(srcSize / 1024L);
        try {
            while ((long)imageBytes.length > desFileSize * 1024L) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(imageBytes.length);
                Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(accuracy).outputQuality(accuracy).toOutputStream((OutputStream)outputStream);
                imageBytes = outputStream.toByteArray();
            }
            logger.info("\u3010\u56fe\u7247\u538b\u7f29\u3011imageId={} | \u56fe\u7247\u539f\u5927\u5c0f={}kb | \u538b\u7f29\u540e\u5927\u5c0f={}kb", new Object[]{"", srcSize / 1024L, imageBytes.length / 1024});
        }
        catch (Exception e) {
            logger.error("\u3010\u56fe\u7247\u538b\u7f29\u3011\u56fe\u7247\u538b\u7f29\u5f02\u5e38!", (Throwable)e);
        }
        return imageBytes;
    }

    private static double getAccuracy(long size) {
        double accuracy = size < 900L ? 0.85 : (size < 2047L ? 0.8 : (size < 3275L ? 0.7 : 0.6));
        return accuracy;
    }

    private static MultipartFile base64ToMultipart(String base64) {
        try {
            String[] baseStrs = base64.split(",");
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] b = decoder.decodeBuffer(baseStrs[1]);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            return new BASE64DecodedMultipartFile(b, baseStrs[0]);
        }
        catch (IOException e) {
            logger.error("[\u538b\u7f29\u56fe\u7247]base64 \u8f6cMultipartFile", (Throwable)e);
            return null;
        }
    }

    private static byte[] getByteArray(InputStream inStream) throws IOException {
        int rc;
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        return swapStream.toByteArray();
    }

    public static MultipartFile compress(MultipartFile fileImg) {
        if (!ImageCompressorUtil.checkImageSuffix(fileImg).booleanValue()) {
            return fileImg;
        }
        MultipartFile result = fileImg;
        BASE64Encoder encoder = new BASE64Encoder();
        try {
            InputStream inputStream = fileImg.getInputStream();
            byte[] imgData = ImageCompressorUtil.compressPicForScale(ImageCompressorUtil.getByteArray(inputStream), DES_FILE_SIZE);
            String imgDataBase64 = "data:" + fileImg.getContentType() + ";base64," + encoder.encode(imgData);
            result = ImageCompressorUtil.base64ToMultipart(imgDataBase64);
        }
        catch (IOException e) {
            logger.error("\u538b\u7f29\u56fe\u7247\u5f02\u5e38\uff01", (Throwable)e);
        }
        return result;
    }
}

