/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.context.BaseContext;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.file.model.Catalog;
import com.hotent.file.persistence.dao.CatalogDao;
import com.hotent.file.persistence.manager.CatalogManager;
import com.hotent.jms.model.JmsSysTypeChangeMessage;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="catalogManager")
public class CatalogManagerImpl
extends BaseManagerImpl<CatalogDao, Catalog>
implements CatalogManager {
    @Resource
    CatalogManager catalogManager;
    @Resource
    JmsProducer jmsProducer;
    @Resource
    IUserService userService;
    @Resource
    BaseContext baseContext;

    @Override
    public List<Catalog> getCatalogByCreateBy(String userId) {
        return ((CatalogDao)this.baseMapper).getCatalogByCreateBy(userId);
    }

    @Override
    public List<String> getDepartmentList(String id, List<String> listId) {
        try {
            List<Catalog> list = ((CatalogDao)this.baseMapper).getCatalogBypParentId(id);
            if (null != list && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Catalog c = list.get(i);
                    listId.add(c.getId());
                    this.getDepartmentList(c.getId(), listId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listId;
    }

    @Override
    public List<Catalog> getListByParentId(String parentId, String name) {
        return ((CatalogDao)this.baseMapper).getListByParentId(parentId, name);
    }

    @Override
    public CommonResult saveCatalog(Catalog catalog) {
        String id = catalog.getId();
        try {
            String resultMsg;
            List<Catalog> catalogList = this.catalogManager.getListByParentId(catalog.getParentId(), catalog.getName());
            if (BeanUtils.isNotEmpty(catalogList)) {
                return new CommonResult(false, "\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            if (StringUtil.isEmpty((String)id)) {
                catalog.setId(UniqueIdUtil.getSuid());
                this.catalogManager.create((Model)catalog);
                resultMsg = "\u6dfb\u52a0\u9644\u4ef6\u76ee\u5f55\u6210\u529f";
            } else {
                Catalog oldType = (Catalog)this.catalogManager.get((Serializable)((Object)catalog.getId()));
                this.catalogManager.update((Model)catalog);
                this.jmsProducer.sendToTopic((Object)new JmsSysTypeChangeMessage("FILE_TYPE", "", catalog.getName(), oldType.getName(), Integer.valueOf(1)));
                resultMsg = "\u66f4\u65b0\u9644\u4ef6\u76ee\u5f55\u6210\u529f";
            }
            return new CommonResult(resultMsg);
        }
        catch (Exception e) {
            String resultMsg = "\u5bf9\u9644\u4ef6\u76ee\u5f55\u64cd\u4f5c\u5931\u8d25";
            return new CommonResult(false, resultMsg);
        }
    }

    @Override
    public CommonResult removeCatalogById(String id) {
        try {
            ArrayList<String> listId = new ArrayList<String>();
            List<String> childrenIds = this.catalogManager.getDepartmentList(id, listId);
            childrenIds.add(id);
            String[] ids = new String[childrenIds.size()];
            for (int i = 0; i < childrenIds.size(); ++i) {
                ids[i] = childrenIds.get(i);
            }
            QueryFilter filter = QueryFilter.build();
            filter.addFilter("ID", (Object)ids, QueryOP.IN);
            PageList query = this.catalogManager.query(filter);
            if (BeanUtils.isNotEmpty((Object)query) && BeanUtils.isNotEmpty((Object)query.getRows())) {
                for (Catalog type : query.getRows()) {
                    this.jmsProducer.sendToTopic((Object)new JmsSysTypeChangeMessage("FILE_TYPE", "", type.getName(), type.getName(), Integer.valueOf(2)));
                }
            }
            this.catalogManager.removeByIds(Arrays.asList(ids));
            return new CommonResult("\u5220\u9664\u9644\u4ef6\u76ee\u5f55\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u9644\u4ef6\u76ee\u5f55\u5931\u8d25");
        }
    }

    @Override
    public List<Catalog> getTree() {
        IUser user = null;
        String accout = this.baseContext.getCurrentUserAccout();
        if (StringUtil.isNotEmpty((String)accout)) {
            user = this.userService.getUserByAccount(accout);
        }
        List<Object> listCatalog = new ArrayList();
        if (BeanUtils.isNotEmpty((Object)user) && user.isAdmin()) {
            listCatalog = this.catalogManager.list();
        } else if (BeanUtils.isNotEmpty((Object)user)) {
            listCatalog = this.catalogManager.getCatalogByCreateBy(user.getUserId());
        }
        Catalog cl = new Catalog();
        cl.setName("\u9644\u4ef6\u5206\u7c7b");
        cl.setId("-1");
        listCatalog.add((Object)cl);
        ArrayList<Catalog> listSysType = new ArrayList<Catalog>();
        for (Catalog catalog : listCatalog) {
            Catalog sysTypes = new Catalog();
            sysTypes = catalog;
            sysTypes.setOpen(true);
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.addFilter("parentId", (Object)catalog.getId(), QueryOP.EQUAL);
            List sys_Type = this.catalogManager.query(queryFilter).getRows();
            if (sys_Type != null && sys_Type.size() == 0) {
                sysTypes.setIsParent("true");
            }
            listSysType.add(catalog);
        }
        List rtnList = BeanUtils.listToTree(listSysType);
        return rtnList;
    }
}

