/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.persistence.manager.impl;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.keking.model.FileAttribute;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.data.DocxRenderData;
import com.deepoove.poi.policy.RenderPolicy;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.attachment.Attachment;
import com.hotent.base.attachment.AttachmentService;
import com.hotent.base.attachment.AttachmentServiceFactory;
import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.NotFoundException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.file.attachmentService.FtpAttachmentServiceImpl;
import com.hotent.file.extend.DetailTablePolicy;
import com.hotent.file.extend.InstanceFlowOpinions;
import com.hotent.file.extend.SubRenderPolicy;
import com.hotent.file.model.DefaultFile;
import com.hotent.file.model.FlowUploadProperties;
import com.hotent.file.model.UploadResult;
import com.hotent.file.model.WangEditorUploadResult;
import com.hotent.file.persistence.dao.FileDao;
import com.hotent.file.persistence.manager.CatalogManager;
import com.hotent.file.persistence.manager.FileManager;
import com.hotent.file.persistence.manager.FlowUploadPropertiesManager;
import com.hotent.file.print.model.WordPrintParam;
import com.hotent.file.print.service.PrintTemplateService;
import com.hotent.file.util.AppFileUtil;
import com.hotent.file.util.HtmlUtil;
import com.hotent.file.util.ImageCompressorUtil;
import com.hotent.file.util.SignetPictureRenderPolicy;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="fileManager")
public class FileManagerImpl
extends BaseManagerImpl<FileDao, DefaultFile>
implements FileManager {
    private Logger logger = LoggerFactory.getLogger(FileManagerImpl.class);
    @Resource
    UCFeignService ucFeignService;
    @Resource
    IUserService userService;
    @Resource
    BaseContext baseContext;
    @Resource
    CatalogManager catalogManager;
    @Resource
    BpmRuntimeFeignService bpmRuntimeFeignService;
    @Value(value="${eip.allowFileSuffix:}")
    String allowFileSuffix = "";
    private AttachmentService attachmentService;
    @Resource
    PrintTemplateService printTemplateService;
    List<String> XWPF_WORD_TYPE = Arrays.asList("doc", "docx");
    private static final String TEMP_FOLDER_PATH = "temps";
    @Resource
    JmsProducer jmsTodoProducer;
    @Resource
    ResourceLoader resourceLoader;

    private void initCurrentHandler(String propertiesId) throws Exception {
        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
        this.attachmentService = attachmentHandlerFactory.getCurrentServices(AppFileUtil.getSaveType((String)propertiesId));
    }

    @Override
    public List<DefaultFile> getAllByExt(String[] allowFiles) {
        return ((FileDao)this.baseMapper).getAllByExt(allowFiles);
    }

    @Override
    @Transactional
    public void delSysFileByIds(String[] ids) throws Exception {
        DefaultFile file;
        String propertiesId = "";
        if (BeanUtils.isNotEmpty((Object)ids) && ids.length > 0 && BeanUtils.isNotEmpty((Object)((Object)(file = this.get((Serializable)((Object)ids[0])))))) {
            propertiesId = file.getProp6();
        }
        this.initCurrentHandler(propertiesId);
        for (String id : ids) {
            DefaultFile def;
            this.attachmentService.remove((Attachment)def, BeanUtils.isNotEmpty((Object)((Object)(def = this.get((Serializable)((Object)id))))) ? def.getProp6() : "");
            ((FileDao)this.baseMapper).deleteById((Serializable)((Object)id));
        }
    }

    @Override
    @Transactional
    public UploadResult uploadFile(DefaultFile file, List<MultipartFile> files, String fileFormates, IUser currentUser, String flowKey) throws Exception {
        FlowUploadPropertiesManager uploadPropertiesManager;
        FlowUploadProperties uploadProperties;
        this.initCurrentHandler(flowKey);
        String saveType = AppFileUtil.getSaveType((String)flowKey);
        String prop6 = null;
        if (StringUtil.isNotEmpty((String)flowKey) && BeanUtils.isNotEmpty((Object)((Object)(uploadProperties = (uploadPropertiesManager = (FlowUploadPropertiesManager)AppUtil.getBean(FlowUploadPropertiesManager.class)).getByFlowKey(flowKey))))) {
            prop6 = uploadProperties.getId();
        }
        return this.uploadFile(file, files, fileFormates, currentUser, saveType, prop6, false);
    }

    @Override
    public UploadResult uploadFile(DefaultFile file, List<MultipartFile> files, Boolean isCompress) throws Exception {
        String account = this.baseContext.getCurrentUserAccout();
        IUser currentUser = this.userService.getUserByAccount(account);
        String saveType = AppFileUtil.getSaveType((String)"");
        return this.uploadFile(file, files, "", currentUser, saveType, null, isCompress);
    }

    @Transactional
    public UploadResult uploadFile(DefaultFile file, List<MultipartFile> files, String fileFormates, IUser currentUser, String saveType, String prop6, Boolean isCompress) throws Exception {
        Iterator<MultipartFile> it = files.iterator();
        UploadResult result = new UploadResult();
        boolean mark = true;
        short isdel = 0;
        while (it.hasNext()) {
            String fileSuffix;
            DefaultFile sysFile;
            Boolean isAdd = false;
            String oldFilePath = "";
            if (StringUtil.isNotEmpty((String)file.getId())) {
                sysFile = this.get((Serializable)((Object)file.getId()));
                oldFilePath = sysFile.getFilePath();
            } else {
                isAdd = true;
                sysFile = new DefaultFile();
                sysFile.setId(UniqueIdUtil.getSuid());
            }
            MultipartFile f = it.next();
            if (isCompress.booleanValue()) {
                f = ImageCompressorUtil.compress(f);
            }
            if (StringUtil.isNotEmpty((String)file.getFileName()) && !file.getFileName().equals(f.getName())) {
                throw new RuntimeException("\u4e0a\u4f20\u540d\u79f0\u4e0e\u6587\u4ef6\u540d\u79f0\u4e0d\u7b26");
            }
            sysFile.setContentType(f.getContentType());
            String oriFileName = f.getOriginalFilename();
            String extName = FileUtil.getFileExt((String)oriFileName);
            String string = fileSuffix = StringUtil.isEmpty((String)fileFormates) ? this.allowFileSuffix : fileFormates;
            if (StringUtil.isNotEmpty((String)fileSuffix)) {
                List<String> typeList = Arrays.asList(fileSuffix.split(","));
                for (int i = 0; i < typeList.size(); ++i) {
                    if (!StringUtil.isNotEmpty((String)typeList.get(i))) continue;
                    typeList.set(i, typeList.get(i));
                }
                if (typeList.indexOf(extName) < 0 && typeList.indexOf("." + extName) < 0) {
                    mark = false;
                }
            }
            if (mark) {
                String fileName = sysFile.getId() + "." + extName;
                String filePath = "";
                String creatorAccount = DefaultFile.FILE_UPLOAD_UNKNOWN;
                if (currentUser != null) {
                    sysFile.setCreateBy(currentUser.getUserId());
                    sysFile.setCreatorName(currentUser.getFullname());
                    creatorAccount = currentUser.getAccount();
                } else {
                    sysFile.setCreatorName(creatorAccount);
                }
                filePath = "pictureShow".equals(sysFile.getFileType()) ? AppFileUtil.getFilePath((String)(creatorAccount + File.separator + "pictureShow"), (String)fileName) : AppFileUtil.getFilePath((String)currentUser.getAccount(), (String)fileName);
                sysFile.setFileName(oriFileName.lastIndexOf(46) == -1 ? oriFileName : oriFileName.substring(0, oriFileName.lastIndexOf(46)));
                sysFile.setFilePath(filePath);
                sysFile.setCreateTime(LocalDateTime.now());
                sysFile.setExtensionName(extName);
                sysFile.setByteCount(f.getSize());
                sysFile.setIsDel(isdel);
                sysFile.setNote(FileUtil.getSize((double)f.getSize()));
                sysFile.setStoreType(saveType);
                sysFile.setProp6(prop6);
                if (isAdd.booleanValue()) {
                    sysFile.setBytes(f.getBytes());
                    this.attachmentService.upload((Attachment)sysFile, f.getInputStream(), BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                    if (!saveType.equals(DefaultFile.SAVE_TYPE_DTABASE)) {
                        sysFile.setBytes(null);
                    }
                    super.create((Model)sysFile);
                } else {
                    this.attachmentService.upload((Attachment)sysFile, f.getInputStream(), BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                    this.update((Model)sysFile);
                    boolean tag = true;
                    String newFilePath = sysFile.getFilePath();
                    if (StringUtil.isNotEmpty((String)newFilePath) && StringUtil.isNotEmpty((String)oldFilePath) && newFilePath.trim().equals(oldFilePath.trim())) {
                        tag = false;
                    }
                    if (tag) {
                        sysFile.setFilePath(oldFilePath);
                        this.attachmentService.remove((Attachment)sysFile, BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                    }
                }
                result.setSuccess(true);
                result.setFileId(sysFile.getId());
                result.setFileName(oriFileName);
                result.setSize(sysFile.getByteCount());
                result.setUsername(sysFile.getCreatorName());
                this.jmsTodoProducer.sendToTopic((Object)result, "file_preview_trans_queue");
                continue;
            }
            result.setSuccess(false);
            result.setMessage("\u7cfb\u7edf\u4e0d\u5141\u8bb8\u7c7b\u578b[" + extName + "]\u6587\u4ef6\u7684\u4e0a\u4f20\uff01");
        }
        return result;
    }

    @Override
    public DefaultFile downloadFile(String fileId, OutputStream outStream) throws Exception {
        AttachmentServiceFactory attachmentHandlerFactory;
        DefaultFile sysFile = this.get((Serializable)((Object)fileId));
        if (DefaultFile.SAVE_TYPE_DTABASE.equals(sysFile.getStoreType())) {
            attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
            this.attachmentService = attachmentHandlerFactory.getCurrentServices(DefaultFile.SAVE_TYPE_DTABASE);
        } else {
            this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
        }
        if (BeanUtils.isEmpty((Object)((Object)sysFile))) {
            return null;
        }
        if (this.attachmentService instanceof FtpAttachmentServiceImpl && DefaultFile.SAVE_TYPE_FOLDER.equals(sysFile.getStoreType())) {
            attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
            this.attachmentService = attachmentHandlerFactory.getCurrentServices(DefaultFile.SAVE_TYPE_FOLDER);
        }
        try {
            this.attachmentService.download((Attachment)sysFile, outStream, BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
        }
        catch (BaseException e) {
            IoUtil.copy((InputStream)this.resourceLoader.getResource("classpath:defaultImage.png").getInputStream(), (OutputStream)outStream);
        }
        return sysFile;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void uploadFile(DefaultFile file, InputStream inputStream) throws Exception {
        this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
        String storeType = file.getStoreType();
        if (StringUtil.isEmpty((String)file.getId())) {
            file.setId(UniqueIdUtil.getSuid());
        }
        this.attachmentService.upload((Attachment)file, inputStream, BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
        if (StringUtil.isEmpty((String)storeType)) {
            storeType = AppFileUtil.getSaveType((String)(BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : ""));
            file.setStoreType(storeType);
        }
        if (!DefaultFile.SAVE_TYPE_DTABASE.equals(storeType)) {
            file.setBytes(null);
        }
        super.create((Model)file);
    }

    @Override
    @Transactional
    public void setXbTypeId(List<String> fileId, String xbTypeId, String type) throws Exception {
        ((FileDao)this.baseMapper).setXbTypeId(fileId, xbTypeId, type);
    }

    @Override
    @Transactional
    public void updateFileExtraProp(List<DefaultFile> files) {
        if (BeanUtils.isNotEmpty(files)) {
            for (DefaultFile defaultFile : files) {
                ((FileDao)this.baseMapper).updateExtraProps(defaultFile);
            }
        }
    }

    @Override
    public byte[] getFileBytesById(String fileId) throws Exception {
        DefaultFile sysFile = this.get((Serializable)((Object)fileId));
        this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
        if (BeanUtils.isEmpty((Object)((Object)sysFile))) {
            return null;
        }
        return this.attachmentService.getFileBytes((Attachment)sysFile);
    }

    public DefaultFile get(Serializable id) {
        DefaultFile file = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            file = (DefaultFile)super.get(id);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        return file;
    }

    @Override
    public void downloadFileToPath(DefaultFile file, String path) throws Exception {
        this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
        File dfile = new File(path);
        if (!dfile.exists()) {
            if (BeanUtils.isNotEmpty((Object)dfile.getParentFile()) && !dfile.getParentFile().exists()) {
                dfile.getParentFile().mkdir();
            }
            FileOutputStream out = new FileOutputStream(dfile);
            this.attachmentService.download((Attachment)file, (OutputStream)out, BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
            out.flush();
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importSignature(MultipartFile file, boolean isCover) {
        String rootRealPath = "";
        CommonResult message = new CommonResult(true, "\u5bfc\u5165\u6210\u529f\uff01");
        try {
            String unZipDir = TimeUtil.getCurrentTimeMillis() + "_" + this.baseContext.getCurrentUserId();
            rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/" + unZipDir).replace("/", File.separator);
            File folder = new File(rootRealPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            File ignatureFloder = new File(rootRealPath);
            File[] fs = ignatureFloder.listFiles();
            if (fs != null && fs.length == 1 && fs[0].isDirectory()) {
                ignatureFloder = fs[0];
                fs = fs[0].listFiles();
            }
            if (fs == null || fs.length == 0) {
                message.setState(Boolean.valueOf(false));
                message.setMessage("\u5bfc\u5165\u5931\u8d25\uff1a\u538b\u7f29\u6587\u4ef6\u4e2d\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u7b7e\u7ae0\u6587\u4ef6\u4e14\u7b7e\u7ae0\u6587\u4ef6\u4e0d\u5b58\u5728\u5d4c\u5957\u5c42\u7ea7\uff01");
                CommonResult commonResult = message;
                return commonResult;
            }
            IUser user = null;
            String account = this.baseContext.getCurrentUserAccout();
            if (StringUtil.isNotEmpty((String)account)) {
                user = this.userService.getUserByAccount(account);
            }
            ArrayNode accountFiles = JsonUtil.getMapper().createArrayNode();
            ExecutorService pool = Executors.newFixedThreadPool(fs.length);
            FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
            ArrayList<Future<Object>> list = new ArrayList<Future<Object>>();
            for (File signatureFile : fs) {
                if (!signatureFile.getName().endsWith(".png")) {
                    message.setState(Boolean.valueOf(false));
                    message.setMessage("\u7b7e\u7ae0\u6587\u4ef6\u53ea\u652f\u6301.png\u56fe\u7247\u6587\u4ef6\uff01");
                }
                if (signatureFile.isDirectory() || !signatureFile.getName().endsWith(".png")) continue;
                MyCallable c = new MyCallable(signatureFile, user, fileManager);
                Future<Object> f = pool.submit(c);
                list.add(f);
            }
            for (Future future : list) {
                UploadResult result = (UploadResult)future.get();
                if (!result.isSuccess()) continue;
                ObjectNode accountFile = JsonUtil.getMapper().createObjectNode();
                String[] names = result.getFileName().split("\\.");
                accountFile.put("account", names[0]);
                accountFile.put("fileId", result.getFileId());
                accountFiles.add((JsonNode)accountFile);
            }
            if (accountFiles.size() > 0) {
                ObjectNode signatureData = JsonUtil.getMapper().createObjectNode();
                signatureData.put("repeatConver", isCover);
                signatureData.set("signatureList", (JsonNode)accountFiles);
                CommonResult commonResult = this.ucFeignService.saveSignatureBatch(signatureData);
                if (!commonResult.getState().booleanValue()) {
                    String[] ids = new String[signatureData.size()];
                    for (int i = 0; i < accountFiles.size(); ++i) {
                        ids[i] = accountFiles.get(i).get("fileId").asText();
                    }
                    this.delSysFileByIds(ids);
                    CommonResult commonResult2 = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + commonResult.getMessage());
                    return commonResult2;
                }
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
        finally {
            File fileDir = new File(rootRealPath);
            if (fileDir.exists()) {
                FileUtil.deleteDir((File)fileDir);
            }
        }
        return message;
    }

    @Override
    public PageList<DefaultFile> listData(QueryFilter queryFilter) {
        List listQueryField = queryFilter.getQuerys();
        ArrayList<String> listId = new ArrayList<String>();
        QueryField query = new QueryField();
        String xbTypeId = "";
        for (QueryField queryField : listQueryField) {
            if (!"xbTypeId".equals(queryField.getProperty())) continue;
            xbTypeId = queryField.getValue() + "";
            query.setProperty(queryField.getProperty());
            query.setRelation(queryField.getRelation());
            listQueryField.remove(queryField);
            break;
        }
        if (StringUtil.isNotEmpty((String)xbTypeId)) {
            List<String> ids = this.catalogManager.getDepartmentList(xbTypeId, listId);
            ids.add(xbTypeId);
            query.setValue(ids);
            query.setOperation(QueryOP.IN);
            listQueryField.add(query);
            queryFilter.setQuerys(listQueryField);
        }
        return this.query(queryFilter);
    }

    @Override
    public UploadResult upload(MultipartHttpServletRequest request, Optional<String> flowKey, String fileId) throws Exception {
        IUser user = null;
        String account = this.baseContext.getCurrentUserAccout();
        if (StringUtil.isNotEmpty((String)account)) {
            user = this.userService.getUserByAccount(account);
        }
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
        while (it.hasNext()) {
            files.add((MultipartFile)it.next());
        }
        DefaultFile file = new DefaultFile();
        if (StringUtil.isNotEmpty((String)fileId)) {
            file = this.get((Serializable)((Object)fileId));
            file.setFileName(null);
        }
        return this.uploadFile(file, files, "", user, flowKey.orElse(""));
    }

    @Override
    public void downloadFile(HttpServletRequest request, HttpServletResponse response, String fileId) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        DefaultFile file = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            file = this.get((Serializable)((Object)fileId));
        }
        if (BeanUtils.isEmpty((Object)((Object)file))) {
            throw new NotFoundException(String.format("\u672a\u627e\u5230fileId\u4e3a: %s \u7684\u6587\u4ef6", fileId));
        }
        String fileName = file.getFileName() + "." + file.getExtensionName();
        String filedisplay = URLEncoder.encode(fileName, "utf-8");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        response.setHeader("Access-Control-Allow-Origin", "*");
        String type = new MimetypesFileTypeMap().getContentType(new File(file.getFilePath()));
        response.setContentType(type);
        this.downloadFile(fileId, (OutputStream)response.getOutputStream());
    }

    @Override
    public void getLogoFile(HttpServletRequest request, HttpServletResponse response, String tenantId, String logoType) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        DefaultFile file = null;
        JsonNode tenantNode = this.ucFeignService.getTenantById(tenantId);
        String logoTypeField = "manageLogo";
        if ("front".equals(logoType)) {
            logoTypeField = "frontLogo";
        } else if ("ico".equals(logoType)) {
            logoTypeField = "ico";
        }
        ArrayNode logoNode = (ArrayNode)JsonUtil.toJsonNode((String)tenantNode.get(logoTypeField).asText());
        String fileId = logoNode.get(0).get("id").asText();
        file = this.get((Serializable)((Object)fileId));
        if (BeanUtils.isEmpty((Object)((Object)file))) {
            throw new NotFoundException(String.format("\u672a\u627e\u5230fileId\u4e3a: %s \u7684\u6587\u4ef6", fileId));
        }
        String fileName = file.getFileName() + "." + file.getExtensionName();
        String filedisplay = URLEncoder.encode(fileName, "utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        response.setHeader("Access-Control-Allow-Origin", "*");
        String type = new MimetypesFileTypeMap().getContentType(new File(file.getFilePath()));
        response.setContentType(type);
        this.downloadFile(fileId, (OutputStream)response.getOutputStream());
    }

    @Override
    public void preview(HttpServletRequest request, HttpServletResponse response, String fileId) {
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            String fileName;
            response.setContentType("text/html; charset=UTF-8");
            response.setContentType("image/jpeg");
            DefaultFile file = null;
            file = this.get((Serializable)((Object)fileId));
            if (BeanUtils.isEmpty((Object)((Object)file))) {
                return;
            }
            String filedisplay = fileName = file.getFileName() + "." + file.getExtensionName();
            String agent = request.getHeader("USER-AGENT");
            filedisplay = agent != null && agent.indexOf("MSIE") == -1 && agent.indexOf("Trident") == -1 ? "=?UTF-8?B?" + new String(Base64.getBase64((String)filedisplay)) + "?=" : URLEncoder.encode(filedisplay, "utf-8");
            response.addHeader("filename", filedisplay);
            response.setHeader("Access-Control-Allow-Origin", "*");
            this.downloadFile(fileId, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            this.logger.error("\u9884\u89c8\u9644\u4ef6\u5931\u8d25");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String wordPrint(WordPrintParam param) throws Exception {
        DefaultFile templateFile = this.get((Serializable)((Object)param.getFileId()));
        Assert.notNull((Object)((Object)templateFile), (String)"\u627e\u4e0d\u5230\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u6b63\u5e38", (Object[])new Object[0]);
        DefaultFile printFile = new DefaultFile();
        printFile.setId(UniqueIdUtil.getSuid());
        String outputFilePath = AppFileUtil.createFilePath((String)("print" + File.separator + this.baseContext.getCurrentUserAccout()), (String)(printFile.getId() + "." + templateFile.getExtensionName()));
        outputFilePath.replace("/", File.separator);
        outputFilePath.replace("\\", File.separator);
        while (outputFilePath.contains("\\\\")) {
            outputFilePath = outputFilePath.replace("\\\\", File.separator);
        }
        while (outputFilePath.contains("//")) {
            outputFilePath = outputFilePath.replace("//", File.separator);
        }
        String saveOutputFilePath = this.printFile(param, templateFile, outputFilePath, printFile.getId());
        this.savePrintLog(param, param.getTemplateName(), printFile.getId());
        printFile.setFileName(param.getSubject());
        return this.saveFile(printFile, saveOutputFilePath);
    }

    private String saveFile(DefaultFile printFile, String saveOutputFilePath) throws Exception {
        printFile.setStoreType(AppFileUtil.getSaveType((String)""));
        printFile.setFilePath(saveOutputFilePath.replace(AppFileUtil.getAttachPath() + File.separator, ""));
        String extName = FileNameUtil.extName((String)saveOutputFilePath);
        printFile.setExtensionName(extName);
        printFile.setIsDel((short)0);
        printFile.setCreateTime(DateUtil.getCurrentDate());
        if (!printFile.getStoreType().equals(DefaultFile.SAVE_TYPE_FOLDER)) {
            this.uploadFile(printFile, Files.newInputStream(Paths.get(saveOutputFilePath, new String[0]), new OpenOption[0]));
        } else {
            this.create((Model)printFile);
        }
        return printFile.getId();
    }

    private void savePrintLog(WordPrintParam param, String templateName, String newFileId) {
        try {
            ArrayNode flowOpinions = param.getFlowOpinions();
            if (flowOpinions.size() > 0) {
                ObjectNode opinion = (ObjectNode)flowOpinions.get(0);
                ObjectNode record = JsonUtil.getMapper().createObjectNode();
                record.put("procInstId", JsonUtil.getString((JsonNode)opinion, (String)"procInstId"));
                record.put("nodeId", param.getNodeId());
                record.put("procDefId", param.getDefId());
                record.put("formKey", param.getFormKey());
                record.put("templateId", param.getFileId());
                record.put("templateName", StringUtil.isEmpty((String)param.getTemplateName()) ? templateName : param.getTemplateName());
                record.put("fileId", newFileId);
                this.bpmRuntimeFeignService.addPrintLog(record);
            }
        }
        catch (Exception e) {
            System.out.println("\u65b0\u589e\u6253\u5370\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private String printFile(WordPrintParam param, DefaultFile defaultFile, String outputFilePath, String fileId) throws Exception {
        HashMap<String, Object> boMap = new HashMap<String, Object>();
        HashMap<String, Object> twiceMap = new HashMap<String, Object>();
        String templateType = defaultFile.getExtensionName();
        Map boDataMap = JsonUtil.toMap((String)param.getBoData());
        boMap.put("flowOpinions", param.getFlowOpinions());
        Configure config = this.initConfig(boDataMap, boMap);
        JsonUtil.toMap((String)param.getBoData()).forEach((boAlias, item) -> ((Map)item).forEach((key, val) -> {
            List<String> commonColumns;
            String skey = key.toString();
            if (!param.getIsSql().booleanValue() && !param.getIsOld().booleanValue()) {
                key = boAlias + "_" + key;
            }
            try {
                if (HtmlUtil.isHtml(Base64.getFromBase64((String)((Object)val).toString()))) {
                    val = Base64.getFromBase64((String)((Object)val).toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (skey.startsWith("sub_") && val instanceof List) {
                commonColumns = Arrays.asList("ID_", "REF_ID_");
                ArrayList newVal = new ArrayList();
                ((List)val).forEach(subItem -> {
                    HashMap subMap = new HashMap();
                    newVal.add(subMap);
                    ((Map)subItem).forEach((subK, subV) -> {
                        if (subV instanceof Number) {
                            NumberFormat nf = NumberFormat.getInstance();
                            nf.setGroupingUsed(false);
                            nf.setMaximumFractionDigits(6);
                            subV = nf.format(subV);
                        }
                        subMap.put(subK, subV);
                        String columnKey = subK.toString().toUpperCase();
                        if (commonColumns.contains(columnKey)) {
                            subMap.put(subK.toString().toUpperCase(), subV);
                        } else if (!columnKey.startsWith("F_")) {
                            subMap.put("F_" + columnKey, subV);
                        }
                    });
                });
                val = newVal;
            }
            if (val instanceof Number) {
                NumberFormat nf = NumberFormat.getInstance();
                nf.setGroupingUsed(false);
                nf.setMaximumFractionDigits(6);
                val = nf.format(val);
            }
            boMap.put((String)key, val);
            boMap.put(skey, val);
            commonColumns = Arrays.asList("ID_", "REF_ID_");
            for (String col : commonColumns) {
                if (boMap.containsKey(col) || !boMap.containsKey(col.toLowerCase())) continue;
                boMap.put(col, val);
            }
            String columnKey = skey.toUpperCase();
            if (!columnKey.startsWith("F_") && !commonColumns.contains(columnKey)) {
                boMap.put("F_" + columnKey, val);
            }
            if (null != val && HtmlUtil.isHtml(((Object)val).toString())) {
                String text = ((Object)val).toString();
                text = text.replaceAll("\\&nbsp;", "");
                File docxFile = HtmlUtil.getRichtextToDocx(text);
                if (this.XWPF_WORD_TYPE.contains(templateType)) {
                    DocxRenderData docxRenderData = new DocxRenderData(docxFile);
                    boMap.put((String)key, docxRenderData);
                    boMap.put(skey, docxRenderData);
                } else {
                    try (FileInputStream is = new FileInputStream(docxFile);){
                        XWPFDocument doc = new XWPFDocument((InputStream)is);
                        StringBuilder docText = new StringBuilder();
                        doc.getParagraphs().forEach(xwpfParagraph -> xwpfParagraph.getRuns().forEach(xwpfRun -> {
                            String s = xwpfRun.getText(0);
                            if (StringUtil.isNotEmpty((String)s) && !"-1".equals(s) && !"null".equals(s)) {
                                if (docText.length() > 1) {
                                    docText.append("\n");
                                }
                                docText.append(s);
                            }
                        }));
                        boMap.put((String)key, docText.toString());
                        boMap.put(skey, docText.toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (docxFile != null && docxFile.exists()) {
                    docxFile.delete();
                }
            } else if (BeanUtils.isNotEmpty(val)) {
                if (val instanceof List && key.toString().indexOf("_sub_") > -1) {
                    List lmList = val;
                    for (int i = 0; i < lmList.size(); ++i) {
                        Map m = (Map)lmList.get(i);
                        String subIndex = skey + "_" + i + "_";
                        try {
                            Map cloneMap = JsonUtil.toMap((String)JsonUtil.toJsonString((Object)m));
                            cloneMap.forEach((k, v) -> {
                                if (BeanUtils.isNotEmpty((Object)v)) {
                                    HtmlUtil.printPicture(k.toString(), k.toString(), v.toString(), m, twiceMap, templateType, this.XWPF_WORD_TYPE.contains(templateType), subIndex);
                                }
                            });
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    HtmlUtil.printPicture(skey, key.toString(), ((Object)val).toString(), boMap, twiceMap, templateType, this.XWPF_WORD_TYPE.contains(templateType), "");
                }
            }
        }));
        this.executeScript(param.getScriptStr(), boMap, param.getBoData());
        if (boMap.containsKey(DefaultFile.FILE_SUBJECT)) {
            param.setSubject(MapUtil.getStr(boMap, (Object)DefaultFile.FILE_SUBJECT, (String)param.getSubject()));
        }
        String filePath = defaultFile.getFilePath();
        String fullPath = StringUtil.trimSufffix((String)AppFileUtil.getAttachPath(), (String)File.separator) + File.separator + filePath.replace("/", File.separator);
        outputFilePath = StringUtil.trimSufffix((String)AppFileUtil.getAttachPath(), (String)File.separator) + outputFilePath.replace("/", File.separator);
        if (!DefaultFile.SAVE_TYPE_FOLDER.equals(defaultFile.getStoreType())) {
            fullPath = TEMP_FOLDER_PATH + File.separator + fullPath;
            outputFilePath = TEMP_FOLDER_PATH + File.separator + outputFilePath.replace("/", File.separator);
        }
        this.initCurrentHandler("");
        if (DefaultFile.SAVE_TYPE_FTP.equals(this.attachmentService.getStoreType())) {
            fullPath = TEMP_FOLDER_PATH + File.separator + filePath.replace("/", File.separator);
            while (fullPath.contains("\\\\")) {
                fullPath = fullPath.replace("\\\\", File.separator);
            }
        }
        outputFilePath = outputFilePath.replace("/", File.separator);
        outputFilePath = outputFilePath.replace("\\", File.separator);
        while (outputFilePath.contains("\\\\")) {
            outputFilePath = outputFilePath.replace("\\\\", File.separator);
        }
        while (outputFilePath.contains("//")) {
            outputFilePath = outputFilePath.replace("//", File.separator);
        }
        String[] paths = outputFilePath.split(fileId);
        if (paths.length > 1 && !FileUtil.isExistFile((String)paths[0])) {
            FileUtil.createFolder((String)paths[0], (boolean)false);
        }
        if (!DefaultFile.SAVE_TYPE_FOLDER.equals(defaultFile.getStoreType())) {
            FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
            fileManager.downloadFileToPath(defaultFile, fullPath);
        }
        return this.printTemplateService.print(param, templateType, fullPath, outputFilePath, boMap, twiceMap, config);
    }

    private Configure initConfig(Map<String, Object> boDataMap, Map boMap) {
        Configure config = Configure.newBuilder().setElMode(Configure.ELMode.SPEL_MODE).addPlugin('#', (RenderPolicy)new SignetPictureRenderPolicy()).build();
        boDataMap.forEach((boAlias, item) -> ((Map)item).forEach((key, val) -> {
            String skey = key.toString();
            if (skey.startsWith("sub_")) {
                if (val instanceof List && ((List)val).size() == 1) {
                    Map subMapKey = (Map)((List)val).get(0);
                    subMapKey.forEach((subK, subV) -> {
                        String subVString = "";
                        if (BeanUtils.isNotEmpty((Object)subV)) {
                            subVString = subV.toString();
                        }
                        boMap.put(skey + "_" + subK, subVString);
                        config.customPolicy(skey + "." + subK, (RenderPolicy)new SubRenderPolicy(subVString));
                    });
                }
                config.customPolicy(skey, (RenderPolicy)new DetailTablePolicy());
            }
        }));
        config.customPolicy("flowOpinions", (RenderPolicy)new InstanceFlowOpinions());
        return config;
    }

    private void executeScript(String script, Map<String, Object> boMap, String boData) {
        if (StringUtil.isNotEmpty((String)script)) {
            GroovyScriptEngine groovyScriptEngine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("boMap", boMap);
            params.putAll(boMap);
            if (BeanUtils.isNotEmpty((Object)boData)) {
                try {
                    Map bodataMap = JsonUtil.toMap((String)boData);
                    HashMap newMap = new HashMap();
                    bodataMap.forEach((key, value) -> {
                        try {
                            ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((Object)value);
                            newMap.put(key, HtJsonNodeFactory.build().htObjectNode(node));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    params.putAll(newMap);
                }
                catch (Exception e) {
                    System.out.println("\u6dfb\u52a0bo\u53d8\u91cf\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            groovyScriptEngine.executeString(script, params);
        }
    }

    private void executeParamScript(WordPrintParam param) throws IOException {
        if (BeanUtils.isNotEmpty((Object)param) && StringUtil.isNotEmpty((String)param.getScriptStr())) {
            GroovyScriptEngine groovyScriptEngine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
            HashMap<String, WordPrintParam> params = new HashMap<String, WordPrintParam>();
            params.put("param", param);
            params.putAll(JsonUtil.toMap((String)JsonUtil.toJson((Object)param)));
            if (BeanUtils.isNotEmpty((Object)param.getBoData())) {
                try {
                    Map bodataMap = JsonUtil.toMap((String)param.getBoData());
                    HashMap newMap = new HashMap();
                    bodataMap.forEach((key, value) -> {
                        try {
                            ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((Object)value);
                            newMap.put(key, HtJsonNodeFactory.build().htObjectNode(node));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    params.putAll(newMap);
                }
                catch (Exception e) {
                    System.out.println("\u6dfb\u52a0bo\u53d8\u91cf\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            groovyScriptEngine.executeString(param.getScriptStr(), params);
        }
    }

    private void handRichtext(String key, String text, Map boMap) {
        if (boMap.get(key) instanceof List) {
            List subList = (List)boMap.get(key);
            subList.forEach(subMap -> subMap.forEach((subKey, subValue) -> {
                if (HtmlUtil.isHtml(subValue.toString())) {
                    File docxFile = HtmlUtil.getRichtextToDocx(subValue.toString());
                    subMap.put(subKey, new DocxRenderData(docxFile));
                    if (docxFile != null && docxFile.exists()) {
                        docxFile.delete();
                    }
                }
            }));
        } else if (boMap.get(key) instanceof Map) {
            Map subMap2 = (Map)boMap.get(key);
            subMap2.forEach((subKey, subValue) -> {
                if (HtmlUtil.isHtml(subValue.toString())) {
                    File docxFile = HtmlUtil.getRichtextToDocx(subValue.toString());
                    subMap2.put(subKey, new DocxRenderData(docxFile));
                    if (docxFile != null && docxFile.exists()) {
                        docxFile.delete();
                    }
                }
            });
        } else {
            File docxFile = HtmlUtil.getRichtextToDocx(text);
            boMap.put(key, new DocxRenderData(docxFile));
            if (docxFile != null && docxFile.exists()) {
                docxFile.delete();
            }
        }
    }

    @Override
    public WangEditorUploadResult uploadFile(Map<DefaultFile, MultipartFile> files, IUser currentUser) throws Exception {
        if (MapUtil.isEmpty(files)) {
            return new WangEditorUploadResult(Integer.valueOf(3));
        }
        ArrayList list = new ArrayList();
        files.entrySet().forEach(file -> {
            DefaultFile sysFile = (DefaultFile)((Object)((Object)file.getKey()));
            MultipartFile multipartFile = (MultipartFile)file.getValue();
            ArrayList<MultipartFile> multipartFiles = new ArrayList<MultipartFile>();
            multipartFiles.add(multipartFile);
            try {
                UploadResult uploadResult = this.uploadFile(sysFile, multipartFiles, "", currentUser, "");
                list.add(new WangEditorUploadResult(uploadResult));
            }
            catch (Exception e) {
                throw new BaseException((Throwable)e);
            }
        });
        WangEditorUploadResult finalResult = (WangEditorUploadResult)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            WangEditorUploadResult item = (WangEditorUploadResult)list.get(i);
            if (item.getErrno() > 0) {
                finalResult.setErrno(Integer.valueOf(3));
            }
            finalResult.getData().addAll(item.getData());
        }
        return finalResult;
    }

    @Override
    public FileAttribute getFileAttributeByFileId(String fileId) {
        DefaultFile defaultFile = this.get((Serializable)((Object)fileId));
        if (defaultFile == null) {
            throw new NotFoundException(String.format("\u672a\u627e\u5230fileId\u4e3a\uff1a%s\u7684\u9644\u4ef6", fileId));
        }
        FileAttribute fileAttribute = new FileAttribute();
        fileAttribute.setFileId(fileId);
        String fullFileName = defaultFile.getFileName() + "." + defaultFile.getExtensionName();
        fileAttribute.setName(fullFileName);
        fileAttribute.setSuffix(defaultFile.getExtensionName());
        return fileAttribute;
    }

    @Override
    public UploadResult thumbnailUpload(MultipartHttpServletRequest request, String fileId) throws Exception {
        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
        this.attachmentService = attachmentHandlerFactory.getCurrentServices(DefaultFile.SAVE_TYPE_DTABASE);
        IUser user = null;
        String account = this.baseContext.getCurrentUserAccout();
        if (StringUtil.isNotEmpty((String)account)) {
            user = this.userService.getUserByAccount(account);
        }
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
        while (it.hasNext()) {
            files.add((MultipartFile)it.next());
        }
        DefaultFile file = new DefaultFile();
        if (StringUtil.isNotEmpty((String)fileId)) {
            file = this.get((Serializable)((Object)fileId));
            file.setFileName(null);
        }
        return this.uploadFile(file, files, "", user, DefaultFile.SAVE_TYPE_DTABASE, "", false);
    }

    @Override
    public void thumbnailUpload(DefaultFile file, InputStream inputStream) throws Exception {
        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
        this.attachmentService = attachmentHandlerFactory.getCurrentServices(DefaultFile.SAVE_TYPE_DTABASE);
        if (StringUtil.isEmpty((String)file.getId())) {
            file.setId(UniqueIdUtil.getSuid());
        }
        this.attachmentService.upload((Attachment)file, inputStream, BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
        file.setStoreType(DefaultFile.SAVE_TYPE_DTABASE);
        super.create((Model)file);
    }

    class MyCallable
    implements Callable<Object> {
        private Logger logger = LoggerFactory.getLogger(FileManagerImpl.class);
        private File file;
        private IUser user;
        private FileManager fileManager;

        MyCallable(File file, IUser user, FileManager fileManager) {
            this.file = file;
            this.user = user;
            this.fileManager = fileManager;
        }

        @Override
        public Object call() throws Exception {
            this.logger.info(">>>" + this.file.getName() + "\u7b7e\u7ae0\u9644\u4ef6\u4e0a\u4f20");
            LocalDateTime dateTmp1 = LocalDateTime.now();
            UploadResult result = this.upload();
            Thread.sleep(200L);
            LocalDateTime dateTmp2 = LocalDateTime.now();
            long time = TimeUtil.getTimeMillis((LocalDateTime)dateTmp2) - TimeUtil.getTimeMillis((LocalDateTime)dateTmp1);
            this.logger.info(">>>" + this.file.getName() + "\u7b7e\u7ae0\u9644\u4ef6\u4e0a\u4f20\u5b8c\u6210; \u82b1\u8d39\u65f6\u95f4\u4e3a\uff1a " + time);
            return result;
        }

        private UploadResult upload() {
            try {
                FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
                MultipartFile multipartFile = FileUtil.fileToMultipartFile((File)this.file);
                ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
                files.add(multipartFile);
                DefaultFile file = new DefaultFile();
                return fileManager.uploadFile(file, files, null, this.user, "");
            }
            catch (Exception e) {
                this.logger.info(">>>" + this.file.getName() + "\u7b7e\u7ae0\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a " + e.getMessage());
                return null;
            }
        }
    }
}

