/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.print.service;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.keking.service.OfficeToPdfService;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.hotent.base.exception.BaseException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.file.extend.CopyTableRenderPolicy;
import com.hotent.file.extend.DecimalFormatRenderPolicy;
import com.hotent.file.extend.DetailTablePolicy;
import com.hotent.file.print.model.WordPrintParam;
import com.hotent.file.util.DecimalFormatUtil;
import com.hotent.file.util.HtmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Service;

@Service
public class PrintTemplateService {
    public String print(WordPrintParam param, String templateType, String originPath, String outputFilePath, Map<String, Object> boMap, Map<String, Object> twiceMap, Configure config) throws Exception {
        if ("doc".equals(templateType) || "docx".equals(templateType)) {
            this.printDocx(config, twiceMap, boMap, originPath, outputFilePath, param.getDefId());
        } else if ("xls".equals(templateType) || "xlsx".equals(templateType)) {
            this.printXlsx(boMap, originPath, outputFilePath);
        }
        String printType = Optional.ofNullable(param.getPrintType()).orElse(templateType);
        if ("pdf".equals(printType)) {
            return this.toPdf(outputFilePath);
        }
        return outputFilePath;
    }

    private String toPdf(String inputFilePath) {
        OfficeToPdfService officeToPdfService = (OfficeToPdfService)AppUtil.getBean(OfficeToPdfService.class);
        String outputFilePath = OfficeToPdfService.getOutputFilePath((String)inputFilePath);
        officeToPdfService.office2pdf(inputFilePath, outputFilePath);
        return outputFilePath;
    }

    private void printXlsx(Map boMap, String fullPath, String outputFilePath) throws Exception {
        Workbook workbook;
        TemplateExportParams params = new TemplateExportParams(fullPath, new Integer[0]);
        try {
            workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, (Map)boMap);
        }
        catch (Exception e) {
            throw new BaseException("\u6a21\u677f\u9519\u8bef", (Throwable)e);
        }
        FileOutputStream out = new FileOutputStream(outputFilePath);
        try {
            workbook.write((OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException("\u4e34\u65f6\u6587\u4ef6\u5199\u5165\u5931\u8d25");
        }
        finally {
            out.flush();
            out.close();
        }
    }

    private void printDocx(Configure config, Map<String, Object> twiceMap, Map boMap, String fullPath, String outputFilePath, String defId) throws Exception {
        block18: {
            XWPFTemplate template = null;
            XWPFTemplate template2 = null;
            FileOutputStream out = null;
            FileOutputStream out2 = null;
            try {
                File file = new File(fullPath);
                if (file.exists()) {
                    template = XWPFTemplate.compile((File)file, (Configure)config);
                    List elementlist = template.getElementTemplates();
                    HtmlUtil.printSignetData(defId, elementlist, boMap);
                    for (MetaTemplate metaTemplate : elementlist) {
                        ElementTemplate elementTemplate = (ElementTemplate)metaTemplate;
                        if (elementTemplate.getSource().startsWith("{{+sub_")) {
                            int suffixLen = "_MD".length();
                            if (StringUtil.isNotEmpty((String)elementTemplate.getTagName()) && elementTemplate.getTagName().lastIndexOf("_MD") > 0) {
                                String key = elementTemplate.getTagName().substring(0, elementTemplate.getTagName().length() - suffixLen);
                                boMap.put(elementTemplate.getTagName(), boMap.get(key));
                                String keySub = key + "_TWO";
                                twiceMap.put(keySub, boMap.get(key));
                                boMap.put(keySub, boMap.get(key));
                                config.customPolicy(keySub, (RenderPolicy)new DetailTablePolicy());
                            }
                            config.customPolicy(elementTemplate.getTagName(), (RenderPolicy)new CopyTableRenderPolicy());
                        } else if (elementTemplate.getSource().contains("#d")) {
                            String key = elementTemplate.getTagName();
                            StringBuilder formatDigit = new StringBuilder("");
                            key = DecimalFormatUtil.handleDigitKey(key, formatDigit);
                            elementTemplate.setTagName(key);
                            config.customPolicy(key, (RenderPolicy)new DecimalFormatRenderPolicy(formatDigit.toString()));
                        }
                        if (!elementTemplate.getTagName().startsWith("sub_")) continue;
                        elementTemplate.setTagName(elementTemplate.getTagName().replace(".", "_"));
                    }
                    template.render((Object)boMap);
                    out = new FileOutputStream(outputFilePath);
                    template.write((OutputStream)out);
                    out.flush();
                    if (!twiceMap.isEmpty()) {
                        for (String key : twiceMap.keySet()) {
                            String mapMsg = ThreadMsgUtil.getMapMsg((String)("{{@" + key + "}}"));
                            if (!StringUtil.isNotEmpty((String)mapMsg) || !BeanUtils.isNotEmpty((Object)twiceMap.get(key)) || !(twiceMap.get(key) instanceof PictureRenderData)) continue;
                            Double cellPxWidth = Double.valueOf(mapMsg) / 13.0 - 60.0;
                            if (cellPxWidth < 25.0) {
                                cellPxWidth = Double.valueOf(mapMsg) / 13.0 - 25.0;
                            }
                            PictureRenderData pictureRenderData = (PictureRenderData)twiceMap.get(key);
                            int width = pictureRenderData.getWidth();
                            int height = pictureRenderData.getHeight();
                            if (!((double)width > cellPxWidth)) continue;
                            double mul = new BigDecimal((double)width / cellPxWidth).setScale(2, 4).doubleValue();
                            pictureRenderData.setHeight((int)((double)height / mul));
                            pictureRenderData.setWidth((int)((double)width / mul));
                        }
                        template2 = XWPFTemplate.compile((String)outputFilePath, (Configure)config).render(twiceMap);
                        out2 = new FileOutputStream(outputFilePath);
                        template2.write((OutputStream)out2);
                        out2.flush();
                    }
                    break block18;
                }
                throw new BaseException("\u5f53\u524d\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u914d\u7f6e");
            }
            catch (RenderException e) {
                e.printStackTrace();
                throw new RenderException("\u6a21\u677f\u9519\u8bef", (Exception)((Object)e));
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (template != null) {
                    template.close();
                }
                if (out2 != null) {
                    out2.close();
                }
                if (template2 != null) {
                    template2.close();
                }
            }
        }
    }
}

