/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.service.impl;

import com.hotent.base.exception.BaseException;
import com.hotent.base.util.BeanUtils;
import com.hotent.file.model.DefaultFile;
import com.hotent.file.model.FileInfo;
import com.hotent.file.persistence.manager.FileManager;
import com.hotent.file.service.FileService;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class FileServiceImpl
implements FileService {
    @Resource
    FileManager fileManager;

    public String getFilePath(String fileId) {
        DefaultFile defaultFile = (DefaultFile)this.fileManager.get((Serializable)((Object)fileId));
        return defaultFile.getFilePath();
    }

    public FileInfo getFileInfo(String fileId) {
        DefaultFile sysFile = (DefaultFile)this.fileManager.get((Serializable)((Object)fileId));
        if (BeanUtils.isEmpty((Object)((Object)sysFile))) {
            return null;
        }
        FileInfo fileInfo = new FileInfo();
        try {
            BeanUtils.copyNotNullProperties((Object)fileInfo, (Object)((Object)sysFile));
            fileInfo.setFullFileName(sysFile.getFileName() + "." + sysFile.getExtensionName());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u83b7\u53d6\u6587\u4ef6\u57fa\u672c\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return fileInfo;
    }

    public void uploadFile(FileInfo fileInfo, InputStream is) throws Exception {
        DefaultFile defaultFile = new DefaultFile();
        try {
            BeanUtils.copyNotNullProperties((Object)((Object)defaultFile), (Object)fileInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("fileInfo\u8f6c\u4e3aDefaultFile\u5931\u8d25", (Throwable)e);
        }
        this.fileManager.uploadFile(defaultFile, is);
    }

    public FileInfo get(String id) {
        DefaultFile defaultFile = (DefaultFile)this.fileManager.get((Serializable)((Object)id));
        FileInfo fileInfo = new FileInfo();
        try {
            BeanUtils.copyNotNullProperties((Object)fileInfo, (Object)((Object)defaultFile));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("DefaultFile\u8f6c\u4e3afileInfo\u5931\u8d25", (Throwable)e);
        }
        return fileInfo;
    }

    public void downloadFile(String fileId, ByteArrayOutputStream outputStream) throws Exception {
        this.fileManager.downloadFile(fileId, outputStream);
    }

    public void thumbnailUpload(FileInfo fileInfo, InputStream is) throws Exception {
        DefaultFile defaultFile = new DefaultFile();
        try {
            BeanUtils.copyNotNullProperties((Object)((Object)defaultFile), (Object)fileInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("fileInfo\u8f6c\u4e3aDefaultFile\u5931\u8d25", (Throwable)e);
        }
        this.fileManager.thumbnailUpload(defaultFile, is);
    }
}

