/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.file.util;

import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;

public class SignaturePictureRenderPolicy
extends AbstractRenderPolicy<PictureRenderData> {
    protected boolean validate(PictureRenderData data) {
        return null != data && (null != data.getData() || null != data.getPath());
    }

    public void doRender(RenderContext<PictureRenderData> context) throws Exception {
        Helper.renderPicture(context.getRun(), (PictureRenderData)context.getData());
    }

    protected void afterRender(RenderContext<PictureRenderData> context) {
        SignaturePictureRenderPolicy.clearPlaceholder(context, (boolean)false);
    }

    protected void reThrowException(RenderContext<PictureRenderData> context, Exception e) {
        this.logger.info("Render picture " + context.getEleTemplate() + " error: {}", (Object)e.getMessage());
        context.getRun().setText(((PictureRenderData)context.getData()).getAltMeta(), 0);
    }

    public static class Helper {
        public static final int EMU = 9525;

        public static void renderPicture(XWPFRun run, PictureRenderData picture) throws Exception {
            int suggestFileType = Helper.suggestFileType(picture.getPath());
            try (InputStream ins = null == picture.getData() ? new FileInputStream(picture.getPath()) : new ByteArrayInputStream(picture.getData());){
                run.addPicture(ins, suggestFileType, "Generated", picture.getWidth() * 9525, picture.getHeight() * 9525);
                String pictureText = run.getText(0);
                String regEx = "[`{#}]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(pictureText);
                pictureText = m.replaceAll("").trim();
                String[] strArray = pictureText.split("_");
                int idx = Integer.valueOf(strArray[1]);
                int leftWidth = 35;
                if (idx > 0) {
                    leftWidth += picture.getWidth() * idx;
                }
                CTDrawing drawing = run.getCTR().getDrawingArray(0);
                CTGraphicalObject graphicalobject = drawing.getInlineArray(0).getGraphic();
                CTAnchor anchor = Helper.getAnchorWithGraphic(graphicalobject, pictureText, Units.toEMU((double)picture.getWidth()), Units.toEMU((double)picture.getHeight()), Units.toEMU((double)leftWidth), Units.toEMU((double)-5.0), true);
                drawing.setAnchorArray(new CTAnchor[]{anchor});
                drawing.removeInline(0);
            }
        }

        public static int suggestFileType(String imgFile) {
            int format = 0;
            if (imgFile.endsWith(".emf")) {
                format = 2;
            } else if (imgFile.endsWith(".wmf")) {
                format = 3;
            } else if (imgFile.endsWith(".pict")) {
                format = 4;
            } else if (imgFile.endsWith(".jpeg") || imgFile.endsWith(".jpg")) {
                format = 5;
            } else if (imgFile.endsWith(".png")) {
                format = 6;
            } else if (imgFile.endsWith(".dib")) {
                format = 7;
            } else if (imgFile.endsWith(".gif")) {
                format = 8;
            } else if (imgFile.endsWith(".tiff")) {
                format = 9;
            } else if (imgFile.endsWith(".eps")) {
                format = 10;
            } else if (imgFile.endsWith(".bmp")) {
                format = 11;
            } else if (imgFile.endsWith(".wpg")) {
                format = 12;
            } else {
                throw new RenderException("Unsupported picture: " + imgFile + ". Expected emf|wmf|pict|jpeg|png|dib|gif|tiff|eps|bmp|wpg");
            }
            return format;
        }

        public static CTAnchor getAnchorWithGraphic(CTGraphicalObject ctGraphicalObject, String deskFileName, int width, int height, int leftOffset, int topOffset, boolean behind) {
            String anchorXML = "<wp:anchor xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" simplePos=\"0\" relativeHeight=\"0\" behindDoc=\"" + (behind ? 1 : 0) + "\" locked=\"0\" layoutInCell=\"1\" allowOverlap=\"1\"><wp:simplePos x=\"0\" y=\"0\"/><wp:positionH relativeFrom=\"column\"><wp:posOffset>" + leftOffset + "</wp:posOffset></wp:positionH><wp:positionV relativeFrom=\"paragraph\"><wp:posOffset>" + topOffset + "</wp:posOffset></wp:positionV><wp:extent cx=\"" + width + "\" cy=\"" + height + "\"/><wp:effectExtent l=\"0\" t=\"0\" r=\"0\" b=\"0\"/><wp:wrapNone/><wp:docPr id=\"1\" name=\"Drawing 0\" descr=\"" + deskFileName + "\"/><wp:cNvGraphicFramePr/></wp:anchor>";
            CTDrawing drawing = null;
            try {
                drawing = CTDrawing.Factory.parse((String)anchorXML);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
            CTAnchor anchor = drawing.getAnchorArray(0);
            anchor.setGraphic(ctGraphicalObject);
            return anchor;
        }
    }
}

