/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.ResourcePermissionCheck;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.form.model.CustomDialog;
import com.hotent.form.persistence.manager.CombinateDialogManager;
import com.hotent.form.persistence.manager.CustomDialogManager;
import com.hotent.form.util.CustomUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/customDialog/v1"})
@Api(tags={"\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846"})
@ApiGroup(group={"group_form"})
public class CustomDialogController
extends BaseController<CustomDialogManager, CustomDialog> {
    @Resource
    CombinateDialogManager combinateDialogManager;
    @Resource
    CustomDialogManager customDialogManager;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ResourcePermissionCheck
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((CustomDialogManager)this.baseService).query(queryFilter);
    }

    @RequestMapping(value={"getAll"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846", httpMethod="GET", notes="\u67e5\u8be2\u6240\u6709\u7684\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846")
    public List<CustomDialog> getAll(Short ... styles) throws Exception {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (BeanUtils.isNotEmpty((Object)styles)) {
            wrapper.in(BeanUtils.isNotEmpty((Object)styles), CustomDialog::getStyle, Arrays.asList(styles));
        }
        List customDialogs = ((CustomDialogManager)this.baseService).list((Wrapper)wrapper);
        CustomUtil.filterHasNoUseRight(customDialogs);
        return customDialogs;
    }

    @RequestMapping(value={"getListDialog"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5217\u8868\u5bf9\u8bdd\u6846", httpMethod="GET", notes="\u67e5\u8be2\u6240\u6709\u5217\u8868\u5bf9\u8bdd\u6846")
    public List<CustomDialog> getListDialog() throws Exception {
        List customDialogs = ((CustomDialogManager)this.baseService).list((Wrapper)Wrappers.lambdaQuery().eq(CustomDialog::getStyle, (Object)0));
        CustomUtil.filterHasNoUseRight(customDialogs);
        return customDialogs;
    }

    @RequestMapping(value={"getAllDialogs"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fd4\u56de\u7ec4\u5408\u5bf9\u8bdd\u6846\u548c\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846", httpMethod="POST", notes="\u8fd4\u56de\u7ec4\u5408\u5bf9\u8bdd\u6846\u548c\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846")
    public List<Object> getAllDialogs() throws Exception {
        List customDialogs = ((CustomDialogManager)this.baseService).list();
        customDialogs.addAll(this.combinateDialogManager.list());
        return customDialogs;
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u522b\u540d\u83b7\u53d6\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846", httpMethod="GET", notes="\u6839\u636e\u522b\u540d\u83b7\u53d6\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846")
    public CustomDialog getByAlias(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias) throws Exception {
        CustomDialog customDialog = null;
        if (StringUtil.isNotEmpty((String)alias)) {
            customDialog = ((CustomDialogManager)this.baseService).getByAlias(alias);
        }
        if (customDialog == null) {
            customDialog = new CustomDialog();
        }
        return customDialog;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="json", value="\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846JSON\u5bf9\u8c61") @RequestBody String json) throws Exception {
        return this.customDialogManager.saveCustomDialog(json);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u8bb0\u5f55")
    public CommonResult remove(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        String msg = "\u5220\u9664\u6210\u529f";
        boolean index = true;
        CustomDialog customDialog = (CustomDialog)((CustomDialogManager)this.baseService).get((Serializable)((Object)id));
        if (customDialog.getSystem() == null || !customDialog.getSystem().booleanValue()) {
            ((CustomDialogManager)this.baseService).remove((Serializable)((Object)id));
        } else {
            index = false;
            msg = "id:" + id + "\u662f\u7cfb\u7edf\u9ed8\u8ba4\u4e0d\u80fd\u5220\u9664";
        }
        return new CommonResult(index, msg);
    }

    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49")
    public CommonResult<String> batchRemove(String ... ids) throws Exception {
        ((CustomDialogManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"getTreeData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u6811\u5f62\u6570\u636e\u3002", httpMethod="GET", notes="\u53d6\u5f97\u6811\u5f62\u6570\u636e\u3002")
    public List getTreeData(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias, @ApiParam(name="parentId", value="\u7236id\u503c") @RequestParam(required=false) String parentId, @ApiParam(name="mapParam", value="\u52a8\u6001\u4f20\u5165\u7684\u5b57\u6bb5") @RequestParam String mapParam) throws Exception {
        List res = this.customDialogManager.getTreeData(alias, mapParam, parentId);
        return res;
    }

    @RequestMapping(value={"getListData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u67e5\u8be2", httpMethod="POST", notes="\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u67e5\u8be2")
    public Object getListData(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias, @ApiParam(name="filter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter filter, @ApiParam(name="mapParam", value="") @RequestParam String mapParam) throws Exception {
        return ((CustomDialogManager)this.baseService).getCustomDialogData(alias, filter, mapParam);
    }

    @RequestMapping(value={"mobileCustomDialog"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u624b\u673a\u7aef\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846", httpMethod="POST", notes="\u624b\u673a\u7aef\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846")
    public CommonResult mobileDialog(@ApiParam(name="isCombine", value="") @RequestBody Boolean isCombine, @ApiParam(name="alias", value="\u522b\u540d") @RequestBody String alias) throws Exception {
        Map mv = ((CustomDialogManager)this.baseService).getMobileCustomDialogData(isCombine, alias);
        return new CommonResult(true, null, (Object)mv);
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "customDialog_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String json = this.customDialogManager.export(idList);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"customDialog.json", (String)fileName);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846", httpMethod="POST", notes="\u5bfc\u5165\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846")
    public CommonResult<String> importCustom(MultipartHttpServletRequest request, HttpServletResponse response, @RequestParam(value="typeId") String typeId) throws Exception {
        CommonResult<String> res = this.customDialogManager.importCustom(request, response, typeId);
        return res;
    }

    @RequestMapping(value={"importData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2", httpMethod="POST", notes="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2")
    public CommonResult<String> importData(@ApiParam(name="unZipFilePath", value="unZipFilePath", required=true) @RequestParam String unZipFilePath, @ApiParam(name="status", value="status", required=true) @RequestParam String status, @RequestParam(value="typeId") String typeId) throws Exception {
        CommonResult<String> res = this.customDialogManager.importFileData(unZipFilePath, status, typeId);
        return res;
    }
}

