/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.form.manager.FormCustomComponentManager;
import com.hotent.form.model.FormCustomComponent;
import com.hotent.form.util.CustomUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/formCustomComponent/v1/"})
@Api(tags={"\u81ea\u5b9a\u4e49\u7ec4\u4ef6"})
@ApiGroup(group={"group_form"})
public class FormCustomComponentController
extends BaseController<FormCustomComponentManager, FormCustomComponent> {
    @RequestMapping(value={"/saveOrUp"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e31")
    public CommonResult<String> saveOrUp(@ApiParam(name="t", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody FormCustomComponent t) {
        List list;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ALIAS_", (Object)t.getAlias());
        if (BeanUtils.isNotEmpty((Object)t.getId())) {
            queryWrapper.ne((Object)"ID_", (Object)t.getId());
        }
        if ((list = ((FormCustomComponentManager)this.baseService).list((Wrapper)queryWrapper)).size() > 0) {
            return new CommonResult(false, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u522b\u540d", null);
        }
        boolean result = ((FormCustomComponentManager)this.baseService).saveOrUpdate((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/getAll"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709")
    public List<FormCustomComponent> getAll() throws IOException, IllegalAccessException, NoSuchFieldException, InstantiationException {
        List all = ((FormCustomComponentManager)this.baseService).getAll();
        CustomUtil.filterHasNoUseRight(all);
        return all;
    }

    @GetMapping(value={"/getByAlias"})
    @ApiOperation(value="\u6839\u636e\u522b\u540d\u67e5\u8be2")
    public FormCustomComponent getByAlias(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ALIAS_", (Object)alias);
        return (FormCustomComponent)((Object)((FormCustomComponentManager)this.baseService).getOne((Wrapper)queryWrapper));
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "customComponent_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        List list = ((LambdaQueryChainWrapper)((FormCustomComponentManager)this.baseService).lambdaQuery().in(FormCustomComponent::getId, Arrays.asList(idList))).list();
        String json = JsonUtil.toJson((Object)list);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"customComponent.json", (String)fileName);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u7ec4\u4ef6", httpMethod="POST", notes="\u5bfc\u5165\u81ea\u5b9a\u4e49\u7ec4\u4ef6")
    public CommonResult<String> importCustom(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        CommonResult<String> res = ((FormCustomComponentManager)this.baseService).importData(request, response);
        return res;
    }

    @RequestMapping(value={"importData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u7ec4\u4ef6", httpMethod="POST", notes="\u5bfc\u5165\u81ea\u5b9a\u4e49\u7ec4\u4ef6")
    public CommonResult<String> importData(@ApiParam(name="unZipFilePath", value="unZipFilePath", required=true) @RequestParam String unZipFilePath, @ApiParam(name="status", value="status", required=true) @RequestParam String status) throws Exception {
        CommonResult<String> res = ((FormCustomComponentManager)this.baseService).importData(unZipFilePath, status);
        return res;
    }
}

