/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormMeta;
import com.hotent.form.persistence.manager.FormManager;
import com.hotent.form.persistence.manager.FormMetaManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form/formDef/v1"})
@Api(tags={"\u8868\u5355\u5143\u6570\u636e"})
@ApiGroup(group={"group_form"})
public class FormMetaController
extends BaseController<FormMetaManager, FormMeta> {
    @Resource
    FormManager bpmFormManager;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((FormMetaManager)this.baseService).listJson((QueryFilter<FormMeta>)queryFilter);
    }

    @RequestMapping(value={"listJsonByBODef"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList listJsonByBODef(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="defId", value="\u8868\u5355\u5143\u6570\u636e\u5b9a\u4e49ID") @RequestBody String defId, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b ") @RequestBody String formType, @ApiParam(name="topDefKey", value="") @RequestBody String topDefKey) throws Exception {
        return ((FormMetaManager)this.baseService).listJsonByBODef((QueryFilter<Form>)queryFilter, defId, formType, topDefKey);
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u5143\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u7f16\u8f91\u8868\u5355\u5143\u6570\u636e\u9875\u9762")
    public CommonResult get(@ApiParam(name="formDefId", value="\u8868\u5355\u5143\u6570\u636eID") @RequestParam String formDefId) throws Exception {
        FormMeta bpmForm = null;
        if (StringUtil.isNotEmpty((String)formDefId)) {
            bpmForm = (FormMeta)((FormMetaManager)this.baseService).get((Serializable)((Object)formDefId));
        }
        if (BeanUtils.isEmpty(bpmForm)) {
            return new CommonResult(false, "\u672a\u83b7\u53d6\u5230\u8868\u5355\u5b9a\u4e49", null);
        }
        return new CommonResult(true, null, (Object)bpmForm);
    }

    @RequestMapping(value={"getFormFieldTree"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355\u5143\u6570\u636eID\u83b7\u53d6\u8868\u5355\u7684\u5b57\u6bb5\u4fe1\u606f", httpMethod="POST", notes="\u7f16\u8f91\u8868\u5355\u9875\u9762")
    public CommonResult getBoTreeByFormId(@ApiParam(name="id", value="\u8868\u5355ID") @RequestBody String formId) throws Exception {
        FormMeta bpmForm = (FormMeta)((FormMetaManager)this.baseService).get((Serializable)((Object)formId));
        JsonNode fields = bpmForm.getFieldList();
        return new CommonResult(true, null, (Object)fields);
    }

    @RequestMapping(value={"getObject"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6839\u636e\u8868\u5355key\u6216id\u83b7\u53d6\u8868\u5355\u5143\u6570\u636e\u5b9a\u4e49\u3002", httpMethod="POST", notes="\u7f16\u8f91\u8868\u5355\u9875\u9762")
    public FormMeta getObject(@ApiParam(name="id", value="\u8868\u5355ID") @RequestBody String id, @ApiParam(name="key", value="\u8868\u5355key") @RequestBody String key) throws Exception {
        if (StringUtil.isNotEmpty((String)id)) {
            return (FormMeta)((FormMetaManager)this.baseService).get((Serializable)((Object)id));
        }
        if (StringUtil.isNotEmpty((String)key)) {
            return ((FormMetaManager)this.baseService).getByKey(key);
        }
        return null;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u4fe1\u606f\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355\u4fe1\u606f")
    public CommonResult save(@ApiParam(name="form", value="\u8868\u5355\u5143\u6570\u636e\u5bf9\u8c61") @RequestBody FormMeta bpmFormdef) throws Exception {
        if (BeanUtils.isNotEmpty((Object)bpmFormdef.getId())) {
            ((FormMetaManager)this.baseService).update((Model)bpmFormdef);
        } else {
            String formKey = bpmFormdef.getKey();
            if (((FormMetaManager)this.baseService).getByKey(formKey) != null) {
                throw new RuntimeException("\u8868\u5355\u5df2\u7ecf\u5b58\u5728\uff01key:" + formKey);
            }
            bpmFormdef.setId(UniqueIdUtil.getSuid());
            ((FormMetaManager)this.baseService).create((Model)bpmFormdef);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", null);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8868\u5355\u8bb0\u5f55\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355\u4fe1\u606f")
    public CommonResult remove(@ApiParam(name="id", value="\u8868\u5355\u5143\u6570\u636eID!\u591a\u4e2aID\u7528,\u5206\u5272") @RequestBody String id) throws Exception {
        String bpmNames;
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)id)) {
            aryIds = id.split(",");
        }
        if (StringUtil.isEmpty((String)(bpmNames = this.checkBpmForm(aryIds)))) {
            ((FormMetaManager)this.baseService).removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u4efb\u52a1\u8868\u5355\u6210\u529f", null);
        }
        String msg = "\u5df2\u88ab\u7528\u4e8e\u751f\u6210\u4e1a\u52a1\u8868\u5355\uff1a" + bpmNames + "\u4e0d\u80fd\u88ab\u5220\u9664";
        return new CommonResult(false, msg, null);
    }

    private String checkBpmForm(String[] aryIds) {
        String formKey = "";
        for (String defId : aryIds) {
            List<Form> form = this.bpmFormManager.getByDefId(defId);
            if (!BeanUtils.isNotEmpty(form)) continue;
            for (Form f : form) {
                formKey = formKey + f.getName() + "\uff08" + f.getFormKey() + "\uff09,";
            }
        }
        return formKey;
    }

    @RequestMapping(value={"chooseDesignTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u52a0\u8f7d\u7f16\u8f91\u5668\u8bbe\u8ba1\u6a21\u5f0f\u7684\u6a21\u677f\u5217\u8868", httpMethod="POST", notes="\u52a0\u8f7d\u7f16\u8f91\u5668\u8bbe\u8ba1\u6a21\u5f0f\u7684\u6a21\u677f\u5217\u8868")
    public CommonResult chooseDesignTemplate(@ApiParam(name="subject", value="\u6807\u9898") @RequestBody String subject, @ApiParam(name="categoryId", value="") @RequestBody String categoryId, @ApiParam(name="formDesc", value="\u8868\u5355\u63cf\u8ff0") @RequestBody String formDesc, @ApiParam(name="isSimple", value="true\u5c06\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u884c") @RequestBody Boolean isSimple) throws Exception {
        Map<String, Object> mv = ((FormMetaManager)this.baseService).getChooseDesignTemplate(subject, categoryId, formDesc, isSimple);
        return new CommonResult(true, null, mv);
    }

    @RequestMapping(value={"boFormDefDialog"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u5b9a\u4e49\u5bf9\u8bdd\u6846\u3002 ", httpMethod="POST", notes="\u8868\u5355\u5b9a\u4e49\u5bf9\u8bdd\u6846\u3002 ")
    public CommonResult dialog(@ApiParam(name="isSingle", value="true\u5c06\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u884c") @RequestBody Boolean isSingle, @ApiParam(name="defId", value="\u8868\u5355\u5143\u6570\u636e\u5b9a\u4e49ID") @RequestBody String defId, @ApiParam(name="formType", value="\u8868\u5355\u7c7b\u578b ") @RequestBody String formType, @ApiParam(name="topDefKey", value="") @RequestBody String topDefKey) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isSingle", isSingle);
        map.put("formType", formType);
        map.put("defId", defId);
        map.put("topDefKey", topDefKey);
        return new CommonResult(true, null, map);
    }

    @RequestMapping(value={"checkkeyIsExist"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65adkey\u662f\u5426\u5b58\u5728\u3002 ", httpMethod="POST", notes="\u8868\u5355\u5b9a\u4e49\u5bf9\u8bdd\u6846\u3002 ")
    public boolean checkAliasIsExist(@ApiParam(name="key", value="\u8868\u5355key") @RequestBody String key) throws Exception {
        if (StringUtil.isEmpty((String)key)) {
            return false;
        }
        FormMeta bpmForm = ((FormMetaManager)this.baseService).getByKey(key);
        return !BeanUtils.isEmpty((Object)((Object)bpmForm));
    }

    @RequestMapping(value={"getOpinionConf"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u8868\u5355\u610f\u89c1\u914d\u7f6e ", httpMethod="POST", notes="\u83b7\u5f97\u8868\u5355\u610f\u89c1\u914d\u7f6e ")
    public String opinionConf(@ApiParam(name="id", value="\u8868\u5355\u5143\u6570\u636eID") @RequestBody String id) throws Exception {
        FormMeta def = (FormMeta)((FormMetaManager)this.baseService).get((Serializable)((Object)id));
        String opinionConf = def.getOpinionConf();
        if (StringUtil.isEmpty((String)opinionConf)) {
            opinionConf = "[]";
        }
        return opinionConf;
    }

    @RequestMapping(value={"opinionConfSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u8868\u5355\u610f\u89c1\u914d\u7f6e\u3002 ", httpMethod="POST", notes="\u66f4\u65b0\u8868\u5355\u610f\u89c1\u914d\u7f6e\u3002 ")
    public CommonResult opinionConfSave(@ApiParam(name="id", value="\u8868\u5355\u5143\u6570\u636eid") @RequestBody String id, @ApiParam(name="opinionConf", value="\u8868\u5355\u5143\u6570\u636e\u610f\u89c1\u914d\u7f6e") @RequestBody String opinionConf) throws Exception {
        ((FormMetaManager)this.baseService).updateOpinionConf(id, opinionConf);
        return new CommonResult(true, "\u66f4\u65b0\u8868\u5355\u610f\u89c1\u914d\u7f6e\u6210\u529f\uff01", null);
    }
}

