/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.annotation.NewVersion;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BaseContextThreadUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.context.FormContextThreadUtil;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.model.BoResult;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormRight;
import com.hotent.form.service.BpmFormRightsService;
import com.hotent.form.service.FormService;
import com.hotent.form.vo.FormRestfulModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form/formServiceController/v1"})
@Api(tags={"\u8868\u5355\u670d\u52a1"})
@ApiGroup(group={"group_form"})
@NewVersion
public class FormServiceController {
    @Resource
    BpmFormRightsService bpmFormRightsService;
    @Resource
    FormService formService;
    @Resource
    BoDefManager boDefManager;

    @RequestMapping(value={"getMainBOEntByDefAliasOrId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u5bf9\u8c61\u522b\u540d\u6216id\u83b7\u53d6\u4e3bBoEnt", httpMethod="GET", notes="\u6839\u636e\u4e1a\u52a1\u5bf9\u8c61\u522b\u540d\u6216id\u83b7\u53d6\u4e3bBoEnt")
    public ObjectNode getMainBOEntByDefAliasOrId(@ApiParam(name="alias", value="\u4e1a\u52a1\u5bf9\u8c61\u522b\u540d") @RequestParam(required=false) String alias, @ApiParam(name="defId", value="\u4e1a\u52a1\u5bf9\u8c61id") @RequestParam(required=false) String defId) throws IOException {
        return this.formService.getMainBOEntByDefAliasOrId(alias, defId);
    }

    @RequestMapping(value={"handlerBoData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5904\u7406bo\u6570\u636e,boid\u3002\u7a7a\u4e3a\u65b0\u589e\u3002\u4e0d\u4e3a\u7a7a\u5219\u66f4\u65b0 ", httpMethod="POST", notes="\u5904\u7406bo\u6570\u636e,boid\u3002\u7a7a\u4e3a\u65b0\u589e\u3002\u4e0d\u4e3a\u7a7a\u5219\u66f4\u65b0 ")
    public List<BoResult> handlerBoData(@ApiParam(name="model", value="model") @RequestBody FormRestfulModel model) throws Exception {
        FormContextThreadUtil.putCommonVars((String)"defId", (Object)model.getFlowDefId());
        FormContextThreadUtil.putCommonVars((String)"nodeId", (Object)model.getNodeId());
        FormContextThreadUtil.putCommonVars((String)"flowKey", (Object)model.getFlowKey());
        FormContextThreadUtil.putCommonVars((String)"formkey", (Object)model.getFormkey());
        FormContextThreadUtil.putCommonVars((String)"parentDefKey", (Object)(StringUtil.isEmpty((String)model.getParentFlowKey()) ? "" : model.getParentFlowKey()));
        if (StringUtil.isNotEmpty((String)model.getUpdateSubTableJson())) {
            FormContextThreadUtil.putCommonVars((String)"updateSubTableJson", (Object)model.getUpdateSubTableJson());
        }
        if (StringUtil.isNotEmpty((String)model.getHasCheckFormDataRev())) {
            FormContextThreadUtil.putCommonVars((String)"hasCheckFormDataRev", (Object)model.getHasCheckFormDataRev());
        }
        List<BoResult> handlerBoData = this.formService.handlerBoData(model.getBoid(), model.getDefId(), model.getBoData(), model.getSaveType());
        return handlerBoData;
    }

    @RequestMapping(value={"getBodataByDefCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u522b\u540d\u83b7\u53d6BoData", httpMethod="GET", notes="\u6839\u636e\u522b\u540d\u83b7\u53d6BoData")
    public BoData getBodataByDefCode(@ApiParam(name="saveMode", value="\u4fdd\u5b58\u65b9\u5f0f") @RequestParam String saveMode, @ApiParam(name="code", value="\u522b\u540d") @RequestParam String code) {
        return this.formService.getBodataByDefCode(saveMode, code);
    }

    @RequestMapping(value={"getBodataById"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5b9e\u4f8bID\u548cbo\u5b9a\u4e49code\u83b7\u53d6BODATA\uff0c\u53ea\u8fd4\u56de\u4e24\u5c42", httpMethod="POST", notes="\u6839\u636e\u5b9e\u4f8bID\u548cbo\u5b9a\u4e49code\u83b7\u53d6BODATA\uff0c\u53ea\u8fd4\u56de\u4e24\u5c42 ")
    public JsonNode getBodataById(@ApiParam(name="model", value="model") @RequestBody FormRestfulModel model) throws IOException {
        BoData byFormRestfulModel = this.formService.getByFormRestfulModel(model);
        return JsonUtil.toJsonNode((Object)byFormRestfulModel);
    }

    @RequestMapping(value={"getByFormKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eformkey\u83b7\u53d6\u8868\u5355", httpMethod="GET", notes="\u6839\u636eformkey\u83b7\u53d6\u8868\u5355")
    public Form getByFormKey(@ApiParam(name="formKey", value="key") @RequestParam String formKey) {
        return this.formService.getByFormKey(formKey);
    }

    @RequestMapping(value={"getFormExportXml"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eformKey \u5bfc\u51fa\u8868\u5355", httpMethod="POST", notes="\u6839\u636eformKey \u5bfc\u51fa\u8868\u5355")
    public String getFormExportXml(@ApiParam(name="formKeys", value="key\u96c6\u5408") @RequestBody String formKeys) {
        return this.formService.getFormExportXml(formKeys);
    }

    @RequestMapping(value={"getBoDefExportXml"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ebodef\u83b7\u5f97\u5bfc\u51fa\u7528\u7684xml\u6587\u4ef6", httpMethod="POST", notes="\u6839\u636ebodef\u83b7\u5f97\u5bfc\u51fa\u7528\u7684xml\u6587\u4ef6")
    public String getBoDefExportXml(@ApiParam(name="bodef", value="bodefJson\u6570\u636e") @RequestBody ObjectNode bodef) throws JsonParseException, JsonMappingException, JAXBException, IOException {
        return this.formService.getBoDefExportXml(bodef);
    }

    @RequestMapping(value={"getFormRightExportXml"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eFormRight\u83b7\u5f97\u5bfc\u51fa\u7528\u7684xml\u6587\u4ef6", httpMethod="POST", notes="\u6839\u636eFormRight\u83b7\u5f97\u5bfc\u51fa\u7528\u7684xml\u6587\u4ef6")
    public String getFormRightExportXml(@ApiParam(name="bpmFormRights", value="bpmFormRightsJson\u6570\u636e") @RequestBody ObjectNode bpmFormRights) throws JsonParseException, JsonMappingException, JAXBException, IOException {
        return this.bpmFormRightsService.getFormRightExportXml(bpmFormRights);
    }

    @RequestMapping(value={"importBo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165 bo", httpMethod="GET", notes="\u5bfc\u5165 bo")
    public CommonResult<String> importBo(@ApiParam(name="bodefXml", value="") @RequestParam String bodefXml) {
        try {
            this.formService.importBo(bodefXml);
        }
        catch (Exception e) {
            return CommonResult.error((String)e.getMessage());
        }
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"importBoDef"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165bodef\u5bf9\u8c61", httpMethod="POST", notes="\u5bfc\u5165bodef\u5bf9\u8c61")
    public List<BoDef> importBoDef(@ApiParam(name="bos", value="bodef\u5bf9\u8c61") @RequestBody List<ObjectNode> bos) throws JsonParseException, JsonMappingException, IOException {
        ArrayList<BoDef> list = new ArrayList<BoDef>();
        for (ObjectNode objectNode : bos) {
            list.add((BoDef)JsonUtil.toBean((JsonNode)objectNode, BoDef.class));
        }
        return this.formService.importBoDef(list);
    }

    @RequestMapping(value={"importForm"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165form", httpMethod="POST", notes="\u5bfc\u5165form")
    public CommonResult<String> importForm(@ApiParam(name="formfXml", value="formfXml") @RequestBody String formfXml) {
        this.formService.importForm(formfXml);
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"importFormRights"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165formRigths", httpMethod="POST", notes="\u5bfc\u5165formRigths")
    public CommonResult<String> importFormRights(@ApiParam(name="formRightsXml", value="formRightsXml") @RequestBody String formRightsXml) {
        this.bpmFormRightsService.importFormRights(formRightsXml);
        return new CommonResult("\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"getByFormId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355ID\u53d6\u5f97\u8868\u5355\u5bf9\u8c61\u3002", httpMethod="GET", notes="\u6839\u636e\u8868\u5355ID\u53d6\u5f97\u8868\u5355\u5bf9\u8c61\u3002")
    public Form getByFormId(@ApiParam(name="formId", value="\u8868\u5355ID") @RequestParam String formId) {
        return this.formService.getByFormId(formId);
    }

    @RequestMapping(value={"getInstPermission"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u8868\u5355\u7684\u6743\u9650\u3002", httpMethod="POST", notes="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u8868\u5355\u7684\u6743\u9650\u3002")
    public String getInstPermission(@ApiParam(name="model", value="model") @RequestBody FormRestfulModel model) {
        return this.bpmFormRightsService.getInstPermission(model.getFormkey(), model.getUserId(), model.getFlowKey(), model.getNodeId());
    }

    @RequestMapping(value={"getStartPermission"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u542f\u52a8\u65f6\u7684\u8868\u5355\u6743\u9650", httpMethod="POST", notes="\u83b7\u53d6\u6d41\u7a0b\u542f\u52a8\u65f6\u7684\u8868\u5355\u6743\u9650")
    public String getStartPermission(@ApiParam(name="model", value="model") @RequestBody FormRestfulModel model) {
        return this.bpmFormRightsService.getStartPermission(model.getFormkey(), model.getFlowKey(), model.getNodeId(), model.getNextNodeId());
    }

    @RequestMapping(value={"getPermission"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6743\u9650", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6743\u9650")
    public String getPermission(@ApiParam(name="model", value="model") @RequestBody FormRestfulModel model) {
        if (StringUtil.isNotEmpty((String)model.getFormType())) {
            BaseContextThreadUtil.putCommonVars((String)"formType", (Object)model.getFormType());
        }
        return this.bpmFormRightsService.getPermission(model.getFormkey(), model.getUserId(), model.getFlowKey(), model.getParentFlowKey(), model.getNodeId());
    }

    @RequestMapping(value={"getMyApplyPermission"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6743\u9650", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6743\u9650")
    public String getMyApplyPermission(@ApiParam(name="model", value="model") @RequestBody FormRestfulModel model) {
        return this.bpmFormRightsService.getMyApplyPermission(model.getFormkey(), model.getFlowKey(), model.getParentFlowKey(), model.getNodeId());
    }

    @RequestMapping(value={"getFormRigthListByFlowKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355key\u83b7\u5f97\u6743\u9650\u5217\u8868\u3002", httpMethod="GET", notes="\u6839\u636e\u8868\u5355key\u83b7\u5f97\u6743\u9650\u5217\u8868\u3002")
    public List<FormRight> getFormRigthListByFlowKey(@ApiParam(name="formId", value="\u8868\u5355key") @RequestParam String formId) {
        return this.bpmFormRightsService.getFormRigthListByFlowKey(formId);
    }

    @RequestMapping(value={"removeFormRights"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u8868\u5355\u6743\u9650", httpMethod="GET", notes="\u5220\u9664\u8868\u5355\u6743\u9650")
    public void removeFormRights(@ApiParam(name="flowKey", value="\u6d41\u7a0bKEY") @RequestParam String flowKey, @ApiParam(name="parentFlowKey", value="parentFlowKey") @RequestParam String parentFlowKey) {
        this.bpmFormRightsService.removeFormRights(flowKey, parentFlowKey);
    }

    @RequestMapping(value={"getBodefByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u522b\u540d\u83b7\u53d6bo\u5b9a\u4e49", httpMethod="GET", notes="\u901a\u8fc7\u522b\u540d\u83b7\u53d6bo\u5b9a\u4e49")
    public BoDef getBodefByAlias(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias) throws IOException {
        return this.formService.getBoDefByAlias(alias);
    }

    @RequestMapping(value={"getBoJosn"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7bo\u5b9a\u4e49id\u83b7\u53d6bo\u7684json\u683c\u5f0f\u5b9a\u4e49", httpMethod="GET", notes="\u901a\u8fc7bo\u5b9a\u4e49id\u83b7\u53d6bo\u7684json\u683c\u5f0f\u5b9a\u4e49")
    public ObjectNode getBoJosn(@ApiParam(name="id", value="bo\u5b9a\u4e49id") @RequestParam String id) throws IOException {
        return this.formService.getBoJosn(id);
    }

    @RequestMapping(value={"getBoEntByName"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7bo\u5b9e\u4f8bname\u83b7\u53d6boent", httpMethod="GET", notes="\u901a\u8fc7bo\u5b9e\u4f8bname\u83b7\u53d6boent")
    public BoEnt getBoEntByName(@ApiParam(name="name", value="bo\u5b9e\u4f8bname") @RequestParam String name) {
        return this.formService.getBoEntByName(name);
    }

    @RequestMapping(value={"removeFormRightByFlowKey"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u8868\u5355\u6743\u9650", httpMethod="POST", notes="\u5220\u9664\u8868\u5355\u6743\u9650")
    public void removeFormRightByFlowKey(@ApiParam(name="model", value="model") @RequestBody FormRestfulModel model) {
        this.bpmFormRightsService.removeFormRightByFlowKey(model.getFlowKey(), model.getParentFlowKey(), model.getPermissionType());
    }

    @RequestMapping(value={"createFormRight"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65b0\u589e\u8868\u5355\u6743\u9650", httpMethod="POST", notes="\u65b0\u589e\u8868\u5355\u6743\u9650")
    public void createFormRight(@ApiParam(name="bpmFormRight", value="bpmFormRight") @RequestBody ObjectNode bpmFormRight) throws JsonParseException, JsonMappingException, IOException {
        FormRight right = (FormRight)((Object)JsonUtil.toBean((JsonNode)bpmFormRight, FormRight.class));
        this.bpmFormRightsService.createFormRight(right);
    }

    @RequestMapping(value={"queryFormRight"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u8868\u5355\u6743\u9650", httpMethod="POST", notes="\u67e5\u8be2\u8868\u5355\u6743\u9650")
    public List<FormRight> queryFormRight(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) {
        return this.bpmFormRightsService.queryFormRight(queryFilter);
    }

    @RequestMapping(value={"getFormBoLists"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u7ed1\u5b9a\u7684bo", httpMethod="GET", notes="\u83b7\u53d6\u8868\u5355\u7ed1\u5b9a\u7684bo")
    public List<BoDef> getFormBoLists(@ApiParam(name="formKey", value="\u8868\u5355key") @RequestParam String formKey) {
        return this.boDefManager.getByFormKey(formKey);
    }

    @RequestMapping(value={"getFormAndBoExportXml"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u5bfc\u51fa\u7684xml", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u5bfc\u51fa\u7684xml")
    public Map<String, String> getFormAndBoExportXml(@ApiParam(name="obj", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody ObjectNode obj) throws JAXBException {
        Map<String, String> map = this.formService.getFormAndBoExportXml(obj);
        return map;
    }

    @RequestMapping(value={"importFormAndBo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u8868\u5355\u548cBo", httpMethod="POST", notes="\u5bfc\u5165\u8868\u5355\u548cBo")
    public CommonResult<String> importFormAndBo(@ApiParam(name="obj", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody ObjectNode obj) throws Exception {
        return this.formService.importFormAndBo(obj, null);
    }

    @RequestMapping(value={"removeDataByBusLink"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u6570\u636e\u5173\u8054\u5bf9\u8c61\u6e05\u9664\u6d41\u7a0b\u76f8\u5173\u6570\u636e", httpMethod="POST", notes="\u6839\u636e\u4e1a\u52a1\u6570\u636e\u5173\u8054\u5bf9\u8c61\u6e05\u9664\u6d41\u7a0b\u76f8\u5173\u6570\u636e")
    public void removeDataByBusLink(@ApiParam(name="links", value="\u4e1a\u52a1\u6570\u636e\u5173\u8054\u5bf9\u8c61\u5217\u8868") @RequestBody JsonNode links) throws Exception {
        this.formService.removeDataByBusLink(links);
    }

    @RequestMapping(value={"batchHandlerBoData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5904\u7406bo\u6570\u636e,boid\u3002\u7a7a\u4e3a\u65b0\u589e\u3002\u4e0d\u4e3a\u7a7a\u5219\u66f4\u65b0 ", httpMethod="POST", notes="\u5904\u7406bo\u6570\u636e,boid\u3002\u7a7a\u4e3a\u65b0\u589e\u3002\u4e0d\u4e3a\u7a7a\u5219\u66f4\u65b0 ")
    public List<List<BoResult>> batchHandlerBoData(@ApiParam(name="model", value="model") @RequestBody List<FormRestfulModel> models) throws Exception {
        return this.formService.batchHandlerBoData(models);
    }

    @RequestMapping(value={"getBodefWithMainEntByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u522b\u540d\u83b7\u53d6bo\u5b9a\u4e49", httpMethod="GET", notes="\u901a\u8fc7\u522b\u540d\u83b7\u53d6bo\u5b9a\u4e49")
    public List<BoDef> getBodefWithMainEntByAlias(@ApiParam(name="alias", value="\u522b\u540d") @RequestParam String alias) throws Exception {
        return this.formService.getBodefWithMainEntByAlias(alias);
    }

    @RequestMapping(value={"getMainTableAliasByBoCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ebo\u522b\u540d\u83b7\u53d6\u4e3b\u8868\u522b\u540d", httpMethod="GET", notes="\u6839\u636ebo\u522b\u540d\u83b7\u53d6\u4e3b\u8868\u522b\u540d")
    public CommonResult<String> getMainTableAliasByBoCode(@ApiParam(name="boCode", value="boCode") @RequestParam String boCode) {
        BoEnt ent = this.boDefManager.getMainByBoCode(boCode);
        if (BeanUtils.isNotEmpty((Object)ent)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)ent.getName());
        }
        return new CommonResult(false, String.format("BO\u522b\u540d\u3010%s\u3011\u7684\u4e3b\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", boCode));
    }
}

