/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.enums.ResourcesRightType;
import com.hotent.form.manager.FormAuthorizeManager;
import com.hotent.form.model.CustomDialog;
import com.hotent.form.model.QuerySqldef;
import com.hotent.form.model.QueryView;
import com.hotent.form.param.DataTemplateQueryVo;
import com.hotent.form.param.QueryViewEditVo;
import com.hotent.form.persistence.manager.CustomDialogManager;
import com.hotent.form.persistence.manager.FormTemplateManager;
import com.hotent.form.persistence.manager.QueryMetafieldManager;
import com.hotent.form.persistence.manager.QuerySqldefManager;
import com.hotent.form.persistence.manager.QueryViewManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import poi.util.ExcelUtil;

@RestController
@RequestMapping(value={"/form/query/queryView"})
@Api(tags={"\u81ea\u5b9a\u4e49\u67e5\u8be2"})
@ApiGroup(group={"group_form"})
public class QueryViewController
extends BaseController<QueryViewManager, QueryView> {
    @Resource
    QueryViewManager queryViewManager;
    @Resource
    FormTemplateManager bpmFormTemplateManager;
    @Resource
    QuerySqldefManager querySqldefManager;
    @Resource
    QueryMetafieldManager queryMetafieldManager;
    @Resource
    FormAuthorizeManager formAuthorizeManager;
    @Resource
    CustomDialogManager customDialogManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    @ResponseBody
    public PageList<QueryView> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<QueryView> queryFilter, @ApiParam(name="sqlAlias", value="sql\u522b\u540d") @RequestParam(required=false) String sqlAlias, @ApiParam(name="isAll", value="\u67e5\u8be2\u6240\u6709\u5305\u542b\u5bf9\u8bdd\u6846\u6a21\u5f0f") @RequestParam(required=false) Optional<Boolean> isAll) throws Exception {
        PageList<QueryView> query;
        String rightType = ResourcesRightType.USE.getType();
        if (queryFilter.getParams().containsKey("manage")) {
            rightType = ResourcesRightType.LIST.getType();
        }
        if (BeanUtils.isNotEmpty((Object)sqlAlias)) {
            queryFilter.addFilter("SQL_ALIAS_", (Object)sqlAlias, QueryOP.EQUAL);
        } else if (ResourcesRightType.USE.getType().equals(rightType)) {
            Set<String> noRightKeys = this.formAuthorizeManager.getCurUserCanNotUseKeys(ResourceModelType.DATA_LIST, QuerySqldef.class);
            queryFilter.addFilter("SQL_ALIAS_", new ArrayList<String>(noRightKeys), QueryOP.NOT_IN, FieldRelation.OR, "resouceAuthGroup");
        }
        if (isAll.orElse(false).booleanValue()) {
            query = ((QueryViewManager)this.baseService).queryAll(queryFilter);
            List<String> customDialogAlias = query.getRows().stream().map(QueryView::getCustomDialogAlias).filter(StringUtil::isNotEmpty).collect(Collectors.toList());
            if (!customDialogAlias.isEmpty()) {
                Map<String, CustomDialog> customDialogs = this.customDialogManager.getByAlias(customDialogAlias).stream().collect(Collectors.toMap(CustomDialog::getAlias, e -> e));
                for (QueryView row : query.getRows()) {
                    row.setCustomDialog(customDialogs.get(row.getCustomDialogAlias()));
                }
            }
            return query;
        }
        query = this.queryViewManager.query(queryFilter);
        return query;
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u660e\u7ec6", httpMethod="GET", notes="\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u660e\u7ec6")
    public QueryView getJson(@ApiParam(name="id", value="id") @RequestParam Optional<String> id, @ApiParam(name="sqlAlias", value="sql\u522b\u540d") @RequestParam Optional<String> sqlAlias, @ApiParam(name="alias", value="alias") @RequestParam Optional<String> alias) throws Exception {
        return this.queryViewManager.getJson(id, sqlAlias, alias);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="queryView", value="\u4fdd\u5b58\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u4fe1\u606f", required=true) @RequestBody QueryView queryView) throws Exception {
        return this.queryViewManager.saveQueryView(queryView);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u8bb0\u5f55ID!\u591a\u4e2aID\u7528,\u5206\u5272", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.queryViewManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u81ea\u5b9a\u4e49SQL\u89c6\u56fe\u6210\u529f");
    }

    @RequestMapping(value={"getEditInfo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7f16\u8f91\u9875\u9762\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7f16\u8f91\u9875\u9762\u4fe1\u606f")
    public QueryViewEditVo getEditInfo(@ApiParam(name="sqlAlias", value="sqlAlias") @RequestParam String sqlAlias) throws Exception {
        QuerySqldef sqldef = this.querySqldefManager.getByAlias(sqlAlias);
        sqldef.setMetafields(this.queryMetafieldManager.getBySqlId(sqldef.getId()));
        List comVarList = (List)AppUtil.getBean((String)"queryViewComVarList");
        return new QueryViewEditVo("/system/query/queryViewEdit", sqldef, comVarList);
    }

    @RequestMapping(value={"data_{sqlAlias}/{alias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6570\u636e\u5217\u8868")
    public PageList getShowData(@PathVariable(value="sqlAlias") String sqlAlias, @PathVariable(value="alias") String alias, @ApiParam(name="queryFilter", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u67e5\u8be2\u5bf9\u8c61") @RequestBody DataTemplateQueryVo dataTemplateQueryVo, @ApiParam(name="initSearch", value="\u662f\u5426\u521d\u59cb\u5316\u67e5\u8be2") @RequestParam Optional<Boolean> initSearch) throws Exception {
        return this.queryViewManager.getShowData(sqlAlias, alias, dataTemplateQueryVo, false, initSearch.orElse(true));
    }

    @RequestMapping(value={"getTempList"})
    @ResponseBody
    public Object getTempList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.bpmFormTemplateManager.getQueryDataTemplate();
    }

    @RequestMapping(value={"export"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="POST", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, @ApiParam(name="sqlAlias", value="sqlAlias", required=true) @RequestParam String sqlAlias, @ApiParam(name="alias", value="alias", required=false) @RequestParam String alias, @ApiParam(name="getType", value="getType", required=false) @RequestParam String getType, @ApiParam(name="expField", value="expField", required=true) @RequestParam String expField, @ApiParam(name="queryFilter", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u67e5\u8be2\u5bf9\u8c61") @RequestBody DataTemplateQueryVo dataTemplateQueryVo, @ApiParam(name="initSearch", value="\u662f\u5426\u521d\u59cb\u5316\u67e5\u8be2") @RequestParam Optional<Boolean> initSearch) throws Exception {
        String[] expFields;
        QueryView queryView = this.queryViewManager.getBySqlAliasAndAlias(sqlAlias, alias);
        PageList pageList = this.queryViewManager.getShowData(sqlAlias, alias, dataTemplateQueryVo, getType.equals("all"), initSearch.orElse(true));
        expField = Base64.getFromBase64((String)expField);
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        ArrayNode showJA = (ArrayNode)JsonUtil.toJsonNode((String)queryView.getShows());
        ObjectNode showJO = JsonUtil.arrayToObject((ArrayNode)showJA, (String)"fieldName");
        for (String str : expFields = expField.split(",")) {
            ObjectNode node = (ObjectNode)showJO.get(str);
            exportMaps.put(str, node.get("fieldDesc").asText());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)queryView.getName(), (int)24, exportMaps, (List)pageList.getRows());
        ExcelUtil.downloadExcel((Workbook)book, (String)queryView.getName(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"isExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u5224\u65ad\u662f\u5426\u5b58\u5728")
    public CommonResult<Boolean> isExist(@ApiParam(name="id", value="id") @RequestParam String id, @ApiParam(name="key", value="key") @RequestParam String key, @ApiParam(name="sqlAlias", value="sqlAlias") @RequestParam String sqlAlias) throws Exception {
        if (StringUtil.isNotEmpty((String)key)) {
            QueryView temp = this.queryViewManager.getBySqlAliasAndAlias(sqlAlias, key);
            if (temp == null) {
                return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)false);
            }
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)(!temp.getId().equals(id) ? 1 : 0));
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)false);
    }

    @RequestMapping(value={"saveTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u89c6\u56fe\u9875\u9762html", httpMethod="POST", notes="\u4fdd\u5b58\u89c6\u56fe\u9875\u9762html")
    public CommonResult<String> saveTemplate(@ApiParam(name="id", value="\u6a21\u677fid", required=true) @RequestParam String id, @ApiParam(name="templateHtml", value="\u6a21\u677fhtml", required=true) @RequestBody String templateHtml) throws IOException {
        String resultMsg = "\u4fdd\u5b58\u6210\u529f";
        QueryView queryView = (QueryView)this.queryViewManager.get((Serializable)((Object)id));
        queryView.setTemplate(templateHtml);
        this.queryViewManager.update((Model)queryView);
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"getById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u81ea\u5b9a\u4e49\u89c6\u56fe", httpMethod="GET", notes="\u901a\u8fc7id\u83b7\u53d6\u81ea\u5b9a\u4e49\u89c6\u56fe")
    public QueryView getQueryViewById(@ApiParam(name="id", value="\u81ea\u5b9a\u4e49\u89c6\u56feid", required=true) @RequestParam String id) throws Exception {
        return (QueryView)((QueryViewManager)this.baseService).get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u81ea\u5b9a\u4e49\u89c6\u56fe", httpMethod="GET", notes="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u81ea\u5b9a\u4e49\u89c6\u56fe")
    public QueryView getQueryViewByAlias(@ApiParam(name="alias", value="\u81ea\u5b9a\u4e49\u89c6\u56fe\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"alias_", (Object)alias);
        return (QueryView)((Object)((QueryViewManager)this.baseService).getOne((Wrapper)queryWrapper, false));
    }

    @RequestMapping(value={"getAuthDetailPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u89c6\u56fe\u6570\u636e\u6743\u9650", httpMethod="POST", notes="\u83b7\u53d6\u89c6\u56fe\u6570\u636e\u6743\u9650")
    public PageList<Map<String, Object>> getAuthDetailPage(@ApiParam(name="queryFilter", value="\u7528\u6237id") @RequestBody QueryFilter<QueryView> queryFilter) throws Exception {
        return ((QueryViewManager)this.baseService).getAuthDetailPage(queryFilter);
    }

    @RequestMapping(value={"exportAuthDetail"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u89c6\u56fe\u6570\u636e\u6743\u9650", httpMethod="POST", notes="\u5bfc\u51fa\u89c6\u56fe\u6570\u636e\u6743\u9650")
    public void exportAuthDetail(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody QueryFilter<QueryView> queryFilter, HttpServletResponse httpServletResponse) throws Exception {
        ((QueryViewManager)this.baseService).exportAuthDetail(queryFilter, httpServletResponse);
    }

    @RequestMapping(value={"copeOrTransferAuth"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fc1\u79fb\u6216\u590d\u5236\u6570\u636e\u5217\u8868\u89c6\u56fe\u6570\u636e\u8fc7\u6ee4\u6743\u9650", httpMethod="POST", notes="\u8fc1\u79fb\u6216\u590d\u5236\u6570\u636e\u5217\u8868\u89c6\u56fe\u6570\u636e\u8fc7\u6ee4\u6743\u9650")
    public CommonResult<String> copeOrTransferAuth(@ApiParam(name="map", value="\u6743\u9650\u4fee\u6539\u4fe1\u606f") @RequestBody List<Map<String, String>> list) throws Exception {
        return ((QueryViewManager)this.baseService).copeOrTransferAuth(list);
    }
}

