/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.form.model.ViewManage;
import com.hotent.form.persistence.manager.ViewManageManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/viewManage/v1"})
@Api(tags={"viewManageController"})
@ApiGroup(group={"group_form"})
public class ViewManageController
extends BaseController<ViewManageManager, ViewManage> {
    @Resource
    ViewManageManager viewManageManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u89c6\u56fe\u7ba1\u7406\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u89c6\u56fe\u7ba1\u7406\u5217\u8868")
    public PageList<ViewManage> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<ViewManage> queryFilter) throws Exception {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return this.viewManageManager.query(queryFilter);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u89c6\u56fe\u7ba1\u7406\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u89c6\u56fe\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public ViewManage get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (ViewManage)this.viewManageManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"/save/{saveType}"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u89c6\u56fe\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u89c6\u56fe\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="viewManage", value="\u89c6\u56fe\u7ba1\u7406\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody ViewManage viewManage, @PathVariable Integer saveType) throws Exception {
        String msg = "\u64cd\u4f5c\u6210\u529f";
        this.viewManageManager.savePub(viewManage, saveType);
        return new CommonResult(msg);
    }

    @GetMapping(value={"/createPhysicalView/{id}"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u89c6\u56fe\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u89c6\u56fe\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> createPhysicalView(@PathVariable String id) throws Exception {
        this.viewManageManager.createPhysicalView(id);
        String msg = "\u64cd\u4f5c\u6210\u529f";
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u89c6\u56fe\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u89c6\u56fe\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.viewManageManager.removeByIds(ids);
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u89c6\u56fexml", httpMethod="GET", notes="\u5bfc\u51fa\u89c6\u56fexml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="ids", value="\u89c6\u56feid", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            String[] stringsIds = ids.split(",");
            List<String> list = Arrays.asList(stringsIds);
            String zipName = "ht_viewManage_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map<String, String> strXml = ((ViewManageManager)this.baseService).exportData(list);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, strXml, (String)zipName);
        }
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u89c6\u56fe\u5bfc\u5165", httpMethod="POST", notes="\u89c6\u56fe\u5bfc\u5165")
    public CommonResult<String> importData(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        CommonResult<String> res = this.viewManageManager.importData(request, response);
        return res;
    }
}

