/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.generator.conf;

import cn.hutool.core.util.ReflectUtil;
import com.hotent.base.util.AppUtil;
import com.hotent.form.generator.conf.RegistryConfig;
import com.hotent.form.generator.enums.GeneratorEnum;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class RegistryConfiguration {
    @Bean
    @Primary
    @ConditionalOnClass(name={"org.springframework.cloud.netflix.eureka.EurekaClientConfigBean"})
    public RegistryConfig createEurekaConfig() {
        RegistryConfig registryConfig = new RegistryConfig();
        Object eurekaClientConfigBean = AppUtil.getBean((String)"eurekaClientConfigBean");
        if (eurekaClientConfigBean != null) {
            Map serviceUrl = (Map)ReflectUtil.getFieldValue((Object)eurekaClientConfigBean, (String)"serviceUrl");
            registryConfig.setRegistryServerName(GeneratorEnum.RegistryServerName.EUREKA.getValue());
            registryConfig.setRegistryServerAddr((String)serviceUrl.get("defaultZone"));
        }
        return registryConfig;
    }

    @Bean
    @ConditionalOnClass(name={"com.alibaba.cloud.nacos.NacosDiscoveryProperties"})
    public RegistryConfig createNacosConfig() {
        RegistryConfig registryConfig = new RegistryConfig();
        Object nacosDiscoveryProperties = AppUtil.getBean((String)"nacosDiscoveryProperties");
        if (nacosDiscoveryProperties != null) {
            registryConfig.setRegistryServerName(GeneratorEnum.RegistryServerName.NACOS.getValue());
            registryConfig.setRegistryServerAddr((String)ReflectUtil.getFieldValue((Object)nacosDiscoveryProperties, (String)"serverAddr"));
            registryConfig.setRegistryUsername((String)ReflectUtil.getFieldValue((Object)nacosDiscoveryProperties, (String)"username"));
            registryConfig.setRegistryPassword((String)ReflectUtil.getFieldValue((Object)nacosDiscoveryProperties, (String)"password"));
            registryConfig.setRegistryNamespace((String)ReflectUtil.getFieldValue((Object)nacosDiscoveryProperties, (String)"namespace"));
            registryConfig.setRegistryGroup((String)ReflectUtil.getFieldValue((Object)nacosDiscoveryProperties, (String)"group"));
        }
        return registryConfig;
    }
}

