/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.generator.generate;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.form.generator.GeneratorModel;
import com.hotent.form.generator.enums.GeneratorEnum;
import com.hotent.form.generator.util.CodeGeneratorUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.ResourceUtils;

public class FileOutConfigGenerator {
    private static final String FLOW_TEMPLATE_PATH = "template/codegen/flow";

    public static List<FileOutConfig> generate(final String baseProjectPath, final GeneratorModel generatorModel) throws FileNotFoundException {
        final String backProjectPath = CodeGeneratorUtil.getBackendProjectPath(baseProjectPath, generatorModel);
        ArrayList<FileOutConfig> fileOutList = new ArrayList<FileOutConfig>();
        String type = generatorModel.getType();
        String tamplatePath = "/template/codegen/mapper.xml.ftl";
        if ("querySqldef".equals(type)) {
            tamplatePath = "/template/codegen/mapper.querySqldef.xml.ftl";
        }
        fileOutList.add(new FileOutConfig(tamplatePath){

            public String outputFile(TableInfo tableInfo) {
                return backProjectPath + "/src/main/resources/mapper/".replace("/", File.separator) + tableInfo.getEntityName() + "Mapper.xml";
            }
        });
        tamplatePath = "/template/codegen/entityManager.vue.ftl";
        if ("dataTemplate".equals(type)) {
            tamplatePath = "/template/codegen/entityManager.dataTemplate.eip.vue.ftl";
        }
        if ("querySqldef".equals(type)) {
            tamplatePath = "/template/codegen/entityManager.querySqldef.vue.ftl";
        }
        fileOutList.add(new FileOutConfig(tamplatePath){

            public String outputFile(TableInfo tableInfo) {
                return CodeGeneratorUtil.getFrontendProjectPath(baseProjectPath, generatorModel) + "/src/views/".replace("/", File.separator) + (StringUtil.isNotEmpty((String)generatorModel.getModuleName()) ? generatorModel.getModuleName() + File.separator : "") + tableInfo.getEntityName() + "Manager.vue";
            }
        });
        if ("dataTemplate".equals(type) && BeanUtils.isNotEmpty((Object)generatorModel.getDataTemplate().getMobileFormAlias())) {
            tamplatePath = "/template/codegen/entityMobileManager.dataTemplate.vue.ftl";
            fileOutList.add(new FileOutConfig(tamplatePath){

                public String outputFile(TableInfo tableInfo) {
                    return CodeGeneratorUtil.getFrontendProjectPath(baseProjectPath, generatorModel) + "/src/views/".replace("/", File.separator) + (StringUtil.isNotEmpty((String)generatorModel.getModuleName()) ? generatorModel.getModuleName() + File.separator : "") + tableInfo.getEntityName() + "MobileManager.vue";
                }
            });
            tamplatePath = "/template/codegen/entityMobileManagerEdit.form.vue.ftl";
            fileOutList.add(new FileOutConfig(tamplatePath){

                public String outputFile(TableInfo tableInfo) {
                    return CodeGeneratorUtil.getFrontendProjectPath(baseProjectPath, generatorModel) + "/src/views/".replace("/", File.separator) + (StringUtil.isNotEmpty((String)generatorModel.getModuleName()) ? generatorModel.getModuleName() + File.separator : "") + tableInfo.getEntityName() + "MobileManagerEdit.vue";
                }
            });
        }
        if (!"querySqldef".equals(type) && !"dataTemplate".equals(type)) {
            tamplatePath = "/template/codegen/entityManagerEdit.table.vue.ftl";
            if ("form".equals(type)) {
                tamplatePath = "/template/codegen/entityManagerEdit.form.vue.ftl";
            }
            fileOutList.add(new FileOutConfig(tamplatePath){

                public String outputFile(TableInfo tableInfo) {
                    return CodeGeneratorUtil.getFrontendProjectPath(baseProjectPath, generatorModel) + "/src/views/".replace("/", File.separator) + (StringUtil.isNotEmpty((String)generatorModel.getModuleName()) ? generatorModel.getModuleName() + File.separator : "") + tableInfo.getEntityName() + "ManagerEdit.vue";
                }
            });
        }
        if (!"dataTemplate".equals(type)) {
            tamplatePath = "/template/codegen/api.js.ftl";
            fileOutList.add(new FileOutConfig(tamplatePath){

                public String outputFile(TableInfo tableInfo) {
                    return CodeGeneratorUtil.getFrontendProjectPath(baseProjectPath, generatorModel) + "/src/api/".replace("/", File.separator) + tableInfo.getEntityName() + ".js";
                }
            });
        }
        if (GeneratorEnum.GenType.FAST.getValue().equals(generatorModel.getGenType())) {
            File folder;
            tamplatePath = "/template/codegen/fast/maven-pom.xml.ftl";
            fileOutList.add(new FileOutConfig(tamplatePath){

                public String outputFile(TableInfo tableInfo) {
                    return backProjectPath + "/pom.xml".replace("/", File.separator);
                }
            });
            tamplatePath = "/template/codegen/fast/Application.java.ftl";
            fileOutList.add(new FileOutConfig(tamplatePath){

                public String outputFile(TableInfo tableInfo) {
                    return (backProjectPath + "/src/main/java/" + generatorModel.getBasePackage().replace(".", "/") + "/Application.java").replace("/", File.separator);
                }
            });
            tamplatePath = "/template/codegen/fast/application-dev.yml.ftl";
            fileOutList.add(new FileOutConfig(tamplatePath){

                public String outputFile(TableInfo tableInfo) {
                    return (backProjectPath + "/src/main/resources/application-dev.yml").replace("/", File.separator);
                }
            });
            tamplatePath = "/template/codegen/fast/bootstrap.yml.ftl";
            fileOutList.add(new FileOutConfig(tamplatePath){

                public String outputFile(TableInfo tableInfo) {
                    return (backProjectPath + "/src/main/resources/bootstrap.yml").replace("/", File.separator);
                }
            });
            if (BeanUtils.isNotEmpty((Object)generatorModel.getFlowKey()) && (folder = ResourceUtils.getFile((String)"classpath:template/codegen/flow")).exists() && folder.isDirectory()) {
                FileOutConfigGenerator.traverseFolder(folder, fileOutList, backProjectPath, generatorModel);
            }
        }
        return fileOutList;
    }

    private static void traverseFolder(File folder, List<FileOutConfig> fileOutList, final String backProjectPath, final GeneratorModel generatorModel) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (final File file : files) {
                if (file.isDirectory()) {
                    FileOutConfigGenerator.traverseFolder(file, fileOutList, backProjectPath, generatorModel);
                    continue;
                }
                String templatePath = FLOW_TEMPLATE_PATH + StrUtil.subAfter((CharSequence)file.getAbsolutePath(), (CharSequence)FLOW_TEMPLATE_PATH.replace("/", File.separator), (boolean)true);
                fileOutList.add(new FileOutConfig(templatePath){

                    public String outputFile(TableInfo tableInfo) {
                        String outputDir = backProjectPath + "/src/main/java/" + generatorModel.getBasePackage().replace(".", "/") + "/" + generatorModel.getModuleName().replace(".", "/") + StrUtil.subAfter((CharSequence)file.getAbsolutePath(), (CharSequence)FileOutConfigGenerator.FLOW_TEMPLATE_PATH.replace("/", File.separator), (boolean)false);
                        return outputDir.replace(".ftl", "").replace("/", File.separator);
                    }
                });
            }
        }
    }
}

