/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.model.ResourceBaseModel;
import com.hotent.form.dao.FormAuthorizeDao;
import com.hotent.form.dto.ResourceAuthActDTO;
import com.hotent.form.dto.ResourceAuthDTO;
import com.hotent.form.manager.FormAuthorizeActManager;
import com.hotent.form.manager.FormAuthorizeManager;
import com.hotent.form.manager.FormAuthorizeUserManager;
import com.hotent.form.model.FormAuthorize;
import com.hotent.form.model.FormAuthorizeAct;
import com.hotent.form.model.FormAuthorizeUser;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.service.IUserGroupService;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormAuthorizeManagerImpl
extends BaseManagerImpl<FormAuthorizeDao, FormAuthorize>
implements FormAuthorizeManager {
    @Resource
    private FormAuthorizeUserManager formAuthorizeUserManager;
    @Resource
    private FormAuthorizeActManager formAuthorizeActManager;
    @Resource
    IUserGroupService defaultUserGroupService;

    @Override
    public FormAuthorize getDetail(String id) throws IOException {
        FormAuthorize formAuthorize = (FormAuthorize)this.get((Serializable)((Object)id));
        List authUserList = ((LambdaQueryChainWrapper)this.formAuthorizeUserManager.lambdaQuery().eq(FormAuthorizeUser::getAuthorizeId, (Object)id)).list();
        formAuthorize.setAuthorizeUserList(authUserList);
        formAuthorize.setAuthUserJson(this.toAuthUserJson(authUserList));
        List authActList = ((LambdaQueryChainWrapper)this.formAuthorizeActManager.lambdaQuery().eq(FormAuthorizeAct::getAuthorizeId, (Object)id)).list();
        formAuthorize.setAuthorizeActList(authActList);
        formAuthorize.setAuthModelJson(this.totAuthModelJson(authActList));
        return formAuthorize;
    }

    public String totAuthModelJson(List<FormAuthorizeAct> defActList) throws IOException {
        if (BeanUtils.isEmpty(defActList)) {
            return "[]";
        }
        ArrayNode jsonArray = JsonUtil.getMapper().createArrayNode();
        for (FormAuthorizeAct act : defActList) {
            JsonNode jsonNode = JsonUtil.toJsonNode((Object)((Object)act));
            jsonArray.add(jsonNode);
        }
        return jsonArray.toString();
    }

    private String toAuthUserJson(List<FormAuthorizeUser> bpmDefUsers) {
        if (BeanUtils.isEmpty(bpmDefUsers)) {
            return "[]";
        }
        HashMap map = new HashMap();
        ArrayList permissions = (ArrayList)AppUtil.getBean((String)"defaultObjectRightType");
        HashMap<String, String> userTypeMap = new HashMap<String, String>();
        permissions.forEach(p -> userTypeMap.put(p.getType(), p.getTitle()));
        for (FormAuthorizeUser user : bpmDefUsers) {
            List<FormAuthorizeUser> list;
            String string = user.getRightType();
            if (map.containsKey(string)) {
                list = (List)map.get(string);
                list.add(user);
                continue;
            }
            list = new ArrayList();
            list.add(user);
            map.put(string, list);
        }
        ArrayNode jsonArray = JsonUtil.getMapper().createArrayNode();
        for (Map.Entry<String, List<FormAuthorizeUser>> entry : map.entrySet()) {
            ObjectNode json = this.userEntToJson(entry, userTypeMap);
            jsonArray.add((JsonNode)json);
        }
        return jsonArray.toString();
    }

    private ObjectNode userEntToJson(Map.Entry<String, List<FormAuthorizeUser>> entry, Map<String, String> userTypeMap) {
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        String type = entry.getKey();
        String title = userTypeMap.get(type);
        jsonObj.put("type", type);
        jsonObj.put("title", title);
        if (type.equals("everyone")) {
            return jsonObj;
        }
        List<FormAuthorizeUser> list = entry.getValue();
        String ids = "";
        String names = "";
        String authOrg = "";
        String authOrgName = "";
        for (int i = 0; i < list.size(); ++i) {
            FormAuthorizeUser user = list.get(i);
            if (i == 0) {
                ids = ids + user.getOwnerId();
                names = names + user.getOwnerName();
            } else {
                ids = ids + "," + user.getOwnerId();
                names = names + "," + user.getOwnerName();
            }
            authOrg = user.getAuthOrg();
            authOrgName = user.getAuthOrgName();
        }
        jsonObj.put("id", ids);
        jsonObj.put("name", names);
        jsonObj.put("authOrg", authOrg);
        jsonObj.put("authOrgName", authOrgName);
        return jsonObj;
    }

    @Override
    @Transactional
    public void createOrUpdate(FormAuthorize formAuthorize) throws IOException {
        String authorizeId = formAuthorize.getId();
        if (StringUtil.isNotEmpty((String)authorizeId)) {
            this.formAuthorizeUserManager.remove((Wrapper)Wrappers.lambdaQuery().eq(FormAuthorizeUser::getAuthorizeId, (Object)authorizeId));
            this.formAuthorizeActManager.remove((Wrapper)Wrappers.lambdaQuery().eq(FormAuthorizeAct::getAuthorizeId, (Object)authorizeId));
        } else {
            authorizeId = UniqueIdUtil.getSuid();
            formAuthorize.setId(authorizeId);
            formAuthorize.setCreateTime(LocalDateTime.now());
            formAuthorize.setCreateBy(ContextUtil.getCurrentUserId());
            formAuthorize.setCreator(ContextUtil.getCurrentUser().getFullname());
        }
        String authUserJson = formAuthorize.getAuthUserJson();
        List<FormAuthorizeUser> bpmDefUserList = this.toBpmDefUserList(authUserJson, authorizeId);
        this.formAuthorizeUserManager.saveBatch(bpmDefUserList);
        String authModelJson = formAuthorize.getAuthModelJson();
        List<FormAuthorizeAct> bpmDefActList = this.toBpmDefActList(authModelJson, formAuthorize);
        this.formAuthorizeActManager.saveBatch(bpmDefActList);
        this.saveOrUpdate((Object)formAuthorize);
    }

    @Override
    @Transactional
    public void deleteByIds(List<String> ids) {
        super.removeByIds(ids);
        this.formAuthorizeUserManager.remove((Wrapper)Wrappers.lambdaQuery().in(FormAuthorizeUser::getAuthorizeId, ids));
        this.formAuthorizeActManager.remove((Wrapper)Wrappers.lambdaQuery().in(FormAuthorizeAct::getAuthorizeId, ids));
    }

    private List<FormAuthorizeUser> toBpmDefUserList(String ownNameJson, String authorizeId) throws IOException {
        ArrayList<FormAuthorizeUser> userList = new ArrayList<FormAuthorizeUser>();
        if (StringUtil.isEmpty((String)ownNameJson)) {
            return userList;
        }
        ArrayNode aryJson = (ArrayNode)JsonUtil.toJsonNode((String)ownNameJson);
        for (Object obj : aryJson) {
            ObjectNode jsonObject = (ObjectNode)obj;
            List<FormAuthorizeUser> list = this.getList(jsonObject, authorizeId);
            userList.addAll(list);
        }
        return userList;
    }

    private List<FormAuthorizeUser> getList(ObjectNode json, String authorizeId) {
        ArrayList<FormAuthorizeUser> bpmDefUsers = new ArrayList<FormAuthorizeUser>();
        String type = json.get("type").asText();
        String authOrg = "";
        String authOrgName = "";
        if (BeanUtils.isNotEmpty((Object)json.get("authOrg"))) {
            authOrg = json.get("authOrg").asText();
        }
        if (BeanUtils.isNotEmpty((Object)json.get("authOrgName"))) {
            authOrgName = json.get("authOrgName").asText();
        }
        if ("everyone".equals(type)) {
            FormAuthorizeUser defUser = new FormAuthorizeUser();
            defUser.setId(UniqueIdUtil.getSuid());
            defUser.setAuthorizeId(authorizeId);
            defUser.setRightType(type);
            defUser.setAuthOrg(authOrg);
            defUser.setAuthOrgName(authOrgName);
            bpmDefUsers.add(defUser);
        } else {
            String ids = json.get("id").asText();
            String names = json.get("name").asText();
            String[] aryId = ids.split(",");
            String[] aryName = names.split(",");
            for (int i = 0; i < aryId.length; ++i) {
                FormAuthorizeUser defUser = new FormAuthorizeUser();
                defUser.setId(UniqueIdUtil.getSuid());
                defUser.setAuthorizeId(authorizeId);
                defUser.setRightType(type);
                defUser.setOwnerId(aryId[i]);
                defUser.setOwnerName(aryName[i]);
                defUser.setAuthOrg(authOrg);
                defUser.setAuthOrgName(authOrgName);
                bpmDefUsers.add(defUser);
            }
        }
        return bpmDefUsers;
    }

    private List<FormAuthorizeAct> toBpmDefActList(String defNameJson, FormAuthorize formAuthorize) throws IOException {
        ArrayList<FormAuthorizeAct> myBpmDefActList = new ArrayList<FormAuthorizeAct>();
        if (StringUtil.isEmpty((String)defNameJson)) {
            return myBpmDefActList;
        }
        ArrayNode myJsonArray = (ArrayNode)JsonUtil.toJsonNode((String)defNameJson);
        for (int i = 0; i < myJsonArray.size(); ++i) {
            ObjectNode jsonObject = (ObjectNode)myJsonArray.get(i);
            FormAuthorizeAct bpmDefAct = new FormAuthorizeAct();
            String defKey = jsonObject.get("modelKey").asText();
            bpmDefAct.setModelKey(defKey);
            String defName = jsonObject.get("modelName").asText();
            bpmDefAct.setModelName(defName);
            ArrayList<String> rightList = new ArrayList<String>();
            ArrayNode arrayNode = (ArrayNode)jsonObject.get("right");
            for (JsonNode jsonNode2 : arrayNode) {
                rightList.add(jsonNode2.asText());
            }
            bpmDefAct.setRightContent(StringUtil.join(rightList));
            bpmDefAct.setId(UniqueIdUtil.getSuid());
            bpmDefAct.setAuthorizeId(formAuthorize.getId());
            bpmDefAct.setType(jsonObject.get("type").asText());
            bpmDefAct.setModelType(jsonObject.get("modelType").asText());
            myBpmDefActList.add(bpmDefAct);
        }
        return myBpmDefActList;
    }

    @Override
    public ResourceAuthDTO getResourceRightByUserId(String userId, String resourceType, String rightType) throws IOException {
        Map<String, String> userRightMapStr = this.convertGroupList(userId);
        return this.getActRightByRightMapAndUserId(userId, resourceType, rightType, userRightMapStr);
    }

    @Override
    public ResourceAuthDTO getActRightByRightMapAndUserId(String userId, String resourceType, String rightType, Map<String, String> userRightMapStr) throws IOException {
        ResourceAuthDTO resourceAuthDTO = new ResourceAuthDTO();
        resourceAuthDTO.setRightMapType(new ArrayList<ResourceAuthActDTO>());
        resourceAuthDTO.setRightMapModel(new ArrayList<ResourceAuthActDTO>());
        resourceAuthDTO.setRightMapAll(new ArrayList<ResourceAuthActDTO>());
        List<FormAuthorizeAct> list = this.formAuthorizeActManager.getActRightByUserMap(userRightMapStr, resourceType);
        if (BeanUtils.isEmpty(list)) {
            return resourceAuthDTO;
        }
        for (FormAuthorizeAct bpmDefAct : list) {
            List<ResourceAuthActDTO> actList;
            String rightContent = bpmDefAct.getRightContent();
            if (StringUtil.isEmpty((String)rightContent) || !rightContent.contains(rightType)) continue;
            String type = bpmDefAct.getType();
            if (type.equals("1")) {
                actList = this.handleAndMergeRight(resourceAuthDTO.getRightMapModel(), bpmDefAct, rightContent);
                resourceAuthDTO.setRightMapModel(actList);
            }
            if (type.equals("2")) {
                actList = this.handleAndMergeRight(resourceAuthDTO.getRightMapType(), bpmDefAct, rightContent);
                resourceAuthDTO.setRightMapType(actList);
            }
            if (!type.equals("3")) continue;
            actList = this.handleAndMergeRight(resourceAuthDTO.getRightMapAll(), bpmDefAct, rightContent);
            resourceAuthDTO.setRightMapAll(actList);
        }
        return resourceAuthDTO;
    }

    private List<ResourceAuthActDTO> handleAndMergeRight(List<ResourceAuthActDTO> actList, FormAuthorizeAct bpmDefAct, String rightContent) {
        ResourceAuthActDTO actDTO;
        String modelKey = bpmDefAct.getModelKey();
        Optional<ResourceAuthActDTO> optionalAct = actList.stream().filter(a -> StringUtil.isNotEmpty((String)a.getModelKey()) && a.getModelKey().equals(modelKey)).findFirst();
        if (!optionalAct.isPresent()) {
            actDTO = new ResourceAuthActDTO();
            actDTO.setModelKey(modelKey);
            actList.add(actDTO);
        } else {
            actDTO = optionalAct.get();
        }
        Set<Object> authorizeRight = actDTO.getRightContent() == null ? new HashSet() : actDTO.getRightContent();
        authorizeRight.addAll(Arrays.asList(rightContent.split(",")));
        actDTO.setRightContent(authorizeRight);
        return actList;
    }

    private Map<String, String> convertGroupList(String userId) {
        List list = this.defaultUserGroupService.getGroupsByUserIdOrAccount(userId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user", "'" + userId + "'");
        if (BeanUtils.isEmpty((Object)list)) {
            return map;
        }
        for (IGroup group : list) {
            String type = group.getGroupType();
            if ("position".equals(type)) {
                type = "pos";
            }
            if (map.containsKey(type)) {
                String groupId = (String)map.get(type);
                groupId = groupId + ",'" + group.getGroupId() + "'";
                map.put(type, groupId);
                continue;
            }
            map.put(type, "'" + group.getGroupId() + "'");
        }
        return map;
    }

    @Override
    public Set<String> getCurUserCanNotUseKeys(ResourceModelType authModelType, Class<? extends ResourceBaseModel<?>> cls) throws IOException {
        if (!ContextUtil.getCurrentUser().isAdmin()) {
            // empty if block
        }
        return new HashSet<String>();
    }

    @Override
    public List<String> getScopeUser() {
        return null;
    }

    private static /* synthetic */ boolean lambda$getCurUserCanNotUseKeys$3(Set hasRightIds, FormAuthorizeAct r) {
        return !hasRightIds.contains(r.getId());
    }

    private static /* synthetic */ void lambda$getCurUserCanNotUseKeys$2(List hasuseRight, FormAuthorizeAct r) {
        if (r.getRightContent().indexOf("1") > -1) {
            hasuseRight.add(r);
        }
    }
}

