/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.manager.impl;

import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.hotent.base.exception.DataExistException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.form.dao.FormCustomComponentDao;
import com.hotent.form.manager.FormCustomComponentManager;
import com.hotent.form.model.FormCustomComponent;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class FormCustomComponentManagerImpl
extends BaseManagerImpl<FormCustomComponentDao, FormCustomComponent>
implements FormCustomComponentManager {
    @Override
    public FormCustomComponent getByAlias(String alias) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"alias_", (Object)alias);
        List list = ((FormCustomComponentDao)this.baseMapper).selectList((Wrapper)wrapper);
        if (BeanUtils.isNotEmpty((Object)list)) {
            return (FormCustomComponent)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public CommonResult<String> importData(MultipartHttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        MultipartFile file = request.getFile("file");
        Assert.notNull((Object)file, (String)"\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String unZipFilePath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            this.importData(Base64.getBase64((String)unZipFilePath), "check");
            return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
        }
        catch (DataExistException e) {
            return new CommonResult(true, "confirmUpload", (Object)Base64.getBase64Replace((String)unZipFilePath));
        }
        catch (Exception e) {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> importData(String unZipFilePath, String status) throws Exception {
        try {
            String json = FileUtil.readFile((String)(Base64.getFromBase64Replace((String)unZipFilePath) + File.separator + "customComponent.json"));
            List customComponents = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<FormCustomComponent>>(){});
            if ("check".equals(status)) {
                this.importCheck(customComponents, item -> {
                    throw new DataExistException();
                });
            }
            this.importData(customComponents, status);
        }
        catch (Exception e) {
            File zipFile;
            if (!(e instanceof DataExistException) && StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
            throw e;
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    @Override
    public void importCheck(List<FormCustomComponent> components, Consumer<FormCustomComponent> notSuitableConsumer) {
        for (FormCustomComponent component : components) {
            FormCustomComponent byAlias = this.getByAlias(component.getAlias());
            if (!BeanUtils.isNotEmpty((Object)((Object)byAlias))) continue;
            notSuitableConsumer.accept(byAlias);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importData(List<FormCustomComponent> components, String status) {
        ArrayList<FormCustomComponent> saveOrUpdateComponents = new ArrayList<FormCustomComponent>();
        for (FormCustomComponent customComponent : components) {
            FormCustomComponent byAlias = this.getByAlias(customComponent.getAlias());
            if (!BeanUtils.isEmpty((Object)((Object)byAlias)) && !"cover".equals(status)) continue;
            saveOrUpdateComponents.add(customComponent);
        }
        this.saveOrUpdateBatch(saveOrUpdateComponents);
    }
}

