/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.mobile.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.form.enums.LayoutType;
import com.hotent.form.util.GenerateExpandUtil;
import java.util.Arrays;
import java.util.List;

public interface Pc2MobileConverter {
    public LayoutType type();

    public ArrayNode convert(JsonNode var1);

    default public void tempArrayAddItem(ArrayNode array, JsonNode item) {
        try {
            List<String> excludeCtrls = Arrays.asList("processForecast", "dataView");
            if (item.has("ctrlType") && excludeCtrls.contains(item.get("ctrlType").asText())) {
                return;
            }
            item = this.removePcStyle(item);
            array.add(item);
        }
        catch (Exception e) {
            array.add(item);
        }
    }

    default public JsonNode removePcStyle(JsonNode itemNode) {
        String ctrlType = JsonUtil.getString((JsonNode)itemNode, (String)"ctrlType", (String)"");
        String[] styleArr = new String[]{"labelstyleWidth", "width", "isReadonly"};
        ObjectNode node = (ObjectNode)itemNode.deepCopy();
        if (node.has("options")) {
            JsonNode options = node.get("options");
            ObjectNode optionsON = (ObjectNode)options.deepCopy();
            for (int i = 0; i < styleArr.length; ++i) {
                if (!BeanUtils.isNotEmpty((Object)optionsON) || !optionsON.has(styleArr[i])) continue;
                optionsON.put(styleArr[i], "");
            }
            if (optionsON != null) {
                optionsON.put("frameborder", "0");
                optionsON = GenerateExpandUtil.appendScanConfig(optionsON, ctrlType);
            }
            node.set("options", (JsonNode)optionsON);
            if (node.get("list") != null && node.get("list") instanceof ArrayNode) {
                ArrayNode nodeList = (ArrayNode)node.get("list");
                ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
                for (JsonNode nodeSub : nodeList) {
                    arrayNode.add(this.removePcStyle(nodeSub));
                }
                node.set("list", (JsonNode)arrayNode);
            }
        }
        return node;
    }

    default public void handleColsInTable(JsonNode tableNode, ArrayNode tempArray) {
        ArrayNode rows = (ArrayNode)tableNode.findValue("rows");
        for (JsonNode row : rows) {
            if (!row.has("cols")) continue;
            ArrayNode cols = (ArrayNode)row.findValue("cols");
            for (JsonNode col : cols) {
                if (!col.has("list")) continue;
                ArrayNode list = (ArrayNode)col.findValue("list");
                for (JsonNode item : list) {
                    this.tempArrayAddItem(tempArray, item);
                }
            }
        }
    }
}

