/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Method;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.PermissionDeniedException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.sqlbuilder.SqlBuilderModel;
import com.hotent.base.sqlbuilder.service.ISqlBuilderService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.FluentUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.enums.ResourcesRightType;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.manager.BoAttributeManager;
import com.hotent.bo.persistence.manager.BoEntManager;
import com.hotent.form.datatrans.ResultTransform;
import com.hotent.form.model.CustomDialog;
import com.hotent.form.model.CustomQuery;
import com.hotent.form.model.RequestParam;
import com.hotent.form.model.RestfulQueryParam;
import com.hotent.form.persistence.dao.CustomQueryDao;
import com.hotent.form.persistence.manager.CustomDialogManager;
import com.hotent.form.persistence.manager.CustomQueryManager;
import com.hotent.form.util.CustomUtil;
import com.hotent.form.vo.CustomDialogDisplayFieldVo;
import com.hotent.form.vo.CustomQueryControllerVo;
import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.model.Column;
import com.hotent.table.model.Table;
import com.hotent.table.operator.IViewOperator;
import com.hotent.table.util.MetaDataUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import poi.util.ExcelUtil;

@Service(value="customQueryManager")
public class CustomQueryManagerImpl
extends BaseManagerImpl<CustomQueryDao, CustomQuery>
implements CustomQueryManager {
    Logger logger = LoggerFactory.getLogger(CustomQueryManagerImpl.class);
    @Resource
    CommonManager commonManager;
    @Resource
    ISqlBuilderService sqlBuilderService;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    MultiTenantHandler tenantHandler;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    CustomDialogManager customDialogManager;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoAttributeManager boAttributeManager;

    @Override
    public PageList getData(CustomQuery customQuery, String queryData, String dsType, int pageNo, int pageSize) throws IOException {
        ArrayNode resultFields;
        String sql = this.getSql(customQuery, queryData, dsType);
        if (!"postgresql".equals(dsType) && !"oracle".equals(dsType)) {
            sql = sql.replaceAll("\"", "");
        }
        PageList pageList = null;
        List list = null;
        String finalSql = sql;
        if (customQuery.getNeedPage() == 1) {
            pageNo = pageNo <= 0 ? 1 : pageNo;
            pageSize = pageSize <= 0 ? 10 : pageSize;
            PageBean page = new PageBean(Integer.valueOf(pageNo), Integer.valueOf(pageSize));
            pageList = (PageList)this.databaseContext.switchDS(customQuery.getDsalias(), () -> this.commonManager.query(finalSql, page), e -> {
                throw new BaseException(e.getMessage());
            });
        } else {
            list = (List)this.databaseContext.switchDS(customQuery.getDsalias(), () -> this.commonManager.query(finalSql), e -> {
                throw new BaseException(e.getMessage());
            });
            pageList = new PageList(list);
        }
        Map<String, String> dateFormatMap = this.getDateFormatMap(customQuery.getObjName());
        ResultTransform.transform(pageList.getRows(), obj -> {
            Map map = null;
            if (BeanUtils.isNotEmpty((Object)obj)) {
                map = (Map)obj;
                for (String key : map.keySet()) {
                    if (BeanUtils.isEmpty(map.get(key)) || !java.sql.Date.class.isAssignableFrom(map.get(key).getClass()) && !Date.class.isAssignableFrom(map.get(key).getClass())) continue;
                    String formatStr = "yyyy-MM-dd";
                    if (dateFormatMap.containsKey(key)) {
                        formatStr = (String)dateFormatMap.get(key);
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                    try {
                        map.put(key, sdf.format(map.get(key)));
                    }
                    catch (Exception exception) {}
                }
            }
            return map;
        });
        String resultfield = customQuery.getResultfield();
        if (StringUtil.isNotEmpty((String)resultfield) && !(resultFields = (ArrayNode)JsonUtil.toJsonNode((String)resultfield)).isEmpty()) {
            ArrayList resultList = new ArrayList();
            List rows = pageList.getRows();
            for (Object row : rows) {
                HashMap tempMap = new HashMap();
                if (BeanUtils.isNotEmpty(row)) {
                    Map map = (Map)row;
                    for (String key : map.keySet()) {
                        int size = tempMap.size();
                        for (JsonNode resultField : resultFields) {
                            if (!key.equalsIgnoreCase(JsonUtil.getString((JsonNode)resultField, (String)"field"))) continue;
                            Object value = map.get(key);
                            tempMap.put(JsonUtil.getString((JsonNode)resultField, (String)"field"), value);
                        }
                        if (size != tempMap.size()) continue;
                        tempMap.put(key, map.get(key));
                    }
                }
                resultList.add(tempMap);
            }
            pageList.setRows(resultList);
        }
        return pageList;
    }

    private Map<String, String> getDateFormatMap(String tableName) {
        HashMap<String, String> dateFormatMap = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((String)tableName)) {
            List boEntList = this.boEntManager.getByTableName(tableName);
            for (BoEnt boEnt : boEntList) {
                List attr = this.boAttributeManager.getByBoEnt(boEnt);
                for (BoAttribute attribute : attr) {
                    if (!StringUtil.isNotEmpty((String)attribute.getFormat())) continue;
                    dateFormatMap.put(attribute.getFieldName().toUpperCase(), attribute.getFormat());
                    dateFormatMap.put(attribute.getFieldName().toLowerCase(), attribute.getFormat());
                }
            }
        }
        return dateFormatMap;
    }

    private SqlBuilderModel buildSqlBuilderModel(CustomQuery customQuery, String queryData, String dsType) throws IOException {
        ObjectNode jsonObject;
        SqlBuilderModel sqlBuilderModel = new SqlBuilderModel();
        ArrayNode conditionField = JsonUtil.getMapper().createArrayNode();
        HashMap<String, Boolean> treeParamMap = new HashMap<String, Boolean>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)queryData)) {
            ArrayNode jArray = (ArrayNode)JsonUtil.toJsonNode((String)queryData);
            for (int i = 0; i < jArray.size(); ++i) {
                JsonNode jsonNode;
                ObjectNode jSONObject = (ObjectNode)JsonUtil.toJsonNode((Object)jArray.get(i));
                if (!BeanUtils.isNotEmpty((Object)jSONObject.get("value"))) continue;
                String value = jSONObject.get("value").asText();
                if (StringUtil.isNotEmpty((String)value) && value.contains("groovyScript") && (jsonNode = JsonUtil.toJsonNode((String)value)).has("groovyScript")) {
                    BpmRuntimeFeignService runtime = (BpmRuntimeFeignService)AppUtil.getBean(BpmRuntimeFeignService.class);
                    value = (String)runtime.executeScript(jsonNode.get("groovyScript").asText()).getValue();
                }
                if (JsonUtil.getString((JsonNode)jSONObject, (String)"condition", (String)"").equalsIgnoreCase("IN") && StringUtil.isNotEmpty((String)JsonUtil.getString((JsonNode)jSONObject, (String)"value", (String)""))) {
                    jsonObject = JsonUtil.getMapper().createObjectNode();
                    jsonObject.put("field", JsonUtil.getString((JsonNode)jSONObject, (String)"key", (String)""));
                    jsonObject.put("condition", JsonUtil.getString((JsonNode)jSONObject, (String)"condition", (String)""));
                    jsonObject.put("op", JsonUtil.getString((JsonNode)jSONObject, (String)"condition", (String)"IN"));
                    jsonObject.put("value", value);
                    jsonObject.put("dbType", this.getDataType(customQuery, JsonUtil.getString((JsonNode)jSONObject, (String)"key", (String)"")));
                    conditionField.add((JsonNode)jsonObject);
                    continue;
                }
                JsonNode treeParamNode = jSONObject.get("treeParam");
                if (treeParamNode != null) {
                    treeParamMap.put(jSONObject.get("key").asText(), treeParamNode.asBoolean());
                }
                params.put(jSONObject.get("key").asText(), value);
            }
        }
        sqlBuilderModel.setDbType(dsType);
        sqlBuilderModel.setFromName(customQuery.getObjName());
        sqlBuilderModel.setResultField((ArrayNode)JsonUtil.toJsonNode((String)customQuery.getResultfield()));
        ArrayNode confilJA = (ArrayNode)JsonUtil.toJsonNode((String)customQuery.getConditionfield());
        try {
            ArrayNode queryDataArry = (ArrayNode)JsonUtil.toJsonNode((String)queryData);
            if (BeanUtils.isNotEmpty((Object)queryDataArry) && queryDataArry.size() > 0) {
                for (Object object1 : queryDataArry) {
                    ObjectNode qObj = (ObjectNode)JsonUtil.toJsonNode(object1);
                    boolean isIn = false;
                    for (Object object2 : confilJA) {
                        ObjectNode confObj = (ObjectNode)JsonUtil.toJsonNode(object2);
                        if (!qObj.get("key").asText().equalsIgnoreCase(confObj.get("field").asText()) && !qObj.get("key").asText().equalsIgnoreCase(confObj.get("comment").asText())) continue;
                        isIn = true;
                    }
                    if (isIn || treeParamMap.containsKey(qObj.get("key").asText())) continue;
                    this.getMoreConditionField(customQuery.getResultfield(), qObj, confilJA);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Set paramKeys = params.keySet();
        for (int i = 0; i < confilJA.size(); ++i) {
            ObjectNode jObject = (ObjectNode)JsonUtil.toJsonNode((Object)confilJA.get(i));
            String field = JsonUtil.getString((JsonNode)jObject, (String)"field");
            String defaultType = JsonUtil.getString((JsonNode)jObject, (String)"defaultType");
            String defaultValue = JsonUtil.getString((JsonNode)jObject, (String)"defaultValue");
            String dbType = JsonUtil.getString((JsonNode)jObject, (String)"dbType");
            String condition = JsonUtil.getString((JsonNode)jObject, (String)"condition");
            Object value = null;
            ObjectNode jsonObject2 = JsonUtil.getMapper().createObjectNode();
            jsonObject2.put("field", field);
            jsonObject2.put("op", condition);
            jsonObject2.put("dbType", dbType);
            if (QueryOP.IS_NULL.value().equals(condition) || QueryOP.NOTNULL.value().equals(condition)) {
                conditionField.add((JsonNode)jsonObject2);
                continue;
            }
            value = CustomUtil.buildValue(field, defaultType, defaultValue, params);
            if (BeanUtils.isEmpty((Object)value) || value instanceof String && (StringUtil.isEmpty((String)value.toString()) || value.toString().equals("|"))) continue;
            if (condition.equals(QueryOP.BETWEEN.toString())) {
                value = CustomUtil.handleDateBetweenValue(value);
            }
            jsonObject2.set("value", JsonUtil.toJsonNode((Object)value));
            if (treeParamMap.containsKey(field) && !((Boolean)treeParamMap.get(field)).booleanValue()) continue;
            conditionField.add((JsonNode)jsonObject2);
            paramKeys.remove(field);
        }
        if (BeanUtils.isNotEmpty(paramKeys)) {
            for (String paramKey : paramKeys) {
                jsonObject = JsonUtil.getMapper().createObjectNode();
                Object value = params.get(paramKey);
                if (BeanUtils.isEmpty(value)) continue;
                jsonObject.put("field", paramKey);
                jsonObject.put("condition", "");
                jsonObject.put("op", "EQ");
                jsonObject.put("value", JsonUtil.toJsonNode(value));
                jsonObject.put("dbType", this.getDataType(customQuery, paramKey));
                conditionField.add((JsonNode)jsonObject);
            }
        }
        sqlBuilderModel.setConditionField(conditionField);
        sqlBuilderModel.setSortField((ArrayNode)JsonUtil.toJsonNode((String)customQuery.getSortfield()));
        return sqlBuilderModel;
    }

    private String getDataType(CustomQuery customQuery, String key) throws IOException {
        String dataType = null;
        String resultfield = customQuery.getResultfield();
        JsonNode jsonNode = JsonUtil.toJsonNode((String)resultfield);
        if (jsonNode instanceof ArrayNode) {
            ArrayNode resultfieldArray = (ArrayNode)jsonNode;
            for (JsonNode node : resultfieldArray) {
                if (!key.equalsIgnoreCase(JsonUtil.getString((JsonNode)node, (String)"field", (String)""))) continue;
                dataType = JsonUtil.getString((JsonNode)node, (String)"columnType", (String)"varchar");
            }
        }
        Assert.notNull(dataType, (String)StrUtil.format((CharSequence)"\u63a5\u53e3\u8fd4\u56de\u63a5\u53e3\u91cc\u9762\u9700\u8981\u914d\u7f6e{}\u7684\u8fd4\u56de\u5b57\u6bb5", (Object[])new Object[]{key}));
        return dataType;
    }

    private void getMoreConditionField(String resultField, ObjectNode qObj, ArrayNode confilJA) throws IOException {
        ArrayNode resultFields = (ArrayNode)JsonUtil.toJsonNode((String)resultField);
        for (Object object : resultFields) {
            ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode(object);
            if (!obj.get("comment").asText().equals(qObj.get("key").asText())) continue;
            ObjectNode newCondi = JsonUtil.getMapper().createObjectNode();
            newCondi.put("field", obj.get("field").asText());
            newCondi.put("comment", obj.get("comment").asText());
            newCondi.put("condition", "LK");
            newCondi.put("dbType", "varchar");
            newCondi.put("defaultType", 2);
            newCondi.put("defaultValue", qObj.get("value").asText());
            confilJA.add((JsonNode)newCondi);
            break;
        }
    }

    private String getSql(CustomQuery customQuery, String queryData, String dsType) throws IOException {
        String sql = "";
        if (customQuery.getSqlBuildType() == 1) {
            HashMap params = new HashMap();
            if (StringUtil.isNotEmpty((String)queryData)) {
                ArrayNode json = (ArrayNode)JsonUtil.toJsonNode((String)queryData);
                HashMap<String, String> tmp = new HashMap<String, String>();
                boolean isEmpty = true;
                for (JsonNode jsonObj : json) {
                    tmp.put(jsonObj.get("key").asText(), jsonObj.get("value").asText());
                    isEmpty = false;
                }
                if (!isEmpty) {
                    params.put("map", tmp);
                    params.putAll(tmp);
                }
            }
            BpmRuntimeFeignService runtime = (BpmRuntimeFeignService)AppUtil.getBean(BpmRuntimeFeignService.class);
            params.put("runtime", runtime);
            sql = this.groovyScriptEngine.executeString(customQuery.getDiySql(), params);
        } else {
            SqlBuilderModel model = this.buildSqlBuilderModel(customQuery, queryData, dsType);
            sql = this.sqlBuilderService.getSql(model);
        }
        return sql;
    }

    @Override
    public CustomQuery getByAlias(String alias) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("alias_", (Object)alias, QueryOP.EQUAL, FieldRelation.AND);
        PageList list = this.query(queryFilter);
        List customQueries = list.getRows();
        if (customQueries == null || customQueries.isEmpty()) {
            return null;
        }
        return (CustomQuery)((Object)customQueries.get(0));
    }

    @Override
    public ArrayNode getTableOrViewByDsName(CustomQueryControllerVo vo) throws Exception {
        ArrayNode jsonArray = JsonUtil.getMapper().createArrayNode();
        if ("1".equals(vo.getIsTable())) {
            Map map = (Map)this.databaseContext.switchDS(vo.getDsalias(), dResult -> {
                BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                return baseTableMeta.getTablesByName(vo.getObjName());
            });
            String tenantCode = this.tenantHandler.getTenantCode();
            List ignoreTableNames = this.tenantHandler.getIgnoreTableNames();
            Pattern regex = null;
            if (StringUtil.isNotEmpty((String)tenantCode)) {
                String exp = String.format("^%s(%s)_.*$", "W_".toLowerCase(), tenantCode.toLowerCase());
                regex = Pattern.compile(exp);
            }
            for (String key : map.keySet()) {
                Matcher matcher;
                if (ignoreTableNames.stream().anyMatch(e -> e.equalsIgnoreCase(key)) || key.toLowerCase().startsWith("W_".toLowerCase()) && regex != null && ((matcher = regex.matcher(key.toLowerCase())) == null || !matcher.find())) continue;
                ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
                jsonObject.put("name", key.toString());
                jsonObject.put("comment", BeanUtils.isNotEmpty(map.get(key)) ? ((String)map.get(key)).toString() : key.toString());
                jsonArray.add((JsonNode)jsonObject);
            }
        } else {
            PageList viewNames = (PageList)this.databaseContext.switchDS(vo.getDsalias(), dResult -> {
                IViewOperator iViewOperator = MetaDataUtil.getIViewOperatorAfterSetDT((String)dResult.getDbType());
                try {
                    return iViewOperator.getViews(vo.getObjName());
                }
                catch (Exception e) {
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
            });
            for (String name : viewNames.getRows()) {
                ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
                jsonObject.put("name", name);
                jsonObject.put("comment", name);
                jsonArray.add((JsonNode)jsonObject);
            }
        }
        return jsonArray;
    }

    @Override
    public String export(String[] idList) throws Exception {
        if (BeanUtils.isEmpty((Object)idList)) {
            return "";
        }
        ArrayList<Model> list = new ArrayList<Model>();
        for (String s : idList) {
            list.add(this.get((Serializable)((Object)s)));
        }
        if (BeanUtils.isEmpty(list)) {
            return "";
        }
        return JsonUtil.toJson(list);
    }

    @Override
    @Transactional
    public boolean importFile(String unZipFilePath, String typeId) throws Exception {
        try {
            String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "customQuery.json"));
            List customQueries = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<CustomQuery>>(){});
            ArrayList byAliases = new ArrayList();
            this.importCheck(customQueries, byAliases::add);
            if (byAliases.size() > 0) {
                return false;
            }
            ObjectNode sysTypeNode = this.portalFeignService.getSysTypeById(typeId);
            String typeName = sysTypeNode.get("name").asText("");
            for (CustomQuery customQuery : customQueries) {
                customQuery.setTypeId(typeId);
                customQuery.setTypeName(typeName);
                customQuery.setId(UniqueIdUtil.getSuid());
                ((CustomQueryDao)this.baseMapper).insert((Object)customQuery);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return true;
    }

    @Override
    @Transactional
    public CommonResult importFileData(String unZipFilePath, String status, String typeId) {
        List<Object> noRightNames = new ArrayList();
        try {
            String json = FileUtil.readFile((String)(Base64.getFromBase64Replace((String)unZipFilePath) + File.separator + "customQuery.json"));
            List customQueries = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<CustomQuery>>(){});
            noRightNames = this.importData(customQueries, status, typeId, false);
        }
        catch (Exception e) {
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                File formDir;
                String unZipFilePathStr = Base64.getFromBase64((String)unZipFilePath);
                if (StringUtil.isNotEmpty((String)unZipFilePathStr) && (formDir = new File(unZipFilePathStr)).exists()) {
                    FileUtil.deleteDir((File)formDir);
                }
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25");
            }
        }
        CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
        if (BeanUtils.isNotEmpty(noRightNames)) {
            commonResult.setMessage(String.format("\u5bfc\u5165\u6210\u529f\uff0c\u4ee5\u4e0b\u6570\u636e\u65e0\u6743\u9650\u5bfc\u5165\uff0c\u5df2\u8df3\u8fc7\uff1a[%s]", StringUtil.join(noRightNames)));
        }
        return commonResult;
    }

    @Override
    public CommonResult saveDialogByQuery(String json) throws Exception {
        String resultMsg;
        CustomDialog customDialog = null;
        if (!StringUtil.isEmpty((String)json)) {
            ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)json);
            String displayfield = node.get("resultfield") + "";
            String resultfield = node.get("resultfield") + "";
            String sortfield = node.get("sortfield") + "";
            ArrayNode conditionfield = JsonUtil.createArrayNode();
            if (node.get("conditionfield").isArray()) {
                JsonNode conditionfields = node.get("conditionfield");
                Iterator elements = conditionfields.elements();
                while (elements.hasNext()) {
                    JsonNode element = (JsonNode)elements.next();
                    if (!element.isObject()) continue;
                    ObjectNode ele = (ObjectNode)element;
                    String defaultType = ele.get("defaultType").asText();
                    ele.put("defaultType", this.getDialogDefaultType(defaultType));
                    conditionfield.add((JsonNode)ele);
                }
            }
            node.remove("conditionfield");
            node.remove("displayfield");
            node.remove("resultfield");
            node.remove("sortfield");
            customDialog = (CustomDialog)((Object)JsonUtil.toBean((JsonNode)node, CustomDialog.class));
            customDialog.setDisplayfield(displayfield);
            customDialog.setConditionfield(conditionfield.toString());
            customDialog.setResultfield(resultfield);
            customDialog.setSortfield(sortfield);
            customDialog.setStyle(new Short("0"));
            customDialog.setSelectNum(1);
            customDialog.setHeight(800);
            customDialog.setWidth(800);
            ObjectNode sysType = this.portalFeignService.getSysTypeByType("DIALOG_TYPE", "default");
            if (BeanUtils.isNotEmpty((Object)sysType) && sysType.get("id") != null && sysType.get("name") != null) {
                customDialog.setTypeId(sysType.get("id").asText());
                customDialog.setTypeName(sysType.get("name").asText());
            }
        }
        CustomDialog entity = new CustomDialog();
        if (StringUtil.isNotEmpty((String)customDialog.getAlias())) {
            entity = this.customDialogManager.getByAlias(customDialog.getAlias());
        }
        if (BeanUtils.isEmpty((Object)((Object)entity))) {
            if (this.customDialogManager.getByAlias(customDialog.getAlias()) != null) {
                return new CommonResult(false, customDialog.getAlias() + "\uff0c\u5df2\u5b58\u5728", null);
            }
            customDialog.setId(UniqueIdUtil.getSuid());
            customDialog.setCreateTime(LocalDateTime.now());
            customDialog.setUpdateTime(DateUtil.getCurrentDate());
            customDialog.setCreateBy(ContextUtil.getCurrentUserId());
            this.customDialogManager.create((Model)customDialog);
            resultMsg = "\u6dfb\u52a0\u6210\u529f";
        } else {
            try {
                CustomUtil.checkEditRight(CustomDialog.class, ResourceModelType.CUSTOM_DIALOG, entity.getAlias());
            }
            catch (Exception e) {
                if (e instanceof PermissionDeniedException) {
                    return new CommonResult(false, "\u6dfb\u52a0\u5931\u8d25\uff1a\u8be5\u522b\u540d\u7684\u5bf9\u8bdd\u6846\u5df2\u5b58\u5728\uff0c\u5e76\u4e14\u60a8\u6ca1\u6709\u7f16\u8f91\u6743\u9650", null);
                }
                throw e;
            }
            customDialog.setCreateBy(entity.getCreateBy());
            customDialog.setId(entity.getId());
            customDialog.setUpdateTime(LocalDateTime.now());
            this.customDialogManager.update((Model)customDialog);
            resultMsg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(true, resultMsg, null);
    }

    private String getDialogDefaultType(String defaultType) {
        HashMap defaultTypeMapping = Maps.newHashMap();
        defaultTypeMapping.put("1", "3");
        defaultTypeMapping.put("2", "2");
        defaultTypeMapping.put("3", "5");
        defaultTypeMapping.put("", "1");
        return (String)defaultTypeMapping.get(defaultType);
    }

    @Override
    public CommonResult saveQueryByDialog(String json) throws Exception {
        CustomQuery customQuery = this.queryByDialog(json);
        String resultMsg = null;
        CustomQuery entity = new CustomQuery();
        if (StringUtil.isNotEmpty((String)customQuery.getAlias())) {
            entity = this.getByAlias(customQuery.getAlias());
        }
        if (BeanUtils.isEmpty((Object)((Object)entity))) {
            if (this.getByAlias(customQuery.getAlias()) != null) {
                return new CommonResult(false, customQuery.getAlias() + "\uff0c\u5df2\u5b58\u5728", null);
            }
            customQuery.setId(UniqueIdUtil.getSuid());
            ObjectNode sysType = this.portalFeignService.getSysTypeByType("Query_TYPE", "default");
            if (BeanUtils.isNotEmpty((Object)sysType) && sysType.get("id") != null && sysType.get("name") != null) {
                customQuery.setTypeId(sysType.get("id").asText());
                customQuery.setTypeName(sysType.get("name").asText());
            }
            this.create((Model)customQuery);
            resultMsg = "\u6dfb\u52a0\u6210\u529f";
        } else {
            try {
                CustomUtil.checkEditRight(CustomQuery.class, ResourceModelType.CUSTOM_QUERY, entity.getAlias());
            }
            catch (Exception e) {
                if (e instanceof PermissionDeniedException) {
                    return new CommonResult(false, "\u6dfb\u52a0\u5931\u8d25\uff1a\u8be5\u522b\u540d\u7684\u5173\u8054\u67e5\u8be2\u5df2\u5b58\u5728\uff0c\u5e76\u4e14\u60a8\u6ca1\u6709\u7f16\u8f91\u6743\u9650", null);
                }
                throw e;
            }
            customQuery.setId(entity.getId());
            this.update((Model)customQuery);
            resultMsg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(true, resultMsg, null);
    }

    @Override
    public ObjectNode getTable(CustomQueryControllerVo vo, Optional<Boolean> flag) {
        ObjectNode result = (ObjectNode)this.databaseContext.switchDS(vo.getDsalias(), dResult -> {
            ObjectNode resultTemp = null;
            try {
                resultTemp = JsonUtil.getMapper().createObjectNode();
                Table table = null;
                if (vo.getIsTable().equals("1")) {
                    BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                    try {
                        table = baseTableMeta.getTableByName(vo.getObjName());
                    }
                    catch (Exception e) {
                        throw new BaseException("\u627e\u4e0d\u5230\u540d\u4e3a" + vo.getObjName() + "\u7684\u7269\u7406\u8868\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664");
                    }
                }
                IViewOperator iViewOperator = MetaDataUtil.getIViewOperatorAfterSetDT((String)dResult.getDbType());
                try {
                    table = iViewOperator.getModelByViewName(vo.getObjName());
                }
                catch (Exception e) {
                    throw new BaseException("\u627e\u4e0d\u5230\u540d\u4e3a" + vo.getObjName() + "\u7684\u7269\u7406\u8868\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664");
                }
                boolean isFlag = true;
                if (BeanUtils.isNotEmpty((Object)flag)) {
                    isFlag = flag.orElse(true);
                }
                if (BeanUtils.isNotEmpty((Object)table.getColumnList())) {
                    for (Column column : table.getColumnList()) {
                        if (!column.getIsPk()) continue;
                        if (isFlag || !"int".equals(column.getColumnType()) && !"number".equals(column.getColumnType()) || column.getIntLen() >= 19) break;
                        throw new BaseException("\u5f53\u524d\u8868\u4e3b\u952e\u7c7b\u578b\u4e3a\u6570\u5b57\uff0c\u4e14\u957f\u5ea6\u5c0f\u4e8e19\uff0c\u65e0\u6cd5\u5e94\u7528\u7cfb\u7edf\u4e3b\u952e\u751f\u6210\u89c4\u5219\uff0c\u6dfb\u52a0\u5931\u8d25\uff01 ");
                    }
                }
                try {
                    resultTemp.set("table", JsonUtil.toJsonNode((Object)table));
                }
                catch (IOException e) {
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            return resultTemp;
        }, e -> {
            throw new BaseException(e.getMessage(), (Throwable)e);
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importCustom(MultipartHttpServletRequest request, HttpServletResponse response, String typeId) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)typeId), (String)"\u8bf7\u9009\u62e9\u5206\u7c7b");
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        boolean isRepeat = true;
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            unZipFilePath = ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            isRepeat = this.importFile(unZipFilePath, typeId);
            if (!isRepeat) {
                CommonResult commonResult = new CommonResult(true, "confirmUpload", (Object)Base64.getBase64Replace((String)unZipFilePath));
                return commonResult;
            }
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && isRepeat && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }

    @Override
    public CommonResult saveCustomQuery(String json) throws Exception {
        CustomQuery customQuery = this.getCustomQuery(json);
        String resultMsg = null;
        if (StringUtil.isEmpty((String)customQuery.getId())) {
            if (this.getByAlias(customQuery.getAlias()) != null) {
                return new CommonResult(false, "\u522b\u540d" + customQuery.getAlias() + "\uff0c\u5df2\u5b58\u5728", null);
            }
            customQuery.setId(UniqueIdUtil.getSuid());
            this.create((Model)customQuery);
            resultMsg = "\u6dfb\u52a0\u6210\u529f";
        } else {
            this.update((Model)customQuery);
            resultMsg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(true, resultMsg, null);
    }

    @Override
    public PageList doQuery(Optional<String> alias, Optional<String> queryData, Optional<Integer> page) throws Exception {
        CustomQuery customQuery = this.getByAlias(alias.orElse(null));
        if (customQuery == null) {
            return null;
        }
        if ("restful".equals(customQuery.getDsType())) {
            PageList pageList = new PageList();
            Object customQueryRestful = this.getCustomQueryRestful(customQuery, null);
            if (customQueryRestful instanceof String) {
                try {
                    pageList = (PageList)JsonUtil.toBean((String)((String)customQueryRestful), PageList.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (customQueryRestful instanceof PageList) {
                pageList = (PageList)customQueryRestful;
            }
            return pageList;
        }
        if (Short.valueOf("0").equals(customQuery.getIsTable())) {
            try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                PageList pageList = this.getData(customQuery, queryData.orElse(null), this.databaseContext.getDbTypeByAlias(customQuery.getDsalias()), (Integer)page.orElse(null), customQuery.getPageSize());
                return pageList;
            }
        }
        return this.getData(customQuery, queryData.orElse(null), this.databaseContext.getDbTypeByAlias(customQuery.getDsalias()), (Integer)page.orElse(null), customQuery.getPageSize());
    }

    @Override
    public Object doCustomQuery(Optional<String> alias, Optional<String> queryData, Optional<Integer> page) throws Exception {
        CustomQuery customQuery = this.getByAlias(alias.orElse(null));
        if (customQuery == null) {
            return null;
        }
        if ("dataSource".equals(customQuery.getDsType())) {
            if (Short.valueOf("0").equals(customQuery.getIsTable())) {
                try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                    PageList pageList = this.getData(customQuery, queryData.orElse(null), this.databaseContext.getDbTypeByAlias(customQuery.getDsalias()), (Integer)page.orElse(null), customQuery.getPageSize());
                    return pageList;
                }
            }
            return this.getData(customQuery, queryData.orElse(null), this.databaseContext.getDbTypeByAlias(customQuery.getDsalias()), (Integer)page.orElse(null), customQuery.getPageSize());
        }
        if ("selectedApi".equals(customQuery.getDsType())) {
            return this.portalFeignService.executeIntefaceJob(customQuery.getApiAlias(), null, null, (String)queryData.orElse(null));
        }
        if ("restful".equals(customQuery.getDsType())) {
            Object response = this.getCustomQueryRestful(customQuery, queryData.orElse(null));
            if (response != null) {
                response = this.handleResponse(customQuery, JsonUtil.toJsonNode((String)response.toString()));
            }
            return response;
        }
        throw new BaseException("\u672a\u5339\u914d\u5230\u6570\u636e\u6765\u6e90\u7c7b\u578b");
    }

    private Object handleResponse(CustomQuery customQuery, JsonNode result) {
        try {
            String listKey = customQuery.getListKey();
            if (StringUtil.isNotEmpty((String)listKey)) {
                result = this.getResult(listKey, result);
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            ArrayNode resultField = (ArrayNode)JsonUtil.toJsonNode((String)customQuery.getResultfield());
            for (JsonNode jObject : resultField) {
                String field = jObject.get("field").asText();
                String comment = jObject.get("comment").asText();
                params.put(field, comment);
            }
            if (params.isEmpty()) {
                return result;
            }
            if (result.isArray()) {
                ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
                ArrayNode resultAry = (ArrayNode)result;
                for (JsonNode node : resultAry) {
                    arrayNode.add((JsonNode)this.handleResultField(params, node));
                }
                return arrayNode;
            }
            return this.handleResultField(params, result);
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u8fd4\u56de\u503c\u5f02\u5e38", (Throwable)e);
            return result;
        }
    }

    private JsonNode getResult(String listKey, JsonNode result) {
        if (listKey.contains(".")) {
            String[] data;
            for (String item : data = listKey.split("\\.")) {
                result = result.get(item);
            }
        } else {
            result = result.get(listKey);
        }
        return result;
    }

    private ObjectNode handleResultField(Map<String, Object> params, JsonNode node) {
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            if (!BeanUtils.isNotEmpty((Object)node.get(key))) continue;
            objectNode.set(key, node.get(key));
        }
        return objectNode;
    }

    @Override
    public PageList doQueryBase64(String alias, String queryData, Integer page) throws UnsupportedEncodingException {
        CustomQuery customQuery = this.getByAlias(alias);
        if (customQuery == null) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)queryData)) {
            queryData = Base64.getFromBase64((String)queryData);
            queryData = Base64.getFromBase64((String)queryData);
        }
        try {
            PageList data = this.getData(customQuery, queryData, this.databaseContext.getDbTypeByAlias(customQuery.getDsalias()), page, customQuery.getPageSize());
            return data;
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object getCustomQueryRestful(CustomQuery customQuery, Object params) throws Exception {
        String authorization;
        Pattern pattern = Pattern.compile("(\\$\\{[^\\}]+})");
        StringBuilder url = new StringBuilder(customQuery.getUrl());
        List result = this.portalFeignService.getServiceList();
        Matcher matcher = pattern.matcher(url.toString());
        HashMap microServiceMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            for (ObjectNode on : result) {
                microServiceMap.put(on.get("sysCode").asText(), on.get("rootAddress").asText());
            }
        }
        while (matcher.find()) {
            String group = matcher.group(1);
            String paramName = group.replaceAll("\\$", "").replaceAll("\\{", "").replaceAll("\\}", "");
            url = new StringBuilder(url.toString().replace("${" + paramName + "}", microServiceMap.getOrDefault(paramName, "")));
        }
        HttpServletRequest request = HttpUtil.getRequest();
        ObjectNode headerNode = JsonUtil.createObjectNode();
        try {
            headerNode = (ObjectNode)JsonUtil.toJsonNode((String)customQuery.getHeader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (BeanUtils.isNotEmpty((Object)headerNode) && BeanUtils.isNotEmpty((Object)request) && StringUtil.isNotEmpty((String)(authorization = request.getHeader("Authorization")))) {
            headerNode.put("Authorization", authorization);
        }
        String conditionField = customQuery.getConditionfield();
        HashMap<String, String> dataParamMap = new HashMap<String, String>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (params != null) {
            if (params instanceof QueryFilter) {
                QueryFilter filter = (QueryFilter)params;
                if (BeanUtils.isNotEmpty((Object)filter) && BeanUtils.isNotEmpty((Object)filter.getQuerys())) {
                    List querys = filter.getQuerys();
                    for (QueryField query : querys) {
                        resultMap.put(query.getProperty(), query.getValue());
                    }
                }
            } else if (params instanceof String && StringUtil.isNotEmpty((String)params.toString())) {
                ArrayNode json = (ArrayNode)JsonUtil.toJsonNode((String)params.toString());
                HashMap<String, String> tmp = new HashMap<String, String>();
                boolean isEmpty = true;
                for (JsonNode jsonObj : json) {
                    tmp.put(jsonObj.get("key").asText(), jsonObj.get("value").asText());
                    isEmpty = false;
                }
                if (!isEmpty) {
                    resultMap.put("map", tmp);
                    resultMap.putAll(tmp);
                }
            }
        }
        try {
            ArrayNode conditionfieldNode = (ArrayNode)JsonUtil.toJsonNode((String)conditionField);
            RestfulQueryParam restfulQueryParam = new RestfulQueryParam();
            restfulQueryParam.setUrl(url.toString());
            ArrayList<RequestParam> paramList = new ArrayList<RequestParam>();
            for (JsonNode jsonNode : conditionfieldNode) {
                String defaultType = JsonUtil.getString((JsonNode)jsonNode, (String)"defaultType");
                String defaultValue = JsonUtil.getString((JsonNode)jsonNode, (String)"defaultValue");
                String paramType = JsonUtil.getString((JsonNode)jsonNode, (String)"paramType");
                String field = JsonUtil.getString((JsonNode)jsonNode, (String)"field");
                String value = "";
                if ("2".equals(defaultType)) {
                    value = defaultValue;
                } else if (MapUtil.containsIgnoreKey(resultMap, (String)field)) {
                    value = MapUtil.getIgnoreCase(resultMap, (String)field).toString();
                }
                if (String.valueOf(RequestParam.PATH_INPUT).equals(paramType)) {
                    RequestParam requestParam = new RequestParam();
                    requestParam.setKey(field);
                    requestParam.setValue(value);
                    requestParam.setParamType(RequestParam.PATH_INPUT);
                    paramList.add(requestParam);
                    continue;
                }
                dataParamMap.put(field, value);
            }
            restfulQueryParam.setParams(paramList);
            this.parseRequestUrl(restfulQueryParam);
            url = new StringBuilder(restfulQueryParam.getUrl());
        }
        catch (Exception conditionfieldNode) {
            // empty catch block
        }
        String dataParam = customQuery.getDataParam();
        for (String s : dataParamMap.keySet()) {
            if (!BeanUtils.isNotEmpty((Object)dataParam)) continue;
            dataParam = dataParam.replace("${" + s + "}", dataParamMap.getOrDefault(s, ""));
        }
        ObjectNode dataParamNode = JsonUtil.createObjectNode();
        try {
            dataParamNode = (ObjectNode)JsonUtil.toJsonNode((String)dataParam);
        }
        catch (Exception s) {
            // empty catch block
        }
        Object o = new Object();
        if ("POST".equals(customQuery.getRequestType())) {
            o = FluentUtil.post((String)url.toString(), (String)Base64.getBase64((String)JsonUtil.toJson((Object)headerNode)), (Object)dataParamNode);
        } else {
            if (BeanUtils.isNotEmpty(dataParamMap)) {
                url.append("?");
                for (String key : dataParamMap.keySet()) {
                    String value = (String)dataParamMap.get(key);
                    if (!BeanUtils.isNotEmpty((Object)value)) continue;
                    url.append(key).append("=").append(value).append("&");
                }
                url.delete(url.length() - 1, url.length());
            }
            o = FluentUtil.get((String)url.toString(), (String)Base64.getBase64((String)JsonUtil.toJson((Object)headerNode)));
        }
        return o;
    }

    @Override
    public PageList getQueryPage(String alias) {
        PageList pageList = new PageList();
        CustomQuery customQuery = this.getByAlias(alias);
        if (customQuery == null) {
            return null;
        }
        try {
            customQuery.setNeedPage(0);
            pageList = this.getData(customQuery, null, this.databaseContext.getDbTypeByAlias(customQuery.getDsalias()), 1, 20);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        return pageList;
    }

    private CustomQuery queryByDialog(String json) throws Exception {
        CustomQuery customQuery = null;
        ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)json);
        String conditionfield = node.get("conditionfield").toString();
        String resultfield = node.get("displayfield").toString();
        String sortfield = node.get("sortfield").toString();
        String header = JsonUtil.getString((JsonNode)node, (String)"header");
        node.remove("conditionfield");
        node.remove("resultfield");
        node.remove("sortfield");
        customQuery = (CustomQuery)((Object)JsonUtil.toBean((JsonNode)node, CustomQuery.class));
        customQuery.setConditionfield(conditionfield);
        customQuery.setResultfield(resultfield);
        customQuery.setSortfield(sortfield);
        if (BeanUtils.isNotEmpty((Object)node.get("needPage"))) {
            customQuery.setNeedPage(node.get("needPage").asInt());
        }
        if (StringUtil.isNotEmpty((String)header)) {
            customQuery.setHeader(header);
        }
        customQuery.setPageSize(10);
        return customQuery;
    }

    private CustomQuery getCustomQuery(String json) throws Exception {
        CustomQuery customQuery = null;
        ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)json);
        String conditionfield = node.get("conditionfield").toString();
        String resultfield = node.get("resultfield").toString();
        String sortfield = node.get("sortfield").toString();
        String header = JsonUtil.getString((JsonNode)node, (String)"header");
        node.remove("conditionfield");
        node.remove("resultfield");
        node.remove("sortfield");
        customQuery = (CustomQuery)((Object)JsonUtil.toBean((JsonNode)node, CustomQuery.class));
        customQuery.setConditionfield(conditionfield);
        customQuery.setResultfield(resultfield);
        customQuery.setSortfield(sortfield);
        if (StringUtil.isNotEmpty((String)header)) {
            customQuery.setHeader(header);
        }
        return customQuery;
    }

    @Override
    public void importCheck(List<CustomQuery> customQueries, Consumer<CustomQuery> existConsumer) {
        for (CustomQuery customDialog : customQueries) {
            CustomQuery byAlias = this.getByAlias(customDialog.getAlias());
            if (byAlias == null) continue;
            existConsumer.accept(byAlias);
        }
    }

    @Override
    public List<String> importData(List<CustomQuery> customQueries, String status, String typeId, boolean ignoreRight) throws IOException {
        HashMap<String, Boolean> rightMap = new HashMap();
        ArrayList<String> noRightNames = new ArrayList<String>();
        if ("cover".equals(status)) {
            rightMap = CustomUtil.getRightMapByModel(this.getCurrentModelClass(), ResourceModelType.CUSTOM_QUERY, ResourcesRightType.EDIT);
        }
        ObjectNode sysTypeNode = this.portalFeignService.getSysTypeById(typeId);
        String typeName = sysTypeNode.get("name").asText("");
        for (CustomQuery customQuery : customQueries) {
            customQuery.setTypeId(typeId);
            customQuery.setTypeName(typeName);
            CustomQuery byAlias = this.getByAlias(customQuery.getAlias());
            if (BeanUtils.isEmpty((Object)((Object)byAlias))) {
                customQuery.setId(UniqueIdUtil.getSuid());
                ((CustomQueryDao)this.baseMapper).insert((Object)customQuery);
                continue;
            }
            if (!"cover".equals(status) && !ignoreRight) continue;
            if (CustomUtil.checkRight(rightMap, customQuery.getAlias())) {
                customQuery.setId(byAlias.getId());
                ((CustomQueryDao)this.baseMapper).updateById((Object)customQuery);
                continue;
            }
            noRightNames.add(customQuery.getName());
        }
        return noRightNames;
    }

    @Override
    public JsonNode doQueryByRest(RestfulQueryParam queryParam) throws Exception {
        HttpMethod httpMethod = HttpMethod.resolve((String)queryParam.getMethod().toUpperCase());
        Assert.notNull((Object)httpMethod, (String)"\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5");
        this.parseRequestUrl(queryParam);
        RestTemplate httpsTemplate = (RestTemplate)AppUtil.getBean((String)"httpsTemplate");
        if (httpsTemplate == null) {
            throw new BaseException("\u627e\u4e0d\u5230http\u5ba2\u6237\u7aef");
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpHeaders.setBearerAuth(HttpUtil.getToken());
        httpHeaders.setAccept(Collections.singletonList(MediaType.ALL));
        this.handlerHeaders(httpHeaders, queryParam.getHeaders());
        HttpEntity httpEntity = Objects.nonNull(queryParam.getData()) ? new HttpEntity((Object)JsonUtil.toJsonString((Object)queryParam.getData()), (MultiValueMap)httpHeaders) : new HttpEntity((MultiValueMap)httpHeaders);
        ResponseEntity responseEntity = httpsTemplate.exchange(URI.create(queryParam.getUrl()), httpMethod, httpEntity, String.class);
        if (!HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
            this.logger.error("queryParam\u53c2\u6570\uff1a{}", (Object)JsonUtil.toJson((Object)queryParam));
            this.logger.error("\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u72b6\u6001\u4e3a\uff1a{}", (Object)responseEntity.getStatusCodeValue());
            this.logger.error("\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", responseEntity.getBody());
            throw new BaseException("\u8bf7\u6c42\u63a5\u53e3\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a" + (String)responseEntity.getBody());
        }
        if (responseEntity.getBody() == null) {
            return null;
        }
        return JsonUtil.toJsonNode((String)((String)responseEntity.getBody()));
    }

    @Override
    public void exportQueryByRest(RestfulQueryParam queryParam, HttpServletResponse response) throws Exception {
        JsonNode jsonNode = this.doQueryByRest(queryParam);
        String[] path = queryParam.getListKey().split("\\.");
        ArrayNode data = null;
        for (int i = 0; i < path.length && jsonNode != null; ++i) {
            if (i == path.length - 1) {
                data = (ArrayNode)jsonNode.withArray(path[i]);
                continue;
            }
            jsonNode = jsonNode.get(path[i]);
        }
        ArrayList<Map> list = new ArrayList<Map>();
        for (Object datum : data) {
            list.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)datum)));
        }
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        for (CustomDialogDisplayFieldVo exportField : queryParam.getExportFields()) {
            exportMap.put(exportField.getField(), exportField.getComment());
        }
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u6570\u636e\u5bfc\u51fa", (int)list.size(), exportMap, list);
        ExcelUtil.downloadExcel((Workbook)exportFile, (String)"\u6570\u636e\u5bfc\u51fa", (HttpServletResponse)response);
    }

    private void handlerHeaders(HttpHeaders httpHeaders, Object header) throws IOException {
        Map headers = null;
        if (header instanceof Map) {
            headers = (Map)header;
        } else if (header instanceof String) {
            String headerStr = (String)header;
            if (StringUtil.isEmpty((String)headerStr)) {
                return;
            }
            headers = JsonUtil.toMap((String)headerStr);
        }
        if (headers == null) {
            return;
        }
        headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
    }

    private void parseRequestUrl(RestfulQueryParam queryParam) {
        Map<String, Object> urlParam;
        List<RequestParam> params = queryParam.getParams();
        String url = queryParam.getUrl();
        if (BeanUtils.isEmpty((Object)url) || BeanUtils.isEmpty(params)) {
            return;
        }
        Map<String, Object> pathInputMap = params.stream().filter(item -> StringUtil.isNotEmpty((String)item.getKey())).filter(item -> RequestParam.PATH_INPUT.equals(item.getParamType())).collect(Collectors.toMap(RequestParam::getKey, RequestParam::getValue, (oldValue, newValue) -> oldValue));
        if (BeanUtils.isNotEmpty(params)) {
            if (BeanUtils.isNotEmpty(pathInputMap)) {
                String suffixParam = url.substring(url.indexOf("?") + 1);
                for (String suffix : suffixParam.split("&")) {
                    int indexOf = suffix.indexOf("=");
                    if (indexOf == -1) continue;
                    String key = suffix.substring(0, indexOf);
                    String value = suffix.substring(indexOf + 1);
                    pathInputMap.put(key, value);
                }
            }
            url = this.parsePathParam(pathInputMap, url, "preview".equals(queryParam.getUse()));
        }
        if (BeanUtils.isNotEmpty(urlParam = params.stream().filter(item -> StringUtil.isNotEmpty((String)item.getKey())).filter(item -> item.getParamType() == null && Method.GET.name().equals(queryParam.getMethod()) || RequestParam.PARAM_INPUT.equals(item.getParamType())).collect(Collectors.toMap(RequestParam::getKey, RequestParam::getValue, (oldValue, newValue) -> oldValue)))) {
            url = this.appendUrlParam(urlParam, url);
        }
        queryParam.setUrl(url);
    }

    private String appendUrlParam(Map<String, Object> urlParam, String requestUrl) {
        StringBuilder req = new StringBuilder();
        if (CollectionUtil.isNotEmpty(urlParam)) {
            String[] urls = requestUrl.split("\\?");
            req.append(urls[0]);
            req.append("?");
            req.append(urls.length > 1 ? urls[1] : cn.hutool.http.HttpUtil.toParams(urlParam));
        } else {
            req.append(requestUrl);
        }
        return req.toString();
    }

    private String parsePathParam(Map<String, Object> params, String requestUrl, boolean showError) {
        Pattern varsPattern = Pattern.compile("\\{[^\\}]*\\}");
        Matcher matcher = varsPattern.matcher(requestUrl);
        while (matcher.find()) {
            String replace = matcher.group(0);
            String key = replace.substring(1, replace.length() - 1);
            String newValue = "";
            if (StringUtil.isNotEmpty((String)key) && params.get(key) != null) {
                if (BeanUtils.isEmpty((Object)params.get(key))) {
                    if (showError) {
                        throw new BaseException("\u8def\u5f84\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
                    }
                    newValue = key;
                } else {
                    newValue = String.valueOf(params.get(key));
                }
            }
            requestUrl = requestUrl.replace(replace, newValue);
        }
        return requestUrl;
    }
}

