/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Lists;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.string.StringValidator;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.bo.persistence.manager.BoEntManager;
import com.hotent.form.model.FormDataTemplate;
import com.hotent.form.param.DataTemplateImportResult;
import com.hotent.form.persistence.manager.DataTemplateWorkBookService;
import com.hotent.form.persistence.manager.FormDataTemplateManager;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DataTemplateWorkBookServiceImpl
implements DataTemplateWorkBookService {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_DESC = "desc";
    private static final String FIELD_CHILDREN = "children";
    private static final String FIELD_ROW_INDEX = "rowIndex";
    private static final String FIELD_COL_INDEX = "colIndex";
    private static final String FIELD_BIND_PK = "bindPk";
    private static final String HEAD_PK = "\u4e3b\u952e";
    private static final String HEAD_FK = "\u5916\u952e";
    private static final ThreadLocal<Map<String, BoEnt>> BO_ENT_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<FormDataTemplate> DATA_TEMPLATE_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<Map<String, Map<Integer, String>>> ENT_COL_INDEX_MAP = new ThreadLocal();
    @Value(value="${poi.xlsx.rowAccessWindowSize:100}")
    private Integer rowAccessWindowSize;
    @Resource
    FormDataTemplateManager formDataTemplateManager;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    CommonManager commonManager;
    @Resource
    BoDefManager boDefManager;
    @Resource
    BoEntManager boEntManager;
    private static final Logger logger = LoggerFactory.getLogger(DataTemplateWorkBookServiceImpl.class);

    @Override
    public void downloadTemplate(String templateKey, ObjectNode config, HttpServletResponse response) throws Exception {
        FormDataTemplate template = this.formDataTemplateManager.getByAlias(templateKey);
        Assert.notNull((Object)((Object)template), (String)String.format("\u5bfc\u5165\u5931\u8d25\uff1a\u6839\u636e\u8868\u5355\u5217\u8868key[%s]\u672a\u627e\u5230\u8868\u5355\u5217\u8868", templateKey));
        this.downloadTemplate(template, config, response);
    }

    @Override
    public void downloadTemplate(FormDataTemplate template, ObjectNode config, HttpServletResponse response) throws Exception {
        String fileName = "\u5bfc\u5165\u6a21\u677f.xlsx";
        this.handleResponse(fileName, response);
        XSSFWorkbook workbook = new XSSFWorkbook();
        ArrayNode configArr = (ArrayNode)config.get("config");
        try {
            this.handleInitCmdByBoAlias(template.getBoDefAlias());
            this.handleCreateSheets(configArr, workbook);
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw e;
        }
        finally {
            workbook.close();
            BO_ENT_THREAD_LOCAL.remove();
        }
    }

    private void handleInitCmdByBoAlias(String boDeAlias) {
        BoDef boDef = this.boDefManager.getByAlias(boDeAlias);
        Assert.notNull((Object)boDef, (String)String.format("\u5bfc\u5165\u5931\u8d25\uff1a\u6839\u636e\u5efa\u6a21\u522b\u540d[%s]\u672a\u627e\u5230\u5efa\u6a21", boDeAlias));
        this.handleInitCmd(boDef);
    }

    private void handleInitCmd(BoDef boDef) {
        HashMap<String, BoEnt> entMap = new HashMap<String, BoEnt>(16);
        BoEnt boEnt = boDef.getBoEnt();
        entMap.put(boEnt.getName(), boEnt);
        for (BoEnt child : boEnt.getChildEntList()) {
            entMap.put(child.getName(), child);
            for (BoEnt sunEnt : child.getChildEntList()) {
                entMap.put(sunEnt.getName(), sunEnt);
            }
        }
        BO_ENT_THREAD_LOCAL.set(entMap);
    }

    private void handleCreateSheets(ArrayNode config, XSSFWorkbook workbook) {
        if (null == config || config.isEmpty()) {
            throw new IllegalArgumentException("\u5bfc\u5165\u6a21\u677f\u914d\u7f6e\u5f02\u5e38");
        }
        for (JsonNode mainNode : config) {
            this.doCreateSheet((ObjectNode)mainNode, workbook);
        }
    }

    private void doCreateSheet(ObjectNode node, XSSFWorkbook workbook) {
        String name = JsonUtil.getString((JsonNode)node, (String)FIELD_NAME);
        String desc = JsonUtil.getString((JsonNode)node, (String)FIELD_DESC);
        XSSFSheet sheet = workbook.createSheet(String.format("%s(%s)", desc, name));
        Integer rowIndex = JsonUtil.getInt((JsonNode)node, (String)FIELD_ROW_INDEX, (int)0);
        Integer colIndex = JsonUtil.getInt((JsonNode)node, (String)FIELD_COL_INDEX, (int)0);
        Map<String, BoEnt> entMap = BO_ENT_THREAD_LOCAL.get();
        if (entMap.containsKey(name)) {
            Integer baseColIndex;
            BoEnt boEnt = entMap.get(name);
            XSSFRow row = (XSSFRow)this.getOrCreateRow((Sheet)sheet, rowIndex);
            Integer n = baseColIndex = colIndex;
            baseColIndex = baseColIndex + 1;
            Object object = baseColIndex;
            XSSFCell pkCell = (XSSFCell)this.getOrCreateCell((Row)row, n);
            pkCell.setCellValue(boEnt.getPkKey());
            object = baseColIndex;
            Integer n2 = baseColIndex = Integer.valueOf(baseColIndex + 1);
            XSSFCell fkCell = (XSSFCell)this.getOrCreateCell((Row)row, (Integer)object);
            fkCell.setCellValue(boEnt.getFk());
            for (BoAttribute attribute : boEnt.getBoAttrList()) {
                Integer n3 = baseColIndex;
                Integer n4 = baseColIndex = Integer.valueOf(baseColIndex + 1);
                int curColIndex = n3;
                XSSFCell cell = (XSSFCell)this.getOrCreateCell((Row)row, curColIndex);
                cell.setCellValue(attribute.getDesc());
                this.setColStyle((Sheet)sheet, attribute, curColIndex);
            }
        }
        if (node.has(FIELD_CHILDREN)) {
            ArrayNode children = (ArrayNode)node.get(FIELD_CHILDREN);
            for (JsonNode child : children) {
                this.doCreateSheet((ObjectNode)child, workbook);
            }
        }
    }

    private void setColStyle(Sheet sheet, BoAttribute boAttribute, Integer index) {
        Workbook workbook = sheet.getWorkbook();
        CellStyle style = workbook.createCellStyle();
        String dataType = boAttribute.getDataType();
        CreationHelper creationHelper = workbook.getCreationHelper();
        switch (dataType) {
            case "date": {
                style.setDataFormat(creationHelper.createDataFormat().getFormat(boAttribute.getFormat()));
                break;
            }
            case "number": 
            case "numeric": 
            case "int": {
                int decimalLen = boAttribute.getDecimalLen();
                StringBuilder sb = new StringBuilder("0");
                if (decimalLen > 0) {
                    sb.append(".");
                    for (int i = 0; i < decimalLen; ++i) {
                        sb.append("0");
                    }
                }
                style.setDataFormat(creationHelper.createDataFormat().getFormat(sb.toString()));
                break;
            }
        }
        sheet.setDefaultColumnStyle(index.intValue(), style);
    }

    private Row getOrCreateRow(Sheet sheet, Integer rowIndex) {
        if (null == rowIndex || rowIndex < 0) {
            throw new IllegalArgumentException("\u884c\u5750\u6807\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        }
        Row row = sheet.getRow(rowIndex.intValue());
        if (null == row) {
            row = sheet.createRow(rowIndex.intValue());
        }
        return row;
    }

    private Cell getOrCreateCell(Row row, Integer cellIndex) {
        if (null == cellIndex || cellIndex < 0) {
            throw new IllegalArgumentException("\u5217\u5750\u6807\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        }
        Cell cell = row.getCell(cellIndex.intValue());
        if (null == cell) {
            cell = row.createCell(cellIndex.intValue());
        }
        return cell;
    }

    private void handleResponse(String fileName, HttpServletResponse response) throws Exception {
        String fileDisplay = URLEncoder.encode(fileName, "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileDisplay);
    }

    @Override
    public String importWorkBook(List<MultipartFile> file, String alias) throws Exception {
        XSSFWorkbook workbook;
        if (BeanUtils.isEmpty(file)) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        FormDataTemplate template = this.formDataTemplateManager.getByAlias(alias);
        Assert.notNull((Object)((Object)template), (String)String.format("\u6839\u636e\u8868\u5355\u5217\u8868\u522b\u540d\u3010%s\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u5b9e\u4f53", alias));
        DATA_TEMPLATE_THREAD_LOCAL.set(template);
        MultipartFile multipartFile = file.get(0);
        String name = multipartFile.getOriginalFilename();
        String fileExt = FileUtil.getFileExt((String)name);
        if (!"xlsx".equals(fileExt)) {
            throw new IllegalArgumentException("\u53ea\u80fd\u4e0a\u4f20xlsx\u7c7b\u578b\u6587\u4ef6");
        }
        try (InputStream is = multipartFile.getInputStream();){
            workbook = new XSSFWorkbook(is);
        }
        return this.resolvingAll(alias, workbook);
    }

    private String resolvingAll(String templateKey, XSSFWorkbook workbook) throws Exception {
        Object oldTableField;
        FormDataTemplate template = DATA_TEMPLATE_THREAD_LOCAL.get();
        if (StringUtil.isEmpty((String)template.getManageField())) {
            throw new BaseException("\u672a\u914d\u7f6e\u5bfc\u5165\u6309\u94ae\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e");
        }
        ArrayNode manages = (ArrayNode)JsonUtil.toJsonNode((String)template.getManageField());
        ObjectNode importBtnOption = null;
        for (JsonNode manage : manages) {
            if (!"import".equals(JsonUtil.getString((JsonNode)manage, (String)FIELD_NAME))) continue;
            importBtnOption = (ObjectNode)manage;
            break;
        }
        if (null == importBtnOption) {
            throw new BaseException("\u672a\u914d\u7f6e\u5bfc\u5165\u6309\u94ae\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e");
        }
        BoDef bodef = this.boDefManager.getByAlias(template.getBoDefAlias());
        Assert.notNull((Object)bodef, (String)String.format("\u5bfc\u5165\u5931\u8d25\uff1a\u6839\u636e\u5efa\u6a21\u522b\u540d[%s]\u672a\u627e\u5230\u5efa\u6a21", template.getAlias()));
        String isFormatterData = JsonUtil.getString((JsonNode)importBtnOption, (String)"formatterData", (String)"1");
        HashMap<String, Map<String, Map<String, String>>> filedFormat = new HashMap<String, Map<String, Map<String, String>>>();
        if (StringUtil.isNotEmpty((String)template.getDisplayField())) {
            ArrayNode displayField = (ArrayNode)JsonUtil.toJsonNode((String)template.getDisplayField());
            for (JsonNode field : displayField) {
                if (!BeanUtils.isNotEmpty((Object)field.get("formatterData")) || !isFormatterData.equals("1")) continue;
                ArrayNode formatterData = (ArrayNode)field.get("formatterData");
                HashMap<String, String> formatMap = new HashMap<String, String>();
                for (JsonNode format : formatterData) {
                    formatMap.put(format.get("key_").asText(), format.get("value_").asText());
                }
                if (!BeanUtils.isNotEmpty(formatMap)) continue;
                oldTableField = JsonUtil.getString((JsonNode)field, (String)"oldTableField");
                String tableName = JsonUtil.getString((JsonNode)field, (String)"tableName");
                Object name = bodef.getBoEnt().getFieldPrefix() + field.get(FIELD_NAME).asText();
                if (StringUtil.isNotEmpty((String)oldTableField)) {
                    name = oldTableField;
                }
                if (filedFormat.containsKey(tableName)) {
                    ((Map)filedFormat.get(tableName)).put(name, formatMap);
                    continue;
                }
                HashMap<Object, HashMap<String, String>> map = new HashMap<Object, HashMap<String, String>>();
                map.put(name, formatMap);
                filedFormat.put(tableName, map);
            }
        }
        this.handleInitCmd(bodef);
        ArrayList<DataTemplateImportResult> results = new ArrayList<DataTemplateImportResult>();
        Integer limit = JsonUtil.getInt((JsonNode)importBtnOption, (String)"limit", (int)1000);
        ArrayNode config = (ArrayNode)importBtnOption.get("config");
        HashMap<String, Object> defaultConfigMap = new HashMap<String, Object>();
        if (BeanUtils.isEmpty((Object)config)) {
            List boEnts = this.boEntManager.getByDefId(bodef.getId());
            oldTableField = boEnts.iterator();
            while (oldTableField.hasNext()) {
                BoEnt boEnt = (BoEnt)oldTableField.next();
                if (!boEnt.getType().equals("main")) continue;
                defaultConfigMap.put(FIELD_NAME, boEnt.getName());
                defaultConfigMap.put(FIELD_DESC, boEnt.getDesc());
                defaultConfigMap.put(FIELD_BIND_PK, BoEnt.PK_NAME);
                defaultConfigMap.put(FIELD_CHILDREN, new ArrayList());
                break;
            }
            this.createDataTemplateImportResult((ObjectNode)JsonUtil.toJsonNode(defaultConfigMap), "", results, filedFormat);
        } else {
            for (JsonNode main : config) {
                this.createDataTemplateImportResult((ObjectNode)main, "", results, filedFormat);
            }
        }
        this.resolveWorkBook(workbook, results, limit);
        String cacheId = UniqueIdUtil.getSuid();
        DataTemplateWorkBookService bean = (DataTemplateWorkBookService)AppUtil.getBean(DataTemplateWorkBookService.class);
        if (BeanUtils.isEmpty((Object)config)) {
            this.validateImportDateFkBind((ObjectNode)JsonUtil.toJsonNode(defaultConfigMap), results);
        } else {
            for (JsonNode node : config) {
                this.validateImportDateFkBind((ObjectNode)node, results);
            }
        }
        this.validateImportData(results);
        bean.saveImportCache(cacheId, results);
        return cacheId;
    }

    /*
     * WARNING - void declaration
     */
    private void validateImportDateFkBind(ObjectNode objectNode, List<DataTemplateImportResult> results) {
        Map<String, BoEnt> entMap = BO_ENT_THREAD_LOCAL.get();
        BoEnt boEnt = entMap.get(objectNode.get(FIELD_NAME).asText());
        DataTemplateImportResult dataTemplateImportResult = null;
        for (DataTemplateImportResult dataTemplateImportResult2 : results) {
            if (!dataTemplateImportResult2.getEntName().equals(boEnt.getName())) continue;
            dataTemplateImportResult = dataTemplateImportResult2;
            break;
        }
        if (null != dataTemplateImportResult && BeanUtils.isEmpty((Object)dataTemplateImportResult.getParentBoEntName())) {
            for (DataTemplateImportResult.Result result : dataTemplateImportResult.getResult()) {
                if (result.isState()) continue;
            }
        } else if (null != dataTemplateImportResult) {
            void var7_12;
            BoEnt parentEnt = entMap.get(dataTemplateImportResult.getParentBoEntName());
            Object var7_10 = null;
            for (DataTemplateImportResult result : results) {
                if (!result.getEntName().equals(parentEnt.getName())) continue;
                DataTemplateImportResult dataTemplateImportResult3 = result;
                break;
            }
            if (null == var7_12) {
                throw new BaseException("\u6821\u9a8c\u5f02\u5e38");
            }
            HashSet<String> parentPks = new HashSet<String>();
            for (DataTemplateImportResult.Result result : var7_12.getResult()) {
                String parentPk;
                if (null == result.getDataNode() || !StringUtil.isNotEmpty((String)(parentPk = JsonUtil.getString((JsonNode)result.getDataNode(), (String)parentEnt.getPkKey())))) continue;
                parentPks.add(parentPk);
            }
            for (DataTemplateImportResult.Result result : dataTemplateImportResult.getResult()) {
                if (!result.isState()) continue;
                if (null == result.getDataNode()) {
                    result.setState(false);
                    result.setCause("\u6570\u636e\u4e3a\u7a7a");
                    continue;
                }
                ObjectNode dataNode = result.getDataNode();
                String fk = JsonUtil.getString((JsonNode)dataNode, (String)boEnt.getFk());
                if (StringUtil.isEmpty((String)fk)) {
                    result.setState(false);
                    result.setCause("\u5916\u952e\u4e3a\u7a7a");
                    continue;
                }
                if (parentPks.contains(fk)) continue;
                result.setState(false);
                result.setCause(String.format("\u7ed1\u5b9a\u7684\u5916\u952e\u3010%s\u3011\u5728\u3010%s\u3011\u4e2d\u4e0d\u5b58\u5728", fk, parentEnt.getDesc()));
            }
        }
        if (objectNode.has(FIELD_CHILDREN)) {
            ArrayNode children = (ArrayNode)objectNode.get(FIELD_CHILDREN);
            for (JsonNode child : children) {
                this.validateImportDateFkBind((ObjectNode)child, results);
            }
        }
    }

    private void validateImportData(List<DataTemplateImportResult> importResults) throws Exception {
        for (DataTemplateImportResult importResult : importResults) {
            this.doValidateImportData(importResult);
        }
    }

    private void doValidateImportData(DataTemplateImportResult result) throws Exception {
        String entName = result.getEntName();
        BoEnt boEnt = BO_ENT_THREAD_LOCAL.get().get(entName);
        String dsName = boEnt.getDsName();
        if (StringUtil.isEmpty((String)dsName)) {
            dsName = "LOCAL";
        }
        List values = Collections.synchronizedList(new ArrayList());
        String key = result.getBindPk();
        if (!(BoEnt.PK_NAME.equalsIgnoreCase(key) || BoEnt.FK_NAME.equalsIgnoreCase(key) || boEnt.isExternal())) {
            key = BoEnt.FIELD_PREFIX + key;
        }
        String finalKey = key;
        result.getResult().parallelStream().forEach(item -> {
            ObjectNode dataNode = item.getDataNode();
            String bindVal = JsonUtil.getStringIgnoreKey((JsonNode)dataNode, (String)result.getBindPk(), (String)"");
            if (StringUtil.isNotEmpty((String)bindVal)) {
                values.add(bindVal);
            }
        });
        List<QueryFilter> queryFilters = Collections.synchronizedList(new ArrayList());
        Set existsValue = Collections.synchronizedSet(new HashSet());
        List list = Lists.partition(values, (int)500);
        for (List objects : list) {
            if (CollectionUtils.isEmpty((Collection)objects)) continue;
            QueryFilter qf = QueryFilter.build();
            qf.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            qf.addFilter(key, (Object)objects, QueryOP.IN, FieldRelation.AND);
            queryFilters.add(qf);
        }
        this.databaseContext.switchDS(dsName, dResult -> {
            queryFilters.parallelStream().forEach(queryFilter -> {
                String sql = String.format("SELECT %s as pk FROM %s ", finalKey, boEnt.getTableName());
                PageList pl = this.commonManager.query(sql, queryFilter);
                pl.getRows().parallelStream().forEach(row -> existsValue.add(MapUtil.getStringIgnoreKey((Map)row, (String)"pk", (String)"")));
            });
            return null;
        }, e -> {
            throw new BaseException("\u4e3b\u952e\u6821\u9a8c\u5931\u8d25: " + e.getMessage());
        });
        if (!existsValue.isEmpty()) {
            for (DataTemplateImportResult.Result item2 : result.getResult()) {
                ObjectNode obj = item2.getDataNode();
                String pk = JsonUtil.getStringIgnoreKey((JsonNode)obj, (String)result.getBindPk(), (String)"");
                if (!existsValue.contains(pk)) continue;
                item2.setRepeat(true);
            }
        }
    }

    @Override
    @CachePut(value={"eip:form:formDataTemplateImportCache"}, key="#cacheId", firstCache=@FirstCache(expireTime=5))
    public List<DataTemplateImportResult> saveImportCache(String cacheId, List<DataTemplateImportResult> data) {
        return data;
    }

    @Override
    @Cacheable(value={"eip:form:formDataTemplateImportCache"}, key="#cacheId", firstCache=@FirstCache(expireTime=5))
    public List<DataTemplateImportResult> getImportCache(String cacheId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:form:formDataTemplateImportCache"}, key="#cacheKey")
    public void clearCache(String cacheKey) {
    }

    private void createDataTemplateImportResult(ObjectNode ent, String parentName, List<DataTemplateImportResult> list, Map<String, Map<String, Map<String, String>>> filedFormat) {
        BoEnt parentEnt;
        String name;
        Map<String, BoEnt> entMap = BO_ENT_THREAD_LOCAL.get();
        BoEnt currentEnt = entMap.get(name = JsonUtil.getString((JsonNode)ent, (String)FIELD_NAME));
        String type = "main".equals(currentEnt.getType()) ? "main" : ("main".equals((parentEnt = entMap.get(parentName)).getType()) ? "sub" : "sun");
        Integer rowIndex = JsonUtil.getInt((JsonNode)ent, (String)FIELD_ROW_INDEX, (int)0);
        Integer colIndex = JsonUtil.getInt((JsonNode)ent, (String)FIELD_COL_INDEX, (int)0);
        DataTemplateImportResult dataTemplateImportResult = new DataTemplateImportResult(type, name, currentEnt.getDesc(), parentName, currentEnt.getTableName(), StringUtil.isEmpty((String)currentEnt.getDsName()) ? "LOCAL" : currentEnt.getDsName(), rowIndex, colIndex);
        if (currentEnt.getIsExternal() == 1) {
            dataTemplateImportResult.setBindPk(currentEnt.getPkKey());
        } else {
            dataTemplateImportResult.setBindPk(JsonUtil.getString((JsonNode)ent, (String)FIELD_BIND_PK, (String)currentEnt.getPkKey()));
        }
        for (String key : filedFormat.keySet()) {
            if (!currentEnt.getTableName().equalsIgnoreCase(key)) continue;
            dataTemplateImportResult.setFiledFormat(filedFormat.get(key));
        }
        list.add(dataTemplateImportResult);
        if (ent.hasNonNull(FIELD_CHILDREN)) {
            ArrayNode children = (ArrayNode)ent.get(FIELD_CHILDREN);
            for (JsonNode child : children) {
                this.createDataTemplateImportResult((ObjectNode)child, name, list, filedFormat);
            }
        }
    }

    private void resolveWorkBook(XSSFWorkbook workbook, List<DataTemplateImportResult> results, Integer limit) {
        for (DataTemplateImportResult result : results) {
            String sheetName = String.format("%s(%s)", result.getDesc(), result.getEntName());
            XSSFSheet sheet = workbook.getSheet(sheetName);
            if (null != sheet) {
                this.handleReadData(sheet, result, limit);
                continue;
            }
            logger.warn(String.format("\u5bfc\u5165\u914d\u7f6e\u4e86\u3010%s\u3011\u5b9e\u4f53\uff0c\u5b9e\u4f53\u5728\u5de5\u4f5c\u7c3f\u3010%s\u3011\u4e0d\u5b58\u5728", result.getDesc(), sheetName));
        }
    }

    private void handleReadData(XSSFSheet sheet, DataTemplateImportResult inputResult, Integer limit) {
        Map<String, BoEnt> entMap = BO_ENT_THREAD_LOCAL.get();
        Map<String, Map<Integer, String>> entColMaps = ENT_COL_INDEX_MAP.get();
        if (null == entColMaps) {
            entColMaps = new HashMap<String, Map<Integer, String>>();
            ENT_COL_INDEX_MAP.set(entColMaps);
        }
        BoEnt boEnt = entMap.get(inputResult.getEntName());
        List boAttrList = boEnt.getBoAttrList();
        HashMap<String, BoAttribute> descAttributeMap = new HashMap<String, BoAttribute>();
        HashMap<String, Object> nameAttributeMap = new HashMap<String, Object>();
        HashMap<Integer, String> colMap = new HashMap<Integer, String>();
        HashMap<String, String> headerCellMap = new HashMap<String, String>();
        entColMaps.put(boEnt.getName(), colMap);
        for (Object boAttribute : boAttrList) {
            descAttributeMap.put(boAttribute.getDesc(), (BoAttribute)boAttribute);
            nameAttributeMap.put(boAttribute.getName(), boAttribute);
        }
        XSSFRow headerRow = sheet.getRow(inputResult.getRowIndex().intValue());
        if (null == headerRow) {
            throw new BaseException(String.format("\u6a21\u677f\u9519\u8bef\uff0c\u5de5\u4f5c\u8868\u3010%s\u3011\u4e2d\uff0c\u6839\u636e\u8868\u5934\u884c\u5750\u6807\u3010%s\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u884c", sheet.getSheetName(), inputResult.getRowIndex()));
        }
        for (Cell headerCell : headerRow) {
            if (headerCell.getCellType() != CellType.STRING) {
                throw new BaseException(String.format("\u6a21\u677f\u9519\u8bef\uff0c\u5de5\u4f5c\u8868\u3010%s\u3011\u4e2d\uff0c\u6839\u636e\u8868\u5934\u884c\u5750\u6807\u3010%s\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u884c", sheet.getSheetName(), inputResult.getRowIndex()));
            }
            String cellValue = headerCell.getStringCellValue();
            Integer index = headerCell.getColumnIndex();
            if (boEnt.getPkKey().equals(cellValue)) {
                colMap.put(index, boEnt.getPkKey());
                headerCellMap.put(boEnt.getPkKey(), cellValue);
                continue;
            }
            if (boEnt.getFk().equals(cellValue)) {
                colMap.put(index, boEnt.getFk());
                headerCellMap.put(boEnt.getFk(), cellValue);
                continue;
            }
            BoAttribute attribute = (BoAttribute)descAttributeMap.get(cellValue);
            if (null == attribute) continue;
            colMap.put(index, attribute.getName());
            headerCellMap.put(attribute.getName(), cellValue);
        }
        int baseRowIndex = inputResult.getRowIndex() + 1;
        int lastRowNum = sheet.getLastRowNum() + 1;
        lastRowNum = Math.min(lastRowNum, limit + baseRowIndex);
        List<DataTemplateImportResult.Result> results = inputResult.getResult();
        int count = 0;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        HashMap<String, Map<String, Object>> attributeMaps = new HashMap<String, Map<String, Object>>();
        int i = baseRowIndex;
        while (i < lastRowNum & count < limit) {
            XSSFRow row = sheet.getRow(i);
            if (null != row) {
                boolean allBlank = true;
                ObjectNode rowData = JsonUtil.getMapper().createObjectNode();
                DataTemplateImportResult.Result result = new DataTemplateImportResult.Result(rowData);
                result.setState(true);
                result.setCause("");
                for (Integer colIndex : colMap.keySet()) {
                    XSSFCell cell = row.getCell(colIndex.intValue());
                    String name = (String)colMap.get(colIndex);
                    BoAttribute attribute = (BoAttribute)nameAttributeMap.get(name);
                    if (null == cell) {
                        this.validityImportDataFormat(attributeMaps, attribute, null, result);
                        continue;
                    }
                    switch (cell.getCellType()) {
                        case STRING: {
                            rowData.put(name, cell.getStringCellValue());
                            allBlank = false;
                            break;
                        }
                        case FORMULA: 
                        case NUMERIC: {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                if (null != attribute && "date".equals(attribute.getDataType())) {
                                    rowData.put(name, DateFormatUtil.format((long)cell.getDateCellValue().getTime(), (String)attribute.getFormat()));
                                }
                                rowData.put(name, DateFormatUtil.format((long)cell.getDateCellValue().getTime(), (String)attribute.getFormat()));
                            } else {
                                double numericCellValue = cell.getNumericCellValue();
                                if (null == attribute || "varchar".equals(attribute.getDataType()) || "text".equals(attribute.getDataType()) || "clob".equals(attribute.getDataType())) {
                                    BigDecimal decimal = BigDecimal.valueOf(numericCellValue).stripTrailingZeros();
                                    rowData.put(name, decimal.toPlainString());
                                } else {
                                    nf.setMaximumFractionDigits(attribute.getDecimalLen());
                                    nf.setGroupingUsed(false);
                                    rowData.put(name, nf.format(numericCellValue));
                                }
                            }
                            allBlank = false;
                            break;
                        }
                    }
                    try {
                        Map map = JsonUtil.toMap((String)rowData.toString());
                        this.validityImportDataFormat(attributeMaps, attribute, MapUtil.getStringIgnoreKey((Map)map, (String)name, null), result);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++count;
                if (!allBlank) {
                    results.add(result);
                }
            }
            ++i;
        }
    }

    private void validityImportDataFormat(Map<String, Map<String, Object>> attributeMaps, BoAttribute attribute, String cellValue, DataTemplateImportResult.Result result) {
        if (attribute != null) {
            Map<String, Object> attributeMap = null;
            if (attributeMaps.containsKey(attribute.getName())) {
                attributeMap = attributeMaps.get(attribute.getName());
            } else {
                try {
                    attributeMap = JsonUtil.toMap((String)JsonUtil.toJson((Object)attribute));
                    attributeMaps.put(attribute.getName(), attributeMap);
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
            Integer isRequired = (Integer)MapUtil.getIgnoreCase(attributeMap, (String)"isRequired", (Object)0);
            Integer attrLength = (Integer)MapUtil.getIgnoreCase(attributeMap, (String)"attrLength", (Object)0);
            Integer decimalLen = (Integer)MapUtil.getIgnoreCase(attributeMap, (String)"decimalLen", (Object)0);
            String defaultValue = MapUtil.getStringIgnoreKey(attributeMap, (String)"defaultValue", (String)"");
            String dataType = MapUtil.getStringIgnoreKey(attributeMap, (String)"dataType", (String)"");
            String columnName = MapUtil.getStringIgnoreKey(attributeMap, (String)FIELD_DESC, (String)"");
            if (StringUtils.isEmpty((String)cellValue)) {
                if (Integer.valueOf(1).equals(isRequired) && "".equals(defaultValue)) {
                    result.setState(false);
                    result.setCause(String.format("%s\u3010%s\u3011\u4e0d\u80fd\u4e3a\u7a7a;", result.getCause(), columnName));
                }
            } else if ("varchar".equals(dataType)) {
                if (cellValue.length() > attrLength) {
                    result.setState(false);
                    result.setCause(String.format("%s\u3010%s\u3011\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%s;", result.getCause(), columnName, attrLength));
                }
            } else if ("number".equals(dataType)) {
                if (!StringValidator.isNumberic((String)cellValue)) {
                    result.setState(false);
                    result.setCause(String.format("%s\u3010%s\u3011\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e;", result.getCause(), columnName));
                } else {
                    String[] split = cellValue.split(".");
                    if (split.length == 1 && split[0].length() > attrLength) {
                        result.setState(false);
                        result.setCause(String.format("%s\u3010%s\u3011\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e;", result.getCause(), columnName));
                    } else if (split.length == 2 && (split[0].length() > attrLength || split[1].length() > decimalLen)) {
                        result.setState(false);
                        result.setCause(String.format("%s\u3010%s\u3011\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e;", result.getCause(), columnName));
                    }
                }
            } else if ("date".equals(dataType)) {
                try {
                    DateFormatUtil.parse((String)cellValue, (String)attribute.getFormat());
                }
                catch (Exception e) {
                    result.setState(false);
                    result.setCause(String.format("%s\u3010%s\u3011\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e;", result.getCause(), columnName));
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveImportResult(String cacheKey, String templateAlias) throws Exception {
        String entName;
        DataTemplateWorkBookService me = (DataTemplateWorkBookService)AppUtil.getBean(DataTemplateWorkBookService.class);
        List<DataTemplateImportResult> importCache = me.getImportCache(cacheKey);
        if (null == importCache) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff1a \u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165");
        }
        FormDataTemplate template = this.formDataTemplateManager.getByAlias(templateAlias);
        if (null == template) {
            throw new BaseException("\u8868\u5355\u5217\u8868\u4e0d\u5b58\u5728");
        }
        ArrayNode manages = (ArrayNode)JsonUtil.toJsonNode((String)template.getManageField());
        ObjectNode importBtn = null;
        for (JsonNode manage : manages) {
            if (!"import".equals(JsonUtil.getString((JsonNode)manage, (String)FIELD_NAME))) continue;
            importBtn = (ObjectNode)manage;
            break;
        }
        String importDataRule = JsonUtil.getString(importBtn, (String)"importDataRule", (String)"0");
        String updateDataRule = JsonUtil.getString(importBtn, (String)"updateDataRule", (String)"0");
        if (null == importBtn) {
            throw new BaseException("\u8868\u5355\u5217\u8868\u672a\u914d\u7f6e\u5bfc\u5165\u6309\u94ae");
        }
        HashMap<String, List> repeatMap = new HashMap<String, List>();
        for (DataTemplateImportResult resultWrapper : importCache) {
            resultWrapper.getResult().removeIf(result -> !result.isState());
            for (DataTemplateImportResult.Result result2 : resultWrapper.getResult()) {
                if (!result2.isRepeat()) continue;
                List pks = repeatMap.computeIfAbsent(resultWrapper.getEntName(), key -> new ArrayList());
                String pkVal = JsonUtil.getStringIgnoreKey((JsonNode)result2.getDataNode(), (String)resultWrapper.getBindPk(), (String)"");
                if (!StringUtil.isNotEmpty((String)pkVal)) continue;
                pks.add(pkVal);
            }
        }
        this.handleInitCmdByBoAlias(template.getBoDefAlias());
        if ("1".equals(importDataRule)) {
            for (DataTemplateImportResult wrapper : importCache) {
                entName = wrapper.getEntName();
                if (!BeanUtils.isNotEmpty(wrapper.getResult())) continue;
                this.handleRemoveFromDb(entName, (List)repeatMap.get(entName), wrapper.getBindPk(), wrapper.getDbAlias());
            }
            this.batchExecute(importCache, 0);
        } else if ("1".equals(updateDataRule)) {
            for (DataTemplateImportResult wrapper : importCache) {
                entName = wrapper.getEntName();
                if (!repeatMap.containsKey(entName)) continue;
                List pks = (List)repeatMap.get(entName);
                wrapper.getResult().removeIf(item -> {
                    ObjectNode obj = item.getDataNode();
                    String pk = JsonUtil.getString((JsonNode)obj, (String)wrapper.getBindPk());
                    return pks.contains(pk);
                });
            }
            this.batchExecute(importCache, 0);
        } else if ("0".equals(updateDataRule)) {
            this.batchExecute(importCache, 1);
        }
    }

    private void handleUpdate(String tableName, String bindPk, List<Map<String, Object>> valueMaps) {
        this.commonManager.batchUpdate(tableName, bindPk, valueMaps);
    }

    private void handleInsert(String tableName, List<Map<String, Object>> valueMaps) {
        this.commonManager.batchInsert(tableName, valueMaps);
    }

    private void batchExecute(List<DataTemplateImportResult> data, int action) {
        for (DataTemplateImportResult wrapper : data) {
            String tableName = wrapper.getTableName();
            ArrayList insertMap = new ArrayList();
            ArrayList updateMap = new ArrayList();
            Map<String, BoEnt> entMap = BO_ENT_THREAD_LOCAL.get();
            BoEnt boEnt = entMap.get(wrapper.getEntName());
            List boAttrList = boEnt.getBoAttrList();
            for (DataTemplateImportResult.Result result : wrapper.getResult()) {
                ObjectNode obj = result.getDataNode();
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                String pk = JsonUtil.getString((JsonNode)obj, (String)boEnt.getPkKey());
                if (StringUtil.isEmpty((String)pk)) {
                    pk = UniqueIdUtil.getSuid();
                }
                valueMap.put(boEnt.getPkKey(), pk);
                String fk = JsonUtil.getString((JsonNode)obj, (String)boEnt.getFk());
                if (StringUtil.isEmpty((String)fk)) {
                    String string = fk = boEnt.isExternal() ? "" : "0";
                }
                if (StringUtil.isNotEmpty((String)boEnt.getFk())) {
                    valueMap.put(boEnt.getFk(), fk);
                }
                for (BoAttribute boAttribute : boAttrList) {
                    if (obj.has(boAttribute.getName())) {
                        JsonNode node = obj.get(boAttribute.getName());
                        Object value = this.getObjFromJsonNode(node);
                        if ("date".equals(boAttribute.getDataType())) {
                            try {
                                valueMap.put(boAttribute.getFieldName(), DateFormatUtil.parseDate((String)value.toString(), (String)boAttribute.getFormat()));
                                continue;
                            }
                            catch (ParseException e2) {
                                throw new BaseException((Throwable)e2);
                            }
                        }
                        if (((DatabaseContext)AppUtil.getBean(DatabaseContext.class)).getDbType().equals("postgresql")) {
                            if ("number".equals(boAttribute.getDataType())) {
                                if (node instanceof DoubleNode) {
                                    valueMap.put(boAttribute.getFieldName(), node.doubleValue());
                                    continue;
                                }
                                if (node instanceof FloatNode) {
                                    valueMap.put(boAttribute.getFieldName(), Float.valueOf(node.floatValue()));
                                    continue;
                                }
                                valueMap.put(boAttribute.getFieldName(), node.asInt(0));
                                continue;
                            }
                            value = this.formatValue(value, wrapper, boAttribute);
                            valueMap.put(boAttribute.getFieldName(), value);
                            continue;
                        }
                        value = this.formatValue(value, wrapper, boAttribute);
                        valueMap.put(boAttribute.getFieldName(), value);
                        continue;
                    }
                    valueMap.put(boAttribute.getFieldName(), null);
                }
                if (action == 0 || !result.isRepeat()) {
                    insertMap.add(valueMap);
                    continue;
                }
                updateMap.add(valueMap);
            }
            String dsName = boEnt.getDsName();
            if (StringUtil.isEmpty((String)dsName)) {
                dsName = "LOCAL";
            }
            if (!insertMap.isEmpty()) {
                this.databaseContext.switchDS(dsName, () -> this.commonManager.batchInsert(tableName, insertMap), e -> {
                    throw new BaseException("\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
                });
            }
            if (updateMap.isEmpty()) continue;
            String key = wrapper.getBindPk().toLowerCase();
            if (!BoEnt.PK_NAME.equalsIgnoreCase(key) && !BoEnt.FK_NAME.equalsIgnoreCase(key)) {
                key = BoEnt.FIELD_PREFIX + key;
            }
            String finalKey = key;
            this.databaseContext.switchDS(dsName, () -> this.commonManager.batchUpdate(tableName, finalKey, updateMap), e -> {
                throw new BaseException("\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
            });
        }
    }

    private Object formatValue(Object value, DataTemplateImportResult wrapper, BoAttribute boAttribute) {
        Map<String, Map<String, String>> filedFormat = wrapper.getFiledFormat();
        if (BeanUtils.isEmpty(filedFormat)) {
            return value;
        }
        Map formatMap = (Map)MapUtil.getIgnoreCase(filedFormat, (String)boAttribute.getFieldName(), new HashMap());
        String finalValue = value.toString();
        return formatMap.entrySet().stream().filter(entry -> Objects.equals(finalValue, entry.getValue())).map(Map.Entry::getKey).findFirst().orElse(finalValue);
    }

    private Object getObjFromJsonNode(JsonNode node) {
        if (null == node) {
            return null;
        }
        if (node instanceof TextNode) {
            return node.asText();
        }
        if (node instanceof IntNode) {
            return node.asInt();
        }
        if (node instanceof DoubleNode) {
            return node.asDouble();
        }
        if (node instanceof FloatNode) {
            return Float.valueOf(node.floatValue());
        }
        return node.toString();
    }

    private void handleRemoveFromDb(String entName, List<String> pks, String bindPk, String dsName) throws Exception {
        Map<String, BoEnt> entMap = BO_ENT_THREAD_LOCAL.get();
        BoEnt boEnt = entMap.get(entName);
        if (null != boEnt) {
            this.databaseContext.switchDS(dsName, () -> this.commonManager.execute(String.format("delete from %s", boEnt.getTableName())));
        }
    }
}

