/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.template.impl.FreeMarkerEngine;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.bo.bodef.BoDefService;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoDefXml;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.bo.persistence.manager.BoEntManager;
import com.hotent.bo.util.BoUtil;
import com.hotent.form.enums.FormType;
import com.hotent.form.enums.LayoutType;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormDefinitionTemplate;
import com.hotent.form.model.FormHistoryRecord;
import com.hotent.form.model.FormImportData;
import com.hotent.form.model.FormImportXml;
import com.hotent.form.model.FormMeta;
import com.hotent.form.model.FormTagRelation;
import com.hotent.form.model.FormTemplate;
import com.hotent.form.model.FormXml;
import com.hotent.form.persistence.dao.FormDefinitionTemplateDao;
import com.hotent.form.persistence.manager.FormDefinitionTemplateManager;
import com.hotent.form.persistence.manager.FormHistoryRecordManager;
import com.hotent.form.persistence.manager.FormManager;
import com.hotent.form.persistence.manager.FormMetaManager;
import com.hotent.form.persistence.manager.FormRightManager;
import com.hotent.form.persistence.manager.FormTagRelationManager;
import com.hotent.form.persistence.manager.FormTemplateManager;
import com.hotent.form.service.BoDefIService;
import com.hotent.form.service.FormService;
import com.hotent.form.util.CustomUtil;
import com.hotent.form.util.FormHtmlUtil;
import com.hotent.form.util.FormUtil;
import com.hotent.form.util.FreeMakerUtil;
import com.hotent.form.vo.FormDefinitionTemplateVO;
import com.hotent.form.vo.FormTemplateCopyVO;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class FormDefinitionTemplateManagerImpl
extends BaseManagerImpl<FormDefinitionTemplateDao, FormDefinitionTemplate>
implements FormDefinitionTemplateManager {
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    BoDefService boDefService;
    @Resource
    BoDefManager boDefManager;
    @Resource
    FormManager formManager;
    @Resource
    FormTemplateManager formTemplateManager;
    @Resource
    FreeMarkerEngine freemarkEngine;
    @Resource
    FormTagRelationManager formTagRelationManager;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    FormHistoryRecordManager formHistoryRecordManager;
    @Resource
    FormService formService;
    @Resource
    FormRightManager bpmFormRightManager;
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoDefIService boDefIService;

    @Override
    public Map<String, String> exportData(List<String> idList, boolean containBo) {
        FormImportXml formImport = new FormImportXml();
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> boDefIds = new HashSet<String>();
        ArrayList<FormDefinitionTemplate> forms = new ArrayList<FormDefinitionTemplate>();
        for (String formId : idList) {
            FormXml formXml = new FormXml();
            FormDefinitionTemplate formDefinitionTemplate = (FormDefinitionTemplate)this.get((Serializable)((Object)formId));
            Assert.notNull((Object)((Object)formDefinitionTemplate), (String)("\u4e0d\u5b58\u5728id\u4e3a[" + formId + "]\u8be5\u8868\u5355"));
            FormMeta formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)formDefinitionTemplate.getDefId()));
            Assert.notNull((Object)((Object)formDefinitionTemplate), (String)("\u4e0d\u5b58\u5728id\u4e3a[" + formDefinitionTemplate.getDefId() + "]\u8868\u5355\u5143\u6570\u636e\u5bf9\u8c61"));
            List<String> boCodes = this.formMetaManager.getBOCodeByFormId(formDefinitionTemplate.getDefId());
            formXml.setBpmFormTemplate(formDefinitionTemplate);
            formXml.setBpmFormDef(formDef);
            formXml.setBoCodes(boCodes);
            formImport.addFormXml(formXml);
            forms.add(formDefinitionTemplate);
            boDefIds.add(formDefinitionTemplate.getDefId());
        }
        try {
            map.put("form.xml", JAXBUtil.marshall((Object)formImport, FormImportXml.class));
            if (containBo) {
                Map<String, String> exportBo = this.exportBo(boDefIds);
                map.putAll(exportBo);
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException("\u5bfc\u51fa\u8868\u5355\u6a21\u677f\u5931\u8d25" + e.getMessage(), e);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response, Optional<String> typeId) {
        CommonResult message;
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList files = new ArrayList();
        while (it.hasNext()) {
            files.add(it.next());
        }
        MultipartFile fileLoad = (MultipartFile)files.get(0);
        String unZipFilePath = "";
        try {
            String cacheFileId;
            String fileDir = StringUtil.substringBeforeLast((String)fileLoad.getOriginalFilename().toString(), (String)".");
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            File folder = new File(rootRealPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            ZipUtil.unZipFile((MultipartFile)fileLoad, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            String formXmlStr = FileUtil.readFile((String)(unZipFilePath + File.separator + "form.xml"));
            String boXmlStr = FileUtil.readFile((String)(unZipFilePath + File.separator + "bo.xml"));
            String formRightsXml = "";
            if (FileUtil.isExistFile((String)(unZipFilePath + File.separator + "formrights.xml"))) {
                formRightsXml = FileUtil.readFile((String)(unZipFilePath + File.separator + "formrights.xml"));
            }
            if (StringUtils.isEmpty((String)formXmlStr)) {
                throw new Exception("\u5bfc\u5165\u7684\u672a\u6309\u6307\u5b9a\u7684\u683c\u5f0f");
            }
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("formXmlStr", formXmlStr);
            obj.put("boXmlStr", boXmlStr);
            if (StringUtil.isNotEmpty((String)formRightsXml)) {
                obj.put("formRightsXml", formRightsXml);
            }
            FormImportXml formImportXml = (FormImportXml)JAXBUtil.unmarshall((String)formXmlStr, FormImportXml.class);
            List<FormXml> formXmlList = formImportXml.getFormXmlList();
            ArrayList<String> names = new ArrayList<String>();
            for (FormXml formXml : formXmlList) {
                FormDefinitionTemplate formTemplate = formXml.getBpmFormTemplate();
                if (BeanUtils.isEmpty((Object)((Object)formTemplate))) {
                    throw new BaseException("\u5bfc\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6");
                }
                FormDefinitionTemplate oldForm = this.getMainByFormKey(formTemplate.getFormKey());
                if (oldForm == null) continue;
                names.add(oldForm.getName() + "\uff08" + oldForm.getFormKey() + "\uff09");
            }
            List boDefs = this.boDefManager.parseXml(boXmlStr);
            Set entNames = this.boDefManager.checkBoEnt(boDefs);
            if (BeanUtils.isNotEmpty(names)) {
                cacheFileId = UniqueIdUtil.getSuid();
                this.formManager.putImportFileInCache(cacheFileId, JsonUtil.toJson((Object)obj));
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u8868\u5355\u3010" + String.join((CharSequence)"\uff0c", names) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u4e3a\u5176\u65b0\u589e\u7248\u672c\uff1f", (Object)cacheFileId);
            } else if (BeanUtils.isNotEmpty((Object)entNames)) {
                cacheFileId = UniqueIdUtil.getSuid();
                this.formManager.putImportFileInCache(cacheFileId, JsonUtil.toJson((Object)obj));
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u5efa\u6a21\u5b9e\u4f53\u3010" + String.join((CharSequence)"\uff0c", entNames) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u5bfc\u5165\u8ffd\u52a0\u5efa\u6a21\u5b9e\u4f53\u5b57\u6bb5\uff1f", (Object)cacheFileId);
            } else {
                CommonResult<String> commonResult = this.importForms(obj, typeId.orElse(""));
                message = commonResult.getState().booleanValue() ? new CommonResult(true, "\u5bfc\u5165\u6210\u529f") : new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + commonResult.getMessage() + ",\u4e0d\u652f\u6301\u5bfc\u5165");
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage() + ",\u4e0d\u652f\u6301\u5bfc\u5165");
        }
        finally {
            File boDir = new File(unZipFilePath);
            if (boDir.exists()) {
                FileUtil.deleteDir((File)boDir);
            }
        }
        return message;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> importForms(ObjectNode obj, String typeId) throws Exception {
        return this.formService.importFormAndBo(obj, "jump", data -> {
            try {
                this.importByFormXml((FormImportData)data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void importByFormXml(FormImportData formImportData) throws Exception {
        FormImportXml formImportXml = (FormImportXml)JAXBUtil.unmarshall((String)formImportData.getXml(), FormImportXml.class);
        List<FormXml> formXmlList = formImportXml.getFormXmlList();
        Map entIdMap = this.boDefManager.getEntIdMap(formImportData.getImportBoDefs(), formImportData.getNameMap());
        for (FormXml formXml : formXmlList) {
            HashSet<String> boCodesSet = new HashSet<String>();
            if (BeanUtils.isNotEmpty(formXml.getBoCodes())) {
                for (String boCode : formXml.getBoCodes()) {
                    boCodesSet.add(boCode);
                }
            }
            FormMeta formDef = formXml.getBpmFormDef();
            FormDefinitionTemplate form = formXml.getBpmFormTemplate();
            List<String> hasRightImportForms = formImportData.getHasRightImportForms();
            if (hasRightImportForms != null && !hasRightImportForms.contains(form.getFormKey())) {
                ThreadMsgUtil.addMapMsg2((String)"formHasNoRight", (String)String.format("<div  style='margin-left:12px; margin-top:6px;color: red;'>%s [%s]</div>", form.getName() + "", form.getFormKey() + ""));
                continue;
            }
            String html = this.genFormHtml(form.getFormSetting(), formDef.getExpand(), "mobile".equals(form.getFormType()));
            form.setFormHtml(html);
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormMeta::getKey, (Object)formDef.getKey())).eq(FormMeta::getFormType, (Object)formDef.getFormType());
            FormMeta oldFormDef = (FormMeta)((Object)this.formMetaManager.getOne((Wrapper)wrapper));
            ObjectNode expand = (ObjectNode)JsonUtil.toJsonNode((String)formDef.getExpand());
            ArrayNode boDefList = JsonUtil.getMapper().createArrayNode();
            for (BoDef boDef : formImportData.getImportBoDefs()) {
                ArrayNode boDefList1 = (ArrayNode)expand.get("boDefList");
                for (JsonNode node : boDefList1) {
                    if (!JsonUtil.getString((JsonNode)node, (String)"alias").equals(boDef.getAlias()) || !boCodesSet.contains(boDef.getAlias())) continue;
                    ((ObjectNode)node).put("id", boDef.getId());
                    boDefList.add(node);
                }
            }
            expand.set("boDefList", (JsonNode)boDefList);
            if (BeanUtils.isNotEmpty(formImportData.getImportBoDefs())) {
                this.boDefManager.updateEntId(formImportData.getImportBoDefs(), expand);
            }
            formDef.setExpand(expand.toString());
            if (oldFormDef != null) {
                formDef.setId(oldFormDef.getId());
                this.formMetaManager.updateByImport(formDef, entIdMap);
                ThreadMsgUtil.addMapMsg2((String)"formDefsUpdated", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", formDef.getName(), formDef.getKey()));
            } else {
                formDef.setId(UniqueIdUtil.getSuid());
                formDef.setFormType("2");
                this.formMetaManager.createByImport(formDef, entIdMap);
                ThreadMsgUtil.addMapMsg2((String)"formDefsAdded", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", formDef.getName(), formDef.getKey()));
            }
            this.formMetaManager.deleteBpmFormBo(formDef.getId());
            Iterator iterator = boDefList.iterator();
            while (iterator.hasNext()) {
                JsonNode obj;
                JsonNode boDefJson = obj = (JsonNode)iterator.next();
                this.formMetaManager.createBpmFormBo(UniqueIdUtil.getSuid(), boDefJson.get("id").asText() + "", formDef.getId());
            }
            FormDefinitionTemplate oldForm = this.getMainByFormKey(form.getFormKey());
            form.setDefId(formDef.getId());
            form.setStatus("deploy");
            form.setExpand(formDef.getExpand());
            if (oldForm != null) {
                form.setId(oldForm.getId());
                if ("deploy".equals(oldForm.getStatus())) {
                    this.createNewVersionForm(form);
                    ThreadMsgUtil.addMapMsg2((String)"formsUpdatedReleased", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", form.getName() + "", form.getFormKey() + ""));
                    continue;
                }
                if (!"draft".equals(oldForm.getStatus())) continue;
                this.createNewDraftForm(form);
                ThreadMsgUtil.addMapMsg2((String)"formsUpdated", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", form.getName() + "", form.getFormKey() + ""));
                continue;
            }
            form.setId(UniqueIdUtil.getSuid());
            form.setVersion(1);
            form.setIsMain("Y");
            form.setUpdateTime(LocalDateTime.now());
            form.setCreateTime(LocalDateTime.now());
            form.setCreateBy(ContextUtil.getCurrentUserId());
            this.create((Model)form);
            ThreadMsgUtil.addMapMsg2((String)"formsAddedPublished", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", form.getName() + "", form.getFormKey() + ""));
        }
    }

    private void createNewVersionForm(FormDefinitionTemplate bpmform) {
        if (bpmform != null) {
            Integer rtn = ((FormDefinitionTemplateDao)this.baseMapper).getMaxVersionByFormKey(bpmform.getFormKey());
            String newFormId = UniqueIdUtil.getSuid();
            FormDefinitionTemplate newBpmForm = bpmform;
            newBpmForm.setId(newFormId);
            newBpmForm.setIsMain("N");
            newBpmForm.setStatus("draft");
            newBpmForm.setVersion(rtn + 1);
            newBpmForm.setUpdateTime(LocalDateTime.now());
            this.create((Model)newBpmForm);
            this.publish(newFormId);
            this.setDefaultVersion(newFormId, newBpmForm.getFormKey());
        }
    }

    private void createNewDraftForm(FormDefinitionTemplate bpmFormDraft) {
        if (bpmFormDraft != null) {
            Integer rtn = ((FormDefinitionTemplateDao)this.baseMapper).getMaxVersionByFormKey(bpmFormDraft.getFormKey());
            String newFormId = UniqueIdUtil.getSuid();
            FormDefinitionTemplate newBpmForm = bpmFormDraft;
            newBpmForm.setId(newFormId);
            newBpmForm.setIsMain("N");
            newBpmForm.setStatus("draft");
            newBpmForm.setVersion(rtn + 1);
            this.create((Model)newBpmForm);
            this.setDefaultVersion(newFormId, newBpmForm.getFormKey());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyByFormId(FormTemplateCopyVO formTemplateCopyVO) throws Exception {
        Form form = (Form)this.formManager.get((Serializable)((Object)formTemplateCopyVO.getId()));
        Assert.notNull((Object)((Object)form), (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        Assert.isTrue((!this.checkExternalEnt(form.getDefId()) ? 1 : 0) != 0, (String)"\u5916\u90e8\u6570\u636e\u6e90\u8868\u4e0d\u80fd\u6dfb\u52a0\u4e3a\u6a21\u677f");
        String defId = this.boDefManager.getBoDefIdByFormId(form.getDefId());
        Assert.isTrue((!JsonUtil.getBoolean((ObjectNode)this.boDefIService.getSubEntInfo(defId, Optional.of(false)), (String)"hasSun", (boolean)false) ? 1 : 0) != 0, (String)"\u8be5\u8868\u5355\u5b58\u5728\u5b59\u8868\u4e0d\u80fd\u6dfb\u52a0\u4e3a\u6a21\u677f");
        FormMeta formMeta = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId()));
        formMeta.setId(null);
        formMeta.setKey(formTemplateCopyVO.getKey());
        formMeta.setName(formTemplateCopyVO.getName());
        FormDefinitionTemplate formDefinitionTemplate = (FormDefinitionTemplate)((Object)BeanUtil.copyProperties((Object)((Object)form), FormDefinitionTemplate.class, (String[])new String[0]));
        formDefinitionTemplate.setId(null);
        formDefinitionTemplate.setVersion(1);
        formDefinitionTemplate.setFormKey(formTemplateCopyVO.getKey());
        formDefinitionTemplate.setName(formTemplateCopyVO.getName());
        this.saveFormDef(formDefinitionTemplate, formMeta, "");
        this.formTagRelationManager.saveFormTagRelation(formTemplateCopyVO.getTags(), Collections.singletonList(formDefinitionTemplate.getFormKey()));
    }

    @Override
    public CommonResult<String> checkMobileForm(String formKey) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormDefinitionTemplate::getFormKey, (Object)(formKey + "mobile"))).eq(FormDefinitionTemplate::getIsMain, (Object)Character.valueOf('Y'));
        FormDefinitionTemplate mainTemplate = (FormDefinitionTemplate)((Object)this.getOne((Wrapper)wrapper));
        if (BeanUtils.isNotEmpty((Object)((Object)mainTemplate))) {
            return new CommonResult(true, "", (Object)"update");
        }
        return new CommonResult(true, "", (Object)"create");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void pcForm2MobileForm(String formId) throws Exception {
        this.pc2MobileForm(formId, true);
    }

    private void pc2MobileForm(String formId, boolean create) throws Exception {
        FormMeta mobileFormDef;
        FormDefinitionTemplate bpmForm = (FormDefinitionTemplate)this.get((Serializable)((Object)formId));
        FormMeta bpmFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)bpmForm.getDefId()));
        FormDefinitionTemplate mobileForm = this.getMainByFormKey(bpmForm.getFormKey() + "mobile");
        if (create) {
            Assert.isTrue((boolean)BeanUtils.isEmpty((Object)((Object)mobileForm)), (String)"\u5df2\u7ecf\u751f\u6210\u624b\u673a\u8868\u5355key\u4e3a\u3010%s\u3011\u7684\u8868\u5355");
            mobileForm = bpmForm;
            mobileForm.setId("");
            mobileForm.setFormKey(bpmForm.getFormKey() + "mobile");
            mobileForm.setFormType(FormType.MOBILE.value());
            mobileFormDef = bpmFormDef;
            mobileFormDef.setId("");
            mobileFormDef.setKey(bpmFormDef.getKey() + "mobile");
        } else {
            mobileFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)mobileForm.getDefId()));
        }
        mobileForm.setName(bpmForm.getName());
        mobileForm.setFormSetting(FormUtil.convertFormSettingFullscreen(mobileForm.getFormSetting()));
        mobileFormDef.setExpand(FormUtil.transformationMobileExpand(bpmFormDef.getExpand()));
        this.saveFormDef(mobileForm, mobileFormDef, "deploy".equals(mobileForm.getStatus()) ? "newForm" : null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void pcUpdateMobileForm(String formId) throws Exception {
        this.pc2MobileForm(formId, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> updateFormHistoryRecord(FormHistoryRecord formHistoryRecord) {
        String formId = formHistoryRecord.getFormId();
        String formHtml = formHistoryRecord.getFormHtml();
        String formExpand = formHistoryRecord.getFormExpand();
        String diyJs = formHistoryRecord.getDiyJs();
        FormDefinitionTemplate form = (FormDefinitionTemplate)this.get((Serializable)((Object)formId));
        if (BeanUtils.isNotEmpty((Object)((Object)form))) {
            form.setFormHtml(formHtml);
            form.setExpand(formExpand);
            form.setDiyJs(diyJs);
            this.update((Model)form);
            FormMeta formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId()));
            formDef.setExpand(formExpand);
            this.formMetaManager.update((Model)formDef);
            return new CommonResult(true, "\u6062\u590d\u6210\u529f");
        }
        return new CommonResult(false, "\u8bf7\u5148\u4fdd\u5b58\u8868\u5355\u5185\u5bb9");
    }

    @Override
    public void publish(String formId) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(FormDefinitionTemplate::getId, (Object)formId)).set(FormDefinitionTemplate::getStatus, (Object)"deploy");
        this.update((Wrapper)wrapper);
    }

    @Override
    public Object getPreviewDesignVueData(String formId) throws Exception {
        FormDefinitionTemplate bpmForm = (FormDefinitionTemplate)this.get((Serializable)((Object)formId));
        return this.getPreviewDesignVueData(bpmForm);
    }

    @Override
    public Map<String, Object> getPreviewDesignVueData(FormDefinitionTemplate bpmForm) throws Exception {
        FormMeta formMeta = (FormMeta)this.formMetaManager.get((Serializable)((Object)bpmForm.getDefId()));
        JsonNode jsonNodeExpand = JsonUtil.toJsonNode((String)formMeta.getExpand());
        String expand = "";
        if (BeanUtils.isNotEmpty((Object)jsonNodeExpand)) {
            expand = JsonUtil.toJson((Object)jsonNodeExpand.get("boDefList"));
        }
        ArrayList<BoDef> boDefList = new ArrayList<BoDef>();
        ArrayNode bosArray = (ArrayNode)JsonUtil.toBean((String)expand, ArrayNode.class);
        for (int i = 0; i < bosArray.size(); ++i) {
            JsonNode obj = bosArray.get(i);
            BoDef boDef = this.boDefManager.getByAlias(obj.get("alias").asText());
            if (!BeanUtils.isNotEmpty((Object)boDef)) continue;
            boDefList.add(boDef);
        }
        List<BoData> boJson = this.formService.getBoDataByBoDefs(boDefList);
        ObjectNode object = BoUtil.hanlerData(boJson);
        String formKey = bpmForm.getFormKey();
        JsonNode permissionConf = this.bpmFormRightManager.getByFormKey(formKey, false, formMeta, boDefList);
        JsonNode permission = this.bpmFormRightManager.calcFormPermission(permissionConf);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("bpmForm", (Object)bpmForm);
        resultMap.put("permission", permission);
        resultMap.put("data", object);
        return resultMap;
    }

    @Override
    public String getFormFromCache(String cacheId) {
        return this.formManager.getFormFromCache(cacheId);
    }

    @Override
    public Map<String, Object> getPreviewDesignVueData(FormDefinitionTemplateVO bpmFormVo) throws Exception {
        FormDefinitionTemplate bpmForm = bpmFormVo.getBpmForm();
        bpmForm.setExpand(bpmFormVo.getBpmFormDef().getExpand());
        this.genFromHtml(bpmFormVo);
        JsonNode jsonNode = JsonUtil.toJsonNode((String)bpmFormVo.getBpmFormDef().getExpand());
        String bos = "";
        if (BeanUtils.isNotEmpty((Object)jsonNode)) {
            bos = JsonUtil.toJson((Object)jsonNode.get("boDefList"));
        }
        ArrayList<String> boCode = new ArrayList<String>();
        ArrayNode bosArray = (ArrayNode)JsonUtil.toBean((String)bos, ArrayNode.class);
        for (int i = 0; i < bosArray.size(); ++i) {
            JsonNode obj = bosArray.get(i);
            BoDef boDef = (BoDef)this.boDefManager.get((Serializable)((Object)obj.get("id").asText()));
            if (!BeanUtils.isNotEmpty((Object)boDef)) continue;
            boCode.add(boDef.getAlias());
        }
        List<BoData> boJson = this.formService.getBoDataByBoKeys(boCode);
        ObjectNode object = BoUtil.hanlerData(boJson);
        JsonNode permissionConf = this.bpmFormRightManager.getDefaultByExpand(bpmFormVo.getBpmFormDef().getExpand());
        JsonNode permission = this.bpmFormRightManager.calcFormPermission(permissionConf);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String formHtml = I18nUtil.replaceTemp((String)bpmForm.getFormHtml(), (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        bpmForm.setFormHtml(formHtml);
        resultMap.put("bpmForm", (Object)bpmForm);
        resultMap.put("permission", permission);
        resultMap.put("data", object);
        return resultMap;
    }

    @Override
    public boolean checkExternalEnt(String defId) {
        List boEnts = this.boEntManager.getExternalEnts(defId);
        return BeanUtils.isNotEmpty((Object)boEnts);
    }

    private String genFromHtml(FormDefinitionTemplateVO formDefinitionTemplateVO) throws Exception {
        String formSetting = formDefinitionTemplateVO.getBpmForm().getFormSetting();
        String expand = formDefinitionTemplateVO.getBpmFormDef().getExpand();
        String html = this.genFormHtml(formSetting, expand, "mobile".equals(formDefinitionTemplateVO.getBpmForm().getFormType()));
        formDefinitionTemplateVO.getBpmForm().setFormHtml(html);
        return html;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveFormDef(FormDefinitionTemplate formDefinitionTemplate, FormMeta bpmFormDef, String newForm) throws Exception {
        formDefinitionTemplate.setExpand(bpmFormDef.getExpand());
        if (StringUtil.isEmpty((String)bpmFormDef.getId())) {
            bpmFormDef.setFormType("2");
            this.formMetaManager.create((Model)bpmFormDef);
            formDefinitionTemplate.setDefId(bpmFormDef.getId());
        } else {
            if ("pc".equals(formDefinitionTemplate.getFormType())) {
                CustomUtil.checkEditRight(this.getCurrentModelClass(), ResourceModelType.PC_FORM, formDefinitionTemplate.getFormKey());
            } else {
                CustomUtil.checkEditRight(this.getCurrentModelClass(), ResourceModelType.MOBILE_FORFM, formDefinitionTemplate.getFormKey());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", bpmFormDef.getId());
            map.put("rev", bpmFormDef.getRev());
            FormMeta bpmFormDef1 = this.formMetaManager.getFormDefByRev(map);
            if (BeanUtils.isEmpty((Object)((Object)bpmFormDef1))) {
                throw new BaseException("\u6b64\u8868\u5355\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
            }
            bpmFormDef.setFormType("2");
            this.formMetaManager.update((Model)bpmFormDef);
        }
        String formHtml = this.genFormHtml(formDefinitionTemplate.getFormSetting(), bpmFormDef.getExpand(), FormType.MOBILE.value().equals(formDefinitionTemplate.getFormType()));
        formDefinitionTemplate.setFormHtml(formHtml);
        FormDefinitionTemplate oldBpmForm = null;
        if (StringUtil.isNotEmpty((String)formDefinitionTemplate.getId())) {
            oldBpmForm = (FormDefinitionTemplate)((Object)((FormDefinitionTemplateDao)this.baseMapper).selectById((Serializable)((Object)formDefinitionTemplate.getId())));
        }
        if (StringUtil.isEmpty((String)formDefinitionTemplate.getId())) {
            formDefinitionTemplate.setStatus("draft");
            formDefinitionTemplate.setCreateBy(ContextUtil.getCurrentUserId());
            formDefinitionTemplate.setCreatorName(AuthenticationUtil.getCurrentUserFullname());
            formDefinitionTemplate.setUpdateTime(DateUtil.getCurrentDate());
            this.create((Model)formDefinitionTemplate);
        } else if ("newForm".equals(newForm)) {
            Integer rtn = ((FormDefinitionTemplateDao)this.baseMapper).getMaxVersionByFormKey(formDefinitionTemplate.getFormKey());
            String newFormId = UniqueIdUtil.getSuid();
            this.setDefaultVersion(newFormId, formDefinitionTemplate.getFormKey());
            if (StringUtil.isNotEmpty((String)oldBpmForm.getDiyJs())) {
                formDefinitionTemplate.setDiyJs(oldBpmForm.getDiyJs());
            }
            formDefinitionTemplate.setCreateBy(oldBpmForm.getCreateBy());
            formDefinitionTemplate.setCreatorName(oldBpmForm.getCreatorName());
            formDefinitionTemplate.setId(newFormId);
            formDefinitionTemplate.setIsMain("Y");
            formDefinitionTemplate.setVersion(rtn + 1);
            formDefinitionTemplate.setStatus("deploy");
            formDefinitionTemplate.setUpdateTime(DateUtil.getCurrentDate());
            this.create((Model)formDefinitionTemplate);
        } else {
            if (BeanUtils.isNotEmpty((Object)((Object)oldBpmForm))) {
                formDefinitionTemplate.setDiyJs(oldBpmForm.getDiyJs());
                formDefinitionTemplate.setCreateBy(oldBpmForm.getCreateBy());
                formDefinitionTemplate.setCreatorName(oldBpmForm.getCreatorName());
            }
            this.update((Model)formDefinitionTemplate);
        }
        if (BeanUtils.isNotEmpty((Object)((Object)oldBpmForm))) {
            FormHistoryRecord formHistoryRecord = new FormHistoryRecord(oldBpmForm);
            this.formHistoryRecordManager.create((Model)formHistoryRecord);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setDefaultVersion(String formId, String formKey) {
        LambdaUpdateWrapper updateWrapper1 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(FormDefinitionTemplate::getFormKey, (Object)formKey)).set(FormDefinitionTemplate::getIsMain, (Object)"N");
        this.update((Wrapper)updateWrapper1);
        LambdaUpdateWrapper updateWrapper2 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(FormDefinitionTemplate::getId, (Object)formId)).set(FormDefinitionTemplate::getIsMain, (Object)"Y");
        this.update((Wrapper)updateWrapper2);
        FormDefinitionTemplate form = (FormDefinitionTemplate)super.get((Serializable)((Object)formId));
        if (BeanUtils.isNotEmpty((Object)((Object)form))) {
            FormMeta byKey = (FormMeta)((Object)this.formMetaManager.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormMeta::getKey, (Object)formKey)).eq(FormMeta::getFormType, (Object)Character.valueOf('2'))));
            byKey.setExpand(form.getExpand());
            this.formMetaManager.update((Model)byKey);
        }
    }

    @Override
    public ObjectNode getFormDesign(String formId) throws Exception {
        FormMeta formDef = null;
        ObjectNode resultJson = JsonUtil.getMapper().createObjectNode();
        if (StringUtil.isNotEmpty((String)formId)) {
            ObjectNode designJson = JsonUtil.getMapper().createObjectNode();
            FormDefinitionTemplate form = (FormDefinitionTemplate)this.get((Serializable)((Object)formId));
            if (BeanUtils.isNotEmpty((Object)((Object)form)) && BeanUtils.isNotEmpty((Object)((Object)(formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId())))))) {
                resultJson.put("ganged", formDef.getGanged());
                resultJson.put("opinion", formDef.getOpinionConf());
                resultJson.put("defId", formDef.getId());
                resultJson.put("desc", formDef.getDesc());
                resultJson.put("name", formDef.getName());
                resultJson.put("rev", formDef.getRev());
                JsonNode jsonNode = JsonUtil.toJsonNode((String)formDef.getExpand());
                if (BeanUtils.isNotEmpty((Object)jsonNode)) {
                    resultJson.put("bos", JsonUtil.toJson((Object)jsonNode.get("boDefList")));
                    resultJson.put("fields", JsonUtil.toJson((Object)jsonNode.get("fields")));
                    resultJson.put("flowField", jsonNode.has("flowField") ? jsonNode.get("flowField").asText() : "");
                    resultJson.put("includeFiles", jsonNode.has("includeFiles") ? jsonNode.get("includeFiles").asText() : "");
                    resultJson.put("designFormName", jsonNode.has("designFormName") ? jsonNode.get("designFormName").asText() : "");
                    if (jsonNode.has("treeCtrl")) {
                        resultJson.set("treeCtrl", jsonNode.get("treeCtrl"));
                    }
                }
                designJson.put("type", formDef.getType());
            }
            ObjectNode formJson = JsonUtil.getMapper().createObjectNode();
            designJson.set("form", (JsonNode)formJson);
            resultJson.put("formName", form.getName());
            resultJson.put("formKey", form.getFormKey());
            resultJson.put("formType", form.getFormType());
            resultJson.put("version", form.getVersion());
            resultJson.put("status", form.getStatus());
            resultJson.put("typeId", form.getTypeId());
            resultJson.put("typeName", form.getTypeName());
            resultJson.put("desc", form.getDesc());
            resultJson.put("macroAlias", formDef.getMacroAlias());
            resultJson.put("mainAlias", formDef.getMainAlias());
            resultJson.put("subEntity", formDef.getSubEntity());
            resultJson.put("isPrint", form.getIsPrint());
            resultJson.set("design", (JsonNode)designJson);
            resultJson.put("formSetting", form.getFormSetting());
            resultJson.put("diyJs", form.getDiyJs());
            resultJson.put("formCss", form.getFormCss());
        }
        return resultJson;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAll(List<String> ids) {
        for (String id : ids) {
            FormDefinitionTemplate formDefinitionTemplate = (FormDefinitionTemplate)this.get((Serializable)((Object)id));
            this.formMetaManager.remove((Serializable)((Object)formDefinitionTemplate.getDefId()));
            this.remove((Serializable)((Object)id));
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormTagRelation::getFormKey, (Object)formDefinitionTemplate.getFormKey());
            this.formTagRelationManager.remove((Wrapper)wrapper);
        }
    }

    @Override
    public PageList<FormDefinitionTemplate> queryByFilter(QueryFilter<FormDefinitionTemplate> queryFilter) {
        Map<String, String> tagMap = this.getTagMap();
        IPage<FormDefinitionTemplate> page = ((FormDefinitionTemplateDao)this.baseMapper).queryByFilter((IPage<FormDefinitionTemplate>)this.convert2IPage(queryFilter.getPageBean()), queryFilter.getParams());
        page.getRecords().forEach(item -> {
            if (StringUtil.isNotEmpty((String)item.getTagId())) {
                String[] tagIds;
                for (String tagId : tagIds = item.getTagId().split(",")) {
                    if (!tagMap.containsKey(tagId)) continue;
                    item.getTagNames().add((String)tagMap.get(tagId));
                }
            }
        });
        return new PageList(page);
    }

    private Map<String, String> getTagMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        List sysTypes = this.portalFeignService.getTypeTags("mdbq");
        sysTypes.forEach(sysType -> {
            ArrayNode tags = (ArrayNode)sysType.get("tags");
            tags.forEach(tag -> map.put(JsonUtil.getString((JsonNode)tag, (String)"id"), JsonUtil.getString((JsonNode)tag, (String)"name")));
        });
        return map;
    }

    private String genFormHtml(String formSetting, String expand, boolean isMobile) throws Exception {
        JsonNode expandJsonNode = JsonUtil.toJsonNode((String)expand);
        JsonNode field = expandJsonNode.get("list");
        ArrayList layoutList = new ArrayList();
        field.forEach(obj -> {
            try {
                if (!isMobile || !LayoutType.HOT_TABLE.getValue().equals(JsonUtil.getString((JsonNode)obj, (String)"ctrlType"))) {
                    layoutList.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)obj)));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        HashMap<String, Object> mapObj = new HashMap<String, Object>();
        mapObj.put("layoutList", layoutList);
        mapObj.put("expandMap", JsonUtil.toMap((String)expand));
        mapObj.put("util", freeMakerUtil);
        if (BeanUtils.isNotEmpty((Object)formSetting)) {
            mapObj.put("formSetting", JsonUtil.toJsonNode((String)formSetting));
        }
        mapObj.put("isMobile", isMobile);
        FormTemplate fieldControl = this.formTemplateManager.getByTemplateAlias("fieldControl");
        List<FormTemplate> bpmFormTpls = this.formTemplateManager.getTemplateType("formDesign");
        StringBuffer formDesignFtl = new StringBuffer(fieldControl.getHtml());
        for (FormTemplate bpmFormTemplate : bpmFormTpls) {
            formDesignFtl.append(bpmFormTemplate.getHtml());
        }
        String html = this.freemarkEngine.parseByTemplate(formDesignFtl.toString(), mapObj);
        html = FormHtmlUtil.htmlCompressor(html);
        return html;
    }

    @Override
    public FormDefinitionTemplate getMainByFormKey(String formKey) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormDefinitionTemplate::getFormKey, (Object)formKey)).eq(FormDefinitionTemplate::getIsMain, (Object)Character.valueOf('Y'));
        FormDefinitionTemplate formDefinitionTemplate = (FormDefinitionTemplate)((Object)this.getOne((Wrapper)wrapper));
        if (formDefinitionTemplate == null) {
            return null;
        }
        String html = formDefinitionTemplate.getFormHtml();
        String formHtml = I18nUtil.replaceTemp((String)html, (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        formDefinitionTemplate.setFormHtml(formHtml);
        return formDefinitionTemplate;
    }

    @Override
    public Object importSave(Optional<Boolean> confirmImport, Optional<String> typeId, Optional<String> cacheFileId) throws Exception {
        CommonResult<String> message = new CommonResult<String>("\u5bfc\u5165\u6210\u529f");
        if (confirmImport.orElse(false).booleanValue()) {
            String byKey = this.formManager.getImportFileFromCache(cacheFileId.get());
            if (StringUtil.isEmpty((String)byKey)) {
                return new CommonResult("\u5bfc\u5165\u7684\u6587\u4ef6\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)byKey);
            message = this.importForms(objectNode, typeId.orElse(""));
            if (message.getState().booleanValue()) {
                String msg;
                LinkedHashSet entDefsAdded = ThreadMsgUtil.getMapMsg2((String)"entDefsAdded");
                LinkedHashSet entDefsSkipped = ThreadMsgUtil.getMapMsg2((String)"entDefsSkipped");
                LinkedHashSet entsAdded = ThreadMsgUtil.getMapMsg2((String)"entsAdded");
                LinkedHashSet entsSkipped = ThreadMsgUtil.getMapMsg2((String)"entsSkipped");
                LinkedHashSet formDefsUpdated = ThreadMsgUtil.getMapMsg2((String)"formDefsUpdated");
                LinkedHashSet formDefsAdded = ThreadMsgUtil.getMapMsg2((String)"formDefsAdded");
                LinkedHashSet formsUpdatedReleased = ThreadMsgUtil.getMapMsg2((String)"formsUpdatedReleased");
                LinkedHashSet formsUpdated = ThreadMsgUtil.getMapMsg2((String)"formsUpdated");
                LinkedHashSet formsAddedPublished = ThreadMsgUtil.getMapMsg2((String)"formsAddedPublished");
                LinkedHashSet formHasNoRight = ThreadMsgUtil.getMapMsg2((String)"formHasNoRight");
                StringBuilder sb = new StringBuilder();
                if (BeanUtils.isNotEmpty((Object)entsAdded)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u5b9e\u4f53\u5b9a\u4e49\uff0c\u5bfc\u5165\u5e76\u6dfb\u52a0\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", entsAdded));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)entDefsSkipped)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u5b9e\u4f53\u5b9a\u4e49\uff0c\u5df2\u5b58\u5728\uff0c\u66f4\u65b0\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", entDefsSkipped));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)entsSkipped)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u5b9e\u4f53\uff0c\u5df2\u5b58\u5728\u6545\u8df3\u8fc7\uff0c\u6570\u636e\u5e93\u5b57\u6bb5\u7ea7\u522b\u5dee\u5f02\u8bf7\u624b\u52a8\u9010\u4e2a\u66f4\u65b0\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", entsSkipped));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formDefsUpdated)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\u5b9a\u4e49\uff0c\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formDefsUpdated));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formsUpdatedReleased)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\uff0c\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u5e76\u53d1\u5e03\u65b0\u7248\u672c\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formsUpdatedReleased));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formsUpdated)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\uff0c\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u7248\u672c\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formsUpdated));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formsAddedPublished)) {
                    sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u8868\u5355\uff0c\u5bfc\u5165\u5e76\u53d1\u5e03\u6210\u529f\uff1a</div>");
                    msg = String.format("%s", String.join((CharSequence)"", formsAddedPublished));
                    sb.append(msg);
                }
                if (BeanUtils.isNotEmpty((Object)formHasNoRight)) {
                    msg = "<div style='font-weight:bold;color: red;'>\u4ee5\u4e0b\u8868\u5355\uff0c\u65e0\u6743\u9650\u5bfc\u5165\u5df2\u8df3\u8fc7\uff0c\u8bf7\u68c0\u67e5\u8868\u5355\u548c\u5efa\u6a21\u6743\u9650\uff1a</div>" + String.format("%s", String.join((CharSequence)"", formHasNoRight));
                    if (StringUtil.isEmpty((String)sb.toString())) {
                        message.setState(Boolean.valueOf(false));
                        message.setMessage(msg);
                    }
                    sb.append(msg);
                }
                if (StringUtil.isNotEmpty((String)(msg = sb.toString()))) {
                    message.setValue((Object)msg);
                }
            }
        }
        this.formManager.delImportFileFromCache(cacheFileId.orElse(""));
        return message;
    }

    private Map<String, String> exportBo(Set<String> boDefIds) throws JAXBException {
        HashMap<String, String> result = new HashMap<String, String>();
        BoDefXml bodefXml = new BoDefXml();
        boDefIds.forEach(boDefId -> {
            List<String> boIds = this.formMetaManager.getBODefIdByFormId((String)boDefId);
            HashSet<String> boIdSet = new HashSet<String>(boIds);
            for (String boId : boIdSet) {
                BoDef bodef = this.boDefService.getByDefId(boId);
                bodefXml.addBodef(bodef);
            }
        });
        result.put("bo.xml", JAXBUtil.marshall((Object)bodefXml, BoDefXml.class));
        return result;
    }
}

