/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import cn.hutool.core.util.XmlUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoData;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.form.def.BpmBoDef;
import com.hotent.form.extmodel.ProcBoDef;
import com.hotent.form.model.Form;
import com.hotent.form.model.FormBoRelation;
import com.hotent.form.model.FormField;
import com.hotent.form.model.FormMeta;
import com.hotent.form.persistence.dao.FormMetaDao;
import com.hotent.form.persistence.manager.FormFieldManager;
import com.hotent.form.persistence.manager.FormManager;
import com.hotent.form.persistence.manager.FormMetaManager;
import com.hotent.form.service.FormService;
import com.hotent.form.util.FormUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmFormDefManager")
public class FormMetaManagerImpl
extends BaseManagerImpl<FormMetaDao, FormMeta>
implements FormMetaManager {
    private static final Logger log = LoggerFactory.getLogger(FormMetaManagerImpl.class);
    public static final HashSet<String> NO_ATTR_FIELDS = new HashSet<String>(){
        {
            this.add("button");
            this.add("text");
            this.add("immediate-single");
            this.add("immediate-textarea");
            this.add("flowChart");
            this.add("approvalHistory");
            this.add("input");
            this.add("textarea");
            this.add("number");
            this.add("property-text");
            this.add("formTable");
        }
    };
    private static final String DESIGN_TEMPLATE_PATH = "designtemps.xml";
    @Resource
    FormFieldManager formFieldManager;
    @Resource
    FormManager bpmFormManager;
    @Resource
    FormService formService;
    @Resource
    BoDefManager boDefManager;
    @Resource
    FormMetaManager formMetaManager;

    @Transactional(rollbackFor={Exception.class})
    public void create(FormMeta bpmFormDef) {
        super.create((Model)bpmFormDef);
        try {
            this.createFields(bpmFormDef, null);
            this.updateBpmFormBo(bpmFormDef);
        }
        catch (IOException e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void createFields(FormMeta bpmFormDef, Map<String, String> entIdMap) throws IOException {
        Object expandNode;
        String formId = bpmFormDef.getId();
        List defList = this.boDefManager.getByFormId(bpmFormDef.getId());
        String expand = bpmFormDef.getExpand();
        if (BeanUtils.isEmpty((Object)defList) && StringUtil.isNotEmpty((String)expand) && (expandNode = JsonUtil.toJsonNode((String)expand)).has("boDefList")) {
            ArrayNode array = (ArrayNode)expandNode.get("boDefList");
            for (JsonNode defJson : array) {
                BoDef bodef = this.boDefManager.getByDefId(defJson.get("id").asText());
                if (!BeanUtils.isNotEmpty((Object)bodef)) continue;
                defList.add(bodef);
            }
        }
        if (BeanUtils.isNotEmpty((Object)defList)) {
            for (BoDef boDef : defList) {
                String boDefId = boDef.getId();
                BoEnt mainEnt = boDef.getBoEnt();
                List mainAttr = mainEnt.getBoAttrList();
                if (!BeanUtils.isNotEmpty((Object)mainAttr)) continue;
                for (BoAttribute boAttribute : mainAttr) {
                    this.createFields(boAttribute, formId, boDefId);
                }
                List subEnts = mainEnt.getChildEntList();
                for (BoEnt subEnt : subEnts) {
                    List subAttr = subEnt.getBoAttrList();
                    for (BoAttribute subAttribute : subAttr) {
                        this.createFields(subAttribute, formId, boDefId);
                    }
                    List sunEnts = subEnt.getChildEntList();
                    for (BoEnt sunEnt : sunEnts) {
                        List sunAttr = sunEnt.getBoAttrList();
                        for (BoAttribute sunAttribute : sunAttr) {
                            this.createFields(sunAttribute, formId, boDefId);
                        }
                    }
                }
            }
        }
        try {
            this.createPermissionFields(bpmFormDef);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u975ebo\u5b57\u6bb5\u5230\u8868form_field\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void createPermissionFields(FormMeta bpmFormDef) throws IOException {
        ArrayNode fields = FormUtil.resolutionFieldsByFormMeta(bpmFormDef);
        if (BeanUtils.isEmpty((Object)fields)) {
            return;
        }
        for (int i = 0; i < fields.size(); ++i) {
            JsonNode fieldObj = fields.get(i);
            String ctrlType = JsonUtil.getString((JsonNode)fieldObj, (String)"ctrlType");
            if (!NO_ATTR_FIELDS.contains(ctrlType) && (!fieldObj.has("options") || !JsonUtil.getBoolean((ObjectNode)((ObjectNode)fieldObj.get("options")), (String)"noBindModel", (boolean)false)) || !fieldObj.hasNonNull("tableName") || !fieldObj.hasNonNull("name")) continue;
            FormField formField = (FormField)((Object)JsonUtil.toBean((JsonNode)fieldObj, FormField.class));
            formField.setCtrlType(ctrlType);
            formField.setId(UniqueIdUtil.getSuid());
            formField.setFormId(bpmFormDef.getId());
            formField.setSn(i);
            if ("formTable".equals(ctrlType) && fieldObj.hasNonNull("templateObj")) {
                JsonNode templateObj2 = fieldObj.get("templateObj");
                formField.setDesc(JsonUtil.getString((JsonNode)templateObj2, (String)"name", (String)formField.getDesc()));
                if (templateObj2.hasNonNull("boDefId")) {
                    formField.setBoDefId(templateObj2.get("boDefId").asText());
                }
                if (templateObj2.hasNonNull("alias")) {
                    formField.setDataKey(templateObj2.get("alias").asText());
                }
            }
            if ("dataView".equals(ctrlType) && fieldObj.hasNonNull("dataTemplateObj")) {
                JsonNode templateObjs = fieldObj.get("dataTemplateObj");
                templateObjs.forEach(templateObj -> {
                    formField.setDesc(JsonUtil.getString((JsonNode)templateObj, (String)"name", (String)formField.getDesc()));
                    if (templateObj.hasNonNull("boDefId")) {
                        formField.setBoDefId(templateObj.get("boDefId").asText());
                    }
                    if (templateObj.hasNonNull("alias")) {
                        formField.setDataKey(templateObj.get("alias").asText());
                    }
                });
            }
            this.formFieldManager.create((Model)formField);
        }
    }

    private void createFields(BoAttribute boAttribute, String formId, String boDefId) {
        FormField formField = new FormField();
        formField.setId(UniqueIdUtil.getSuid());
        formField.setBoAttrId(boAttribute.getId());
        formField.setType(boAttribute.getDataType());
        formField.setFormId(formId);
        formField.setBoDefId(boDefId);
        formField.setName(boAttribute.getName());
        formField.setDesc(boAttribute.getDesc());
        formField.setSn(boAttribute.getSn());
        formField.setEntId(boAttribute.getEntId());
        this.formFieldManager.create((Model)formField);
    }

    private void updateBpmFormBo(FormMeta formDef) throws IOException {
        String formId = formDef.getId();
        if (!StringUtil.isEmpty((String)formDef.getExpand())) {
            JsonNode expand = JsonUtil.toJsonNode((String)formDef.getExpand());
            JsonNode boDefs = expand.findValue("boDefList");
            List<String> boDef = this.formMetaManager.getBODefIdByFormId(formId);
            for (int i = 0; i < boDefs.size(); ++i) {
                String boDefId = boDefs.get(i).path("id").textValue();
                if (!BeanUtils.isNotEmpty((Object)boDefId) || boDef.contains(boDefId)) continue;
                ((FormMetaDao)this.baseMapper).createBpmFormBo(UniqueIdUtil.getSuid(), boDefId, formId);
            }
        }
    }

    @Override
    public FormMeta getByKey(String formKey) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormMeta::getKey, (Object)formKey)).eq(FormMeta::getFormType, (Object)"1");
        return (FormMeta)((Object)this.getOne((Wrapper)wrapper));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOpinionConf(String id, String opinionJson) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(FormMeta::getOpinionConf, (Object)opinionJson)).eq(FormMeta::getId, (Object)id));
    }

    @Override
    public String getMetaKeyByFormKey(String formKey) {
        return ((FormMetaDao)this.baseMapper).getMetaKeyByFormKey(formKey);
    }

    @Override
    public List<String> getBOCodeByFormId(String formDefId) {
        List<String> boCodeByFormId = ((FormMetaDao)this.baseMapper).getBOCodeByFormId(formDefId);
        if (BeanUtils.isNotEmpty(boCodeByFormId)) {
            boCodeByFormId = boCodeByFormId.stream().distinct().collect(Collectors.toList());
        }
        return boCodeByFormId;
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(FormMeta bpmFormDef) {
        super.update((Model)bpmFormDef);
        String formDefId = bpmFormDef.getId();
        try {
            this.formFieldManager.delByMainId(formDefId);
            this.createFields(bpmFormDef, null);
            this.deleteBpmFormBo(formDefId);
            this.updateBpmFormBo(bpmFormDef);
        }
        catch (IOException e) {
            log.error("\u66f4\u65b0\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public List<BoEnt> getChildrenByFormKey(String formKey) throws IOException {
        ObjectNode expandJson;
        ArrayNode boDefList;
        String expandStr;
        ArrayList<BoEnt> ents = new ArrayList<BoEnt>();
        FormMeta def = this.getByKey(formKey);
        if (BeanUtils.isNotEmpty((Object)((Object)def)) && StringUtil.isNotEmpty((String)(expandStr = def.getExpand())) && BeanUtils.isNotEmpty((Object)(boDefList = (ArrayNode)JsonUtil.toJsonNode((Object)(expandJson = (ObjectNode)JsonUtil.toJsonNode((String)expandStr)).get("boDefList"))))) {
            for (JsonNode jsonNode : boDefList) {
                BoEnt boEnt;
                BoDef byAlias = null;
                if (jsonNode.has("alias")) {
                    byAlias = this.boDefManager.getByAlias(jsonNode.get("alias").asText());
                }
                if (BeanUtils.isEmpty(byAlias) && jsonNode.has("id")) {
                    byAlias = this.boDefManager.getByDefId(jsonNode.get("id").asText());
                }
                if (!BeanUtils.isNotEmpty((Object)(boEnt = byAlias.getBoEnt()))) continue;
                return boEnt.getChildEntList();
            }
        }
        return ents;
    }

    @Override
    public List<BoData> getBoDataByFormDefId(String formDefId) {
        List<String> boCodes = ((FormMetaDao)this.baseMapper).getBOCodeByFormId(formDefId);
        ArrayList<BoData> boDatas = new ArrayList<BoData>();
        for (String code : boCodes) {
            BoData boData = this.formService.getBodataByDefCode("database", code);
            if (!BeanUtils.isNotEmpty((Object)boData)) continue;
            boDatas.add(boData);
        }
        return boDatas;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBpmFormBo(String formId) {
        ((FormMetaDao)this.baseMapper).deleteBpmFormBo(formId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBpmFormBo(String id, String boDefId, String formId) {
        List<String> boDef = this.formMetaManager.getBODefIdByFormId(formId);
        if (BeanUtils.isNotEmpty((Object)boDefId) && !boDef.contains(boDefId)) {
            ((FormMetaDao)this.baseMapper).createBpmFormBo(id, boDefId, formId);
        }
    }

    @Override
    public List<String> getBODefIdByFormId(String formId) {
        return ((FormMetaDao)this.baseMapper).getBODefIdByFormId(formId);
    }

    @Override
    public List<FormMeta> getBODefByFormId(String formId) {
        return ((FormMetaDao)this.baseMapper).getBODefByFormId(formId);
    }

    @Override
    public FormMeta getFormDefByRev(Map<String, Object> map) {
        return ((FormMetaDao)this.baseMapper).getFormDefByRev(map);
    }

    @Override
    public PageList<JsonNode> listJson(QueryFilter<FormMeta> queryFilter) throws Exception {
        PageList list = this.query(queryFilter);
        ArrayList<JsonNode> bpmFormDefList = new ArrayList<JsonNode>();
        for (FormMeta bpmFormdef : list.getRows()) {
            JsonNode expandJson;
            HashMap<String, String> formJson = new HashMap<String, String>();
            formJson.put("desc", bpmFormdef.getName());
            formJson.put("key", bpmFormdef.getKey());
            formJson.put("id", bpmFormdef.getId());
            formJson.put("name", bpmFormdef.getName());
            formJson.put("type", bpmFormdef.getType());
            String expand = bpmFormdef.getExpand();
            if (StringUtil.isNotEmpty((String)expand) && (expandJson = JsonUtil.toJsonNode((String)expand)).get("boDefList") != null) {
                formJson.put("boDefList", expandJson.get("boDefList").toString());
            }
            bpmFormDefList.add(JsonUtil.toJsonNode(formJson));
        }
        PageList pageJson = new PageList(bpmFormDefList);
        pageJson.setPage(list.getPage());
        pageJson.setPageSize(list.getPageSize());
        pageJson.setTotal(list.getTotal());
        return pageJson;
    }

    @Override
    public PageList<Form> listJsonByBODef(QueryFilter<Form> queryFilter, String defId, String formType, String topDefKey) {
        List<Object> boList = new ArrayList();
        if (StringUtil.isNotEmpty((String)topDefKey)) {
            BpmBoDef bpmBodef = new BpmBoDef();
            boList = bpmBodef.getBoDefs();
        }
        if (boList.isEmpty()) {
            return new PageList();
        }
        ArrayList<String> codes = new ArrayList<String>();
        for (ProcBoDef procBoDef : boList) {
            codes.add(procBoDef.getKey());
        }
        List<Form> list = this.bpmFormManager.getByBoCodes(codes, formType, queryFilter);
        return new PageList(list);
    }

    @Override
    public Map<String, Object> getChooseDesignTemplate(String subject, String categoryId, String formDesc, Boolean isSimple) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String templatePath = FormUtil.getDesignTemplatePath();
        String xml = FileUtil.readByClassPath((String)(templatePath + DESIGN_TEMPLATE_PATH));
        JSONObject jsonObject = JSONUtil.parseObj((Object)XmlUtil.xmlToMap((String)xml));
        result.put("subject", subject);
        result.put("categoryId", categoryId);
        result.put("formDesc", formDesc);
        result.put("temps", jsonObject.toString());
        result.put("isSimple", isSimple);
        return result;
    }

    @Override
    public void createByImport(FormMeta formDef, Map<String, String> entIdMap) {
        super.create((Model)formDef);
        try {
            this.createFields(formDef, entIdMap);
            this.updateBpmFormBo(formDef);
        }
        catch (IOException e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateByImport(FormMeta formDef, Map<String, String> entIdMap) {
        FormMeta formMeta = (FormMeta)this.get((Serializable)((Object)formDef.getId()));
        formDef.setRev(formMeta.getRev());
        super.update((Model)formDef);
        String formDefId = formDef.getId();
        try {
            this.formFieldManager.delByMainId(formDefId);
            this.createFields(formDef, entIdMap);
            this.deleteBpmFormBo(formDefId);
            this.updateBpmFormBo(formDef);
        }
        catch (IOException e) {
            log.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public List<FormBoRelation> getBoBindFormsByFormKey(String formKey) {
        return ((FormMetaDao)this.baseMapper).getBoBindFormsByFormKey(formKey);
    }
}

