/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.form.model.FormTagRelation;
import com.hotent.form.persistence.dao.FormTagRelationDao;
import com.hotent.form.persistence.manager.FormTagRelationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormTagRelationManagerImpl
extends BaseManagerImpl<FormTagRelationDao, FormTagRelation>
implements FormTagRelationManager {
    @Override
    public Map<String, String> getTagsByFormKey(String formKey) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FormTagRelation::getFormKey, (Object)formKey);
        List tagRelations = this.list((Wrapper)wrapper);
        HashMap<String, List> map = new HashMap<String, List>();
        for (FormTagRelation tagRelation : tagRelations) {
            if (!map.containsKey(tagRelation.getTypeId())) {
                map.put(tagRelation.getTypeId(), new ArrayList());
            }
            ((List)map.get(tagRelation.getTypeId())).add(tagRelation.getTagId());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        map.forEach((key, value) -> result.put((String)key, String.join((CharSequence)",", value)));
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveFormTagRelation(Map<String, String> tags, List<String> formKeys) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(FormTagRelation::getFormKey, formKeys);
        this.remove((Wrapper)wrapper);
        ArrayList relations = new ArrayList();
        tags.forEach((key, tagIds) -> {
            String[] tagIdAry;
            for (String tagId : tagIdAry = tagIds.split(",")) {
                if (StringUtil.isEmpty((String)tagId)) continue;
                for (String formKey : formKeys) {
                    FormTagRelation formTagRelation = new FormTagRelation();
                    formTagRelation.setTypeId((String)key);
                    formTagRelation.setTagId(tagId);
                    formTagRelation.setFormKey(formKey);
                    relations.add(formTagRelation);
                }
            }
        });
        if (BeanUtils.isNotEmpty(relations)) {
            this.saveBatch(relations);
        }
    }
}

