/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.form.model.FormUrlForm;
import com.hotent.form.persistence.dao.FormUrlFormDao;
import com.hotent.form.persistence.manager.FormManager;
import com.hotent.form.persistence.manager.FormUrlFormManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class FormUrlFormManagerImpl
extends BaseManagerImpl<FormUrlFormDao, FormUrlForm>
implements FormUrlFormManager {
    @Autowired
    BaseContext baseContext;
    @Resource
    PortalFeignService portalFeignService;

    @Override
    public FormUrlForm getDetail(String id) {
        FormUrlForm formUrlForm = (FormUrlForm)this.get((Serializable)((Object)id));
        return formUrlForm;
    }

    @Override
    @Transactional
    public void createOrUpdate(FormUrlForm formUrlForm) throws Exception {
        String formKey;
        FormUrlForm newUrlForm;
        IUser user = ContextUtil.getCurrentUser();
        if (StringUtil.isEmpty((String)formUrlForm.getId()) && BeanUtils.isNotEmpty((Object)((Object)(newUrlForm = ((FormUrlFormDao)this.baseMapper).getMainByFormKey(formKey = formUrlForm.getFormKey()))))) {
            throw new BaseException("\u8868\u5355key\u3010" + newUrlForm.getFormKey() + "\u3011\u5df2\u5b58\u5728");
        }
        formUrlForm.setUpdateBy(user.getUserId());
        formUrlForm.setUpdateTime(LocalDateTime.now());
        boolean isUpdate = BeanUtils.isNotEmpty((Object)formUrlForm.getId());
        this.saveOrUpdate((Object)formUrlForm);
        if (isUpdate) {
            this.removeFromCache(formUrlForm.getFormKey());
        }
    }

    @Override
    public void publishData(FormUrlForm formUrlForm) {
        String formKey;
        FormUrlForm newUrlForm;
        IUser user = ContextUtil.getCurrentUser();
        if (StringUtil.isEmpty((String)formUrlForm.getId()) && BeanUtils.isNotEmpty((Object)((Object)(newUrlForm = ((FormUrlFormDao)this.baseMapper).getMainByFormKey(formKey = formUrlForm.getFormKey()))))) {
            throw new BaseException("\u8868\u5355key\u3010" + newUrlForm.getFormKey() + "\u3011\u5df2\u5b58\u5728");
        }
        formUrlForm.setUpdateBy(user.getUserId());
        formUrlForm.setUpdateTime(LocalDateTime.now());
        formUrlForm.setStatus("deploy");
        this.saveOrUpdate((Object)formUrlForm);
    }

    @Override
    public PageList<FormUrlForm> querList(QueryFilter queryFilter, Optional<String> formType, Optional<String> status, Optional<String> formKey) {
        if (StringUtil.isNotEmpty((String)formType.orElse(null))) {
            queryFilter.addFilter("formType", (Object)formType.get(), QueryOP.EQUAL, FieldRelation.AND, "isMain");
        }
        if (StringUtil.isNotEmpty((String)status.orElse(null))) {
            queryFilter.addFilter("status", (Object)status.get(), QueryOP.EQUAL, FieldRelation.AND, "isMain");
        }
        if (StringUtil.isNotEmpty((String)formKey.orElse(null))) {
            queryFilter.addFilter("formKey", (Object)formKey.get(), QueryOP.EQUAL, FieldRelation.AND, "isMain");
        }
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL, FieldRelation.AND, "isMain");
        String currentTenantId = this.baseContext.getCurrentTenantId();
        queryFilter.addParams("tenantId", (Object)currentTenantId);
        PageList pageList = new PageList(((FormUrlFormDao)this.baseMapper).queryList((IPage<FormUrlForm>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<FormUrlForm>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
        HashMap typeMap = Maps.newHashMap();
        pageList.getRows().stream().forEach(r -> {
            String categoryId = r.getTypeId();
            if (StringUtil.isEmpty((String)categoryId)) {
                return;
            }
            r.setTypeName("");
            if (typeMap.containsKey(categoryId)) {
                if (typeMap.get(categoryId) != null) {
                    r.setTypeName(((JsonNode)typeMap.get(categoryId)).get("name").asText());
                }
                return;
            }
            ObjectNode objectNode = this.portalFeignService.getSysTypeById(categoryId);
            typeMap.put(categoryId, objectNode);
            if (objectNode != null) {
                r.setTypeName(objectNode.get("name").asText());
            }
        });
        return pageList;
    }

    @Override
    @Transactional
    public void newVersion(FormUrlForm formUrlForm) {
        this.createNewVersionForm(formUrlForm);
    }

    @Override
    @Transactional
    public void newVersion(String id) {
        FormUrlForm formUrlForm = (FormUrlForm)this.get((Serializable)((Object)id));
        this.createNewVersionForm(formUrlForm);
    }

    private void createNewVersionForm(FormUrlForm formUrlForm) {
        if (BeanUtils.isNotEmpty((Object)((Object)formUrlForm))) {
            IUser user = ContextUtil.getCurrentUser();
            Integer rtn = ((FormUrlFormDao)this.baseMapper).getMaxVersionByFormKey(formUrlForm.getFormKey());
            String newId = UniqueIdUtil.getSuid();
            FormUrlForm newUrlForm = formUrlForm;
            newUrlForm.setId(newId);
            newUrlForm.setIsMain('N');
            newUrlForm.setStatus("draft");
            newUrlForm.setVersion(rtn + 1);
            newUrlForm.setUpdateBy(null);
            newUrlForm.setUpdateTime(null);
            this.create((Model)newUrlForm);
            this.publish(newId);
            this.setDefaultVersion(newId, newUrlForm.getFormKey());
        }
    }

    @Override
    @Transactional
    public void setDefaultVersion(String id, String formKey) {
        ((FormUrlFormDao)this.baseMapper).updNotDefaultByFormKey(formKey);
        ((FormUrlFormDao)this.baseMapper).updDefaultById(id);
    }

    @Override
    @Transactional
    public void publish(String id) {
        FormUrlForm formUrlForm = (FormUrlForm)this.get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)((Object)formUrlForm))) {
            formUrlForm.setStatus("deploy");
            this.update((Model)formUrlForm);
        }
    }

    @Override
    public FormUrlForm getMainByFormKey(String formKey) {
        return ((FormUrlFormDao)this.baseMapper).getMainByFormKey(formKey);
    }

    @Override
    public List<FormUrlForm> getByFormKey(String formKey) {
        return ((FormUrlFormDao)this.baseMapper).getByFormKey(formKey);
    }

    @Override
    @Transactional
    public void removeMainVersion(String ... ids) {
        List<String> idList = Arrays.asList(ids);
        for (String id : idList) {
            FormUrlForm formUrlForm = (FormUrlForm)this.get((Serializable)((Object)id));
            List<FormUrlForm> list = ((FormUrlFormDao)this.baseMapper).getByFormKey(formUrlForm.getFormKey());
            for (FormUrlForm urlForm : list) {
                this.remove((Serializable)((Object)urlForm.getId()));
            }
        }
    }

    @Override
    @Transactional
    public void removeVersions(String[] aryIds) {
        super.removeByIds(aryIds);
    }

    private void removeFromCache(String formKey) {
        FormUrlFormManagerImpl bean = (FormUrlFormManagerImpl)AppUtil.getBean(this.getClass());
        bean.delFromCache(formKey);
    }

    @CacheEvict(value={"eip:form:urlForm"}, key="#formKey")
    protected void delFromCache(String formKey) {
    }

    @Override
    public List<FormUrlForm> getExportDataMapByIds(String[] ids) {
        return this.listByIds(Lists.newArrayList((Object[])ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response, String typeId) {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        CommonResult message = null;
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "formUrlForm.json"));
            ArrayList<String> names = new ArrayList<String>();
            List importData = (List)JsonUtil.toBean((String)json, List.class);
            for (Object obj : importData) {
                FormUrlForm formUrlForm = (FormUrlForm)((Object)JsonUtil.toBean((String)JsonUtil.toJson(obj), FormUrlForm.class));
                List<FormUrlForm> byFormKey = this.getByFormKey(formUrlForm.getFormKey());
                if (!BeanUtils.isNotEmpty(byFormKey)) continue;
                FormUrlForm oldForm = byFormKey.get(byFormKey.size() - 1);
                names.add(oldForm.getFormName() + "\uff08" + oldForm.getFormKey() + "\uff09");
            }
            if (BeanUtils.isEmpty(names)) {
                this.importData(importData, typeId);
                message = new CommonResult(true, "");
                boolean none = false;
                for (Object obj : importData) {
                    FormUrlForm formUrlForm = (FormUrlForm)((Object)JsonUtil.toBean((String)JsonUtil.toJson(obj), FormUrlForm.class));
                    CommonResult portalBizSystemBySysCode = this.portalFeignService.getBizSystemByCode(formUrlForm.getSysCode());
                    if (portalBizSystemBySysCode.getState().booleanValue()) continue;
                    none = true;
                    message.setMessage(message.getMessage() + String.format("\u3010%s\u3011", formUrlForm.getSysCode()));
                }
                if (none) {
                    message.setMessage(message.getMessage() + "\u5916\u90e8\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u6dfb\u52a0\u5916\u90e8\u7cfb\u7edf\u3002");
                }
            } else {
                String cacheFileId = UniqueIdUtil.getSuid();
                ((FormManager)AppUtil.getBean(FormManager.class)).putImportFileInCache(cacheFileId, json);
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u8868\u5355\u3010" + String.join((CharSequence)"\uff0c", names) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u4e3a\u5176\u65b0\u589e\u7248\u672c\uff1f", (Object)cacheFileId);
            }
            CommonResult commonResult = message;
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile = new File(unZipFilePath);
            if (zipFile.exists()) {
                zipFile.delete();
            }
        }
    }

    @Override
    public CommonResult<String> importSave(String cacheFileId, Boolean confirmImport, String typeId) {
        CommonResult message = new CommonResult(true, "");
        try {
            String byKey = ((FormManager)AppUtil.getBean(FormManager.class)).getImportFileFromCache(cacheFileId);
            if (StringUtil.isEmpty((String)byKey)) {
                CommonResult commonResult = new CommonResult("\u5bfc\u5165\u7684\u6587\u4ef6\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
                return commonResult;
            }
            if (confirmImport.booleanValue()) {
                List importData = (List)JsonUtil.toBean((String)byKey, List.class);
                ArrayList insertList = Lists.newArrayList();
                for (Object obj : importData) {
                    FormUrlForm formUrlForm = (FormUrlForm)((Object)JsonUtil.toBean((String)JsonUtil.toJson(obj), FormUrlForm.class));
                    insertList.add(formUrlForm);
                }
                this.importData(importData, typeId);
                boolean none = false;
                for (Object obj : importData) {
                    FormUrlForm formUrlForm = (FormUrlForm)((Object)JsonUtil.toBean((String)JsonUtil.toJson(obj), FormUrlForm.class));
                    CommonResult portalBizSystemBySysCode = this.portalFeignService.getBizSystemByCode(formUrlForm.getSysCode());
                    if (portalBizSystemBySysCode.getState().booleanValue()) continue;
                    none = true;
                    message.setMessage(message.getMessage() + String.format("\u3010%s\u3011", formUrlForm.getSysCode()));
                }
                if (none) {
                    message.setMessage(message.getMessage() + "\u5916\u90e8\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u6dfb\u52a0\u5916\u90e8\u7cfb\u7edf\u3002");
                }
            }
            CommonResult commonResult = message;
            return commonResult;
        }
        catch (Exception e) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25");
        }
        finally {
            ((FormManager)AppUtil.getBean(FormManager.class)).delImportFileFromCache(cacheFileId);
        }
    }

    @Transactional
    public boolean importData(List importData, String typeId) throws Exception {
        try {
            ObjectNode sysTypeNode = this.portalFeignService.getSysTypeById(typeId);
            String typeName = sysTypeNode.get("name").asText("");
            for (Object obj : importData) {
                FormUrlForm formUrlForm = (FormUrlForm)((Object)JsonUtil.toBean((String)JsonUtil.toJson(obj), FormUrlForm.class));
                formUrlForm.setId(UniqueIdUtil.getSuid());
                formUrlForm.setTypeId(typeId);
                formUrlForm.setTypeName(typeName);
                List<FormUrlForm> byFormKey = this.getByFormKey(formUrlForm.getFormKey());
                CommonResult portalBizSystemBySysCode = this.portalFeignService.getBizSystemByCode(formUrlForm.getSysCode());
                if (portalBizSystemBySysCode.getState().booleanValue()) {
                    Object value = portalBizSystemBySysCode.getValue();
                    JsonNode jsonNode = JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)value));
                    String id = jsonNode.get("id").asText("");
                    formUrlForm.setSysId(id);
                }
                if (BeanUtils.isEmpty(byFormKey)) {
                    ((FormUrlFormDao)this.baseMapper).insert((Object)formUrlForm);
                    continue;
                }
                byFormKey.stream().filter(r -> r.getIsMain() == 'Y').forEach(item -> {
                    item.setIsMain('N');
                    this.update((Model)item);
                });
                ((FormUrlFormDao)this.baseMapper).insert((Object)formUrlForm);
                this.publish(formUrlForm.getId());
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return true;
    }
}

