/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.persistence.manager.impl;

import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.interceptor.ResultSetInterceptor;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.form.enums.FieldControlType;
import com.hotent.form.enums.ViewType;
import com.hotent.form.model.CustomDialog;
import com.hotent.form.model.QueryMetafield;
import com.hotent.form.model.QuerySqldef;
import com.hotent.form.model.QuerySqldefXml;
import com.hotent.form.model.QuerySqldefXmlList;
import com.hotent.form.model.QueryView;
import com.hotent.form.persistence.dao.QuerySqldefDao;
import com.hotent.form.persistence.manager.CustomDialogManager;
import com.hotent.form.persistence.manager.QueryMetafieldManager;
import com.hotent.form.persistence.manager.QuerySqldefManager;
import com.hotent.form.persistence.manager.QueryViewManager;
import com.hotent.form.vo.CustomDialogDisplayFieldVo;
import com.hotent.table.datasource.DataSourceUtil;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="querySqldefManager")
public class QuerySqldefManagerImpl
extends BaseManagerImpl<QuerySqldefDao, QuerySqldef>
implements QuerySqldefManager {
    @Resource
    QueryMetafieldManager queryMetafieldManager;
    @Resource
    QueryViewManager queryViewManager;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    QuerySqldefManager querySqldefManager;
    @Resource
    CustomDialogManager customDialogManager;
    Logger logger = LoggerFactory.getLogger(QuerySqldefManagerImpl.class);

    @Transactional
    public void remove(Serializable entityId) {
        QuerySqldef querySqldef = (QuerySqldef)this.get(entityId);
        this.queryMetafieldManager.removeBySqlId((String)((Object)entityId));
        this.queryViewManager.removeBySqlAlias(querySqldef.getAlias());
        super.remove(entityId);
    }

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            this.queryMetafieldManager.removeBySqlId(id);
            QuerySqldef querySqldef = (QuerySqldef)this.get((Serializable)((Object)id));
            if (!BeanUtils.isNotEmpty((Object)((Object)querySqldef)) || !BeanUtils.isNotEmpty((Object)querySqldef.getAlias())) continue;
            this.queryViewManager.removeBySqlAlias(querySqldef.getAlias());
        }
        super.removeByIds(ids);
    }

    @Override
    public ObjectNode checkSql(String dsName, String sql) {
        ObjectNode data = JsonUtil.getMapper().createObjectNode();
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
            jdbcTemplate.execute(sql);
            data.put("result", true);
            data.put("message", "\u9a8c\u8bc1\u901a\u8fc7");
        }
        catch (Exception e) {
            data.put("result", false);
            data.put("message", e.getMessage());
        }
        throw new RuntimeException(data.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> saveSql(QuerySqldef querySqldef) {
        boolean result = false;
        String returnId = querySqldef.getId();
        String resultMsg = "\u6dfb\u52a0\u81ea\u5b9a\u4e49SQL\u67e5\u8be2\u6210\u529f";
        this.checkBeforeSave(querySqldef);
        if (ViewType.sql.equals((Object)querySqldef.getViewType())) {
            try {
                this.databaseContext.switchDS(querySqldef.getDsName(), dResult -> {
                    this.checkSql(querySqldef.getSql());
                    return null;
                });
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }
        QuerySqldef byAlias = this.getByAlias(querySqldef.getAlias());
        QuerySqldef sqldef = (QuerySqldef)this.get((Serializable)((Object)querySqldef.getId()));
        if (StringUtil.isEmpty((String)querySqldef.getId())) {
            if (byAlias != null) {
                throw new BaseException(querySqldef.getAlias() + "\u8be5\u522b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01");
            }
            String suid = UniqueIdUtil.getSuid();
            querySqldef.setId(suid);
            result = super.save((Object)querySqldef);
            this.initMetafield(querySqldef);
            returnId = suid;
        } else if (BeanUtils.isEmpty((Object)((Object)sqldef)) && StringUtil.isNotEmpty((String)querySqldef.getId())) {
            result = super.save((Object)querySqldef);
            this.initMetafield(querySqldef);
        } else {
            if (byAlias != null && !byAlias.getId().equals(querySqldef.getId())) {
                throw new BaseException(querySqldef.getAlias() + "\u8be5\u522b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01");
            }
            result = super.updateById((Object)querySqldef);
            resultMsg = "\u66f4\u65b0\u81ea\u5b9a\u4e49SQL\u67e5\u8be2\u6210\u529f";
        }
        this.queryMetafieldManager.removeBySqlId(querySqldef.getId());
        List<QueryMetafield> metafields = querySqldef.getMetafields();
        for (int x = 0; x < metafields.size(); ++x) {
            QueryMetafield field = metafields.get(x);
            int sn = x + 1;
            field.setSn((short)sn);
            field.setId(UniqueIdUtil.getSuid());
            this.queryMetafieldManager.create((Model)field);
        }
        return new CommonResult(result, resultMsg, (Object)returnId);
    }

    @Override
    public void checkSql(String sql) {
        if (SQLUtil.containsSqlInjection((String)sql)) {
            throw new BaseException("SQL\u8bed\u53e5\u542b\u6709\u975e\u6cd5\u6ce8\u5165\uff01");
        }
        JdbcTemplate jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
        ResultSet rs = null;
        try (Connection conn = jdbcTemplate.getDataSource().getConnection();
             Statement stmt = conn.createStatement();){
            stmt.setMaxRows(1);
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQL\u9a8c\u8bc1\u5931\u8d25:" + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void checkSqlAll(String sql) {
        if (SQLUtil.containsSqlInjection((String)sql)) {
            throw new BaseException("sql\u8bed\u53e5\u542b\u6709\u975e\u6cd5\u6ce8\u5165\uff01");
        }
        if (SQLUtil.containsSqlUnion((String)sql)) {
            throw new BaseException("\u4e0d\u652f\u6301union\u5173\u952e\u5b57\uff01");
        }
        boolean flag = true;
        if (sql.split("from").length == 2) {
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                Select select = (Select)CCJSqlParserUtil.parse((String)sql);
                SelectBody selectBody = select.getSelectBody();
                org.springframework.util.Assert.isTrue((boolean)(selectBody instanceof PlainSelect), (String)"\u4e0d\u652f\u6301\u9a8c\u8bc1\u7684\u8be5SQL\u8bed\u53e5");
                PlainSelect plainSelect = (PlainSelect)selectBody;
                Table table = (Table)plainSelect.getFromItem();
                if (table.getAlias() != null) {
                    map.put(table.getAlias().getName(), table.getName());
                }
                if (BeanUtils.isNotEmpty((Object)plainSelect.getJoins())) {
                    for (Join join : plainSelect.getJoins()) {
                        Table table1 = (Table)join.getRightItem();
                        if (table1.getAlias() == null) continue;
                        map.put(table1.getAlias().getName(), table1.getName());
                    }
                }
                for (String key : map.keySet()) {
                    String value = (String)map.get(key);
                    if (value.equals(key)) continue;
                    flag = false;
                    break;
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (!flag) {
            throw new BaseException("\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0cSQL\u8bed\u53e5\u8868\u522b\u540d\u5fc5\u987b\u548c\u8868\u540d\u76f8\u540c");
        }
        this.checkSql(sql);
    }

    @Override
    public List<ImportCheckResult> importCheck(QuerySqldefXmlList list) {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        for (QuerySqldefXml querySqldefXml : list.getQuerySqlDefList()) {
            QuerySqldef tmp = this.getByAlias(querySqldefXml.getQuerySqldef().getAlias());
            if (!BeanUtils.isNotEmpty((Object)((Object)tmp))) continue;
            results.add(new ImportCheckResult(true, "\u6570\u636e\u5217\u8868", tmp.getName()));
        }
        return results;
    }

    private void checkBeforeSave(QuerySqldef querySqldef) {
        if (ViewType.sql.equals((Object)querySqldef.getViewType())) {
            if (StringUtils.isBlank((String)querySqldef.getSql())) {
                throw new RuntimeException("\u8bf7\u8f93\u5165SQL\u8bed\u53e5");
            }
        } else {
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)querySqldef.getCustomDialogAlias()), (String)"\u8bf7\u9009\u62e9\u5bf9\u8bdd\u6846", (Object[])new Object[0]);
        }
        if (!StringUtil.isEmpty((String)querySqldef.getId())) {
            return;
        }
        if (this.getByAlias(querySqldef.getAlias()) != null) {
            throw new RuntimeException("\u522b\u540d:" + querySqldef.getAlias() + ",\u5df2\u88ab\u4f7f\u7528");
        }
    }

    @Override
    public QuerySqldef getByAlias(String alias) {
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        queryFilter.addFilter("alias_", (Object)alias, QueryOP.EQUAL);
        PageList pageList = this.query(queryFilter);
        if (pageList != null && !pageList.getRows().isEmpty()) {
            return (QuerySqldef)((Object)pageList.getRows().get(0));
        }
        return null;
    }

    private void initMetafield(QuerySqldef querySqldef) {
        if (ViewType.customDialog.equals((Object)querySqldef.getViewType())) {
            querySqldef.setMetafields(this.getMetafieldFromCustomDialog(querySqldef));
            return;
        }
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)querySqldef.getDsName());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
        String sql = querySqldef.getSql();
        Boolean isTwoTable = true;
        if (sql.toLowerCase().split("from").length == 2 && sql.toLowerCase().split("from")[1].indexOf(".") == -1) {
            isTwoTable = false;
        }
        String dbType = SQLUtil.getDbType();
        if (isTwoTable.booleanValue() && "oracle".equals(dbType)) {
            try {
                ResultSetInterceptor resultSetInterceptor = (ResultSetInterceptor)AppUtil.getBean(ResultSetInterceptor.class);
                List tableList = resultSetInterceptor.getTableNames(querySqldef.getSql());
                List<QueryMetafield> list = new ArrayList<QueryMetafield>();
                for (int i = 0; i < tableList.size(); ++i) {
                    String table = (String)tableList.get(i);
                    String sqlTwo = "select * from " + table;
                    list = this.getMetafield(jdbcTemplate, querySqldef, sqlTwo, list, isTwoTable, table);
                }
                querySqldef.setMetafields(list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ArrayList<QueryMetafield> queryMetafields = new ArrayList<QueryMetafield>();
            List<QueryMetafield> list = this.getMetafield(jdbcTemplate, querySqldef, querySqldef.getSql(), queryMetafields, isTwoTable, "");
            querySqldef.setMetafields(list);
        }
    }

    private List<QueryMetafield> getMetafieldFromCustomDialog(QuerySqldef querySqldef) {
        ArrayList<QueryMetafield> queryMetafields = new ArrayList<QueryMetafield>();
        CustomDialog customDialog = this.customDialogManager.getByAlias(querySqldef.getCustomDialogAlias());
        List customDialogDisplayFields = JsonUtil.toList((String)customDialog.getDisplayfield(), CustomDialogDisplayFieldVo.class);
        for (int i = 0; i < customDialogDisplayFields.size(); ++i) {
            QueryMetafield field = new QueryMetafield();
            field.setSqlId(querySqldef.getId());
            field.setName(((CustomDialogDisplayFieldVo)customDialogDisplayFields.get(i)).getComment());
            field.setFieldName(((CustomDialogDisplayFieldVo)customDialogDisplayFields.get(i)).getField());
            field.setFieldDesc(((CustomDialogDisplayFieldVo)customDialogDisplayFields.get(i)).getField());
            field.setDataType("varchar");
            field.setIsShow((short)1);
            field.setIsSearch((short)0);
            field.setControlType(FieldControlType.ONETEXT.key);
            field.setIsVirtual((short)0);
            field.setSn((short)i);
            queryMetafields.add(field);
        }
        return queryMetafields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryMetafield> getMetafield(JdbcTemplate jdbcTemplate, QuerySqldef querySqldef, String sql, List<QueryMetafield> list, Boolean isTwoTable, String table) {
        ResultSet rs = null;
        String dbType = SQLUtil.getDbType();
        try (Connection conn = jdbcTemplate.getDataSource().getConnection();
             Statement stmt = conn.createStatement();){
            stmt.setMaxRows(1);
            rs = stmt.executeQuery(sql);
            ResultSetMetaData srsmd = rs.getMetaData();
            int count = srsmd.getColumnCount();
            for (int i = 1; i < count + 1; ++i) {
                String cn = "";
                String fn = "";
                if (!"oracle".equals(dbType)) {
                    table = srsmd.getTableName(i);
                }
                if (!isTwoTable.booleanValue()) {
                    cn = srsmd.getColumnName(i).toUpperCase();
                    fn = srsmd.getColumnName(i).toUpperCase();
                } else if (StringUtil.isEmpty((String)table)) {
                    cn = srsmd.getColumnName(i).toUpperCase();
                    fn = srsmd.getColumnName(i).toUpperCase();
                } else if (StringUtil.isNotEmpty((String)table)) {
                    cn = table + "." + srsmd.getColumnName(i).toUpperCase();
                    fn = table + "_" + srsmd.getColumnName(i).toUpperCase();
                }
                String ctn = srsmd.getColumnTypeName(i);
                QueryMetafield field = new QueryMetafield();
                field.setSqlId(querySqldef.getId());
                field.setName(cn);
                field.setFieldName(fn);
                field.setFieldDesc(fn);
                field.setDataType(this.simplifyDataType(ctn));
                field.setIsShow((short)1);
                field.setIsSearch((short)0);
                field.setControlType(FieldControlType.ONETEXT.key);
                field.setIsVirtual((short)0);
                field.setSn((short)i);
                list.add(field);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return list;
    }

    private String simplifyDataType(String type) {
        type = type.toLowerCase();
        String number = this.portalFeignService.getPropertyByAlias("datatype.number");
        String date = this.portalFeignService.getPropertyByAlias("datatype.date");
        String text = this.portalFeignService.getPropertyByAlias("datatype.text");
        String varchar = this.portalFeignService.getPropertyByAlias("datatype.varchar");
        if (varchar.contains(type)) {
            return "varchar";
        }
        if (text.contains(type)) {
            return "clob";
        }
        if (date.contains(type)) {
            return "date";
        }
        if (number.contains(type)) {
            return "number";
        }
        return type;
    }

    @Override
    public String export(String[] idList) throws Exception {
        if (BeanUtils.isEmpty((Object)idList)) {
            return "";
        }
        QuerySqldefXmlList list = new QuerySqldefXmlList();
        for (String id : idList) {
            QuerySqldef def = (QuerySqldef)this.get((Serializable)((Object)id));
            List<QueryMetafield> metaFieldList = this.queryMetafieldManager.getBySqlId(id);
            List<QueryView> viewList = this.queryViewManager.getBySqlAlias(def.getAlias());
            QuerySqldefXml defXml = new QuerySqldefXml();
            defXml.setQuerySqldef(def);
            defXml.setMetafieldList(metaFieldList);
            defXml.setQueryViewList(viewList);
            list.addQuerySqlDef(defXml);
        }
        String xml = JAXBUtil.marshall((Object)list, QuerySqldefXmlList.class);
        return xml;
    }

    @Override
    @Transactional
    public String importDef(String path) {
        try {
            String xml = FileUtil.readFile((String)(path + File.separator + "sqldef.xml"));
            if (StringUtil.isEmpty((String)xml)) {
                return null;
            }
            QuerySqldefXmlList list = (QuerySqldefXmlList)JAXBUtil.unmarshall((String)xml, QuerySqldefXmlList.class);
            List<QuerySqldefXml> sqlDefList = list.getQuerySqlDefList();
            for (QuerySqldefXml defXml : sqlDefList) {
                QuerySqldef tmp = this.getByAlias(defXml.getQuerySqldef().getAlias());
                if (tmp == null) continue;
                return "repeat";
            }
            for (QuerySqldefXml def : sqlDefList) {
                this.importDef(def);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void importDef(QuerySqldefXml def) {
        QuerySqldef sqlDef = def.getQuerySqldef();
        String sqlId = UniqueIdUtil.getSuid();
        sqlDef.setId(sqlId);
        try {
            List<QueryMetafield> metafields = def.getMetafieldList();
            sqlDef.setMetafields(metafields);
            this.save((Object)sqlDef);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("SQL\u9a8c\u8bc1\u5931\u8d25")) {
                throw new BaseException("SQL\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4e0d\u652f\u6301\u5bfc\u5165\uff01");
            }
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        List<QueryView> viewList = def.getQueryViewList();
        for (QueryView view : viewList) {
            view.setId(UniqueIdUtil.getSuid());
            this.queryViewManager.create((Model)view);
        }
        ThreadMsgUtil.addMsg((String)("\u5b9a\u4e49\uff1a" + sqlDef.getName() + "\uff0c\u6210\u529f\u5bfc\u5165!"));
    }

    private void updateDef(QuerySqldef temp, QuerySqldefXml def) {
        QuerySqldef sqlDef = def.getQuerySqldef();
        try {
            List<QueryMetafield> metafields = def.getMetafieldList();
            temp.setMetafields(metafields);
            temp.setDsName(sqlDef.getDsName());
            temp.setSql(sqlDef.getSql());
            temp.setSupportTab(sqlDef.getSupportTab());
            temp.setButtonDef(sqlDef.getButtonDef());
            this.update((Model)temp);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("SQL\u9a8c\u8bc1\u5931\u8d25")) {
                throw new BaseException("SQL\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4e0d\u652f\u6301\u5bfc\u5165\uff01");
            }
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        this.queryViewManager.removeBySqlAlias(temp.getAlias());
        List<QueryView> viewList = def.getQueryViewList();
        for (QueryView view : viewList) {
            view.setId(UniqueIdUtil.getSuid());
            this.queryViewManager.create((Model)view);
        }
        ThreadMsgUtil.addMsg((String)("\u5b9a\u4e49\uff1a" + sqlDef.getName() + "\uff0c\u6210\u529f\u5bfc\u5165!"));
    }

    @Override
    @Transactional
    public List<QueryMetafield> refreshFields(String id) {
        QuerySqldef querySqldef = (QuerySqldef)this.get((Serializable)((Object)id));
        List<QueryMetafield> oldMetafields = this.queryMetafieldManager.getBySqlId(id);
        this.initMetafield(querySqldef);
        List<QueryMetafield> newMetafields = querySqldef.getMetafields();
        ArrayList<QueryMetafield> returnMetafields = new ArrayList<QueryMetafield>();
        for (int x = 0; x < oldMetafields.size(); ++x) {
            for (int i = 0; i < newMetafields.size(); ++i) {
                if (!newMetafields.get(i).getName().equals(oldMetafields.get(x).getName())) continue;
                returnMetafields.add(oldMetafields.get(x));
                newMetafields.remove(i);
            }
        }
        returnMetafields.addAll(newMetafields);
        return returnMetafields;
    }

    @Override
    public CommonResult<String> checkSql(ObjectNode obj) {
        CommonResult result = null;
        try {
            result = (CommonResult)this.databaseContext.switchDS(obj.get("dsName").asText(), dResult -> {
                JdbcTemplate jdbcTemplate = null;
                jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
                String sql = obj.get("sql").asText();
                if (SQLUtil.containsSqlInjection((String)sql)) {
                    return new CommonResult(false, "sql\u8bed\u53e5\u542b\u6709\u975e\u6cd5\u6ce8\u5165\uff01");
                }
                Boolean flag = true;
                if (sql.split("from").length == 2) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    try {
                        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
                        SelectBody selectBody = select.getSelectBody();
                        PlainSelect plainSelect = (PlainSelect)selectBody;
                        Table table = (Table)plainSelect.getFromItem();
                        if (table.getAlias() != null) {
                            map.put(table.getAlias().getName(), table.getName());
                        }
                        for (Join join : plainSelect.getJoins()) {
                            Table table1 = (Table)join.getRightItem();
                            if (table1.getAlias() == null) continue;
                            map.put(table1.getAlias().getName(), table1.getName());
                        }
                        for (String key : map.keySet()) {
                            String value = (String)map.get(key);
                            if (value.equals(key)) continue;
                            flag = false;
                            break;
                        }
                        System.out.println(map);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (flag.booleanValue()) {
                    jdbcTemplate.execute(sql);
                    return new CommonResult("\u9a8c\u8bc1\u901a\u8fc7");
                }
                return new CommonResult(false, "\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0cSQL\u8bed\u53e5\u8868\u522b\u540d\u5fc5\u987b\u548c\u8868\u540d\u76f8\u540c");
            });
        }
        catch (Exception e) {
            result = new CommonResult(false, "SQL\u9a8c\u8bc1\u5931\u8d25:" + e.getMessage());
        }
        return result;
    }

    /*
     * Loose catch block
     */
    @Override
    @Transactional
    public CommonResult<String> importBo(MultipartHttpServletRequest request, HttpServletResponse response) {
        String isRepeat;
        String unZipFilePath;
        block14: {
            MultipartFile fileLoad = request.getFile("file");
            unZipFilePath = null;
            isRepeat = "";
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = fileLoad.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)fileLoad, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            isRepeat = this.querySqldefManager.importDef(unZipFilePath);
            if (!"repeat".equals(isRepeat)) break block14;
            CommonResult commonResult = new CommonResult(true, "confirmUpload", (Object)Base64.getBase64Replace((String)unZipFilePath));
            try {
                File formDir;
                if (StringUtil.isNotEmpty((String)unZipFilePath) && !"repeat".equals(isRepeat) && (formDir = new File(unZipFilePath)).exists()) {
                    FileUtil.deleteDir((File)formDir);
                }
            }
            catch (Exception e) {
                throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            }
            return commonResult;
        }
        CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
        try {
            File formDir;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && !"repeat".equals(isRepeat) && (formDir = new File(unZipFilePath)).exists()) {
                FileUtil.deleteDir((File)formDir);
            }
        }
        catch (Exception e) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
        return commonResult;
        catch (Exception e) {
            try {
                throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    File formDir;
                    if (StringUtil.isNotEmpty(unZipFilePath) && !"repeat".equals(isRepeat) && (formDir = new File(unZipFilePath)).exists()) {
                        FileUtil.deleteDir((File)formDir);
                    }
                }
                catch (Exception e2) {
                    throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff1a" + e2.getMessage());
                }
                throw throwable;
            }
        }
    }

    @Override
    @Transactional
    public CommonResult<String> importFileData(String unZipFilePath) {
        try {
            String xml = FileUtil.readFile((String)(Base64.getFromBase64Replace((String)unZipFilePath) + File.separator + "sqldef.xml"));
            QuerySqldefXmlList list = (QuerySqldefXmlList)JAXBUtil.unmarshall((String)xml, QuerySqldefXmlList.class);
            List<QuerySqldefXml> sqlDefList = list.getQuerySqlDefList();
            for (QuerySqldefXml def : sqlDefList) {
                QuerySqldef tmp = this.getByAlias(def.getQuerySqldef().getAlias());
                if (tmp != null) continue;
                this.importDef(def);
            }
        }
        catch (Exception e) {
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                File formDir;
                String unZipFilePathStr = Base64.getFromBase64((String)unZipFilePath);
                if (StringUtil.isNotEmpty((String)unZipFilePathStr) && (formDir = new File(unZipFilePathStr)).exists()) {
                    FileUtil.deleteDir((File)formDir);
                }
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25");
            }
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<Map<String, String>> importData(QuerySqldefXmlList list, boolean isCover) {
        List<QuerySqldefXml> sqlDefList = list.getQuerySqlDefList();
        for (QuerySqldefXml def : sqlDefList) {
            QuerySqldef tmp = this.getByAlias(def.getQuerySqldef().getAlias());
            if (tmp == null) {
                this.importDef(def);
                continue;
            }
            if (!isCover) continue;
            this.updateDef(tmp, def);
        }
        List alias = sqlDefList.stream().map(item -> item.getQuerySqldef().getAlias()).collect(Collectors.toList());
        Map<String, String> map = this.queryViewManager.list((Wrapper)Wrappers.lambdaQuery().in(QueryView::getSqlAlias, alias)).stream().collect(Collectors.toMap(QueryView::getAlias, QueryView::getId, (k1, k2) -> k1));
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f", map);
    }
}

