/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bo.instance.BoDataRecordHandler;
import com.hotent.bo.model.BoAttribute;
import com.hotent.bo.model.BoDef;
import com.hotent.bo.model.BoEnt;
import com.hotent.bo.persistence.manager.BoDefManager;
import com.hotent.bo.util.BoUtil;
import com.hotent.bo.vo.RemoveBoDefVO;
import com.hotent.form.service.BoDefIService;
import io.seata.spring.annotation.GlobalTransactional;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BoDefIServiceImpl
implements BoDefIService {
    @Autowired
    BoDefManager baseService;
    @Resource
    BoDefManager boDefManager;
    @Resource
    BoDataRecordHandler boDataRecordHandler;

    @Override
    public ObjectNode getSubEntInfo(String ids, Optional<Boolean> isMobile) {
        ObjectNode infoNode = JsonUtil.getMapper().createObjectNode();
        boolean hasSub = false;
        boolean hasSun = false;
        ArrayNode entArray = JsonUtil.getMapper().createArrayNode();
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] idArray;
            for (String id : idArray = ids.split(",")) {
                BoDef def = this.baseService.getByDefId(id);
                BoEnt mainEnt = def.getBoEnt();
                entArray.add((JsonNode)this.getEntNode(mainEnt.getId(), mainEnt.getName(), mainEnt.getDesc(), "main", isMobile.orElse(false)));
                List subEnts = mainEnt.getChildEntList();
                if (!BeanUtils.isNotEmpty((Object)subEnts)) continue;
                hasSub = true;
                for (BoEnt boEnt : subEnts) {
                    entArray.add((JsonNode)this.getEntNode(boEnt.getId(), boEnt.getName(), boEnt.getDesc(), "sub", isMobile.orElse(false)));
                    List sunEnts = boEnt.getChildEntList();
                    if (!BeanUtils.isNotEmpty((Object)sunEnts)) continue;
                    hasSun = true;
                    for (BoEnt sunEnt : sunEnts) {
                        entArray.add((JsonNode)this.getEntNode(sunEnt.getId(), sunEnt.getName(), sunEnt.getDesc(), "sun", isMobile.orElse(false)));
                    }
                }
            }
        }
        infoNode.put("hasSub", hasSub);
        infoNode.put("hasSun", hasSun);
        infoNode.set("entList", (JsonNode)entArray);
        return infoNode;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> batchRemove(String[] ids) {
        RemoveBoDefVO removeBoDefVO = this.boDefManager.checkRelation(ids);
        if (removeBoDefVO.getCountSuccess() <= 0 || CollUtil.isEmpty((Collection)removeBoDefVO.getIdCanRemove())) {
            return new CommonResult(false, this.getCheckRelationMsg(removeBoDefVO, null));
        }
        List<String> errList = this.removeBoDefDetails(removeBoDefVO.getIdCanRemove().toArray(new String[0]));
        if (errList.size() == 0 && removeBoDefVO.getCountFailed() <= 0) {
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        if (errList.size() + removeBoDefVO.getCountFailed() >= ids.length) {
            return new CommonResult(false, this.getCheckRelationMsg(removeBoDefVO, errList));
        }
        return new CommonResult(true, this.getCheckRelationMsg(removeBoDefVO, errList));
    }

    private String getCheckRelationMsg(RemoveBoDefVO removeBoDefVO, List<String> errList) {
        StringBuilder msg = new StringBuilder();
        if (CollUtil.isEmpty(errList)) {
            msg.append(String.format("%s\u4e2a\u4e0d\u5141\u8bb8\u5220\u9664! <br>", removeBoDefVO.getCountFailed()));
        } else {
            msg.append(String.format("%s\u4e2a\u5220\u9664\u5931\u8d25,\u5206\u522b\u4e3a\uff1a%s <br>", errList.size(), StringUtil.join(errList, (String)",")));
        }
        if (removeBoDefVO.getRefMap() != null && !removeBoDefVO.getRefMap().isEmpty()) {
            msg.append("\u4ee5\u4e0b\u4e3a\u5916\u90e8\u8868\u5df2\u88ab\u5176\u4ed6\u5efa\u6a21\u5f15\u7528\u8be6\u60c5\uff0c\u8bf7\u5148\u5220\u9664\u4ee5\u4e0b\u5f15\u7528\u5173\u7cfb\uff1a<br>");
            List listSource = this.boDefManager.list((Wrapper)Wrappers.lambdaQuery().in(BoDef::getId, removeBoDefVO.getRefMap().keySet()));
            for (Map.Entry entry : removeBoDefVO.getRefMap().entrySet()) {
                String sourceId = (String)entry.getKey();
                List boDefsRel = (List)entry.getValue();
                BoDef sourceBoDef = listSource.stream().filter(item -> item.getId().equals(sourceId)).findFirst().orElse(null);
                if (sourceBoDef == null) continue;
                String rels = boDefsRel.stream().map(BoDef::getDescription).collect(Collectors.joining(", "));
                msg.append(String.format("\u5efa\u6a21\u3010%s\u3011\u5bf9\u5e94\u5f15\u7528\u5173\u7cfb\uff1a%s<br>", sourceBoDef.getDescription(), rels));
            }
        }
        return msg.toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @GlobalTransactional(rollbackFor={Exception.class})
    public CommonResult<String> createTableForm(String json, String action) throws Exception {
        CommonResult<String> vresult = this.validateBoAttr(json);
        if (!vresult.getState().booleanValue()) {
            return vresult;
        }
        this.saveModifyLog(json, action);
        String defId = this.baseService.saveFormData(json);
        return new CommonResult(true, defId);
    }

    private void saveModifyLog(String json, String action) throws IOException {
        BoDef newBoDef = (BoDef)JsonUtil.toBean((String)json, BoDef.class);
        StringBuilder content = new StringBuilder();
        if (StringUtil.isEmpty((String)newBoDef.getId())) {
            content.append(String.format("\u5efa\u6a21\u3010%s\u3011\u65b0\u589e;\n", newBoDef.getDescription()));
        } else {
            BoDef oldBoDef = this.boDefManager.getByDefId(newBoDef.getId());
            List oldEnts = BoUtil.boTree2List(Collections.singletonList(oldBoDef.getBoEnt()), BoEnt::getChildEntList);
            BoEnt newEnt = newBoDef.getEnts().stream().filter(ent -> "main".equalsIgnoreCase(ent.getType())).findFirst().get();
            List subEnts = newBoDef.getEnts().stream().filter(ent -> !newEnt.getId().equalsIgnoreCase(ent.getId())).collect(Collectors.toList());
            newEnt.setChildren(subEnts);
            List newEnts = BoUtil.boTree2List(Collections.singletonList(newEnt), BoEnt::getChildren);
            content.append(this.generateModifyContent(newEnts, oldEnts));
        }
        this.boDataRecordHandler.saveShowRecord(newBoDef.getAlias(), content.toString(), action);
    }

    private String generateModifyContent(List<BoEnt> newEnts, List<BoEnt> oldEnts) {
        StringBuilder content = new StringBuilder();
        Map<String, BoEnt> oldEntMap = oldEnts.stream().collect(Collectors.toMap(BoEnt::getName, ent -> ent, (k1, k2) -> k1));
        BeanUtils.compareListChange(newEnts, oldEntMap, BoEnt::getName, t -> content.append(String.format("\u65b0\u589e\u5b9e\u4f53\u3010%s\u3011;\n", t.getDesc())), (old, t) -> {
            ArrayList contentList = new ArrayList();
            Map<String, BoAttribute> attrFieldMap = old.getBoAttrList().stream().collect(Collectors.toMap(BoAttribute::getName, ent -> ent, (k1, k2) -> k1));
            BeanUtils.compareListChange((List)t.getBoAttrList(), attrFieldMap, BoAttribute::getName, b -> contentList.add(String.format("\u65b0\u589e\u3010%s\u3011\u5b57\u6bb5", b.getDesc())), (oldB, b) -> {
                StringBuilder change = new StringBuilder();
                if (!StringUtil.equals((String)oldB.getDesc(), (String)b.getDesc())) {
                    change.append(String.format("\u6ce8\u91ca\u7531\u3010%s\u3011\u4fee\u6539\u4e3a\u3010%s\u3011;", oldB.getDesc(), b.getDesc()));
                }
                if (!StringUtil.equals((String)oldB.getDataType(), (String)b.getDataType())) {
                    change.append(String.format("\u5b57\u6bb5\u7c7b\u578b\u7531\u3010%s\u3011\u4fee\u6539\u4e3a\u3010%s\u3011;", oldB.getDataType(), b.getDataType()));
                }
                if (!StringUtil.equals((String)oldB.getName(), (String)b.getName())) {
                    change.append(String.format("\u5b57\u6bb5\u540d\u79f0\u7531\u3010%s\u3011\u4fee\u6539\u4e3a\u3010%s\u3011;", oldB.getName(), b.getName()));
                }
                if (!StringUtil.equals((String)oldB.getFormat(), (String)b.getFormat())) {
                    change.append(String.format("\u5b57\u6bb5\u683c\u5f0f\u7531\u3010%s\u3011\u4fee\u6539\u4e3a\u3010%s\u3011;", oldB.getFormat(), b.getFormat()));
                }
                if (!StringUtil.equals((String)oldB.getDefaultValue(), (String)b.getDefaultValue())) {
                    change.append(String.format("\u5b57\u6bb5\u9ed8\u8ba4\u503c\u7531\u3010%s\u3011\u4fee\u6539\u4e3a\u3010%s\u3011;", oldB.getDefaultValue(), b.getDefaultValue()));
                }
                if (oldB.getAttrLength() != b.getAttrLength()) {
                    change.append(String.format("\u5b57\u6bb5\u957f\u5ea6\u7531\u3010%s\u3011\u4fee\u6539\u4e3a\u3010%s\u3011;", oldB.getAttrLength(), b.getAttrLength()));
                }
                if (oldB.getIsRequired() != b.getIsRequired()) {
                    change.append(String.format("\u5b57\u6bb5\u5fc5\u586b\u9879\u7531\u3010%s\u3011\u4fee\u6539\u4e3a\u3010%s\u3011;", oldB.getIsRequired() == 1 ? "\u662f" : "\u5426", b.getIsRequired() == 1 ? "\u662f" : "\u5426"));
                }
                if (StringUtil.isNotEmpty((String)change.toString())) {
                    contentList.add(String.format("\u4fee\u6539\u3010%s\u3011\u5b57\u6bb5:%s", b.getDesc(), change));
                }
            }, b -> contentList.add(String.format("\u5220\u9664\u3010%s\u3011\u5b57\u6bb5", b.getDesc())));
            if (!contentList.isEmpty()) {
                content.append(String.format("\u4fee\u6539\u5b9e\u4f53\u3010%s\u3011:", t.getDesc()));
                content.append(String.join((CharSequence)",", contentList));
                content.append("\n");
            }
        }, t -> content.append(String.format("\u5220\u9664\u5b9e\u4f53\u3010%s\u3011;\n", t.getDesc())));
        return content.toString();
    }

    private ObjectNode getEntNode(String id, String alias, String name, String type, boolean isMobile) {
        ObjectNode entNode = JsonUtil.getMapper().createObjectNode();
        entNode.put("id", id);
        entNode.put("alias", alias);
        entNode.put("name", name);
        entNode.put("type", type);
        entNode.put("template", "main".equals(type) ? "grid" : "table");
        entNode.put("column", isMobile ? 1 : 2);
        return entNode;
    }

    private List<String> removeBoDefDetails(String ... ids) {
        ArrayList<String> delIdList = new ArrayList<String>();
        ArrayList<String> errList = new ArrayList<String>();
        ArrayList<String> boList = new ArrayList<String>();
        for (String id : ids) {
            List formDifinitionData = this.boDefManager.getFormDifinitionData(id);
            List definitionTemplateData = this.boDefManager.getDefinitionTemplateData(id);
            BoDef bo = (BoDef)this.baseService.get((Serializable)((Object)id));
            if (formDifinitionData.size() == 0 && definitionTemplateData.size() == 0) {
                delIdList.add(id);
                boList.add(bo.getAlias());
                continue;
            }
            errList.add(this.validateExist(formDifinitionData, bo, "\u8868\u5355"));
            errList.add(this.validateExist(definitionTemplateData, bo, "\u8868\u5355\u6a21\u677f"));
        }
        String[] delIds = delIdList.toArray(new String[0]);
        this.boDataRecordHandler.deleteShowRecord(boList);
        if (errList.size() == 0) {
            this.baseService.removeByIds(delIds);
            return errList;
        }
        return errList;
    }

    private String validateExist(List<Map<String, String>> data, BoDef bo, String formType) {
        ArrayList<String> formNameList = new ArrayList<String>();
        for (Map<String, String> bpmFormDef : data) {
            String type = (String)MapUtil.getIgnoreCase(bpmFormDef, (String)"form_type_");
            String name = (String)MapUtil.getIgnoreCase(bpmFormDef, (String)"name_");
            String typeName = "";
            if ("pc".equals(type)) {
                typeName = "PC";
            }
            if ("mobile".equals(type)) {
                typeName = "\u624b\u673a";
            }
            formNameList.add((StringUtil.isNotEmpty((String)typeName) ? typeName + ":" : "") + name);
        }
        return "\u3010" + bo.getDescription() + "\u3011\u5df2\u7ed1\u5b9a" + formType + "\uff1a" + StringUtil.join(formNameList, (String)",");
    }

    private CommonResult<String> validateBoAttr(String json) {
        try {
            JsonNode jsonObj = JsonUtil.toJsonNode((String)json);
            String dbType = SQLUtil.getDbType();
            if (jsonObj.has("ents")) {
                ArrayNode entArray = (ArrayNode)jsonObj.get("ents");
                for (JsonNode entNode : entArray) {
                    ArrayNode childrens;
                    if (entNode.has("attributeList")) {
                        String type = "main".equals(entNode.get("relation").asText()) ? "\u4e3b" : "\u5b50";
                        ArrayNode attrArray = (ArrayNode)entNode.get("attributeList");
                        HashSet<String> attrSet = new HashSet<String>();
                        for (JsonNode attrNode : attrArray) {
                            int length;
                            String name = attrNode.get("name").asText();
                            if (dbType.equals("oracle") && (length = name.length()) > 28) {
                                return new CommonResult(false, "\u5b57\u6bb5\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc728\uff01", (Object)"");
                            }
                            if (attrSet.contains(name)) {
                                String entName = entNode.get("desc").asText();
                                return new CommonResult(false, type + "\u5b9e\u4f53\u3010" + entName + "\uff08" + entNode.get("name").asText() + "\uff09\u3011\u4e2d\u7684\u5b57\u6bb5\u540d\uff1a" + name + " \u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002");
                            }
                            attrSet.add(name);
                        }
                    }
                    if (!entNode.has("children") || !BeanUtils.isNotEmpty((Object)(childrens = (ArrayNode)entNode.get("children")))) continue;
                    for (JsonNode sunEntNode : childrens) {
                        if (!sunEntNode.has("attributeList")) continue;
                        ArrayNode attrArray = (ArrayNode)sunEntNode.get("attributeList");
                        HashSet<String> attrSet = new HashSet<String>();
                        for (JsonNode attrNode : attrArray) {
                            String name = attrNode.get("name").asText();
                            if (attrSet.contains(name)) {
                                String entName = sunEntNode.get("desc").asText();
                                return new CommonResult(false, "\u5b59\u5b9e\u4f53\u3010" + entName + "\uff08" + sunEntNode.get("name").asText() + "\uff09\u3011\u4e2d\u7684\u5b57\u6bb5\u540d\uff1a" + name + " \u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002");
                            }
                            attrSet.add(name);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            return new CommonResult(false, "\u4fdd\u5b58\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a" + e.getMessage());
        }
        return new CommonResult(true, "\u6821\u9a8c\u901a\u8fc7");
    }
}

