/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.form.enums.ComponentType;
import com.hotent.form.service.FormComponentIOService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class IdentityNumberIOService
implements FormComponentIOService {
    @Resource
    PortalFeignService portalFeignService;
    private static final String GROUP_KEY = "IDENTITY_MANAGER_TYPE";
    private static final String TYPE_KEY = "default";

    @Override
    public ComponentType getType() {
        return ComponentType.IDENTITY_NUMBER;
    }

    @Override
    public String getAlias(ObjectNode options) {
        return JsonUtil.getStrByPath((JsonNode)options, (String)"bindIdentityjson.alias", jsonNode -> {});
    }

    @Override
    public Map<String, String> getExportContent(String ... alias) throws Exception {
        List identities = this.portalFeignService.getIdentitiesByAlias(alias);
        return this.handleExportContent(identities);
    }

    @Override
    public List<ImportCheckResult> importCheck(Map<String, String> map) throws IOException {
        String json = map.get(this.getKey());
        if (StringUtil.isEmpty((String)json)) {
            return new ArrayList<ImportCheckResult>();
        }
        List list = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<ObjectNode>>(){});
        return this.portalFeignService.importCheckIdentities(list);
    }

    @Override
    public void importData(Map<String, String> map, String status) throws IOException {
        String json = map.get(this.getKey());
        if (StringUtil.isEmpty((String)json)) {
            return;
        }
        List list = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<ObjectNode>>(){});
        ObjectNode sysTypeByType = this.portalFeignService.getSysTypeByType(GROUP_KEY, TYPE_KEY);
        if (BeanUtils.isEmpty((Object)sysTypeByType)) {
            throw new BaseException("\u5b57\u5178\u4e0d\u5b58\u5728\u9ed8\u8ba4\u5206\u7c7b");
        }
        this.portalFeignService.importIdentities(list, status, JsonUtil.getString((JsonNode)sysTypeByType, (String)"id"));
    }
}

