/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.form.util;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.PermissionDeniedException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.ReflectUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.bo.enums.ResourceModelType;
import com.hotent.bo.enums.ResourcesRightType;
import com.hotent.bo.model.ResourceBaseModel;
import com.hotent.form.dto.ResourceAuthActDTO;
import com.hotent.form.dto.ResourceAuthDTO;
import com.hotent.form.manager.FormAuthorizeManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CustomUtil {
    public static final String DEFAULTTYPE_INPUT_PARAM = "1";
    public static final String DEFAULTTYPE_FIX_VALUE = "2";
    public static final String DEFAULTTYPE_SCRIPT = "3";
    public static final String DEFAULTTYPE_INPUT_TRENDS = "4";

    public static Object buildValue(String field, String defaultType, String defaultValue, Map<String, Object> params) {
        String script;
        Object value = null;
        if (defaultType.equals(DEFAULTTYPE_INPUT_PARAM) || defaultType.equals(DEFAULTTYPE_INPUT_TRENDS)) {
            if (MapUtil.containsIgnoreKey(params, (String)field) && StringUtil.isNotEmpty((String)MapUtil.getIgnoreCase(params, (String)field).toString())) {
                value = MapUtil.getIgnoreCase(params, (String)field).toString();
            }
        } else if (defaultType.equals(DEFAULTTYPE_FIX_VALUE)) {
            value = defaultValue;
        } else if (defaultType.equals(DEFAULTTYPE_SCRIPT) && StringUtil.isNotEmpty((String)defaultValue)) {
            BpmRuntimeFeignService runtime = (BpmRuntimeFeignService)AppUtil.getBean(BpmRuntimeFeignService.class);
            value = runtime.executeScriptObject(defaultValue).getValue();
        }
        if (value != null && value.toString().contains("scriptImpl.") && StringUtil.isNotEmpty((String)(script = value.toString()))) {
            BpmRuntimeFeignService runtime = (BpmRuntimeFeignService)AppUtil.getBean(BpmRuntimeFeignService.class);
            value = runtime.executeScript(script).getValue();
        }
        return value;
    }

    public static Object handleDateBetweenValue(Object value) {
        String[] aryDate = value.toString().split("\\|");
        String startDate = aryDate[0];
        String endDate = aryDate[1];
        LocalDateTime d = DateFormatUtil.parse((String)endDate, (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss.SSS"});
        endDate = d.plusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        ObjectNode tjo = JsonUtil.getMapper().createObjectNode();
        tjo.put("startDate", startDate);
        tjo.put("endDate", endDate);
        return tjo;
    }

    public static <T> Map<String, Boolean> getRightMapByModel(Class<? extends ResourceBaseModel<?>> cls, ResourceModelType authModelType, ResourcesRightType type) throws IOException {
        CommonManager commonManager = (CommonManager)AppUtil.getBean(CommonManager.class);
        HashMap<String, Boolean> rightMap = new HashMap<String, Boolean>();
        TableName tableName = cls.getAnnotation(TableName.class);
        if (tableName == null) {
            throw new BaseException("\u672a\u627e\u5230\u8868\u540d\uff0c\u65e0\u6cd5\u6267\u884c\u5224\u65ad\u6743\u9650");
        }
        IUser currentUser = ContextUtil.getCurrentUser();
        String aliasColumn = "";
        List allField = ReflectUtil.getAllField(cls);
        for (Field field : allField) {
            TableField tableField = field.getAnnotation(TableField.class);
            String name = field.getName();
            if (tableField != null && tableField.value() == null || !name.equals(authModelType.getAliasProp())) continue;
            aliasColumn = tableField.value();
        }
        String sql = String.format("select %s As key from %s", aliasColumn, tableName.value());
        List AllList = commonManager.query(sql);
        FormAuthorizeManager formAuthorizeManager = (FormAuthorizeManager)AppUtil.getBean(FormAuthorizeManager.class);
        ResourceAuthDTO resourceAuthDTO = formAuthorizeManager.getResourceRightByUserId(ContextUtil.getCurrentUserId(), authModelType.getType(), type.getType());
        Boolean defaultRight = false;
        if (currentUser.isAdmin() || BeanUtils.isNotEmpty(resourceAuthDTO.getRightMapAll())) {
            defaultRight = true;
        }
        for (Map d : AllList) {
            if (!BeanUtils.isNotEmpty((Object)d)) continue;
            rightMap.put(MapUtil.getStringIgnoreKey((Map)d, (String)"key", (String)""), defaultRight);
        }
        if (currentUser.isAdmin() || BeanUtils.isNotEmpty(resourceAuthDTO.getRightMapAll())) {
            return rightMap;
        }
        Set<String> typeRight = resourceAuthDTO.getRightMapType() == null ? null : resourceAuthDTO.getRightMapType().stream().map(ResourceAuthActDTO::getModelKey).collect(Collectors.toSet());
        Set<String> keySet = CustomUtil.getKeyByTypeIdsAndCreateBy(cls, authModelType, type, typeRight, true);
        if (CollUtil.isNotEmpty(resourceAuthDTO.getRightMapModel())) {
            keySet.addAll(resourceAuthDTO.getRightMapModel().stream().map(ResourceAuthActDTO::getModelKey).collect(Collectors.toSet()));
        }
        for (String key : keySet) {
            rightMap.put(key, true);
        }
        return rightMap;
    }

    public static boolean checkRight(Map<String, Boolean> rightMap, String key) throws IOException {
        return !rightMap.containsKey(key) || rightMap.get(key) != false;
    }

    public static boolean checkEditRight(Class<? extends ResourceBaseModel<?>> cls, ResourceModelType authModelType, String key) throws IOException {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (currentUser.isAdmin()) {
            return true;
        }
        Map<String, Boolean> rightMap = CustomUtil.getRightMapByModel(cls, authModelType, ResourcesRightType.EDIT);
        if (!rightMap.containsKey(key) || rightMap.get(key).booleanValue()) {
            return true;
        }
        throw new PermissionDeniedException("\u4fdd\u5b58\u5931\u8d25\uff1a\u6ca1\u6709[" + authModelType.getDesc() + "]\u7f16\u8f91\u6743\u9650");
    }

    public static <T> Set<String> getKeyByTypeIdsAndCreateBy(Class<? extends ResourceBaseModel<?>> cls, ResourceModelType authModelType, ResourcesRightType type, Set<String> typeIds, boolean inCludCreateBy) throws IOException {
        CommonManager commonManager = (CommonManager)AppUtil.getBean(CommonManager.class);
        HashSet<String> keySet = new HashSet<String>();
        TableName tableName = cls.getAnnotation(TableName.class);
        if (tableName == null) {
            throw new BaseException("\u672a\u627e\u5230\u8868\u540d\uff0c\u65e0\u6cd5\u6267\u884c\u5224\u65ad\u6743\u9650");
        }
        String aliasColumn = "";
        String createIdColumn = "";
        String typeIdColumn = "";
        List allField = ReflectUtil.getAllField(cls);
        for (Field field : allField) {
            TableField tableField = field.getAnnotation(TableField.class);
            String name = field.getName();
            if (tableField != null && tableField.value() == null) continue;
            if (name.equals(authModelType.getAliasProp())) {
                aliasColumn = tableField.value();
                continue;
            }
            if (name.equals(authModelType.getCreateIdProp())) {
                createIdColumn = tableField.value();
                continue;
            }
            if (!name.equals(authModelType.getTypeIdProp())) continue;
            typeIdColumn = tableField.value();
        }
        List query = null;
        String sql = String.format("select %s As \"key\" from %s", aliasColumn, tableName.value());
        QueryFilter queryFilter = QueryFilter.build();
        if (StringUtil.isNotEmpty((String)createIdColumn) && inCludCreateBy) {
            queryFilter.addFilter(createIdColumn, (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL, FieldRelation.OR);
        }
        if (StringUtil.isNotEmpty((String)typeIdColumn) && BeanUtils.isNotEmpty(typeIds)) {
            queryFilter.addFilter(typeIdColumn, new ArrayList<String>(typeIds), QueryOP.IN, FieldRelation.OR);
        }
        if (BeanUtils.isEmpty((Object)queryFilter.getQuerys())) {
            return keySet;
        }
        query = commonManager.queryByCustomSqlNoPage(sql, queryFilter);
        if (BeanUtils.isNotEmpty((Object)query)) {
            query.forEach(d -> {
                if (BeanUtils.isNotEmpty((Object)d)) {
                    keySet.add(MapUtil.getStringIgnoreKey((Map)d, (String)"key", (String)""));
                }
            });
        }
        return keySet;
    }

    public static <T> void filterHasNoUseRight(List<? extends ResourceBaseModel<?>> list) {
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        try {
            FormAuthorizeManager formAuthorizeManager = (FormAuthorizeManager)AppUtil.getBean(FormAuthorizeManager.class);
            ResourceBaseModel<?> modelIntance = list.get(0);
            Class<?> cls = list.get(0).getClass();
            Set<String> resourceNoRight = formAuthorizeManager.getCurUserCanNotUseKeys(modelIntance.getAuthModelType(), cls);
            if (BeanUtils.isEmpty(resourceNoRight)) {
                return;
            }
            Iterator<ResourceBaseModel<?>> iterator = list.iterator();
            while (iterator.hasNext()) {
                ResourceBaseModel<?> model = iterator.next();
                Object alias = BeanUtils.getValue(model, (String)model.getAuthModelType().getAliasProp());
                if (model.getCreateBy().equals(ContextUtil.getCurrentUserId()) || !resourceNoRight.contains(alias)) continue;
                iterator.remove();
            }
        }
        catch (Exception e) {
            throw new BaseException("\u4f7f\u7528\u6743\u9650\u6821\u9a8c\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

