<#assign rootUrl><#noparse>${</#noparse>window.context.${cfg.system}<#noparse>}</#noparse><#if package.ModuleName??>/${package.ModuleName}</#if>/${table.entityPath}/v1</#assign>
//应用端eip-front的request
import request from '@/utils/request'

//管理端manage的request，如果在管理端使用则使用下面两行代码
//import req from '@/request.js'
//const request = req.request

const baseUrl = `${rootUrl}`;

export default {
  loadData(data) {
    return request({
      url: `<#noparse>${baseUrl}</#noparse>/query`,
      method: 'post',
      data,
    })
  },
  getDetail(id) {
    return request({
      url: `<#noparse>${baseUrl}</#noparse>/getDetail?id=<#noparse>${id}</#noparse>`,
    })
  },
  save(data) {
    return request({
      url: `<#noparse>${baseUrl}</#noparse>/save`,
      method: 'post',
      data,
    })
  },
  deleteByIds(ids) {
    return request({
      method: 'delete',
      url: `<#noparse>${baseUrl}</#noparse>/?ids=<#noparse>${ids}</#noparse>`,
    })
  },
  copyById(id,ignoreFields) {
    return request({
      method: 'get',
      url: `<#noparse>${baseUrl}</#noparse>/copy?id=<#noparse>${id}</#noparse>&ignoreFields=<#noparse>${ignoreFields}</#noparse>`,
    })
  },
  updateData(ids,field,value) {
    return request({
      method: 'get',
      url: `<#noparse>${baseUrl}</#noparse>/updateData?ids=<#noparse>${ids}</#noparse>&field=<#noparse>${field}</#noparse>&value=<#noparse>${value}</#noparse>`,
    })
  },
  //业务数据导出
  exportByFilter(filter,ignoreFields) {
    return request({
      url: `<#noparse>${baseUrl}</#noparse>/exportByFilter?ignoreFields=<#noparse>${ignoreFields}</#noparse>`,
      method: 'post',
      data: filter,
      timeout: 30000,
      responseType: 'arraybuffer',
    })
  },
  importData(data) {
    return request({
      url: `<#noparse>${baseUrl}</#noparse>/importData`,
      data: data,
      method: 'post',
      timeout: 30000,
    })
  },
}