<#-- ----------------------- 生成在线表单的编辑页的模板 ----------------------------->
<#assign baseUrl><#noparse>${</#noparse>${cfg.system}<#noparse>}</#noparse><#if package.ModuleName??>/${package.ModuleName}</#if>/${table.entityPath}/v1</#assign>
<template>
  <div data-vv-scope="${table.entityName}Form">
    <el-dialog
      title="<#if table.comment??>${table.comment}<#else>实体信息</#if>"
      :visible="dialogVisible"
      :before-close="beforeCloseDialog"
      :fullscreen="true"
      :append-to-body="true"
    >
      <template>
	  	${cfg.form.formHtml}
	   </template>
      <div slot="footer" style="text-align: center">
        <el-button type="primary" v-if="!readonly" @click="save()">保存</el-button>
        <el-button @click="beforeCloseDialog">取消</el-button>
      </div>
    </el-dialog>
  </div>
</template>
<script>
import api from "@/api/${table.entityName}.js";
import templateEdit from '@/mixins/dataTemplate/templateEdit.js'
export default {
  name: '${table.entityName}ManagerEdit',
  mixins: [templateEdit],
  data() {
    return {
      dialogVisible: false,
      isView: false,
      saveMethod: "POST",
      data: ${cfg.data},
      permission: ${cfg.permission}
    };
  },
  created() {
    this.$nextTick(() => {
      this.handlerJs()
    })
  },
  methods: {
    handlerJs(){
      ${cfg.form.diyJs!}
    },
    showDialog(id) {
      this.blankData = JSON.parse(JSON.stringify(this.data))
      if (id) {
        this.saveMethod = "PUT";
        api.getDetail(id).then(
          resp => {
          	if (resp && resp.state) {
              Object.assign(Object.values(this.data)[0], resp.value)
              this.dialogVisible = true;
            }
          }
        );
      } else {
        this.saveMethod = "POST";
        this.dialogVisible = true;
      }
    },
    beforeCloseDialog() {
      this.data = JSON.parse(JSON.stringify(this.blankData));
      this.dialogVisible = false;
    },
    afterSaveData() {
      setTimeout(() => {
        this.beforeCloseDialog();
        this.$parent && this.$parent.loadData({})
      }, 500);
    },
    save() {
      this.$root.$validator.validateAll('${table.entityName}Form').then((result) => {
          if (result) {
            api.save(Object.values(this.data)[0]).then(() => {
              this.afterSaveData()
            })
          } else {
            this.$message.error('未通过表单校验，请正确填写表单。')
          }
        })
    }
  }
};
</script>
