<#-- ----------------------- 生成物理表编辑页的模板 ----------------------------->
<#assign baseUrl><#noparse>${</#noparse>${cfg.system}<#noparse>}</#noparse><#if package.ModuleName??>/${package.ModuleName}</#if>/${table.entityPath}/v1</#assign>
<template>
  <div class="fullheight">
    <ht-sidebar-dialog
      width="28%"
      title="<#if table.comment??>${table.comment}<#else>实体信息</#if>"
      class="sp-manager__dialog"
      :visible="dialogVisible"
      :before-close="beforeCloseDialog"
    >
      <el-form v-form data-vv-scope="${table.entityName}Form">
        <#list table.fields as field>
        <ht-form-item label="${field.comment!""}">
          <ht-input v-model="${table.entityName}.${field.propertyName}" validate="required" />
        </ht-form-item>
        </#list>
      </el-form>
      <div slot="footer" style="text-align: center">
        <el-button @click="save" type="primary">保存</el-button>
        <el-button @click="beforeCloseDialog">取消</el-button>
      </div>
    </ht-sidebar-dialog>
  </div>
</template>
<script>
import api from "@/api/${table.entityName}.js"
export default {
  data() {
    return {
      dialogVisible: false,
      ${table.entityName}: {},
      saveMethod: "POST"
    };
  },
  mounted() {
    this.$validator = this.$root.$validator;
  },
  methods: {
    showDialog(id) {
      if (id) {
        this.saveMethod = "PUT";
        api.getDetail(id).then((resp) => {
          let response = resp.data || resp
          this.${table.entityName} = response.value
          this.dialogVisible = true
          })
      } else {
        this.saveMethod = "POST";
        this.dialogVisible = true;
      }
    },
    beforeCloseDialog() {
      this.${table.entityName} = {};
      this.dialogVisible = false;
    },
    afterSaveData() {
      setTimeout(() => {
        this.beforeCloseDialog();
        this.$parent && this.$parent.loadData({})
      }, 500);
    },
    save() {
      api.save(this.${table.entityName}).then((resp) => {
        let response = resp.data || resp
        if (response.state) {
          this.$message.success(response.message || '保存成功')
          this.afterSaveData()
        }
      })
    }
  }
};
</script>
<style lang="scss" scoped>
.sp-manager__dialog ::v-deep .el-dialog > .el-dialog__body {
  height: calc(100% - 170px);
}
</style>
