package ${cfg.basePackage};

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;

/**
 *  启动类
 */
@SpringBootApplication(exclude = DruidDataSourceAutoConfigure.class)
@Configuration
@MapperScan(basePackages={"com.hotent.**.dao"<#if cfg.scanPackage??>,"${cfg.scanPackage}.**.dao"</#if>})
@ComponentScan(basePackages={"com.hotent.*"<#if cfg.scanPackage ??>,"${cfg.scanPackage}.*"</#if>},
        excludeFilters= {@ComponentScan.Filter(type= FilterType.ASSIGNABLE_TYPE, value=DruidDataSourceAutoConfigure.class)})
@EnableFeignClients(basePackages = {"com.hotent.*"<#if cfg.scanPackage ??>,"${cfg.scanPackage}.*"</#if>})
public class Application {
    public static void main(String[] args) {
        SpringApplication.run(Application.class, args);
    }
}
