package ${cfg.basePackage}.${cfg.moduleName}.service;

import com.hotent.base.model.CommonResult;
import ${cfg.basePackage}.${cfg.moduleName}.entity.DefaultBpmProcessInstance;
import ${cfg.basePackage}.${cfg.moduleName}.vo.FlowImageDataVo;

import java.util.Map;

/**
 * 流程 服务类
 *
 * @author Blade
 * @since 2022-07-28
 */
public interface FlowService {

	/**
	 * 启动流程
	 * @param account 用户账号
	 * @param flowKey 流程定义key
	 * @param businessKey 业务数据key
	 * @return 实例详情
	 */
	DefaultBpmProcessInstance start(String account, String flowKey, String businessKey, Map<String, String> vars);

	/**
	 * 根据流程实例ID获取流程图
	 * @param instId 流程实例ID
	 * @return 图片数据
	 */
	FlowImageDataVo getBpmImage(String instId) throws Exception;

	/**
	 * 获取流程审批历史
	 * @param instId 流程实例ID
	 * @return
	 * @throws Exception 历史数据
	 */
	CommonResult<?> instanceFlowOpinions(String instId) throws Exception;

	/**
	 * 处理任务-同意。根据实例ID找到最后需要处理的任务；根据实例ID找到业务系统表单数据中的采购金额
	 * @param instId 流程实例ID
	 * @param amount  业务字段信息：采购金额
	 * @param actionName  审批动作,agree（审批）abandon（弃权）oppose（反对）agreeTrans（同意流转）opposeTrans（反对流转）commu（沟通反馈）reject（驳回）backToStart（驳回指定节点）
	 * @return
	 * @throws Exception
	 */
	CommonResult<?> complete(String instId, String code, String amount, String actionName, Map<String, String> vars) throws Exception;

	/**
	 * 根据实例ID获取实例状态
	 * @param instId 实例ID
	 * @return 实例状态
	 */
	String getStatusByInstId(String instId) throws Exception;

	/**
	 * 根据业务主键获取实例状态及实例ID
	 * @param id
	 * @return
	 * @throws Exception
	 */
	DefaultBpmProcessInstance getStatusByBusinessId(String id) throws Exception;
}
