package ${cfg.basePackage}.${cfg.moduleName}.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.JsonUtil;
import ${cfg.basePackage}.${cfg.moduleName}.config.EipConfig;
import ${cfg.basePackage}.${cfg.moduleName}.entity.BpmNodeLayout;
import ${cfg.basePackage}.${cfg.moduleName}.entity.DefaultBpmProcessInstance;
import ${cfg.basePackage}.${cfg.moduleName}.entity.DefaultBpmTask;
import ${cfg.basePackage}.${cfg.moduleName}.service.EipFeignService;
import ${cfg.basePackage}.${cfg.moduleName}.service.FlowService;
import ${cfg.basePackage}.${cfg.moduleName}.vo.*;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * TODO
 *
 * @author 欧阳高龙
 * @company 广州宏天软件股份有限公司
 * @since 2022/8/5 10:16
 */
@Service
public class FlowServiceImpl implements FlowService {

	@Autowired
	EipFeignService eipFeignService;
	@Resource
	EipConfig eipConfig;

	@Override
	public DefaultBpmProcessInstance start(String account, String flowKey, String businessKey, Map<String, String> vars) {
		StartFlowParamObjectVo startFlowParamObjectVo = new StartFlowParamObjectVo();
		startFlowParamObjectVo.setAccount(account);
		startFlowParamObjectVo.setFlowKey(flowKey);
		startFlowParamObjectVo.setBusinessKey(businessKey);
		startFlowParamObjectVo.setSysCode(eipConfig.getSysCode());
		try{
			startFlowParamObjectVo.setData(this.getData(businessKey, vars));
		} catch (Exception e){
			System.out.println("设置data数据异常：" + e.getMessage());
		}
		if(CollUtil.isNotEmpty(vars)){
			startFlowParamObjectVo.setVars(vars);
		}
		try{
			StartResult startResult = eipFeignService.start(startFlowParamObjectVo,getToken());
			return startResult.getInst();
		} catch (Exception e){
			throw new RuntimeException("启动流程异常！", e);
		}
	}
	private String getData(String businessKey, Map<String, String> vars)throws Exception {
		//获取data，并base64编码
		UrlDataVo urlDataVo = new UrlDataVo();
		urlDataVo.setSysCode(eipConfig.getSysCode());
		urlDataVo.setBusinessKey(businessKey);
		if(CollUtil.isNotEmpty(vars)){
			urlDataVo.setVars(vars);
		}
		return com.hotent.base.util.Base64.getBase64(JsonUtil.toJsonString(urlDataVo));
	}

	@Override
	public FlowImageDataVo getBpmImage(String instId) throws Exception {
		FlowImageDataVo flowImageDataVo = new FlowImageDataVo();
		String token = getToken();
		double scale = 1.5;
		FlowImageVo instFlowInfo = eipFeignService.instanceFlowImage(instId, scale, token);
		flowImageDataVo.setInstFlowInfo(instFlowInfo);
		flowImageDataVo.setBpmImage(eipFeignService.getBpmImage(instId, scale, token));
		if(instFlowInfo != null && instFlowInfo.getBpmDefLayout() != null
			&& !CollectionUtils.isEmpty(instFlowInfo.getBpmDefLayout().getListLayout())){
			List<String> list = new ArrayList<>();
			for (BpmNodeLayout layout : instFlowInfo.getBpmDefLayout().getListLayout()){
//				if(NodeType.USERTASK.equals(layout.getNodeType()) || NodeType.SIGNTASK.equals(layout.getNodeType()) ){
//					list.add(layout.getNodeId());
//				}
				list.add(layout.getNodeId());
			}
			String nodeIds = StringUtils.join(list.toArray(), ',');
			flowImageDataVo.setMapNodeOpinion(eipFeignService.nodeOpinion(instId, nodeIds, token));
		}

		return flowImageDataVo;
	}

	@Override
	public CommonResult<?> instanceFlowOpinions(String instId) throws Exception {
		return eipFeignService.opinionHistory(instId, getToken());
	}

	@Override
	public CommonResult<?> complete(String instId, String code, String amount,String actionName, Map<String, String> vars) throws Exception {
//		String token = getTokenByAccount("zhangsan01");
		String token = getToken();
		//获取待处理的任务ID
		CommonResult<?> result = eipFeignService.getTasksByInstId(instId, token);
		if(result.getValue() == null){
			return CommonResult.error("获取待处理的任务ID失败！");
		}
		JsonNode json = JsonUtil.toJsonNode(result.getValue());
		ArrayNode jsonArray = (ArrayNode)json.get("rows");
		if(jsonArray == null || jsonArray.size() <= 0){
			return CommonResult.error("获取待处理的任务列表为空！");
		}
		DefaultBpmTask task = JsonUtil.toBean(jsonArray.get(0), DefaultBpmTask.class);
		if(task == null || StringUtils.isEmpty(task.getTaskId())){
			return CommonResult.error("获取待处理的任务ID为空！");
		}
		String taskId = task.getTaskId();
		//执行同意操作
		DoNextParamObjectVo doNextParamObject = new DoNextParamObjectVo();
		doNextParamObject.setActionName(actionName);
		doNextParamObject.setAgentLeaderId("0");
		doNextParamObject.setFormType("frame");
		doNextParamObject.setOpinion("同意");
		doNextParamObject.setFiles("\"\"");
		doNextParamObject.setFormKey("");
		doNextParamObject.setJumpType("");
		doNextParamObject.setZfiles("");
		doNextParamObject.setDestination("");
		doNextParamObject.setTaskId(taskId);
		doNextParamObject.setBusinessKey(code);
		doNextParamObject.setData(this.getData(code, vars));
		if(CollUtil.isNotEmpty(vars)){
			doNextParamObject.setVars(vars);
		}
		result = eipFeignService.complete(doNextParamObject, token);
		if(result.getCode() != 200){
			return CommonResult.error(result.getMessage());
		}
		return CommonResult.success(result.getMessage());
	}

	@Override
	public String getStatusByInstId(String instId) throws Exception {
		String token = getToken();
		DefaultBpmProcessInstance instance = eipFeignService.getByInstId(instId, token);
		if(instance == null){
			return Strings.EMPTY;
		}
		return instance.getStatus();
	}

	@Override
	public DefaultBpmProcessInstance getStatusByBusinessId(String id) throws Exception {
		String token = getToken();
		return eipFeignService.getInstancetByBusinessKey(id, token);
	}

	private String getToken(){
		return getTokenByAccount("admin");
	}
	private String getTokenByAccount(String userAccount){
		UserAuthVo userAuthVo = new UserAuthVo();
		userAuthVo.setUsername(userAccount);
		userAuthVo.setPassword(eipConfig.getPwd());
//		userAuthVo.setPassword("VXhLKl7ImxvbLMZ0dQFfo4QF13wZxcEC7qVoPlb0D2QB8h5N28eiCcpFUW6PJiHwNQAV1Id/qrbuDTLQuyzH7uWKGf/xWrDVZSVCs0r3wzdjthIfRUA6EFaxPFz7CVJIZy/XgeHOCD5rjotrMD4iUXoBFrsgCR//y9d2D8fz934=");
		ResponseEntity<Map<String,Object>> response = eipFeignService.auth(userAuthVo);
		if(!HttpStatus.OK.equals(response.getStatusCode()) ){
			throw new RuntimeException("获取用户token返回异常！" + response.getStatusCode().toString());
		}
		if(response.getBody() == null || !(response.getBody() instanceof HashMap)
			|| response.getBody().get("token") == null ){
			throw new RuntimeException("获取用户token返回结构不正确！");
		}
		return "Bearer "+ response.getBody().get("token").toString();
	}


}
