
<#function getNgModel field type>
    <#assign rtn><#if type!=1>item.${field.name}<#else>data.${field.fieldPath}</#if></#assign>
    <#return rtn>
</#function>
<#function getSubNgModel field type>
    <#assign rtn><#if type!=1>data.${field.boDefAlias}.${field.parentNodeType}_${field.tableName}.${field.name}</#if></#assign>
    <#return rtn>
</#function>
<#function getPermissionLine field type hasLinkage>
 	<#assign rtn>
 		<#if type!=1 && hasLinkage==true>v-permission-line="'${field.parentNodeType}_${field.tableName}_${field.name}'"<#else></#if></#assign>
	<#return rtn>
</#function>
<#function getAtter field type>
 	<#assign rtn><#if type!=1>item.${field.name}<#else>data.${field.tableName}.${field.name}</#if></#assign>
	<#return rtn>
</#function>
<#function getPermission field type>
	<#assign rtn>permission.fields.${field.tableName}.${field.name}</#assign>
	<#if rtn?matches("^permission\\.fields\\.\\w+\\.\\w+$")>
		<#return rtn>
	<#else>
		<#stop "Incorrect field format: ${field.desc}">
	</#if>
</#function>
<#function getFormula field type>
	<#assign rtn>
		<#if type==2>
			'data.${field.boDefAlias}.${field.parentNodeType}_${field.tableName}['+(getPageOffset('data.${subListPath}') + $index)+'].${field.name}'
		<#elseif type==1>
			'${getNgModel(field,type)}'
		<#elseif type == 3>
			'data.${subListPath}['+(getPageOffset('data.${subListPath}') + $index )+'].sub_${field.boSubEntity}['+sunIndex+'].${field.name}'
		<#else>
			'data.${subName}['+sunIndex+'].${field.name}'
		</#if>
	</#assign>
	<#return rtn>
</#function>
<#-- 调用方式：${getHyperlink(field)}-->
<#function getHyperlink field>
	<#assign hyperlink>
		<#if field.options.hyperlinkUrl?if_exists && field.options.hyperlinkUrl?length gt 0>
			:hyperlink="{url: '${field.options.hyperlinkUrl}', openType: '${field.options.hyperlinkOpenType}', width: '${field.options.hyperlinkWidth}', height: '${field.options.hyperlinkHeight}'}"
		</#if>
	</#assign>
	<#return hyperlink>
</#function>
<#-- 调用方式：${getScanConfig(field)}-->
<#function getScanConfig field>
	<#assign scanConfigStr>
		<#if field.options.scanConfig?if_exists && field.options.scanConfig.isScanInput>
			scanConfig="${util.getBase64(util.getJsonByPath(field.options,"scanConfig"))}"
		</#if>
	</#assign>
	<#return scanConfigStr>
</#function>
<#function getInput field type hasLinkage layout>
	<#assign configAttr = util.getInputAdvancedAttributes(field.options)>
	<#assign rtn>
        <ht-input <#if field.options.showCondition.fieldPath?if_exists>v-if="${field.options.showCondition.fieldPath}=='${field.options.showCondition.value}'"</#if>
				  v-model="${getNgModel(field,type)}"
				  <#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				  <#else>
					name="${field.desc}"
				  </#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				  <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
                  <#if field.options.placeholder?if_exists>
					   <#if field.placeholderI18nKey?if_exists>
						   :placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
					   <#else>
				   		placeholder="${field.options.placeholder}"
					   </#if>
				   </#if>
                  :permission="${getPermission(field,type)}"
                  ${getPermissionLine(field,type,hasLinkage)}
                  <#if field.options.isReadonly ?if_exists>readonly</#if>
									<#if field.options.isInputEdit ?if_exists>:disabled="${field.options.isInputEdit}"</#if>
									<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
									
									<#if field.options.inputType ?if_exists>:showPassword="${field.options.inputType}"</#if>
                  <#if field.options.validate?if_exists && field.options.validate?length gt 0 >:validate="${field.options.validate}"</#if>
				  <#if configAttr != "{}">:config-attributes="${configAttr}"</#if>
                  <#if field.options.mathExp?if_exists>math-exp="${field.options.mathExp}"</#if>
				  <#if field.options.isCountDate> :date-calc-exp="{start:'${field.options.isStartDate}',end:'${field.options.isEndDate}',diffType:'${field.options.countFormat}'}"</#if>
				  <#if field.options.formulasDiyJs?if_exists >
					  <#if layout.vxeTable>
						  v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)},type:'vxe', index:$index}"
					  <#else>
						  v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)}}"
					  </#if>
				  </#if>
					<#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
        		  <#if field.options.mapping?if_exists>v-mapping="data.${field.options.mapping}"</#if>
             	<#if field.options.width?if_exists>
              		style="width: ${field.options.width};"
				<#else>
					style="width: 100%;"
              	</#if>
				${getHyperlink(field)}
				${getScanConfig(field)}
        >
				 <#if field.options.bindPreAndSufFixjson.preFix?if_exists><template slot="prepend">${field.options.bindPreAndSufFixjson.preFix}</template> </#if>
        <#if field.options.bindPreAndSufFixjson.sufSix?if_exists> <template slot="append">${field.options.bindPreAndSufFixjson.sufSix}</template></#if>
        </ht-input>
	</#assign>
	<#return rtn>
</#function>
<#function getNumberInput field type hasLinkage layout>
	<#assign rtn>
        <ht-input v-model="${getNgModel(field,type)}"
				  <#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				  <#else>
					name="${field.desc}"
				  </#if>
				   <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				  ctrlType="${field.ctrlType}" <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				   type="number" company="${field.options.company}" :permission="${getPermission(field,type)}"
				  	controlsPosition="${field.options.controlsPosition}"
				  	contentAlign="${field.options.contentAlign}"
				  	showCompanys="${field.options.showCompanys}"
				<#if field.options.controls> :controls="${field.options.controls}"<#else> :controls="false"</#if>
				   <#if field.options.placeholder?if_exists>
					<#if field.placeholderI18nKey?if_exists>
						:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
					<#else>
						placeholder="${field.options.placeholder}"
					</#if>
				</#if>
                   ${getPermissionLine(field,type,hasLinkage)}
				   <#if field.options.mathExp?if_exists>math-exp="${field.options.mathExp}"</#if>
                   <#if field.options.validate?if_exists && field.options.validate?length gt 0 >:validate="${field.options.validate}"</#if>
				   <#if field.options.min?if_exists>:min=${field.options.min?c}</#if>
				   <#if field.options.max?if_exists>:max=${field.options.max?c}</#if>
				   <#if field.options.step?if_exists>:step=${field.options.step?c}</#if>
				   <#if field.options.decimalDigits>:precision=${field.options.decimalDigits}
					
					 </#if>
                   <#if field.options.filterthousandBit?if_exists>filterthousand-bit</#if> <#--千分位-->
                   <#if field.options.filtercurrency?if_exists>filtercurrency</#if> <#--货币大写-->

					<#if field.options.formulasDiyJs?if_exists >
						<#if layout.vxeTable>
							v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)},type:'vxe',index:$index}"
						<#else>
							v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)}}"
						</#if>
					</#if>
									 <#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
        		   <#if field.options.mapping?if_exists>v-mapping="data.${field.options.mapping}"</#if>
        		   <#if field.options.isCountDate>:date-calc-exp="{start:'${field.options.isStartDate}',end:'${field.options.isEndDate}',diffType:'${field.options.countFormat}'}"</#if>
               <#if field.options.width?if_exists>
              style="width: ${field.options.width};"
			   <#else>
				   style="width: 100%;"
              </#if>

				${getHyperlink(field)}
				<#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
				<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
        >
        </ht-input>
	</#assign>
	<#return rtn>
</#function>
<#function getRadio field type hasLinkage layout>
	<#assign rtn>
        <ht-radio v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
                   <#if field.options.inline >option-layout="vertical"<#else>option-layout="horizontal"</#if>
                   <#if field.options.validate?if_exists && field.options.validate?length gt 0 > :validate="${field.options.validate}"</#if>
                   ${util.getLinkage(field.options)}
                   :ganged="${util.getSelectQuery(field.options,type!=1)}"
                   :permission="${getPermission(field,type)}"
                   rdlist='${util.getJsonByPath(field.options,'options')}'
                   :style='${util.getMapString(field,"controlstyle")}'
                   ${getPermissionLine(field,type,hasLinkage)}

                    <#if field.options.formulasDiyJs?if_exists >
                        <#if layout.vxeTable>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)},type:'vxe',index:$index}"
                        <#else>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)}}"
                        </#if>
                    </#if>
					<#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
					<#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
					<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
        >
        </ht-radio>
	</#assign>
	<#return rtn>
</#function>
<#function getCheckbox field type hasLinkage layout>
    <#assign rtn>
        <ht-checkbox v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
					 <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
                      <#if field.options.inline >option-layout="vertical"<#else>option-layout="horizontal"</#if>
                      :ganged="${util.getSelectQuery(field.options,type!=1)}"
                      :permission="${getPermission(field,type)}"
											:max="${field.options.checkboxMax}"
                      <#if field.options.validate?if_exists && field.options.validate?length gt 0 > :validate="${field.options.validate}"</#if>
                      ${util.getLinkage(field.options)}
                      cklist='${util.getJsonByPath(field.options,'options')}'
                      :style='${util.getMapString(field,"controlstyle")}'
                      ${getPermissionLine(field,type,hasLinkage)}

                    <#if field.options.formulasDiyJs?if_exists >
                        <#if layout.vxeTable>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)},type:'vxe',index:$index}"
                        <#else>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)}}"
                        </#if>
                    </#if>
					  <#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
					  <#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
						<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
        >
        </ht-checkbox>
    </#assign>
    <#return rtn>
</#function>
<#function getSelect field type hasLinkage layout>
    <#assign customQuery  = util.getStringConf(field.options.customQuery)>
    <#assign rtn>
        <ht-select v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				   <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
                    <#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
                    :ganged="${util.getSelectQuery(field.options,type!=1)}"
				    <#if field.options.validate?if_exists && field.options.validate?length gt 0 >:validate="${field.options.validate}"</#if>
					${util.getLinkage(field.options)}
                    ${util.getAttrs(':multiple,:filterable,:allowCreate,:related-query',field)}
                    :permission="${getPermission(field,type)}"
					:limit-count="${field.options.limitCount!1}"
                    :selectlist='${util.getJsonByPath(field.options,'options')}'
					${getPermissionLine(field,type,hasLinkage)}

                    <#if field.options.formulasDiyJs?if_exists >
                        <#if layout.vxeTable>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)},type:'vxe',index:$index}"
                        <#else>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)}}"
                        </#if>
                    </#if>
					<#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
                    <#if field.options.width?if_exists>style="width: ${field.options.width};"
					<#else>
						style="width: 100%;"
					</#if>
                    <#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
										<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
		>
        </ht-select>
    </#assign>
    <#return rtn>
</#function>

<#function getCustomChart field type hasLinkage layout>
	<#assign rtn>
	<ht-chart alias="${field.options.alias}" id="${field.options.chartId}" width="${field.options.chartWidth}" height="${field.options.chartHeight}" chart-key="${field.key}"
			<#if field.options.selectList?if_exists > selectList="${util.toJsonStr(field.options.selectList)}"</#if>
      <#if field.tableName?if_exists && field.name?if_exists>:permission="${getPermission(field,type)}"</#if>
	></ht-chart>
	</#assign>
	<#return rtn>
</#function>

<#function getDialog field type hasLinkage layout>
    <#assign name  = util.getJsonByPath(field.customDialogjson,'name')>
    <#assign icon  = util.getJsonByPath(field.customDialogjson,'icon')>
    <#assign custdialogConf  = util.getStringConf(field.options.customDialogjson)>
    <#assign rtn>
		<ht-custom-dialog v-model="${getNgModel(field,type)}"  model-name="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
                    :custdialog='${custdialogConf}'
                    placeholder="${field.options.placeholder}"
                    :permission="${getPermission(field,type)}"
					style="width: ${field.options.width?default('100%')}"
                    atter="${getAtter(field,type)}"
                    ${util.getAttrs('tooltipplacement',field)}
                    ${getPermissionLine(field,type,hasLinkage)}
                    <#if type?if_exists && (type==2 || type == 3)>:subIndex="getPageOffset('data.${subListPath}') + $index"</#if>
										<#if type?if_exists&&type==3>:sunIndex="sunIndex" subPath="data.${subListPath}" :currentSubData="data.${subListPath}"</#if>
					<#if field.options.validate?if_exists && field.options.validate?length gt 0> :validate="${field.options.validate}"</#if>
                    :style='${util.getMapString(field,"controlstyle")}'
				${getHyperlink(field)}
				<#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
				<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
		>
            <span slot="labeldesc">${field.desc}</span>
        </ht-custom-dialog>
    </#assign>
    <#return rtn>
</#function>
<#function getEipButton field type hasLinkage layout>
	<#assign name  = util.getJsonByPath(field.options.bindEventjson,'name')>
	<#assign icon  = util.getJsonByPath(field.options.bindEventjson,'icon')>
	<#assign isShowInput  = util.getJsonByPath(field.options.bindEventjson,'isShowInput')>
	<#assign alias  = util.getJsonByPath(field.options.bindEventjson,'alias')>
	<#assign rtn>
			<ht-button
					<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
					icon="${icon}"
					btn-name="${name}"
					 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
					<#if field.tableName?if_exists && field.name?if_exists && !field.options.bindEventjson.isShowInput>:permission="${getPermission(field,type)}"</#if>
					<#if field.options.bindEventjson.isShowInput>
					v-model="${getNgModel(field,type)}"
					is-show-input 
					:permission="${getPermission(field,type)}"
					</#if>
					<#if field.options.bindEventjson.lableColor>
					lableColor="${util.getJsonByPath(field.options.bindEventjson,'lableColor')}"
					</#if>
					<#if field.options.bindEventjson.textColor>
					textColor="${util.getJsonByPath(field.options.bindEventjson,'textColor')}"
					</#if>
					<#if field.options.bindEventjson.styleType>
					styleType="${util.getJsonByPath(field.options.bindEventjson,'styleType')}"
					</#if>

                    <#if field.options.formulasDiyJs?if_exists >
                        <#if layout.vxeTable>
                            v-formula="{value:'${field.options.formulasDiyJs}',bindPath:${getFormula(field,type)},type:'vxe',index:$index}"
                        <#else>
                            v-formula="{value:'${field.options.formulasDiyJs}',bindPath:${getFormula(field, type)}}"
                        </#if>
                    </#if>
					<#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
					<#if field.options.showCondition.fieldPath?if_exists>v-if="${field.options.showCondition.fieldPath}=='${field.options.showCondition.value}'"</#if>
					${getPermissionLine(field,type,hasLinkage)}
					<#if field.options.isBindBtn>
					script="${field.options.script}"
					</#if>
					>
			</ht-button>
	</#assign>
	<#return rtn>
</#function>
<#function getEipButtonGroup field type hasLinkage layout>
	<#assign btnLists = util.getJsonByPath(field,'btnLists')>
	<#assign rtn>
	    <ht-button-group  <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if> :btnLists='${btnLists}' :permission="${getPermission(field,type)}" ></ht-button-group>
	</#assign>
	<#return rtn>
</#function>
<#function getEipDivider field type>
	<#assign rtn>
			<div style='margin: 24px 0' >
			<ht-divider
		 
					<#if field.options.position?if_exists>content-position="${field.options.position}"</#if>
					 <#if field.options.color?if_exists>color="${field.options.color}"</#if>
			
					 <#if field.options.dividerStyle?if_exists>dividerStyle="${field.options.dividerStyle}"</#if>
					 <#if field.options.titleStyle?if_exists>titleStyle='${util.objectToJsonString(field.options.titleStyle)}'</#if>
					 <#if field.options.content?if_exists>
					 :content="$td('${field.key}','${field.options.content}')"
					 <#else>
					 content="${field.options.content}"
					 </#if>
					 >
					 <template>
					  <i <#if field.options.customDialogjson.icon?if_exists>class="${field.options.customDialogjson.icon}"</#if>><#if field.options.content?if_exists>${field.options.content}</#if></i>
					</template>
			</ht-divider>
			</div>
	</#assign>
	<#return rtn>
</#function>
<#function getTextarea field type hasLinkage layout>
	<#if field.options.isEditor>
		<#assign rtn>
			<ht-editor 
					v-model="${getNgModel(field,type)}"
					<#if field.i18nKey?if_exists>
						:name="$td('${field.i18nKey}','${field.desc}')"
					<#else>
						name="${field.desc}"
					</#if>
					 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
					encode
					<#if field.options.isInputEdit ?if_exists>:disabled="${field.options.isInputEdit}"</#if>
					<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
					<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
					<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
					:permission="${getPermission(field,type)}"
					textAlign="${field.options.textAlign}"
					isInputEdit="${field.options.isInputEdit}"
					initialFrameWidth="${field.options.initialFrameWidth}"
					initialFrameHeight="${field.options.initialFrameHeight}"
					type="${field.ctrlType}"
					${getPermissionLine(field,type,hasLinkage)}
					<#if field.options.noToolbar?if_exists>noToolbar="${field.options.noToolbar}"</#if>
					<#if field.options.textValue?if_exists>
					textValue="${util.toJsonStr(field.options.textValue)}"
					</#if>
					<#if field.options.isShowBorder == 1>
						:showBorder="true"
					</#if>
						<#if field.options.isShowBorder == 0>
						:showBorder="false"
					</#if>
					borderColor="${util.toJsonStr(field.options.borderColor)}"
					<#if field.options.validate?if_exists && field.options.validate?length gt 0 >:validate="${field.options.validate}"</#if>

                    <#if field.options.formulasDiyJs?if_exists >
                        <#if layout.vxeTable>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)},type:'vxe',index:$index}"
                        <#else>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)}}"
                        </#if>
                    </#if>
					<#if field.options.customValueBase64?if_exists> v-formula="{value:'${field.options.customValueBase64}',bindPath:${getFormula(field,type)}}"</#if>
					<#if field.options.mapping?if_exists>v-mapping="data.${field.options.mapping}"</#if>
					${getHyperlink(field)}
			>
			</ht-editor>
		</#assign>
	<#else>
		<#assign rtn>
			<ht-input
					v-model="${getNgModel(field,type)}"
					type="textarea"
					<#if field.i18nKey?if_exists>
						:name="$td('${field.i18nKey}','${field.desc}')"
					<#else>
						name="${field.desc}"
					</#if>
					 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
					<#if field.options.showWordLimit?if_exists>:show-word-limit="${field.options.showWordLimit}"</#if>
					<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
					:permission="${getPermission(field,type)}"
					${getPermissionLine(field,type,hasLinkage)}
					<#if field.options.isInputEdit ?if_exists>:disabled="${field.options.isInputEdit}"</#if>
						<#if field.options.textareaHeight ?if_exists>:textareaHeight="${field.options.textareaHeight}"</#if>
								<#if field.options.textareaAutoHeight ?if_exists>:textareaAutoHeight="${field.options.textareaAutoHeight}"
								:autosize='true'
								</#if>
					<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
					<#if field.options.validate?if_exists && field.options.validate?length gt 0 >:validate="${field.options.validate}"</#if>
					<#if field.options.showWordLimit?if_exists>:maxlength="${field.options.maxlength}"</#if>

                    <#if field.options.formulasDiyJs?if_exists >
                        <#if layout.vxeTable>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)},type:'vxe',index:$index}"
                        <#else>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)}}"
                        </#if>
                    </#if>
					<#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
					<#if field.options.mapping?if_exists>v-mapping="data.${field.options.mapping}"</#if>
				   <#if field.options.width?if_exists>
					  style="width: ${field.options.width};"
				   <#else>
					   style="width: 100%;"
				   </#if>
					${getHyperlink(field)}
					${getScanConfig(field)}
				>
			</ht-input>
		</#assign>
	</#if>
	<#return rtn>
</#function>
<#function getFont field type layout>
	<#assign rtn>
		<#if field.options.textValue?if_exists>
            <ht-editor   <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if> <#if field.tableName?if_exists && field.name?if_exists>:permission="${getPermission(field,type)}"</#if>
            		   text-value="${util.toJsonStr(field.options.textValue)}"
					<#if field.options.isShowBorder && field.options.isShowBorder == "0">show-border</#if>
					<#if field.options.isShowBorder && field.options.isShowBorder == "0">border-color="${util.toJsonStr(field.options.borderColor)}"</#if>
					${getHyperlink(field)}
			></ht-editor>
		</#if>
	</#assign>
	<#return rtn>
</#function>
<#function getQRcode field type >
	<#assign rtn>
	<#assign usesType = util.getJsonByPath(field.options,'usesType')>
	<ht-qrcode 
	v-model="${getNgModel(field,type)}"  
	<#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	</#if> 
	:inst-id="instId" :def-id="defId" :is-support-mobile="isSupportMobile" usesType="${usesType}"
    <#if field.tableName?if_exists && field.name?if_exists>:permission="${getPermission(field,type)}"</#if>
	 <#if usesType=='content'>
	<#if field.options.formulasDiyJs?if_exists >
       <#if layout.vxeTable>
        v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)},type:'vxe',index:$index}"
       <#else>
        v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)}}"
       </#if>
    </#if>
	<#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
	</#if>
	></ht-qrcode>
	</#assign>
	<#return rtn>
</#function>
<#function getAttachment field type hasLinkage layout>
	<#assign rtn>
		<#assign allowPreview = util.getJsonByPath(field.options.file,'allowPreview','false')>
		<#assign allowDownload = util.getJsonByPath(field.options.file,'allowDownload','false')>
        <ht-file v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>  <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
			      <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
                  :permission="${getPermission(field,type)}"
                  <#if field.options.validate?if_exists && field.options.validate?length gt 0>:validate="${field.options.validate}"</#if>
				  ${util.getAttrs('propConf,accept',field)}
                  :limit="${field.options.file.limit}"
                  :allow-preview="${allowPreview}"
                  :allow-download="${allowDownload}"
                  :size="${util.getToString(field.options.file.size)}"
                  ${getPermissionLine(field,type,hasLinkage)}
				  :multiple="${util.getJsonByPath(field.options.file,'multiple','false')}"
                  :simplicity="${util.getJsonByPath(field.options.file,'simplicity','false')}"
                  :dragUpload="${util.getJsonByPath(field.options.file,'dragUpload','false')}"
				  :pushKm="${util.getJsonByPath(field.options.file,'pushKm','0')}"
				  kmFolderId="${util.getJsonByPath(field.options.file,'kmFolderId','')}"
                  :flow-data="extendProp">
        </ht-file>
	</#assign>
	<#return rtn>
</#function>
<#function getDic field type hasLinkage layout>
	<#assign rtn>
        <ht-dictionary v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>

				 <#if layout.omitLoad?if_exists>
	                  isSubCellTable="${type}"
	 	         </#if>
					   <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
                 :permission="${getPermission(field,type)}"
				 <#if field.options.validate?if_exists && field.options.validate?length gt 0 > :validate="${field.options.validate}"</#if>
				 dickey="${field.options.dic}"
				 ${util.getAttrs(':filterable',field)}
				 ${getPermissionLine(field,type,hasLinkage)}
				 <#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
				<#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
				<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
				${getHyperlink(field)}
		>
        </ht-dictionary>
	</#assign>
	<#return rtn>
</#function>
<#function getTag field type hasLinkage layout>
	<#assign rtn>
		<ht-tag
			v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
			:permission="${getPermission(field,type)}"
			<#if field.options.validate?if_exists && field.options.validate?length gt 0>:validate="${field.options.validate}"</#if>
			tag-key="${field.options.tag}"
			<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
			${getPermissionLine(field,type,hasLinkage)}
			${util.getAttrs(':filterable',field)}
			${util.getAttrs(':expand',field)}
			${util.getAttrs(':multiple',field)}>
		</ht-tag>
	</#assign>
	<#return rtn>
</#function>
<#function getDropdown field type hasLinkage layout>
    <#assign customQuery  = util.getStringConf(field.options.customQuery)>
	<#assign rtn>
		<ht-select-tree :ganged="${util.getSelectQuery(field.options,type!=1)}"
                        v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
						<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
                        <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
                        ${util.getAttrs(':multiple,:filterable,:allowCreate',field)}
                        :permission="${getPermission(field,type)}"
                        ${getPermissionLine(field,type,hasLinkage)}
		 				<#if field.options.validate?if_exists && field.options.validate?length gt 0 >:validate="${field.options.validate}"</#if>

                        <#if field.options.formulasDiyJs?if_exists >
                            <#if layout.vxeTable>
                                v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)},type:'vxe',index:$index}"
                            <#else>
                                v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)}}"
                            </#if>
                        </#if>
						<#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
						<#if field.options.limitCount?if_exists>:limit-count="${field.options.limitCount}"</#if>
						<#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
						<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
						 <#if field.options.customQuery.treeDataMode ?if_exists>:treeDataMode="${field.options.customQuery.treeDataMode}"</#if>
				       <#if field.options.customQuery.pvalue?if_exists >	:pvalue="getPvalue('${field.options.customQuery.pvalue}')"</#if>
		>
		</ht-select-tree>
	</#assign>
	<#return rtn>
</#function>
<#function getAutocomplete field type hasLinkage layout>
	<#assign rtn>
		<ht-autocomplete
				v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				:permission="${getPermission(field,type)}"
				auto-tiplist='${util.getJsonByPath(field.options,'options')}'
				:ganged="${util.getSelectQuery(field.options,type!=1)}"
				:style='${util.getMapString(field,"controlstyle")}'
				<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
				${getPermissionLine(field,type,hasLinkage)}
				<#if field.options.validate?if_exists && field.options.validate?length gt 0> :validate="${field.options.validate}"</#if>
				<#if field.options.mapping?if_exists>v-mapping="data.${field.options.mapping}"</#if>
				${getHyperlink(field)}
		>
		</ht-autocomplete>
	</#assign>
	<#return rtn>
</#function>
<#function getEipCascader field type hasLinkage layout>
	<#assign rtn>
		<ht-cascader
				v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				<#if field.options.validate?if_exists && field.options.validate?length gt 0 >:validate="${field.options.validate}"</#if>
				:permission="${getPermission(field,type)}"
				:ganged="${util.getSelectQuery(field.options,type!=1)}"
			<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
				${getPermissionLine(field,type,hasLinkage)}
				<#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
				<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
		>
		</ht-cascader>
	</#assign>
	<#return rtn>
</#function>
<#function getEipDate field type hasLinkage layout>
	<#assign day  = util.getJsonByPath(field.options,'day','0')>
    <#assign showDate  = util.getJsonByPath(field.options,'showCurrentDate','false')>
	<#switch field.options.type>
	<#case 'date' >
		<#assign rtn>
		<ht-date
				v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
                <#if field.options.isServerDate>is-server-date</#if>
				:permission="${getPermission(field,type)}"
				${getPermissionLine(field,type,hasLinkage)}
                <#if field.options.validate?if_exists && field.options.validate?length gt 0 > :validate="${field.options.validate}"</#if>
                <#if showDate == 'true'>show-date</#if>
								<#if field.options.isInputEdit ?if_exists>:disabled="${field.options.isInputEdit}"</#if>
							
				<#if day != '0'&& day ?if_exists>:day="${day}"</#if>
				<#if field.options.inputFormat?if_exists && field.options.inputFormat?length gt 0>format="${field.options.inputFormat}"</#if>
				<#if field.options.format?if_exists && field.options.format?length gt 0>value-format="${field.options.format}"</#if>
				<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
				<#if field.options.mapping?if_exists>v-mapping="data.${field.options.mapping}"</#if>

                <#if field.options.formulasDiyJs?if_exists >
                    <#if layout.vxeTable>
                        v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)},format:'${field.options.format}',type:'vxe',index:$index}"
                    <#else>
                        v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)},format:'${field.options.format}'}"
                    </#if>
                </#if>
				<#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},format:'${field.options.format}',type:'default'}"</#if>
         		<#if field.options.width?if_exists>style="width: ${field.options.width};"
				<#else>
					style="width: 100%;"
				</#if>
				${getHyperlink(field)}
				<#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
				<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
		>
		</ht-date>
		</#assign>
	<#break>
	<#case 'picker' >
	<#assign rtn>
		<ht-time-picker
				v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				:permission="${getPermission(field,type)}"
        ${getPermissionLine(field,type,hasLinkage)}
			<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
        <#if field.options.validate?if_exists && field.options.validate?length gt 0>:validate="${field.options.validate}"</#if>
        <#if field.options.width?if_exists>style="width: ${field.options.width};"
		<#else>
			style="width: 100%;"
		</#if>

                <#if field.options.formulasDiyJs?if_exists >
                    <#if layout.vxeTable>
                        v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)},format:'${field.options.format}',type:'vxe',index:$index}"
                    <#else>
                        v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)},format:'${field.options.format}'}"
                    </#if>
                </#if>
				<#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},format:'${field.options.format}',type:'default'}"</#if>
		 <#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
		 <#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
		>
		</ht-time-picker>
	</#assign>
	<#break>
	<#case 'select' >
		<#assign rtn>
		<ht-time-select
				v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if> 
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				:permission="${getPermission(field,type)}"
        ${getPermissionLine(field,type,hasLinkage)}
        <#if field.options.validate?if_exists && field.options.validate?length gt 0> :validate="${field.options.validate}"</#if>
				<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
				<#if field.options.mapping?if_exists>v-mapping="data.${field.options.mapping}"</#if>

                <#if field.options.formulasDiyJs?if_exists >
                    <#if layout.vxeTable>
                        v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)},
                        format:'${(field.options.type =='select')?string('HH:mm:ss','HH:mm')}',
                        type:'vxe',index:$index}"
                    <#else>
                        v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)},format:'${(field.options.type =='select')?string('HH:mm:ss','HH:mm')}'}"
                    </#if>
                </#if>
				<#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},format:'${(field.options.type =='select')?string('HH:mm:ss','HH:mm')}',type:'default'}"</#if>
        		<#if field.options.width?if_exists>style="width: ${field.options.width};"
				<#else>
					style="width: 100%;"
				</#if>
				${getHyperlink(field)}
				<#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
				<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
		>
		</ht-time-select>
		</#assign>
	<#break>
	</#switch>
	<#return rtn>
</#function>

<#function getEipDatePicker field type hasLinkage layout>
	<#assign rtn>
		<ht-date-picker
				v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				:permission="${getPermission(field,type)}"
        ${getPermissionLine(field,type,hasLinkage)}
				<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
                <#if field.options.validate?if_exists && field.options.validate?length gt 0>:validate="${field.options.validate}"</#if>
				<#if field.options.inputFormat?if_exists && field.options.inputFormat?length gt 0>format="${field.options.inputFormat}"<#else>format="yyyy-MM-dd"</#if>
				<#if field.options.inputFormat?if_exists && field.options.inputFormat?length gt 0>value-format="${field.options.inputFormat}"<#else>value-format="yyyy-MM-dd"</#if>
        		<#if field.options.width?if_exists>style="width: ${field.options.width};"
				<#else>
					style="width: 100%;"
				</#if>
				${getHyperlink(field)}
		>
		</ht-date-picker>
	</#assign>
	<#return rtn>
</#function>

<#function getEipTimePicker field type hasLinkage layout>
	<#assign rtn>
		<ht-time-picker is-range
				v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
						<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				:permission="${getPermission(field,type)}"
				${getPermissionLine(field,type,hasLinkage)}
				<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
                <#if field.options.validate?if_exists && field.options.validate?length gt 0>:validate="${field.options.validate}"</#if>
                 <#if field.options.width?if_exists>style="width: ${field.options.width};"
				 <#else>
					 style="width: 100%;"
				 </#if>
		>
		</ht-time-picker>
	</#assign>
	<#return rtn>
</#function>

<#function getEipRelFlow field type hasLinkage layout>
	<#assign rtn>
		<ht-relevant-flow v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
      <#if field.options.flowRangeKey?if_exists>flowRangeKey="${field.options.flowRangeKey}"</#if>
						  <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
		                  :permission="${getPermission(field,type)}"
		                  :search-config="{isPaging:${field.options.isPaging},pageSize:${field.options.pageSize}}"
                 ></ht-relevant-flow>
	</#assign>
	<#return rtn>
</#function>
<#function getEipImg field type layout>
    <#assign rtn>
        <ht-image
		 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
                <#if field.options.isDisplay?if_exists>:is-display="${field.options.isDisplay?default(false)}"</#if>
                <#if field.options.imgSrc?if_exists>img-src="${field.options.imgSrc}" :is-display="false"</#if>
                file-json='${field.options.fileJson}'
                :img-height='${field.options.size.height?default(0)}'
                :img-width='${field.options.size.width?default(0)}'
                <#if field.options.openUrl?if_exists>open-url="${field.options.openUrl}"</#if>
                <#if field.options.openType?if_exists>open-type="${field.options.openType}"</#if>
                <#if field.tableName?if_exists && field.name?if_exists>:permission="${getPermission(field,type)}"</#if>
                 />
    </#assign>
    <#return rtn>
</#function>
<#function getEipViewer field type hasLinkage layout>
	<#assign rtn>
		<#assign allowPreview = util.getJsonByPath(field.options.file,'allowPreview','true')>
		<#assign allowDownload = util.getJsonByPath(field.options.file,'allowDownload','false')>
			<ht-picture v-model="${getNgModel(field,type)}"
					<#if field.i18nKey?if_exists>
						:name="$td('${field.i18nKey}','${field.desc}')"
					<#else>
						name="${field.desc}"
					</#if>
					 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
			      <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
                  :permission="${getPermission(field,type)}"
                  <#if field.options.validate?if_exists && field.options.validate?length gt 0>:validate="${field.options.validate}"</#if>
                  :limit="${field.options.file.limit}"
				  <#if field.options.imgHeight?if_exists>img-height="${field.options.imgHeight}"</#if>
				  <#if field.options.imgWidth?if_exists>img-width="${field.options.imgWidth}"</#if>
				  upload-type="${field.options.uploadType}"
                  :allow-preview="${allowPreview}"
                  :allow-download="${allowDownload}"
				  openUrl="${field.options.openUrl}"
                  ${getPermissionLine(field,type,hasLinkage)}
				  :multiple="${util.getJsonByPath(field.options.file,'multiple','false')}"
           <#if field.options.file.compress?if_exists>:compress="${field.options.file.compress}"</#if>
				  :pushKm="${util.getJsonByPath(field.options.file,'pushKm','0')}"
				  kmFolderId="${util.getJsonByPath(field.options.file,'kmFolderId','')}"
				  :flow-data="extendProp">
        </ht-picture>
	</#assign>
	<#return rtn>
</#function>
<#function getSwitch field type hasLinkage layout>
    <#assign rtn>
        <ht-switch v-model="${getNgModel(field,type)}"
				   <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
            	   :permission="${getPermission(field,type)}"
				   ${getPermissionLine(field,type,hasLinkage)}
				   <#if field.options.validate?if_exists && field.options.validate?length gt 0>:validate="${field.options.validate}"</#if>
				   active-value="${field.options.activeValue}"
				   inactive-value="${field.options.inactiveValue}"
				   active-text="${field.options.activeText}"
				   inactive-text="${field.options.inactiveText}"
                	<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if> 
                <#if layout.omitLoad?if_exists>
	            isSubCellTable="${type}"
	           	</#if>
                    <#if field.options.formulasDiyJs?if_exists >
                        <#if layout.vxeTable>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)},type:'vxe',index:$index}"
                        <#else>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)}}"
                        </#if>
                    </#if>
					 <#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
				>
        </ht-switch>
    </#assign>
    <#return rtn>
</#function>

<#function getUrlParameter field type hasLinkage layout>
    <#assign rtn>
        <ht-url-parameter v-model="${getNgModel(field,type)}"
				   <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
            	   :permission="${getPermission(field,type)}"
				   ${getPermissionLine(field,type,hasLinkage)}
				   <#if field.options.validate?if_exists && field.options.validate?length gt 0>:validate="${field.options.validate}"</#if>
				  bindKey="${field.options.bindKey}"
 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
                    <#if field.options.formulasDiyJs?if_exists >
                        <#if layout.vxeTable>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)},type:'vxe',index:$index}"
                        <#else>
                            v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)}}"
                        </#if>
                    </#if>
					 <#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)}}"</#if>
				>
        </ht-url-parameter>
    </#assign>
    <#return rtn>
</#function>

<#function getHistoricalApproval field type layout>
	<#assign rtn>
		<ht-historical-approval  
		<#if layout.omitLoad?if_exists>
	            isSubCellTable="${type}"
	 	</#if>
		        :permission="${getPermission(field,type)}"
					${getPermissionLine(field,type,true)}
				:order='${field.options.order? string("true","false")}'
				:inst-id="instId"
		/>
	</#assign>
	<#return rtn>
</#function>
<#function getColorPicker field type layout>
	<#assign rtn>
		<ht-color-picker 
		v-model="${getNgModel(field,type)}"
		<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	              isSubCellTable="${type}"
	 	         </#if>
		 	   :permission="${getPermission(field,type)}"
				${getPermissionLine(field,type,true)}
		/>
	</#assign>
	<#return rtn>
</#function>
<#function getEipMap field type >
    <#assign rtn>
        <ht-map v-model="${getNgModel(field,type)}"
        		:permission="${getPermission(field,type)}"
            heightMap="${field.options.heightMap}"
            widthMap="${field.options.widthMap}"
            showEffect="${field.options.showEffect}"
            <#if field.options.locationPath> locationPath="data.${field.options.locationPath}"</#if>
						<#if formSetting.display>displayStyle=${formSetting.display}</#if>
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
                <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				<#if field.options.isAddPosition>:append-position="${field.options.isAddPosition}"</#if>
		></ht-map>
    </#assign>
    <#return rtn>
</#function>
<#function getOffice field type hasLinkage layout>
	<#assign rtn>
<#--		<span>office组件尚未实现...</span>-->
	</#assign>
	<#return rtn>
</#function>
<#function getSignature field type hasLinkage>
	<#assign rtn>
<#--		<span>签名组件尚未实现...</span>-->
	</#assign>
	<#return rtn>
</#function>
<#function getFlowChart field type>
	<#assign rtn>
<#--		<span>流程图组件尚未实现...</span>-->
	</#assign>
	<#return rtn>
</#function>
<#function getApprovalHistory field type>
	<#assign rtn>
		<span>审批记录组件尚未实现...</span>
	</#assign>
	<#return rtn>
</#function>
<#function getAuthSelector field type layout>
	<#assign rtn>
		<ht-auth-selector
				v-model="${getNgModel(field,type)}"
				<#if field.options.lableText?if_exists>
					:lableText="'${field.options.lableText}'"
				</#if>
				:permission="${getPermission(field,type)}"
				:authType="'${util.getBase64(util.getJsonByPath(field.options,"authType"))}'"
				${getPermissionLine(field,type,true)}
		/>
	</#assign>
	<#return rtn>
</#function>
<#-- 子表关联查询回填 -->
<#function getSubtableCustomQueryBackfill layout >
    <#assign queryConfig  = util.getStringConf(layout.customQuery)>
    <#assign rtn>
    	<ht-subtable-backfill
    	  :customQuery='${queryConfig}'
        :max-row="${util.getNumber(layout.options.maxRow, 0)}"
        init-fill-data="${layout.initTemplateData}"
    	  init-fill-data-type="${layout.initTemplateDataType}"
        :extend-prop="extendProp"
        />
    </#assign>
    <#return rtn>
</#function>
<#-- 标题 简单文字方法 -->
<#function getText field>
    <#assign rtn>  
     <ht-text
	     <#if field.options.hideCtrl?if_exists> v-show="false"</#if>
	  fontSize="${field.options.fontSize}" fontWeight="${field.options.fontWeight}" ctrlType="${field.ctrlType}"
			textValue="${util.getBase64(field.options.textValue)}" textAlign="${field.options.textAlign}" paddingTop="${field.options.paddingTop}"
      <#if field.options.color>color="${field.options.color}"<#else>color="${formSetting.fontColor?replace('\"','')}"</#if>
      <#if field.tableName?if_exists && field.name?if_exists>:permission="${getPermission(field,type)}"</#if>
      paddingBottom="${field.options.paddingBottom}" paddingLeft="${field.options.paddingLeft}" paddingRight="${field.options.paddingRight}">
				<template #tip>
					<#if field.options.tip?default("")?trim?length gt 1>
						<el-tooltip placement="top">
							<div slot="content" >${field.options.tip}</div>
							<i class="el-icon-question" />
						</el-tooltip>
					</#if>
			</template>
			</ht-text>
    </#assign>
    <#return rtn>
</#function>
<#-- 说明 方法 -->
<#function getExplain field>
    <#assign rtn>
     <ht-explain
			<#if field.options.textValue?if_exists>
				textValue="${field.options.textValue}"
			</#if>
			marginTop="${field.options.marginTop}" marginBottom="${field.options.marginBottom}"
     fontColor="${formSetting.fontColor?replace('\"','')}"
     	<#if field.tableName?if_exists && field.name?if_exists>:permission="${getPermission(field,type)}"</#if>
     	<#if field.options.isLabelShow?if_exists>isLabelShow</#if>
			 ${getHyperlink(field)}
     >
		 <template #tip>
		 	<#if field.options.tip?default("")?trim?length gt 1>
				<el-tooltip placement="top">
					<div slot="content" >${field.options.tip}</div>
					<i class="el-icon-question" />
				</el-tooltip>
			</#if>
		 </template>
	 </ht-explain>
    </#assign>
    <#return rtn>
</#function>

<#function getOpinion field type>
	<#assign rtn>
    <ht-opinion  <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if> :permission="${getPermission(field,type)}" :flow-data="extendProp"></ht-opinion>
	</#assign>
	<#return rtn>
</#function>

<#-- 评分组件 -->
<#function getRate field type layout>
	<#assign rtn>
		<ht-rate v-model="${getNgModel(field,type)}"
				 :permission="${getPermission(field,type)}"
				${getPermissionLine(field,type,true)}
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				 <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				 <#if field.options.allowHalf?if_exists>allow-half</#if>
				 <#if field.options.max?if_exists>:max="${field.options.max}"</#if>
				 <#if field.options.defaultValue?if_exists>:default-value="${field.options.defaultValue}"</#if>
				 <#if field.options.showScore?if_exists>show-score</#if>
				 <#if field.options.iconClass?if_exists>icon-class="${field.options.iconClass}"</#if>
				 <#if field.options.activeColor?if_exists>active-color="${field.options.activeColor}"</#if>

        		 ></ht-rate>
	</#assign>
	<#return rtn>
</#function>

<#-- 滑块组件 -->
<#function getSlider field type layout>
	<#assign rtn>
		<ht-slider v-model="${getNgModel(field,type)}"
				 :permission="${getPermission(field,type)}"
				${getPermissionLine(field,type,true)}
				 :is-preview="isPreview"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				 <#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				 <#if field.options.showInput?if_exists>show-input</#if>
				 <#if field.options.max?if_exists>:max="${field.options.max}"</#if>
          <#if field.options.min?if_exists>:min="${field.options.min}"</#if>
				 <#if field.options.step?if_exists>:step="${field.options.step}"</#if>
         <#if field.options.validate?if_exists>:validate="${field.options.validate}" </#if>
				 <#if field.options.defaultValue?if_exists>:default-value="${field.options.defaultValue}"</#if>
        		 ></ht-slider>
	</#assign>
	<#return rtn>
</#function>

<#function getCustomComponent field type >
	<#assign rtn>
        <ht-custom-component
            :data="data"
            :permission="${getPermission(field,type)}"
            ccAlias='${field.options.alias}'
            <#if field.parentNodeType=='sub'>
                :index="$index"
                :item="item"
            </#if>
        />
	</#assign>
	<#return rtn>
</#function>

<#function getSignature field type hasLinkage layout>
	<#assign rtn>
		<ht-signature
				v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				${getPermissionLine(field,type,hasLinkage)}
				:permission="${getPermission(field,type)}"
				:fieldPath="'${field.fieldPath}'"
				:belong="'${field.options.belong}'"
				:boSubEntity="'${field.options.boSubEntity}'"
					<#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
						<#if field.options.validate?if_exists && field.options.validate?length gt 0 >:validate="${field.options.validate}"</#if>
		></ht-signature>
	</#assign>
	<#return rtn>
</#function>
<#function getHandSignature field type hasLinkage layout>
	<#assign rtn>
		<ht-hand-signature
				v-model="${getNgModel(field,type)}"
				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	             isSubCellTable="${type}"
	 	        </#if>
				 <#if field.options.validate?if_exists && field.options.validate?length gt 0>:validate="${field.options.validate}"</#if>
				:permission="${getPermission(field,type)}"
				penColor="${field.options.penColor}"
				backgroundColor="${field.options.backgroundColor}"
		></ht-hand-signature>
	</#assign>
	<#return rtn>
</#function>
<#function getProcessForecast field type hasLinkage layout>
	<#assign rtn>
		<ht-process-forecast

				<#if field.i18nKey?if_exists>
					:name="$td('${field.i18nKey}','${field.desc}')"
				<#else>
					name="${field.desc}"
				</#if>
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				:permission="${getPermission(field,type)}"
				showType="${field.options.showType}"
				height="${field.options.height}"
				width="${field.options.width}"
		></ht-process-forecast>
	</#assign>
	<#return rtn>
</#function>
<#function getIframe field type hasLinkage>
	<#assign rtn>
		<ht-iframe
        v-if="${getPermission(field,type)}!='n'"
				src="${field.options.iframeSrc}"
				height="${field.options.iframeSrcHeight}"
				width="${field.options.iframeSrcWidth}"
				style="border-color:${field.options.lableColor}"
        		iframe-name="${field.options.iframeNmae}"
				frameborder="${field.options.frameborder}"
        iframeType="${field.options.iframeType}"
        iframeSrcJs="${field.options.iframeSrcJs}"
				:data="data"
				 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
				:permission="permission"
				:inst-id="instId"
				:isBusinessForm="${field.options.isBusinessForm? string("true","false")}"
				:urlParameter='${util.getMapString(field.options,"urlParameter")}'
				:returnParameter='${util.getMapString(field.options,"returnParameter")}'
				   ></ht-iframe>
	</#assign>
	<#return rtn>
</#function>
<#-- 注意不能加空格  -->
<#macro input field type hasLinkage layout>
<#switch field.ctrlType>
	<#case 'input' ><#--单行文本框-->${getInput(field,type,hasLinkage, layout)}
<#break>
	<#case 'textarea'><#--多行文本框-->${getTextarea(field,type,hasLinkage, layout)}
<#break>
	<#case 'richText'><#--多行文本框-->${getTextarea(field,type,hasLinkage, layout)}
<#break>
    <#case 'property-text'><#--属性文本-->${getTextarea(field,type,hasLinkage, layout)}
<#break>
	<#case 'text'>${getFont(field,type)}
<#break>
	<#case 'QRcode'>${getQRcode(field,type)}
<#break>
	<#case 'number'><#--数字框-->${getNumberInput(field,type,hasLinkage, layout)}
<#break>
    <#case 'currency'><#--数字框-->${getNumberInput(field,type,hasLinkage, layout)}
<#break>
	<#case 'radio'><#--单选框-->${getRadio(field,type,hasLinkage, layout)}
<#break>
	<#case 'checkbox'><#--多选框-->${getCheckbox(field,type,hasLinkage, layout)}
<#break>
	<#case 'select'><#--下拉框-->${getSelect(field,type,hasLinkage, layout)}
<#break>
	<#case 'dialog'><#--对话框-->${getDialog(field,type,hasLinkage, layout)}
<#break>
	<#case 'selector'><#--选择器(包括组织，岗位，角色，用户选择器等控件组合)-->
		<${util.getHtSelectorType(field.options,type!=1)}
			v-model="${getNgModel(field,type)}"
			${util.getAttrs(':validate',field)}
	<#if field.i18nKey?if_exists>
		:name="$td('${field.i18nKey}','${field.desc}')"
	<#else>
		name="${field.desc}"
	</#if>
	 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
			appendToBody
			<#if type!=1>key="${getSubNgModel(field,type)}"<#else>key="${getNgModel(field,type)}"</#if>
			<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
			:permission="${getPermission(field,type!=1)}"
			:config="${util.getHtSelectorBind(field.options,type!=1)}"
			<#if field.options.filterRange?if_exists>:range='${field.options.filterRange}'</#if>
			<#if field.options.selector.selectCurrent>select-current</#if>
			<#if field.options.selector.showPath>show-path</#if>
			<#if field.options.selectedData?if_exists>:selected-org='${field.options.selectedData}'</#if>
			<#if field.options.selector.isSingle>single</#if>
			<#if field.options.validate?if_exists >:validate="${field.options.validate}" </#if>
			<#if field.options.placeholder?if_exists>
						<#if field.placeholderI18nKey?if_exists>
							:placeholder="$td('${field.placeholderI18nKey}','${field.options.placeholder}')"
						<#else>
							placeholder="${field.options.placeholder}"
						</#if>
					</#if>
      <#if field.options.width?if_exists>style="width: ${field.options.width};"
	  <#else>
		  style="width: 100%;"
	  </#if>
			 ${getPermissionLine(field,type,hasLinkage)}
			 <#if field.options.disabled ?if_exists>:disabled="${field.options.disabled}"</#if>
			 <#if field.options.isValidate ?if_exists>:isValidate="${field.options.isValidate}"</#if>
        ${getHyperlink(field)}
			>
	</${util.getHtSelectorType(field.options,type!=1)}>
<#break>
<#case 'immediate-single'><#-- 表单实时控件  单行 -->
	<ht-readonly-input type="text" ${util.getAttrs('inputType,placeholder,tooltipplacement', field)}
			<#if field.i18nKey?if_exists>
				:name="$td('${field.i18nKey}','${field.desc}')"
			<#else>
				name="${field.desc}"
			</#if>
			 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
	                   <#if field.tableName?if_exists && field.name?if_exists>:permission="${getPermission(field,type)}"</#if>
					   style="font-weight:${util.getStyleBold(field,'boldValue')};${util.getStyles(field,'color','valueColor')}"
					   :style='${util.getMapString(field,"controlstyle")}'
					   <#if field.options.script?if_exists>script="${field.options.script}"</#if>
					   v-model="${getNgModel(field,type)}"

                        <#if field.options.formulasDiyJs?if_exists >
                            <#if layout.vxeTable>
                                v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)},type:'vxe',index:$index}"
                            <#else>
                                v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)}}"
                            </#if>
                        </#if>
						 <#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
            <#if field.options.width?if_exists>style="width: ${field.options.width};"
			<#else>
				style="width: 100%;"
			</#if>
					>
	</ht-readonly-input>
<#break>
<#case 'immediate-textarea'><#-- 表单实时控件  多行  -->
	<ht-readonly-input type="text" ${util.getAttrs('inputType,placeholder,tooltipplacement',field)}
			<#if field.i18nKey?if_exists>
				:name="$td('${field.i18nKey}','${field.desc}')"
			<#else>
				name="${field.desc}"
			</#if>
			 <#if layout.omitLoad?if_exists>
	 isSubCellTable="${type}"
	 	</#if>
					   <#if field.tableName?if_exists && field.name?if_exists>:permission="${getPermission(field,type)}"
					   </#if> style="font-weight:${util.getStyleBold(field,'boldValue')};${util.getStyles(field,'color','valueColor')}"
					   :style='${util.getMapString(field,"controlstyle")}'
					   <#if field.options.script?if_exists>script="${field.options.script}"</#if>
					   v-model="${getNgModel(field,type)}"

                        <#if field.options.formulasDiyJs?if_exists >
                            <#if layout.vxeTable>
                                v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field, type)},type:'vxe',index:$index}"
                            <#else>
                                v-formula="{value:${field.options.formulasDiyJs},bindPath:${getFormula(field,type)}}"
                            </#if>
                        </#if>
						 <#if field.options.customInput?if_exists> v-formula="{value:'${field.options.customInput}',bindPath:${getFormula(field,type)},type:'default'}"</#if>
             <#if field.options.width?if_exists>style="width: ${field.options.width};"
			 <#else>
				 style="width: 100%;"
			 </#if>
					>
	</ht-readonly-input>
<#break>
<#case 'milepost'><#-- 里程碑 -->
		<ht-milepost v-model="${getNgModel(field,type)}"
		            <#if layout.omitLoad?if_exists>isSubCellTable="${type}"</#if>
		            <#if field.options.hideCtrl?if_exists> v-show="false"</#if>
					direction='${field.options.direction}'
     			  	<#if type!=1>model-name="${getSubNgModel(field,type)}"<#else>model-name="${getNgModel(field,type)}"</#if>
				  	:permission="${getPermission(field,type)}"
     			  	content='${util.objectToJsonString(field.options.steps)}'></ht-milepost>
<#break>
        <#case 'attachment'><#--附件上传-->${getAttachment(field,type,hasLinkage)}
<#break>
        <#case 'dic'><#--数据字典-->${getDic(field,type,hasLinkage, layout)}
	<#break>
		<#case 'tag'>${getTag(field,type,hasLinkage, layout)}
<#break>
        <#case 'dropdown'><#--下拉树-->${getDropdown(field,type,hasLinkage, layout)}
<#break>
<#break>
	<#case 'autocomplete'><#--自动完成-->${getAutocomplete(field,type,hasLinkage, layout)}
<#break>
<#break>
	<#case 'eip-cascader'><#--级联-->${getEipCascader(field,type,hasLinkage, layout)}
<#break>
	<#case 'button'>${getEipButton(field,type,hasLinkage, layout)}
<#break>
	<#case 'buttonGroup'>${getEipButtonGroup(field,type,hasLinkage, layout)} <#--按钮组-->
<#break>
	<#case 'divider'>${getEipDivider(field,type)} <#--分割线-->
<#break>
	<#case 'date'>${getEipDate(field,type,hasLinkage, layout)} <#--日期-->
<#break>
	<#case 'time'>${getEipDate(field,type,hasLinkage, layout)} <#--时间-->
<#break>
	<#case 'date-picker'>${getEipDatePicker(field,type,hasLinkage, layout)} <#--日期范围-->
<#break>
	<#case 'time-picker'>${getEipTimePicker(field,type,hasLinkage, layout)} <#--时间范围-->
<#break>
	<#case 'related-process'>${getEipRelFlow(field,type,hasLinkage, layout)} <#--相关流程控件-->
<#break>
    <#case 'image'>${getEipImg(field,type)} <#--图片控件-->
<#break>
	<#case 'imageViewer'>${getEipViewer(field,type,hasLinkage, layout)} <#--图片控件-->
<#break>
    <#case 'switch'>${getSwitch(field,type,hasLinkage, layout)} <#-- 开关控件 -->
<#break>
    <#case 'amap'>${getEipMap(field,type)} <#-- 地图控件 -->
<#break>
	<#case 'signature'>${getSignature(field,type,hasLinkage, layout)} <#-- 签章控件 -->
<#break>
	<#case 'handSignature'>${getHandSignature(field,type,hasLinkage, layout)} <#-- 手动签章控件 -->
<#break>
	<#case 'processForecast'>${getProcessForecast(field,type,hasLinkage, layout)} <#-- 审批预测 -->
<#break>
	<#case 'htCustomComponent'>${getCustomComponent(field,type)} <#--DIV组件控件-->
<#break>
	<#case 'office'>${getOffice(field,type,hasLinkage, layout)} <#-- office控件 -->
<#break>
	<#case 'customChart'><#--自定义视图-->${getCustomChart(field,type,hasLinkage, layout)}
<#break>
<#case 'flowChart'>${getFlowChart(field,type)} <#-- 流程图控件 -->
<#break>
<#case 'approvalHistory'>${getApprovalHistory(field,type)} <#-- 审批历史控件 -->
<#break>
<#case 'big-title'>${getText(field)} <#-- 大标题 -->
<#break>
<#case 'small-title'>${getText(field)} <#-- 小标题 -->
<#break>
<#case 'simple-text'>${getText(field)} <#-- 文字 -->
<#break>
<#case 'explain'>${getExplain(field)} <#-- 说明 -->
<#break>
<#case 'opinion'>${getOpinion(field, type)} <#-- 审批意见 -->
<#break>
<#case 'rate'>${getRate(field, type, layout)}
<#break>
<#case 'slider'>${getSlider(field, type, layout)}
<#break>
<#case 'iframe'>${getIframe(field, type)}
<#break>
<#case 'historicalApproval'>${getHistoricalApproval(field,type, layout)}
<#break>
<#case 'urlParameter'>${getUrlParameter(field, type, false, layout)}
<#break>
<#case 'colorPicker'>${getColorPicker(field, type, layout)}
<#break>
<#case 'htAuthSelector'>${getAuthSelector(field, type, layout)}
<#break>
</#switch>
</#macro>
