<#macro hotTable layout>
<#assign subTablePath=layout.options.subTablePath>
<#assign sunTablePath=util.getSunTablePath(layout.options.subTablePath,"index")>
<el-container

 style="margin-top:24px;" v-if="!permission.table.${layout.options.boSubEntity}.hidden"
 class="template-hot-table-layout"
 >
  <el-header
   :style="handleTableStyle('${layout.tableBorderColor}','${layout.tableHeaderBgColor}','${layout.options.headerStyle}',0.1)"
   style="height:30px;line-height:30px;background:var(--headerBgColor) !important; font-weight: bold;font-size: 14px;
  border:1px solid var(--borderColor); border-bottom:none;
  ">
  	<#if layout.showTitle!=false>
  		<span style="<#if layout.tableTitleColor>color:${layout.tableTitleColor};<#elseif formSetting && formSetting.fontColor> color:${formSetting.fontColor?replace('\"','')};</#if>">${layout.desc}</span>
  	 </#if>
  	 
  	 <div v-if="!isView" class="inputs" :style="{display:'inline-block',float:'right'}">
	    <el-button type="text" icon="el-icon-info" size="mini" :style="{padding:'0px 5px'}" @click="openUseInstructions('${subTablePath}')"> 
	      	使用说明
    	</el-button>
    </div>
    
  	 <div v-if="!isView && permission.table.${layout.options.boSubEntity}.del" class="inputs" :style="{display:'inline-block',float:'right'}">
	    <el-button type="text" icon="el-icon-delete" size="mini" :style="{padding:'0px 5px'}" @click="clearAllMessageBox({subTablePath: '${subTablePath}',isHot: true})"> 
	      	清空
    	</el-button>
    </div>
    <div v-if="permission.table.${layout.options.boSubEntity}.add && 1==2" class="inputs" :style="{display:'inline-block',float:'right'}">
	    <el-button type="text" icon="el-icon-plus" size="mini" :style="{padding:'0px 5px'}" @click="addInitTemplateData('${subTablePath}')">
	      	${layout.addInitBtnName}
    	</el-button>
    </div>
    <#assign isMathExp = util.getHasMathExp(layout.options)>
    <#assign isCrossMapping = util.getHasCrossMapping(layout.options)>
    <#assign mergeCellSize = util.getMergeCellSize(layout.options)>
    <#if isMathExp gt 0>
	  	 <div class="inputs" :style="{display:'inline-block',float:'right'}">
		    <el-button type="text" icon="el-icon-refresh" size="mini" :style="{padding:'0px 5px'}" @click="execCellMathExp('${subTablePath}')">
		      	运行计算公式
	    	</el-button>
	    </div>
    </#if>
    <#if isCrossMapping gt 0>
	  	 <div class="inputs" :style="{display:'inline-block',float:'right'}">
		    <el-button type="text" icon="el-icon-magic-stick" size="mini" :style="{padding:'0px 5px'}" @click="execCrossMapping('${subTablePath}')">
		      	运行跨表取数
	    	</el-button>
	    </div>
    </#if>
    <#if mergeCellSize gt 0>
	    <div v-if="permission.table.${layout.options.boSubEntity}.del" class="inputs" :style="{display:'inline-block',float:'right'}">
		    <el-button type="text" icon="el-icon-refresh" size="mini" :style="{padding:'0px 5px'}" @click="mergeCellRefresh('${subTablePath}')">
		      	合并单元格
	    	</el-button>
	    </div>
	 </#if>
  	 <#if layout.subtableBackfill && !layout.initTemplateData>
  	 	 ${getHotSubDialog(layout)}
  	 </#if>
  </el-header>
  <el-main
   :style="handleTableStyle('${layout.tableBorderColor}','${layout.tableHeaderBgColor}','${layout.options.headerStyle}',0.05)"
   >
  	  <#assign initConf  = util.getStringConf(layout.customDialogjson)>
      <ht-hot-table
      		:name='`${layout.desc}`'
      		ref='hottable.${layout.options.subTablePath}'
			options='${util.objectToJsonString(layout.options)}'
			subTableRelation="${layout.options.relation}"
			:permission='permission'
			isInitTemplateData="${layout.initTemplateData}"
			initFillDataType="${layout.initTemplateDataType}"
			addInitTemplateData="${layout.addInitTemplateData}"
			initSumRow="${layout.initSumRow}"
			initconf='${initConf}'>
	  </ht-hot-table>
  </el-main>
</el-container>
</#macro>

<#function getHotSubDialog layout >
    <#assign custdialogConf  = util.getStringConf(layout.customDialogjson)>
    <#assign rtn>
      <template v-if="!isView">
        <ht-sub-dialog
          relation="${layout.options.relation}"
    	  :custdialog='${custdialogConf}'
    	  init-fill-data="${layout.initTemplateData}"
    	  init-fill-data-type="${layout.initTemplateDataType}"
          :max-row="${util.getNumber(layout.options.maxRow, 0)}"
          hot-table-path="hottable.${layout.options.subTablePath}"
        />
      </template>
    </#assign>
    <#return rtn>
</#function>
